package io.qt.datavis;

import io.qt.*;


/**
 * <p>Container for resolved data to be added to surface graphs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html">QSurfaceDataItem</a></code></p>
 */
public class QSurfaceDataItem extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#QSurfaceDataItem">QSurfaceDataItem::<wbr/>QSurfaceDataItem()</a></code></p>
     */
    public QSurfaceDataItem(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSurfaceDataItem instance);
    
    /**
     * <p>See <code>QSurfaceDataItem::<wbr/>QSurfaceDataItem(QSurfaceDataItem)</code></p>
     */
    public QSurfaceDataItem(io.qt.datavis.@NonNull QSurfaceDataItem other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSurfaceDataItem instance, io.qt.datavis.QSurfaceDataItem other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#QSurfaceDataItem-1">QSurfaceDataItem::<wbr/>QSurfaceDataItem(QVector3D)</a></code></p>
     */
    public QSurfaceDataItem(io.qt.gui.@NonNull QVector3D position){
        super((QPrivateConstructor)null);
        initialize_native(this, position);
    }
    
    private native static void initialize_native(QSurfaceDataItem instance, io.qt.gui.QVector3D position);
    
    /**
     * <p>See <code>QSurfaceDataItem::<wbr/>createExtraData()</code></p>
     */
    @QtUninvokable
    protected final void createExtraData(){
        createExtraData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void createExtraData_native(long __this__nativeId);
    
    /**
     * <p>See <code>QSurfaceDataItem::<wbr/>operator=(QSurfaceDataItem)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.datavis.@NonNull QSurfaceDataItem other){
        assign_native_cref_QSurfaceDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSurfaceDataItem(long __this__nativeId, long other);
    
    /**
     * <p>See <code>operator==(QSurfaceDataItem,<wbr/>QSurfaceDataItem)</code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.datavis.@NonNull QSurfaceDataItem b){
        return equals_native_cref_QSurfaceDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QSurfaceDataItem(long __this__nativeId, long b);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#position">QSurfaceDataItem::<wbr/>position()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#setPosition">QSurfaceDataItem::<wbr/>setPosition(QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#setX">QSurfaceDataItem::<wbr/>setX(float)</a></code></p>
     */
    @QtUninvokable
    public final void setX(float value){
        setX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setX_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#setY">QSurfaceDataItem::<wbr/>setY(float)</a></code></p>
     */
    @QtUninvokable
    public final void setY(float value){
        setY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setY_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#setZ">QSurfaceDataItem::<wbr/>setZ(float)</a></code></p>
     */
    @QtUninvokable
    public final void setZ(float value){
        setZ_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setZ_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#x">QSurfaceDataItem::<wbr/>x()const</a></code></p>
     */
    @QtUninvokable
    public final float x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#y">QSurfaceDataItem::<wbr/>y()const</a></code></p>
     */
    @QtUninvokable
    public final float y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataitem.html#z">QSurfaceDataItem::<wbr/>z()const</a></code></p>
     */
    @QtUninvokable
    public final float z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float z_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSurfaceDataItem(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator==(QSurfaceDataItem,<wbr/>QSurfaceDataItem)</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other==null || other instanceof io.qt.datavis.QSurfaceDataItem) {
            return equals((io.qt.datavis.QSurfaceDataItem) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QSurfaceDataItem)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QSurfaceDataItem::<wbr/>QSurfaceDataItem(QSurfaceDataItem)</code></p>
     */
    @QtUninvokable
    @Override
    public QSurfaceDataItem clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSurfaceDataItem clone_native(long __this_nativeId);
}
