package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base class for 3D value axis formatters</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html">QValue3DAxisFormatter</a></code></p>
 */
public class QValue3DAxisFormatter extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QValue3DAxisFormatter.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#QValue3DAxisFormatter-1">QValue3DAxisFormatter::<wbr/>QValue3DAxisFormatter(QObject*)</a></code></p>
     */
    public QValue3DAxisFormatter(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QValue3DAxisFormatter instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#allowNegatives">QValue3DAxisFormatter::<wbr/>allowNegatives()const</a></code></p>
     */
    @QtUninvokable
    protected final boolean allowNegatives(){
        return allowNegatives_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean allowNegatives_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#allowZero">QValue3DAxisFormatter::<wbr/>allowZero()const</a></code></p>
     */
    @QtUninvokable
    protected final boolean allowZero(){
        return allowZero_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean allowZero_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#axis">QValue3DAxisFormatter::<wbr/>axis()const</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.datavis.@Nullable QValue3DAxis axis(){
        return axis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxis axis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#gridPositions">QValue3DAxisFormatter::<wbr/>gridPositions()const</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Float> gridPositions(){
        return gridPositions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Float> gridPositions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#labelPositions">QValue3DAxisFormatter::<wbr/>labelPositions()const</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Float> labelPositions(){
        return labelPositions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Float> labelPositions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#labelStrings">QValue3DAxisFormatter::<wbr/>labelStrings()const</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QList<java.lang.@NonNull String> labelStrings(){
        return labelStrings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.String> labelStrings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#locale">QValue3DAxisFormatter::<wbr/>locale()const</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QLocale locale(){
        return locale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QLocale locale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#markDirty">QValue3DAxisFormatter::<wbr/>markDirty(bool)</a></code></p>
     */
    @QtUninvokable
    protected final void markDirty(boolean labelsChange){
        markDirty_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), labelsChange);
    }
    
    @QtUninvokable
    private native void markDirty_native_bool(long __this__nativeId, boolean labelsChange);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#setAllowNegatives">QValue3DAxisFormatter::<wbr/>setAllowNegatives(bool)</a></code></p>
     */
    @QtUninvokable
    protected final void setAllowNegatives(boolean allow){
        setAllowNegatives_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), allow);
    }
    
    @QtUninvokable
    private native void setAllowNegatives_native_bool(long __this__nativeId, boolean allow);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#setAllowZero">QValue3DAxisFormatter::<wbr/>setAllowZero(bool)</a></code></p>
     */
    @QtUninvokable
    protected final void setAllowZero(boolean allow){
        setAllowZero_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), allow);
    }
    
    @QtUninvokable
    private native void setAllowZero_native_bool(long __this__nativeId, boolean allow);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#setLocale">QValue3DAxisFormatter::<wbr/>setLocale(QLocale)</a></code></p>
     */
    @QtUninvokable
    protected final void setLocale(io.qt.core.@NonNull QLocale locale){
        setLocale_native_cref_QLocale(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(locale));
    }
    
    @QtUninvokable
    private native void setLocale_native_cref_QLocale(long __this__nativeId, long locale);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#subGridPositions">QValue3DAxisFormatter::<wbr/>subGridPositions()const</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Float> subGridPositions(){
        return subGridPositions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Float> subGridPositions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#createNewInstance">QValue3DAxisFormatter::<wbr/>createNewInstance()const</a></code></p>
     */
    @QtUninvokable
    protected io.qt.datavis.@Nullable QValue3DAxisFormatter createNewInstance(){
        return createNewInstance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxisFormatter createNewInstance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#populateCopy">QValue3DAxisFormatter::<wbr/>populateCopy(QValue3DAxisFormatter&amp;)const</a></code></p>
     */
    @QtUninvokable
    protected void populateCopy(io.qt.datavis.@StrictNonNull QValue3DAxisFormatter copy){
        java.util.Objects.requireNonNull(copy, "Argument 'copy': null not expected.");
        populateCopy_native_ref_QValue3DAxisFormatter_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(copy));
    }
    
    @QtUninvokable
    private native void populateCopy_native_ref_QValue3DAxisFormatter_constfct(long __this__nativeId, long copy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#positionAt">QValue3DAxisFormatter::<wbr/>positionAt(float)const</a></code></p>
     */
    @QtUninvokable
    protected float positionAt(float value){
        return positionAt_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native float positionAt_native_float_constfct(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#recalculate">QValue3DAxisFormatter::<wbr/>recalculate()</a></code></p>
     */
    @QtUninvokable
    protected void recalculate(){
        recalculate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void recalculate_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#stringForValue">QValue3DAxisFormatter::<wbr/>stringForValue(qreal,<wbr/>QString)const</a></code></p>
     */
    @QtUninvokable
    protected java.lang.@NonNull String stringForValue(double value, java.lang.@NonNull String format){
        return stringForValue_native_qreal_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), value, format);
    }
    
    @QtUninvokable
    private native java.lang.String stringForValue_native_qreal_cref_QString_constfct(long __this__nativeId, double value, java.lang.String format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#valueAt">QValue3DAxisFormatter::<wbr/>valueAt(float)const</a></code></p>
     */
    @QtUninvokable
    protected float valueAt(float position){
        return valueAt_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), position);
    }
    
    @QtUninvokable
    private native float valueAt_native_float_constfct(long __this__nativeId, float position);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QValue3DAxisFormatter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QValue3DAxisFormatter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QValue3DAxisFormatter instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QValue3DAxisFormatter(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QValue3DAxisFormatter() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #markDirty(boolean)}
     *  with <code>labelsChange = false</code>.</p>
     */
    @QtUninvokable
    protected final void markDirty() {
        markDirty((boolean)false);
    }
    
    /**
     * <p>Overloaded function for {@link #setLocale(io.qt.core.QLocale)}.</p>
     */
    @QtUninvokable
    protected final void setLocale(io.qt.core.QLocale.@NonNull Language locale) {
        setLocale(new io.qt.core.QLocale(locale));
    }
}
