package io.qt.datavis;

import io.qt.*;


/**
 * <p>Manipulates an axis of a graph</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qvalue3daxis.html">QValue3DAxis</a></code></p>
 */
public class QValue3DAxis extends io.qt.datavis.QAbstract3DAxis
{
    @QtPropertyMember(enabled=false)
    private Object __rcFormatter = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QValue3DAxis.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#formatter-prop">QValue3DAxis::<wbr/>formatterChanged(QValue3DAxisFormatter*)</a></code></p>
     */
    @QtPropertyNotify(name="formatter")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QValue3DAxisFormatter> formatterChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#labelFormat-prop">QValue3DAxis::<wbr/>labelFormatChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="labelFormat")
    public final @NonNull Signal1<java.lang.@NonNull String> labelFormatChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#reversed-prop">QValue3DAxis::<wbr/>reversedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="reversed")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> reversedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#segmentCount-prop">QValue3DAxis::<wbr/>segmentCountChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="segmentCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> segmentCountChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#subSegmentCount-prop">QValue3DAxis::<wbr/>subSegmentCountChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="subSegmentCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> subSegmentCountChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#QValue3DAxis">QValue3DAxis::<wbr/>QValue3DAxis(QObject*)</a></code></p>
     */
    public QValue3DAxis(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QValue3DAxis instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#formatter-prop">QValue3DAxis::<wbr/>formatter()const</a></code></p>
     */
    @QtPropertyReader(name="formatter")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxisFormatter formatter(){
        return formatter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxisFormatter formatter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#labelFormat-prop">QValue3DAxis::<wbr/>labelFormat()const</a></code></p>
     */
    @QtPropertyReader(name="labelFormat")
    @QtUninvokable
    public final java.lang.@NonNull String labelFormat(){
        return labelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String labelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#reversed-prop">QValue3DAxis::<wbr/>reversed()const</a></code></p>
     */
    @QtPropertyReader(name="reversed")
    @QtUninvokable
    public final boolean reversed(){
        return reversed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean reversed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#segmentCount-prop">QValue3DAxis::<wbr/>segmentCount()const</a></code></p>
     */
    @QtPropertyReader(name="segmentCount")
    @QtUninvokable
    public final int segmentCount(){
        return segmentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int segmentCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#formatter-prop">QValue3DAxis::<wbr/>setFormatter(QValue3DAxisFormatter*)</a></code></p>
     */
    @QtPropertyWriter(name="formatter")
    @QtUninvokable
    public final void setFormatter(io.qt.datavis.@Nullable QValue3DAxisFormatter formatter){
        setFormatter_native_QValue3DAxisFormatter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(formatter));
        __rcFormatter = formatter;
    }
    
    @QtUninvokable
    private native void setFormatter_native_QValue3DAxisFormatter_ptr(long __this__nativeId, long formatter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#labelFormat-prop">QValue3DAxis::<wbr/>setLabelFormat(QString)</a></code></p>
     */
    @QtPropertyWriter(name="labelFormat")
    @QtUninvokable
    public final void setLabelFormat(java.lang.@NonNull String format){
        setLabelFormat_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), format);
    }
    
    @QtUninvokable
    private native void setLabelFormat_native_cref_QString(long __this__nativeId, java.lang.String format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#reversed-prop">QValue3DAxis::<wbr/>setReversed(bool)</a></code></p>
     */
    @QtPropertyWriter(name="reversed")
    @QtUninvokable
    public final void setReversed(boolean enable){
        setReversed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setReversed_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#segmentCount-prop">QValue3DAxis::<wbr/>setSegmentCount(int)</a></code></p>
     */
    @QtPropertyWriter(name="segmentCount")
    @QtUninvokable
    public final void setSegmentCount(int count){
        setSegmentCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @QtUninvokable
    private native void setSegmentCount_native_int(long __this__nativeId, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#subSegmentCount-prop">QValue3DAxis::<wbr/>setSubSegmentCount(int)</a></code></p>
     */
    @QtPropertyWriter(name="subSegmentCount")
    @QtUninvokable
    public final void setSubSegmentCount(int count){
        setSubSegmentCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @QtUninvokable
    private native void setSubSegmentCount_native_int(long __this__nativeId, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxis.html#subSegmentCount-prop">QValue3DAxis::<wbr/>subSegmentCount()const</a></code></p>
     */
    @QtPropertyReader(name="subSegmentCount")
    @QtUninvokable
    public final int subSegmentCount(){
        return subSegmentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int subSegmentCount_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QValue3DAxis(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QValue3DAxis(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QValue3DAxis instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QValue3DAxis(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QValue3DAxis() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #formatter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxisFormatter getFormatter() {
        return formatter();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #labelFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getLabelFormat() {
        return labelFormat();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #reversed()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getReversed() {
        return reversed();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #segmentCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSegmentCount() {
        return segmentCount();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #subSegmentCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSubSegmentCount() {
        return subSegmentCount();
    }
}
