package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base class for all graphs proxies</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstractdataproxy.html">QAbstractDataProxy</a></code></p>
 */
public class QAbstractDataProxy extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractDataProxy.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstractdataproxy.html#DataType-enum">QAbstractDataProxy::DataType</a></code></p>
     */
    @QtUnlistedEnum
    public enum DataType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractdataproxy.html#DataType-enum">QAbstractDataProxy::<wbr/>DataTypeNone</a></code></p>
         */
        DataTypeNone(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractdataproxy.html#DataType-enum">QAbstractDataProxy::<wbr/>DataTypeBar</a></code></p>
         */
        DataTypeBar(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractdataproxy.html#DataType-enum">QAbstractDataProxy::<wbr/>DataTypeScatter</a></code></p>
         */
        DataTypeScatter(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractdataproxy.html#DataType-enum">QAbstractDataProxy::<wbr/>DataTypeSurface</a></code></p>
         */
        DataTypeSurface(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DataType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DataType resolve(int value) {
            switch (value) {
            case 0: return DataTypeNone;
            case 1: return DataTypeBar;
            case 2: return DataTypeScatter;
            case 4: return DataTypeSurface;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractdataproxy.html#type-prop">QAbstractDataProxy::<wbr/>type()const</a></code></p>
     */
    @QtPropertyReader(name="type")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.datavis.QAbstractDataProxy.@NonNull DataType type(){
        return io.qt.datavis.QAbstractDataProxy.DataType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractDataProxy(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstractDataProxy.@NonNull DataType getType() {
        return type();
    }
}
