package io.qt.datavis;

import io.qt.*;


/**
 * <p>Container for resolved data to be added to bar graphs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qbardataitem.html">QBarDataItem</a></code></p>
 */
public class QBarDataItem extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem">QBarDataItem::<wbr/>QBarDataItem()</a></code></p>
     */
    public QBarDataItem(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QBarDataItem instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem-3">QBarDataItem::<wbr/>QBarDataItem(QBarDataItem)</a></code></p>
     */
    public QBarDataItem(io.qt.datavis.@NonNull QBarDataItem other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QBarDataItem instance, io.qt.datavis.QBarDataItem other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem-1">QBarDataItem::<wbr/>QBarDataItem(float)</a></code></p>
     */
    public QBarDataItem(float value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QBarDataItem instance, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem-2">QBarDataItem::<wbr/>QBarDataItem(float,<wbr/>float)</a></code></p>
     */
    public QBarDataItem(float value, float angle){
        super((QPrivateConstructor)null);
        initialize_native(this, value, angle);
    }
    
    private native static void initialize_native(QBarDataItem instance, float value, float angle);
    
    /**
     * <p>See <code>QBarDataItem::<wbr/>createExtraData()</code></p>
     */
    @QtUninvokable
    protected final void createExtraData(){
        createExtraData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void createExtraData_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#operator-eq">QBarDataItem::<wbr/>operator=(QBarDataItem)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.datavis.@NonNull QBarDataItem other){
        assign_native_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QBarDataItem(long __this__nativeId, long other);
    
    /**
     * <p>See <code>operator==(QBarDataItem,<wbr/>QBarDataItem)</code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.datavis.@NonNull QBarDataItem b){
        return equals_native_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QBarDataItem(long __this__nativeId, long b);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#rotation">QBarDataItem::<wbr/>rotation()const</a></code></p>
     */
    @QtUninvokable
    public final float rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#setRotation">QBarDataItem::<wbr/>setRotation(float)</a></code></p>
     */
    @QtUninvokable
    public final void setRotation(float angle){
        setRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    @QtUninvokable
    private native void setRotation_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#setValue">QBarDataItem::<wbr/>setValue(float)</a></code></p>
     */
    @QtUninvokable
    public final void setValue(float val){
        setValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), val);
    }
    
    @QtUninvokable
    private native void setValue_native_float(long __this__nativeId, float val);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataitem.html#value">QBarDataItem::<wbr/>value()const</a></code></p>
     */
    @QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QBarDataItem(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator==(QBarDataItem,<wbr/>QBarDataItem)</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.datavis.QBarDataItem) {
            return equals((io.qt.datavis.QBarDataItem) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QBarDataItem)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QBarDataItem clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QBarDataItem clone_native(long __this_nativeId);
}
