package io.qt.datavis;

import io.qt.*;


/**
 * <p>Formatting rules for a logarithmic value axis</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html">QLogValue3DAxisFormatter</a></code></p>
 */
public class QLogValue3DAxisFormatter extends io.qt.datavis.QValue3DAxisFormatter
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLogValue3DAxisFormatter.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#autoSubGrid-prop">QLogValue3DAxisFormatter::<wbr>autoSubGridChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="autoSubGrid")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoSubGridChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#base-prop">QLogValue3DAxisFormatter::<wbr>baseChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="base")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> baseChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#showEdgeLabels-prop">QLogValue3DAxisFormatter::<wbr>showEdgeLabelsChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="showEdgeLabels")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> showEdgeLabelsChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#QLogValue3DAxisFormatter-1">QLogValue3DAxisFormatter::<wbr>QLogValue3DAxisFormatter(QObject*)</a></code></p>
     */
    public QLogValue3DAxisFormatter(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLogValue3DAxisFormatter instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#autoSubGrid-prop">QLogValue3DAxisFormatter::<wbr>autoSubGrid()const</a></code></p>
     */
    @QtPropertyReader(name="autoSubGrid")
    @QtUninvokable
    public final boolean autoSubGrid(){
        return autoSubGrid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoSubGrid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#base-prop">QLogValue3DAxisFormatter::<wbr>base()const</a></code></p>
     */
    @QtPropertyReader(name="base")
    @QtUninvokable
    public final double base(){
        return base_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double base_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#autoSubGrid-prop">QLogValue3DAxisFormatter::<wbr>setAutoSubGrid(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoSubGrid")
    @QtUninvokable
    public final void setAutoSubGrid(boolean enabled){
        setAutoSubGrid_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setAutoSubGrid_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#base-prop">QLogValue3DAxisFormatter::<wbr>setBase(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="base")
    @QtUninvokable
    public final void setBase(double base){
        setBase_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), base);
    }
    
    @QtUninvokable
    private native void setBase_native_qreal(long __this__nativeId, double base);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#showEdgeLabels-prop">QLogValue3DAxisFormatter::<wbr>setShowEdgeLabels(bool)</a></code></p>
     */
    @QtPropertyWriter(name="showEdgeLabels")
    @QtUninvokable
    public final void setShowEdgeLabels(boolean enabled){
        setShowEdgeLabels_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setShowEdgeLabels_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#showEdgeLabels-prop">QLogValue3DAxisFormatter::<wbr>showEdgeLabels()const</a></code></p>
     */
    @QtPropertyReader(name="showEdgeLabels")
    @QtUninvokable
    public final boolean showEdgeLabels(){
        return showEdgeLabels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean showEdgeLabels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#createNewInstance">QValue3DAxisFormatter::<wbr>createNewInstance()const</a></code></p>
     */
    @QtUninvokable
    @Override
    protected io.qt.datavis.@Nullable QValue3DAxisFormatter createNewInstance(){
        return createNewInstance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxisFormatter createNewInstance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#populateCopy">QValue3DAxisFormatter::<wbr>populateCopy(QValue3DAxisFormatter&amp;)const</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void populateCopy(io.qt.datavis.@StrictNonNull QValue3DAxisFormatter copy){
        java.util.Objects.requireNonNull(copy, "Argument 'copy': null not expected.");
        populateCopy_native_ref_QValue3DAxisFormatter_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(copy));
    }
    
    @QtUninvokable
    private native void populateCopy_native_ref_QValue3DAxisFormatter_constfct(long __this__nativeId, long copy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#positionAt">QValue3DAxisFormatter::<wbr>positionAt(float)const</a></code></p>
     */
    @QtUninvokable
    @Override
    protected float positionAt(float value){
        return positionAt_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native float positionAt_native_float_constfct(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#recalculate">QValue3DAxisFormatter::<wbr>recalculate()</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void recalculate(){
        recalculate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void recalculate_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#valueAt">QValue3DAxisFormatter::<wbr>valueAt(float)const</a></code></p>
     */
    @QtUninvokable
    @Override
    protected float valueAt(float position){
        return valueAt_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), position);
    }
    
    @QtUninvokable
    private native float valueAt_native_float_constfct(long __this__nativeId, float position);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QLogValue3DAxisFormatter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QLogValue3DAxisFormatter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QLogValue3DAxisFormatter instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QLogValue3DAxisFormatter(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QLogValue3DAxisFormatter() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoSubGrid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoSubGrid() {
        return autoSubGrid();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #base()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getBase() {
        return base();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #showEdgeLabels()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getShowEdgeLabels() {
        return showEdgeLabels();
    }
}
