package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base proxy class for Q3DSurface</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html">QHeightMapSurfaceDataProxy</a></code></p>
 */
public class QHeightMapSurfaceDataProxy extends io.qt.datavis.QSurfaceDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHeightMapSurfaceDataProxy.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#autoScaleY-prop">QHeightMapSurfaceDataProxy::<wbr>autoScaleYChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="autoScaleY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoScaleYChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMap-prop">QHeightMapSurfaceDataProxy::<wbr>heightMapChanged(QImage)</a></code></p>
     */
    @QtPropertyNotify(name="heightMap")
    public final @NonNull Signal1<io.qt.gui.@NonNull QImage> heightMapChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMapFile-prop">QHeightMapSurfaceDataProxy::<wbr>heightMapFileChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="heightMapFile")
    public final @NonNull Signal1<java.lang.@NonNull String> heightMapFileChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::<wbr>maxXValueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="maxXValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxXValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxYValue-prop">QHeightMapSurfaceDataProxy::<wbr>maxYValueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="maxYValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxYValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::<wbr>maxZValueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="maxZValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxZValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::<wbr>minXValueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="minXValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minXValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minYValue-prop">QHeightMapSurfaceDataProxy::<wbr>minYValueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="minYValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minYValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::<wbr>minZValueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="minZValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minZValueChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy">QHeightMapSurfaceDataProxy::<wbr>QHeightMapSurfaceDataProxy(QObject*)</a></code></p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy-1">QHeightMapSurfaceDataProxy::<wbr>QHeightMapSurfaceDataProxy(QImage,<wbr>QObject*)</a></code></p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.gui.@NonNull QImage image, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, image, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, io.qt.gui.QImage image, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy-2">QHeightMapSurfaceDataProxy::<wbr>QHeightMapSurfaceDataProxy(QString,<wbr>QObject*)</a></code></p>
     */
    public QHeightMapSurfaceDataProxy(java.lang.@NonNull String filename, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, filename, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, java.lang.String filename, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#autoScaleY-prop">QHeightMapSurfaceDataProxy::<wbr>autoScaleY()const</a></code></p>
     */
    @QtPropertyReader(name="autoScaleY")
    @QtUninvokable
    public final boolean autoScaleY(){
        return autoScaleY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoScaleY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMap-prop">QHeightMapSurfaceDataProxy::<wbr>heightMap()const</a></code></p>
     */
    @QtPropertyReader(name="heightMap")
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage heightMap(){
        return heightMap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage heightMap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMapFile-prop">QHeightMapSurfaceDataProxy::<wbr>heightMapFile()const</a></code></p>
     */
    @QtPropertyReader(name="heightMapFile")
    @QtUninvokable
    public final java.lang.@NonNull String heightMapFile(){
        return heightMapFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String heightMapFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::<wbr>maxXValue()const</a></code></p>
     */
    @QtPropertyReader(name="maxXValue")
    @QtUninvokable
    public final float maxXValue(){
        return maxXValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxXValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxYValue-prop">QHeightMapSurfaceDataProxy::<wbr>maxYValue()const</a></code></p>
     */
    @QtPropertyReader(name="maxYValue")
    @QtUninvokable
    public final float maxYValue(){
        return maxYValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxYValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::<wbr>maxZValue()const</a></code></p>
     */
    @QtPropertyReader(name="maxZValue")
    @QtUninvokable
    public final float maxZValue(){
        return maxZValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxZValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::<wbr>minXValue()const</a></code></p>
     */
    @QtPropertyReader(name="minXValue")
    @QtUninvokable
    public final float minXValue(){
        return minXValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minXValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minYValue-prop">QHeightMapSurfaceDataProxy::<wbr>minYValue()const</a></code></p>
     */
    @QtPropertyReader(name="minYValue")
    @QtUninvokable
    public final float minYValue(){
        return minYValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minYValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::<wbr>minZValue()const</a></code></p>
     */
    @QtPropertyReader(name="minZValue")
    @QtUninvokable
    public final float minZValue(){
        return minZValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minZValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#autoScaleY-prop">QHeightMapSurfaceDataProxy::<wbr>setAutoScaleY(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoScaleY")
    @QtUninvokable
    public final void setAutoScaleY(boolean enabled){
        setAutoScaleY_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setAutoScaleY_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setHeightMap">QHeightMapSurfaceDataProxy::<wbr>setHeightMap(QImage)</a></code></p>
     */
    @QtPropertyWriter(name="heightMap")
    @QtUninvokable
    public final void setHeightMap(io.qt.gui.@NonNull QImage image){
        setHeightMap_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    @QtUninvokable
    private native void setHeightMap_native_cref_QImage(long __this__nativeId, long image);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setHeightMapFile">QHeightMapSurfaceDataProxy::<wbr>setHeightMapFile(QString)</a></code></p>
     */
    @QtPropertyWriter(name="heightMapFile")
    @QtUninvokable
    public final void setHeightMapFile(java.lang.@NonNull String filename){
        setHeightMapFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filename);
    }
    
    @QtUninvokable
    private native void setHeightMapFile_native_cref_QString(long __this__nativeId, java.lang.String filename);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::<wbr>setMaxXValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="maxXValue")
    @QtUninvokable
    public final void setMaxXValue(float max){
        setMaxXValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @QtUninvokable
    private native void setMaxXValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxYValue-prop">QHeightMapSurfaceDataProxy::<wbr>setMaxYValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="maxYValue")
    @QtUninvokable
    public final void setMaxYValue(float max){
        setMaxYValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @QtUninvokable
    private native void setMaxYValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::<wbr>setMaxZValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="maxZValue")
    @QtUninvokable
    public final void setMaxZValue(float max){
        setMaxZValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @QtUninvokable
    private native void setMaxZValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::<wbr>setMinXValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="minXValue")
    @QtUninvokable
    public final void setMinXValue(float min){
        setMinXValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @QtUninvokable
    private native void setMinXValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minYValue-prop">QHeightMapSurfaceDataProxy::<wbr>setMinYValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="minYValue")
    @QtUninvokable
    public final void setMinYValue(float min){
        setMinYValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @QtUninvokable
    private native void setMinYValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::<wbr>setMinZValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="minZValue")
    @QtUninvokable
    public final void setMinZValue(float min){
        setMinZValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @QtUninvokable
    private native void setMinZValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setValueRanges">QHeightMapSurfaceDataProxy::<wbr>setValueRanges(float,<wbr>float,<wbr>float,<wbr>float)</a></code></p>
     */
    @QtUninvokable
    public final void setValueRanges(float minX, float maxX, float minZ, float maxZ){
        setValueRanges_native_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), minX, maxX, minZ, maxZ);
    }
    
    @QtUninvokable
    private native void setValueRanges_native_float_float_float_float(long __this__nativeId, float minX, float maxX, float minZ, float maxZ);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHeightMapSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QHeightMapSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QHeightMapSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(io.qt.gui.QImage, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.gui.@NonNull QImage image) {
        this(image, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy(java.lang.@NonNull String filename) {
        this(filename, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoScaleY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoScaleY() {
        return autoScaleY();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #heightMap()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage getHeightMap() {
        return heightMap();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #heightMapFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getHeightMapFile() {
        return heightMapFile();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxXValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxXValue() {
        return maxXValue();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxYValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxYValue() {
        return maxYValue();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxZValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxZValue() {
        return maxZValue();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minXValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinXValue() {
        return minXValue();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minYValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinYValue() {
        return minYValue();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minZValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinZValue() {
        return minZValue();
    }
}
