package io.qt.datavis;

import io.qt.*;


/**
 * <p>Window and render loop for graphs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html">QAbstract3DGraph</a></code></p>
 */
public class QAbstract3DGraph extends io.qt.gui.QWindow
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DGraph.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::ElementType</a></code></p>
     */
    public enum ElementType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::<wbr>ElementNone</a></code></p>
         */
        ElementNone(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::<wbr>ElementSeries</a></code></p>
         */
        ElementSeries(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::<wbr>ElementAxisXLabel</a></code></p>
         */
        ElementAxisXLabel(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::<wbr>ElementAxisYLabel</a></code></p>
         */
        ElementAxisYLabel(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::<wbr>ElementAxisZLabel</a></code></p>
         */
        ElementAxisZLabel(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::<wbr>ElementCustomItem</a></code></p>
         */
        ElementCustomItem(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ElementType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ElementType resolve(int value) {
            switch (value) {
            case 0: return ElementNone;
            case 1: return ElementSeries;
            case 2: return ElementAxisXLabel;
            case 3: return ElementAxisYLabel;
            case 4: return ElementAxisZLabel;
            case 5: return ElementCustomItem;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#OptimizationHint-enum">QAbstract3DGraph::OptimizationHint</a></code></p>
     * 
     * @see OptimizationHints
     */
    public enum OptimizationHint implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#OptimizationHint-enum">QAbstract3DGraph::<wbr>OptimizationDefault</a></code></p>
         */
        OptimizationDefault(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#OptimizationHint-enum">QAbstract3DGraph::<wbr>OptimizationStatic</a></code></p>
         */
        OptimizationStatic(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private OptimizationHint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull OptimizationHints asFlags() {
            return new OptimizationHints(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull OptimizationHints combined(@NonNull OptimizationHint e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull OptimizationHints cleared(@NonNull OptimizationHint e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link OptimizationHints} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull OptimizationHints flags(@Nullable OptimizationHint @NonNull... values) {
            return new OptimizationHints(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull OptimizationHint resolve(int value) {
            switch (value) {
            case 0: return OptimizationDefault;
            case 1: return OptimizationStatic;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link OptimizationHint}
     */
    public static final class OptimizationHints extends QFlags<OptimizationHint> implements Comparable<OptimizationHints> {
        private static final long serialVersionUID = 0xc1f9e34912806440L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new OptimizationHints where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public OptimizationHints(@Nullable OptimizationHint @NonNull... args){
            super(args);
        }

        /**
         * Creates a new OptimizationHints with given <code>value</code>.
         * @param value
         */
        public OptimizationHints(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new OptimizationHints
         */
        @Override
        public final @NonNull OptimizationHints combined(@StrictNonNull OptimizationHint e){
            return new OptimizationHints(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull OptimizationHints setFlag(@Nullable OptimizationHint e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull OptimizationHints setFlag(@Nullable OptimizationHint e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this OptimizationHints.
         * @return array of enum entries
         */
        @Override
        public final @NonNull OptimizationHint @NonNull[] flags(){
            return super.flags(OptimizationHint.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull OptimizationHints clone(){
            return new OptimizationHints(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull OptimizationHints other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::SelectionFlag</a></code></p>
     * 
     * @see SelectionFlags
     */
    public enum SelectionFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionNone</a></code></p>
         */
        SelectionNone(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionItem</a></code></p>
         */
        SelectionItem(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionRow</a></code></p>
         */
        SelectionRow(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionItemAndRow</a></code></p>
         */
        SelectionItemAndRow(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionColumn</a></code></p>
         */
        SelectionColumn(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionItemAndColumn</a></code></p>
         */
        SelectionItemAndColumn(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionRowAndColumn</a></code></p>
         */
        SelectionRowAndColumn(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionItemRowAndColumn</a></code></p>
         */
        SelectionItemRowAndColumn(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionSlice</a></code></p>
         */
        SelectionSlice(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::<wbr>SelectionMultiSeries</a></code></p>
         */
        SelectionMultiSeries(16);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SelectionFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull SelectionFlags asFlags() {
            return new SelectionFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull SelectionFlags combined(@NonNull SelectionFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull SelectionFlags cleared(@NonNull SelectionFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link SelectionFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull SelectionFlags flags(@Nullable SelectionFlag @NonNull... values) {
            return new SelectionFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SelectionFlag resolve(int value) {
            switch (value) {
            case 0: return SelectionNone;
            case 1: return SelectionItem;
            case 2: return SelectionRow;
            case 3: return SelectionItemAndRow;
            case 4: return SelectionColumn;
            case 5: return SelectionItemAndColumn;
            case 6: return SelectionRowAndColumn;
            case 7: return SelectionItemRowAndColumn;
            case 8: return SelectionSlice;
            case 16: return SelectionMultiSeries;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link SelectionFlag}
     */
    public static final class SelectionFlags extends QFlags<SelectionFlag> implements Comparable<SelectionFlags> {
        private static final long serialVersionUID = 0x94dda626326e2012L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new SelectionFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public SelectionFlags(@Nullable SelectionFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new SelectionFlags with given <code>value</code>.
         * @param value
         */
        public SelectionFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new SelectionFlags
         */
        @Override
        public final @NonNull SelectionFlags combined(@StrictNonNull SelectionFlag e){
            return new SelectionFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull SelectionFlags setFlag(@Nullable SelectionFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull SelectionFlags setFlag(@Nullable SelectionFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this SelectionFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull SelectionFlag @NonNull[] flags(){
            return super.flags(SelectionFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull SelectionFlags clone(){
            return new SelectionFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull SelectionFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::ShadowQuality</a></code></p>
     */
    public enum ShadowQuality implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::<wbr>ShadowQualityNone</a></code></p>
         */
        ShadowQualityNone(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::<wbr>ShadowQualityLow</a></code></p>
         */
        ShadowQualityLow(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::<wbr>ShadowQualityMedium</a></code></p>
         */
        ShadowQualityMedium(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::<wbr>ShadowQualityHigh</a></code></p>
         */
        ShadowQualityHigh(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::<wbr>ShadowQualitySoftLow</a></code></p>
         */
        ShadowQualitySoftLow(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::<wbr>ShadowQualitySoftMedium</a></code></p>
         */
        ShadowQualitySoftMedium(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::<wbr>ShadowQualitySoftHigh</a></code></p>
         */
        ShadowQualitySoftHigh(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShadowQuality(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ShadowQuality resolve(int value) {
            switch (value) {
            case 0: return ShadowQualityNone;
            case 1: return ShadowQualityLow;
            case 2: return ShadowQualityMedium;
            case 3: return ShadowQualityHigh;
            case 4: return ShadowQualitySoftLow;
            case 5: return ShadowQualitySoftMedium;
            case 6: return ShadowQualitySoftHigh;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeInputHandler-prop">QAbstract3DGraph::<wbr>activeInputHandlerChanged(QAbstract3DInputHandler*)</a></code></p>
     */
    @QtPropertyNotify(name="activeInputHandler")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QAbstract3DInputHandler> activeInputHandlerChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeTheme-prop">QAbstract3DGraph::<wbr>activeThemeChanged(Q3DTheme*)</a></code></p>
     */
    @QtPropertyNotify(name="activeTheme")
    public final @NonNull Signal1<io.qt.datavis.@Nullable Q3DTheme> activeThemeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#aspectRatio-prop">QAbstract3DGraph::<wbr>aspectRatioChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="aspectRatio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> aspectRatioChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#currentFps-prop">QAbstract3DGraph::<wbr>currentFpsChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="currentFps")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> currentFpsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#horizontalAspectRatio-prop">QAbstract3DGraph::<wbr>horizontalAspectRatioChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="horizontalAspectRatio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> horizontalAspectRatioChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#locale-prop">QAbstract3DGraph::<wbr>localeChanged(QLocale)</a></code></p>
     */
    @QtPropertyNotify(name="locale")
    public final @NonNull Signal1<io.qt.core.@NonNull QLocale> localeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#margin-prop">QAbstract3DGraph::<wbr>marginChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="margin")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> marginChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#measureFps-prop">QAbstract3DGraph::<wbr>measureFpsChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="measureFps")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> measureFpsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#optimizationHints-prop">QAbstract3DGraph::<wbr>optimizationHintsChanged(QAbstract3DGraph::OptimizationHints)</a></code></p>
     */
    @QtPropertyNotify(name="optimizationHints")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DGraph.@NonNull OptimizationHints> optimizationHintsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#orthoProjection-prop">QAbstract3DGraph::<wbr>orthoProjectionChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="orthoProjection")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> orthoProjectionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#polar-prop">QAbstract3DGraph::<wbr>polarChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="polar")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> polarChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#queriedGraphPosition-prop">QAbstract3DGraph::<wbr>queriedGraphPositionChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="queriedGraphPosition")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> queriedGraphPositionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#radialLabelOffset-prop">QAbstract3DGraph::<wbr>radialLabelOffsetChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="radialLabelOffset")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> radialLabelOffsetChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflection-prop">QAbstract3DGraph::<wbr>reflectionChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="reflection")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> reflectionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflectivity-prop">QAbstract3DGraph::<wbr>reflectivityChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="reflectivity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> reflectivityChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedElement-prop">QAbstract3DGraph::<wbr>selectedElementChanged(QAbstract3DGraph::ElementType)</a></code></p>
     */
    @QtPropertyNotify(name="selectedElement")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DGraph.@NonNull ElementType> selectedElementChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectionMode-prop">QAbstract3DGraph::<wbr>selectionModeChanged(QAbstract3DGraph::SelectionFlags)</a></code></p>
     */
    @QtPropertyNotify(name="selectionMode")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DGraph.@NonNull SelectionFlags> selectionModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#shadowQuality-prop">QAbstract3DGraph::<wbr>shadowQualityChanged(QAbstract3DGraph::ShadowQuality)</a></code></p>
     */
    @QtPropertyNotify(name="shadowQuality")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DGraph.@NonNull ShadowQuality> shadowQualityChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeInputHandler-prop">QAbstract3DGraph::<wbr>activeInputHandler()const</a></code></p>
     */
    @QtPropertyReader(name="activeInputHandler")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QAbstract3DInputHandler activeInputHandler(){
        return activeInputHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QAbstract3DInputHandler activeInputHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeTheme-prop">QAbstract3DGraph::<wbr>activeTheme()const</a></code></p>
     */
    @QtPropertyReader(name="activeTheme")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DTheme activeTheme(){
        return activeTheme_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DTheme activeTheme_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#addCustomItem">QAbstract3DGraph::<wbr>addCustomItem(QCustom3DItem*)</a></code></p>
     */
    @QtUninvokable
    public final int addCustomItem(io.qt.datavis.@Nullable QCustom3DItem item){
        return addCustomItem_native_QCustom3DItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native int addCustomItem_native_QCustom3DItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#addInputHandler">QAbstract3DGraph::<wbr>addInputHandler(QAbstract3DInputHandler*)</a></code></p>
     */
    @QtUninvokable
    public final void addInputHandler(io.qt.datavis.@Nullable QAbstract3DInputHandler inputHandler){
        addInputHandler_native_QAbstract3DInputHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inputHandler));
    }
    
    @QtUninvokable
    private native void addInputHandler_native_QAbstract3DInputHandler_ptr(long __this__nativeId, long inputHandler);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#addTheme">QAbstract3DGraph::<wbr>addTheme(Q3DTheme*)</a></code></p>
     */
    @QtUninvokable
    public final void addTheme(io.qt.datavis.@Nullable Q3DTheme theme){
        addTheme_native_Q3DTheme_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(theme));
    }
    
    @QtUninvokable
    private native void addTheme_native_Q3DTheme_ptr(long __this__nativeId, long theme);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#aspectRatio-prop">QAbstract3DGraph::<wbr>aspectRatio()const</a></code></p>
     */
    @QtPropertyReader(name="aspectRatio")
    @QtUninvokable
    public final double aspectRatio(){
        return aspectRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double aspectRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#clearSelection">QAbstract3DGraph::<wbr>clearSelection()</a></code></p>
     */
    @QtUninvokable
    public final void clearSelection(){
        clearSelection_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearSelection_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#currentFps-prop">QAbstract3DGraph::<wbr>currentFps()const</a></code></p>
     */
    @QtPropertyReader(name="currentFps")
    @QtUninvokable
    public final double currentFps(){
        return currentFps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double currentFps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#customItems">QAbstract3DGraph::<wbr>customItems()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.datavis.@Nullable QCustom3DItem> customItems(){
        return customItems_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QCustom3DItem> customItems_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAbstract3DGraph::<wbr>functions()</code></p>
     */
    @QtUninvokable
    protected final io.qt.gui.@Nullable QOpenGLFunctions functions(){
        return functions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QOpenGLFunctions functions_native(long __this__nativeId);
    
    /**
     * <p>See <code>QAbstract3DGraph::<wbr>hasContext()const</code></p>
     */
    @QtUninvokable
    public final boolean hasContext(){
        return hasContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#hasSeries">QAbstract3DGraph::<wbr>hasSeries(QAbstract3DSeries*)const</a></code></p>
     */
    @QtUninvokable
    public final boolean hasSeries(io.qt.datavis.@Nullable QAbstract3DSeries series){
        return hasSeries_native_QAbstract3DSeries_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @QtUninvokable
    private native boolean hasSeries_native_QAbstract3DSeries_ptr_constfct(long __this__nativeId, long series);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#horizontalAspectRatio-prop">QAbstract3DGraph::<wbr>horizontalAspectRatio()const</a></code></p>
     */
    @QtPropertyReader(name="horizontalAspectRatio")
    @QtUninvokable
    public final double horizontalAspectRatio(){
        return horizontalAspectRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double horizontalAspectRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#inputHandlers">QAbstract3DGraph::<wbr>inputHandlers()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.datavis.@Nullable QAbstract3DInputHandler> inputHandlers(){
        return inputHandlers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QAbstract3DInputHandler> inputHandlers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#orthoProjection-prop">QAbstract3DGraph::<wbr>isOrthoProjection()const</a></code></p>
     */
    @QtPropertyReader(name="orthoProjection")
    @QtUninvokable
    public final boolean isOrthoProjection(){
        return isOrthoProjection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOrthoProjection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#polar-prop">QAbstract3DGraph::<wbr>isPolar()const</a></code></p>
     */
    @QtPropertyReader(name="polar")
    @QtUninvokable
    public final boolean isPolar(){
        return isPolar_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPolar_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflection-prop">QAbstract3DGraph::<wbr>isReflection()const</a></code></p>
     */
    @QtPropertyReader(name="reflection")
    @QtUninvokable
    public final boolean isReflection(){
        return isReflection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReflection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#locale-prop">QAbstract3DGraph::<wbr>locale()const</a></code></p>
     */
    @QtPropertyReader(name="locale")
    @QtUninvokable
    public final io.qt.core.@NonNull QLocale locale(){
        return locale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QLocale locale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#margin-prop">QAbstract3DGraph::<wbr>margin()const</a></code></p>
     */
    @QtPropertyReader(name="margin")
    @QtUninvokable
    public final double margin(){
        return margin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double margin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#measureFps-prop">QAbstract3DGraph::<wbr>measureFps()const</a></code></p>
     */
    @QtPropertyReader(name="measureFps")
    @QtUninvokable
    public final boolean measureFps(){
        return measureFps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean measureFps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#optimizationHints-prop">QAbstract3DGraph::<wbr>optimizationHints()const</a></code></p>
     */
    @QtPropertyReader(name="optimizationHints")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull OptimizationHints optimizationHints(){
        return new io.qt.datavis.QAbstract3DGraph.OptimizationHints(optimizationHints_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int optimizationHints_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#queriedGraphPosition-prop">QAbstract3DGraph::<wbr>queriedGraphPosition()const</a></code></p>
     */
    @QtPropertyReader(name="queriedGraphPosition")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D queriedGraphPosition(){
        return queriedGraphPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D queriedGraphPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#radialLabelOffset-prop">QAbstract3DGraph::<wbr>radialLabelOffset()const</a></code></p>
     */
    @QtPropertyReader(name="radialLabelOffset")
    @QtUninvokable
    public final float radialLabelOffset(){
        return radialLabelOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float radialLabelOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflectivity-prop">QAbstract3DGraph::<wbr>reflectivity()const</a></code></p>
     */
    @QtPropertyReader(name="reflectivity")
    @QtUninvokable
    public final double reflectivity(){
        return reflectivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double reflectivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#releaseCustomItem">QAbstract3DGraph::<wbr>releaseCustomItem(QCustom3DItem*)</a></code></p>
     */
    @QtUninvokable
    public final void releaseCustomItem(io.qt.datavis.@Nullable QCustom3DItem item){
        releaseCustomItem_native_QCustom3DItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void releaseCustomItem_native_QCustom3DItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#releaseInputHandler">QAbstract3DGraph::<wbr>releaseInputHandler(QAbstract3DInputHandler*)</a></code></p>
     */
    @QtUninvokable
    public final void releaseInputHandler(io.qt.datavis.@Nullable QAbstract3DInputHandler inputHandler){
        releaseInputHandler_native_QAbstract3DInputHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inputHandler));
    }
    
    @QtUninvokable
    private native void releaseInputHandler_native_QAbstract3DInputHandler_ptr(long __this__nativeId, long inputHandler);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#releaseTheme">QAbstract3DGraph::<wbr>releaseTheme(Q3DTheme*)</a></code></p>
     */
    @QtUninvokable
    public final void releaseTheme(io.qt.datavis.@Nullable Q3DTheme theme){
        releaseTheme_native_Q3DTheme_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(theme));
    }
    
    @QtUninvokable
    private native void releaseTheme_native_Q3DTheme_ptr(long __this__nativeId, long theme);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#removeCustomItem">QAbstract3DGraph::<wbr>removeCustomItem(QCustom3DItem*)</a></code></p>
     */
    @QtUninvokable
    public final void removeCustomItem(io.qt.datavis.@Nullable QCustom3DItem item){
        removeCustomItem_native_QCustom3DItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void removeCustomItem_native_QCustom3DItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#removeCustomItemAt">QAbstract3DGraph::<wbr>removeCustomItemAt(QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void removeCustomItemAt(io.qt.gui.@NonNull QVector3D position){
        removeCustomItemAt_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void removeCustomItemAt_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#removeCustomItems">QAbstract3DGraph::<wbr>removeCustomItems()</a></code></p>
     */
    @QtUninvokable
    public final void removeCustomItems(){
        removeCustomItems_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void removeCustomItems_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#renderToImage">QAbstract3DGraph::<wbr>renderToImage(int,<wbr>QSize)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage renderToImage(int msaaSamples, io.qt.core.@NonNull QSize imageSize){
        return renderToImage_native_int_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), msaaSamples, QtJambi_LibraryUtilities.internal.checkedNativeId(imageSize));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage renderToImage_native_int_cref_QSize(long __this__nativeId, int msaaSamples, long imageSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#scene-prop">QAbstract3DGraph::<wbr>scene()const</a></code></p>
     */
    @QtPropertyReader(name="scene")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DScene scene(){
        return scene_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DScene scene_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedAxis">QAbstract3DGraph::<wbr>selectedAxis()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QAbstract3DAxis selectedAxis(){
        return selectedAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QAbstract3DAxis selectedAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedCustomItem">QAbstract3DGraph::<wbr>selectedCustomItem()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QCustom3DItem selectedCustomItem(){
        return selectedCustomItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QCustom3DItem selectedCustomItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedCustomItemIndex">QAbstract3DGraph::<wbr>selectedCustomItemIndex()const</a></code></p>
     */
    @QtUninvokable
    public final int selectedCustomItemIndex(){
        return selectedCustomItemIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int selectedCustomItemIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedElement-prop">QAbstract3DGraph::<wbr>selectedElement()const</a></code></p>
     */
    @QtPropertyReader(name="selectedElement")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull ElementType selectedElement(){
        return io.qt.datavis.QAbstract3DGraph.ElementType.resolve(selectedElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int selectedElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedLabelIndex">QAbstract3DGraph::<wbr>selectedLabelIndex()const</a></code></p>
     */
    @QtUninvokable
    public final int selectedLabelIndex(){
        return selectedLabelIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int selectedLabelIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectionMode-prop">QAbstract3DGraph::<wbr>selectionMode()const</a></code></p>
     */
    @QtPropertyReader(name="selectionMode")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull SelectionFlags selectionMode(){
        return new io.qt.datavis.QAbstract3DGraph.SelectionFlags(selectionMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int selectionMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#setActiveInputHandler">QAbstract3DGraph::<wbr>setActiveInputHandler(QAbstract3DInputHandler*)</a></code></p>
     */
    @QtPropertyWriter(name="activeInputHandler")
    @QtUninvokable
    public final void setActiveInputHandler(io.qt.datavis.@Nullable QAbstract3DInputHandler inputHandler){
        setActiveInputHandler_native_QAbstract3DInputHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inputHandler));
    }
    
    @QtUninvokable
    private native void setActiveInputHandler_native_QAbstract3DInputHandler_ptr(long __this__nativeId, long inputHandler);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeTheme-prop">QAbstract3DGraph::<wbr>setActiveTheme(Q3DTheme*)</a></code></p>
     */
    @QtPropertyWriter(name="activeTheme")
    @QtUninvokable
    public final void setActiveTheme(io.qt.datavis.@Nullable Q3DTheme theme){
        setActiveTheme_native_Q3DTheme_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(theme));
    }
    
    @QtUninvokable
    private native void setActiveTheme_native_Q3DTheme_ptr(long __this__nativeId, long theme);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#aspectRatio-prop">QAbstract3DGraph::<wbr>setAspectRatio(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="aspectRatio")
    @QtUninvokable
    public final void setAspectRatio(double ratio){
        setAspectRatio_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), ratio);
    }
    
    @QtUninvokable
    private native void setAspectRatio_native_qreal(long __this__nativeId, double ratio);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#horizontalAspectRatio-prop">QAbstract3DGraph::<wbr>setHorizontalAspectRatio(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="horizontalAspectRatio")
    @QtUninvokable
    public final void setHorizontalAspectRatio(double ratio){
        setHorizontalAspectRatio_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), ratio);
    }
    
    @QtUninvokable
    private native void setHorizontalAspectRatio_native_qreal(long __this__nativeId, double ratio);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#locale-prop">QAbstract3DGraph::<wbr>setLocale(QLocale)</a></code></p>
     */
    @QtPropertyWriter(name="locale")
    @QtUninvokable
    public final void setLocale(io.qt.core.@NonNull QLocale locale){
        setLocale_native_cref_QLocale(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(locale));
    }
    
    @QtUninvokable
    private native void setLocale_native_cref_QLocale(long __this__nativeId, long locale);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#margin-prop">QAbstract3DGraph::<wbr>setMargin(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="margin")
    @QtUninvokable
    public final void setMargin(double margin){
        setMargin_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), margin);
    }
    
    @QtUninvokable
    private native void setMargin_native_qreal(long __this__nativeId, double margin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#measureFps-prop">QAbstract3DGraph::<wbr>setMeasureFps(bool)</a></code></p>
     */
    @QtPropertyWriter(name="measureFps")
    @QtUninvokable
    public final void setMeasureFps(boolean enable){
        setMeasureFps_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setMeasureFps_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#optimizationHints-prop">QAbstract3DGraph::<wbr>setOptimizationHints(QAbstract3DGraph::OptimizationHints)</a></code></p>
     */
    @QtPropertyWriter(name="optimizationHints")
    @QtUninvokable
    public final void setOptimizationHints(io.qt.datavis.QAbstract3DGraph.@NonNull OptimizationHints hints){
        setOptimizationHints_native_QAbstract3DGraph_OptimizationHints(QtJambi_LibraryUtilities.internal.nativeId(this), hints.value());
    }
    
    @QtUninvokable
    private native void setOptimizationHints_native_QAbstract3DGraph_OptimizationHints(long __this__nativeId, int hints);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#orthoProjection-prop">QAbstract3DGraph::<wbr>setOrthoProjection(bool)</a></code></p>
     */
    @QtPropertyWriter(name="orthoProjection")
    @QtUninvokable
    public final void setOrthoProjection(boolean enable){
        setOrthoProjection_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setOrthoProjection_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#polar-prop">QAbstract3DGraph::<wbr>setPolar(bool)</a></code></p>
     */
    @QtPropertyWriter(name="polar")
    @QtUninvokable
    public final void setPolar(boolean enable){
        setPolar_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setPolar_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#radialLabelOffset-prop">QAbstract3DGraph::<wbr>setRadialLabelOffset(float)</a></code></p>
     */
    @QtPropertyWriter(name="radialLabelOffset")
    @QtUninvokable
    public final void setRadialLabelOffset(float offset){
        setRadialLabelOffset_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    @QtUninvokable
    private native void setRadialLabelOffset_native_float(long __this__nativeId, float offset);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflection-prop">QAbstract3DGraph::<wbr>setReflection(bool)</a></code></p>
     */
    @QtPropertyWriter(name="reflection")
    @QtUninvokable
    public final void setReflection(boolean enable){
        setReflection_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setReflection_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflectivity-prop">QAbstract3DGraph::<wbr>setReflectivity(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="reflectivity")
    @QtUninvokable
    public final void setReflectivity(double reflectivity){
        setReflectivity_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), reflectivity);
    }
    
    @QtUninvokable
    private native void setReflectivity_native_qreal(long __this__nativeId, double reflectivity);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectionMode-prop">QAbstract3DGraph::<wbr>setSelectionMode(QAbstract3DGraph::SelectionFlags)</a></code></p>
     */
    @QtPropertyWriter(name="selectionMode")
    @QtUninvokable
    public final void setSelectionMode(io.qt.datavis.QAbstract3DGraph.@NonNull SelectionFlags mode){
        setSelectionMode_native_QAbstract3DGraph_SelectionFlags(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setSelectionMode_native_QAbstract3DGraph_SelectionFlags(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#shadowQuality-prop">QAbstract3DGraph::<wbr>setShadowQuality(QAbstract3DGraph::ShadowQuality)</a></code></p>
     */
    @QtPropertyWriter(name="shadowQuality")
    @QtUninvokable
    public final void setShadowQuality(io.qt.datavis.QAbstract3DGraph.@NonNull ShadowQuality quality){
        setShadowQuality_native_QAbstract3DGraph_ShadowQuality(QtJambi_LibraryUtilities.internal.nativeId(this), quality.value());
    }
    
    @QtUninvokable
    private native void setShadowQuality_native_QAbstract3DGraph_ShadowQuality(long __this__nativeId, int quality);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#shadowQuality-prop">QAbstract3DGraph::<wbr>shadowQuality()const</a></code></p>
     */
    @QtPropertyReader(name="shadowQuality")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull ShadowQuality shadowQuality(){
        return io.qt.datavis.QAbstract3DGraph.ShadowQuality.resolve(shadowQuality_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int shadowQuality_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dgraph.html#themes">QAbstract3DGraph::<wbr>themes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.datavis.@Nullable Q3DTheme> themes(){
        return themes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.Q3DTheme> themes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean event(io.qt.core.@Nullable QEvent event){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#exposeEvent">QWindow::<wbr>exposeEvent(QExposeEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void exposeEvent(io.qt.gui.@Nullable QExposeEvent event){
        exposeEvent_native_QExposeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void exposeEvent_native_QExposeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#mouseDoubleClickEvent">QWindow::<wbr>mouseDoubleClickEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseDoubleClickEvent(io.qt.gui.@Nullable QMouseEvent event){
        mouseDoubleClickEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mouseDoubleClickEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#mouseMoveEvent">QWindow::<wbr>mouseMoveEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseMoveEvent(io.qt.gui.@Nullable QMouseEvent event){
        mouseMoveEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#mousePressEvent">QWindow::<wbr>mousePressEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mousePressEvent(io.qt.gui.@Nullable QMouseEvent event){
        mousePressEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#mouseReleaseEvent">QWindow::<wbr>mouseReleaseEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseReleaseEvent(io.qt.gui.@Nullable QMouseEvent event){
        mouseReleaseEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#resizeEvent">QWindow::<wbr>resizeEvent(QResizeEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void resizeEvent(io.qt.gui.@Nullable QResizeEvent event){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code>QAbstract3DGraph::<wbr>shadowsSupported()const</code></p>
     */
    @QtUninvokable
    public boolean shadowsSupported(){
        return shadowsSupported_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean shadowsSupported_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#touchEvent">QWindow::<wbr>touchEvent(QTouchEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void touchEvent(io.qt.gui.@Nullable QTouchEvent event){
        touchEvent_native_QTouchEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void touchEvent_native_QTouchEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindow.html#wheelEvent">QWindow::<wbr>wheelEvent(QWheelEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void wheelEvent(io.qt.gui.@Nullable QWheelEvent event){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstract3DGraph(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activeInputHandler()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QAbstract3DInputHandler getActiveInputHandler() {
        return activeInputHandler();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activeTheme()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DTheme getActiveTheme() {
        return activeTheme();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #aspectRatio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAspectRatio() {
        return aspectRatio();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #currentFps()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getCurrentFps() {
        return currentFps();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #horizontalAspectRatio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getHorizontalAspectRatio() {
        return horizontalAspectRatio();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isOrthoProjection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getOrthoProjection() {
        return isOrthoProjection();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isPolar()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPolar() {
        return isPolar();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isReflection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getReflection() {
        return isReflection();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #locale()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QLocale getLocale() {
        return locale();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #margin()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getMargin() {
        return margin();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #measureFps()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMeasureFps() {
        return measureFps();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #optimizationHints()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull OptimizationHints getOptimizationHints() {
        return optimizationHints();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #queriedGraphPosition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getQueriedGraphPosition() {
        return queriedGraphPosition();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #radialLabelOffset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRadialLabelOffset() {
        return radialLabelOffset();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reflectivity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getReflectivity() {
        return reflectivity();
    }
    
    /**
     * <p>Overloaded function for {@link #renderToImage(int, io.qt.core.QSize)}
     *  with <code>imageSize = new io.qt.core.QSize()</code>.</p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage renderToImage(int msaaSamples) {
        return renderToImage(msaaSamples, new io.qt.core.QSize());
    }
    
    /**
     * <p>Overloaded function for {@link #renderToImage(int, io.qt.core.QSize)}</p>
     * <p>with: </p><ul>
     * <li><code>msaaSamples = 0</code></li>
     * <li><code>imageSize = new io.qt.core.QSize()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage renderToImage() {
        return renderToImage((int)0, new io.qt.core.QSize());
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #scene()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DScene getScene() {
        return scene();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedElement()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull ElementType getSelectedElement() {
        return selectedElement();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectionMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull SelectionFlags getSelectionMode() {
        return selectionMode();
    }
    
    /**
     * <p>Overloaded function for {@link #setOptimizationHints(io.qt.datavis.QAbstract3DGraph.OptimizationHints)}.</p>
     */
    @QtUninvokable
    public final void setOptimizationHints(io.qt.datavis.QAbstract3DGraph.@NonNull OptimizationHint @NonNull... hints) {
        setOptimizationHints(new io.qt.datavis.QAbstract3DGraph.OptimizationHints(hints));
    }
    
    /**
     * <p>Overloaded function for {@link #setSelectionMode(io.qt.datavis.QAbstract3DGraph.SelectionFlags)}.</p>
     */
    @QtUninvokable
    public final void setSelectionMode(io.qt.datavis.QAbstract3DGraph.@NonNull SelectionFlag @NonNull... mode) {
        setSelectionMode(new io.qt.datavis.QAbstract3DGraph.SelectionFlags(mode));
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #shadowQuality()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.@NonNull ShadowQuality getShadowQuality() {
        return shadowQuality();
    }
}
