package io.qt.datavis;

import io.qt.*;


/**
 * <p>Methods for rendering 3D bar graphs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/q3dbars.html">Q3DBars</a></code></p>
 */
public class Q3DBars extends io.qt.datavis.QAbstract3DGraph
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DBars.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSeriesMargin-prop">Q3DBars::<wbr>barSeriesMarginChanged(QSizeF)</a></code></p>
     */
    @QtPropertyNotify(name="barSeriesMargin")
    public final @NonNull Signal1<io.qt.core.@NonNull QSizeF> barSeriesMarginChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSpacing-prop">Q3DBars::<wbr>barSpacingChanged(QSizeF)</a></code></p>
     */
    @QtPropertyNotify(name="barSpacing")
    public final @NonNull Signal1<io.qt.core.@NonNull QSizeF> barSpacingChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSpacingRelative-prop">Q3DBars::<wbr>barSpacingRelativeChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="barSpacingRelative")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> barSpacingRelativeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barThickness-prop">Q3DBars::<wbr>barThicknessChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="barThickness")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> barThicknessChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#columnAxis-prop">Q3DBars::<wbr>columnAxisChanged(QCategory3DAxis*)</a></code></p>
     */
    @QtPropertyNotify(name="columnAxis")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QCategory3DAxis> columnAxisChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#floorLevel-prop">Q3DBars::<wbr>floorLevelChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="floorLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> floorLevelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#multiSeriesUniform-prop">Q3DBars::<wbr>multiSeriesUniformChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="multiSeriesUniform")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> multiSeriesUniformChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#primarySeries-prop">Q3DBars::<wbr>primarySeriesChanged(QBar3DSeries*)</a></code></p>
     */
    @QtPropertyNotify(name="primarySeries")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QBar3DSeries> primarySeriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#rowAxis-prop">Q3DBars::<wbr>rowAxisChanged(QCategory3DAxis*)</a></code></p>
     */
    @QtPropertyNotify(name="rowAxis")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QCategory3DAxis> rowAxisChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#selectedSeries-prop">Q3DBars::<wbr>selectedSeriesChanged(QBar3DSeries*)</a></code></p>
     */
    @QtPropertyNotify(name="selectedSeries")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QBar3DSeries> selectedSeriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#valueAxis-prop">Q3DBars::<wbr>valueAxisChanged(QValue3DAxis*)</a></code></p>
     */
    @QtPropertyNotify(name="valueAxis")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QValue3DAxis> valueAxisChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#Q3DBars">Q3DBars::<wbr>Q3DBars(const QSurfaceFormat*,<wbr>QWindow*)</a></code></p>
     */
    public Q3DBars(io.qt.gui.@Nullable QSurfaceFormat format, io.qt.gui.@Nullable QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, format, parent);
    }
    
    private native static void initialize_native(Q3DBars instance, io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#addAxis">Q3DBars::<wbr>addAxis(QAbstract3DAxis*)</a></code></p>
     */
    @QtUninvokable
    public final void addAxis(io.qt.datavis.@Nullable QAbstract3DAxis axis){
        addAxis_native_QAbstract3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void addAxis_native_QAbstract3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#addSeries">Q3DBars::<wbr>addSeries(QBar3DSeries*)</a></code></p>
     */
    @QtUninvokable
    public final void addSeries(io.qt.datavis.@Nullable QBar3DSeries series){
        addSeries_native_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @QtUninvokable
    private native void addSeries_native_QBar3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#axes">Q3DBars::<wbr>axes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.datavis.@Nullable QAbstract3DAxis> axes(){
        return axes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QAbstract3DAxis> axes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSeriesMargin-prop">Q3DBars::<wbr>barSeriesMargin()const</a></code></p>
     */
    @QtPropertyReader(name="barSeriesMargin")
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF barSeriesMargin(){
        return barSeriesMargin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSizeF barSeriesMargin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSpacing-prop">Q3DBars::<wbr>barSpacing()const</a></code></p>
     */
    @QtPropertyReader(name="barSpacing")
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF barSpacing(){
        return barSpacing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSizeF barSpacing_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barThickness-prop">Q3DBars::<wbr>barThickness()const</a></code></p>
     */
    @QtPropertyReader(name="barThickness")
    @QtUninvokable
    public final float barThickness(){
        return barThickness_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float barThickness_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#columnAxis-prop">Q3DBars::<wbr>columnAxis()const</a></code></p>
     */
    @QtPropertyReader(name="columnAxis")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QCategory3DAxis columnAxis(){
        return columnAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QCategory3DAxis columnAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#floorLevel-prop">Q3DBars::<wbr>floorLevel()const</a></code></p>
     */
    @QtPropertyReader(name="floorLevel")
    @QtUninvokable
    public final float floorLevel(){
        return floorLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float floorLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#insertSeries">Q3DBars::<wbr>insertSeries(int,<wbr>QBar3DSeries*)</a></code></p>
     */
    @QtUninvokable
    public final void insertSeries(int index, io.qt.datavis.@Nullable QBar3DSeries series){
        insertSeries_native_int_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @QtUninvokable
    private native void insertSeries_native_int_QBar3DSeries_ptr(long __this__nativeId, int index, long series);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSpacingRelative-prop">Q3DBars::<wbr>isBarSpacingRelative()const</a></code></p>
     */
    @QtPropertyReader(name="barSpacingRelative")
    @QtUninvokable
    public final boolean isBarSpacingRelative(){
        return isBarSpacingRelative_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBarSpacingRelative_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#multiSeriesUniform-prop">Q3DBars::<wbr>isMultiSeriesUniform()const</a></code></p>
     */
    @QtPropertyReader(name="multiSeriesUniform")
    @QtUninvokable
    public final boolean isMultiSeriesUniform(){
        return isMultiSeriesUniform_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMultiSeriesUniform_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#primarySeries-prop">Q3DBars::<wbr>primarySeries()const</a></code></p>
     */
    @QtPropertyReader(name="primarySeries")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBar3DSeries primarySeries(){
        return primarySeries_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBar3DSeries primarySeries_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#releaseAxis">Q3DBars::<wbr>releaseAxis(QAbstract3DAxis*)</a></code></p>
     */
    @QtUninvokable
    public final void releaseAxis(io.qt.datavis.@Nullable QAbstract3DAxis axis){
        releaseAxis_native_QAbstract3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void releaseAxis_native_QAbstract3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#removeSeries">Q3DBars::<wbr>removeSeries(QBar3DSeries*)</a></code></p>
     */
    @QtUninvokable
    public final void removeSeries(io.qt.datavis.@Nullable QBar3DSeries series){
        removeSeries_native_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @QtUninvokable
    private native void removeSeries_native_QBar3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#rowAxis-prop">Q3DBars::<wbr>rowAxis()const</a></code></p>
     */
    @QtPropertyReader(name="rowAxis")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QCategory3DAxis rowAxis(){
        return rowAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QCategory3DAxis rowAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#selectedSeries-prop">Q3DBars::<wbr>selectedSeries()const</a></code></p>
     */
    @QtPropertyReader(name="selectedSeries")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBar3DSeries selectedSeries(){
        return selectedSeries_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBar3DSeries selectedSeries_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#seriesList">Q3DBars::<wbr>seriesList()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.datavis.@Nullable QBar3DSeries> seriesList(){
        return seriesList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QBar3DSeries> seriesList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSeriesMargin-prop">Q3DBars::<wbr>setBarSeriesMargin(QSizeF)</a></code></p>
     */
    @QtPropertyWriter(name="barSeriesMargin")
    @QtUninvokable
    public final void setBarSeriesMargin(io.qt.core.@NonNull QSizeF margin){
        setBarSeriesMargin_native_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(margin));
    }
    
    @QtUninvokable
    private native void setBarSeriesMargin_native_cref_QSizeF(long __this__nativeId, long margin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSpacing-prop">Q3DBars::<wbr>setBarSpacing(QSizeF)</a></code></p>
     */
    @QtPropertyWriter(name="barSpacing")
    @QtUninvokable
    public final void setBarSpacing(io.qt.core.@NonNull QSizeF spacing){
        setBarSpacing_native_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(spacing));
    }
    
    @QtUninvokable
    private native void setBarSpacing_native_cref_QSizeF(long __this__nativeId, long spacing);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barSpacingRelative-prop">Q3DBars::<wbr>setBarSpacingRelative(bool)</a></code></p>
     */
    @QtPropertyWriter(name="barSpacingRelative")
    @QtUninvokable
    public final void setBarSpacingRelative(boolean relative){
        setBarSpacingRelative_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), relative);
    }
    
    @QtUninvokable
    private native void setBarSpacingRelative_native_bool(long __this__nativeId, boolean relative);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#barThickness-prop">Q3DBars::<wbr>setBarThickness(float)</a></code></p>
     */
    @QtPropertyWriter(name="barThickness")
    @QtUninvokable
    public final void setBarThickness(float thicknessRatio){
        setBarThickness_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), thicknessRatio);
    }
    
    @QtUninvokable
    private native void setBarThickness_native_float(long __this__nativeId, float thicknessRatio);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#columnAxis-prop">Q3DBars::<wbr>setColumnAxis(QCategory3DAxis*)</a></code></p>
     */
    @QtPropertyWriter(name="columnAxis")
    @QtUninvokable
    public final void setColumnAxis(io.qt.datavis.@Nullable QCategory3DAxis axis){
        setColumnAxis_native_QCategory3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void setColumnAxis_native_QCategory3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#floorLevel-prop">Q3DBars::<wbr>setFloorLevel(float)</a></code></p>
     */
    @QtPropertyWriter(name="floorLevel")
    @QtUninvokable
    public final void setFloorLevel(float level){
        setFloorLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), level);
    }
    
    @QtUninvokable
    private native void setFloorLevel_native_float(long __this__nativeId, float level);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#multiSeriesUniform-prop">Q3DBars::<wbr>setMultiSeriesUniform(bool)</a></code></p>
     */
    @QtPropertyWriter(name="multiSeriesUniform")
    @QtUninvokable
    public final void setMultiSeriesUniform(boolean uniform){
        setMultiSeriesUniform_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), uniform);
    }
    
    @QtUninvokable
    private native void setMultiSeriesUniform_native_bool(long __this__nativeId, boolean uniform);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#primarySeries-prop">Q3DBars::<wbr>setPrimarySeries(QBar3DSeries*)</a></code></p>
     */
    @QtPropertyWriter(name="primarySeries")
    @QtUninvokable
    public final void setPrimarySeries(io.qt.datavis.@Nullable QBar3DSeries series){
        setPrimarySeries_native_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @QtUninvokable
    private native void setPrimarySeries_native_QBar3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#rowAxis-prop">Q3DBars::<wbr>setRowAxis(QCategory3DAxis*)</a></code></p>
     */
    @QtPropertyWriter(name="rowAxis")
    @QtUninvokable
    public final void setRowAxis(io.qt.datavis.@Nullable QCategory3DAxis axis){
        setRowAxis_native_QCategory3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void setRowAxis_native_QCategory3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#valueAxis-prop">Q3DBars::<wbr>setValueAxis(QValue3DAxis*)</a></code></p>
     */
    @QtPropertyWriter(name="valueAxis")
    @QtUninvokable
    public final void setValueAxis(io.qt.datavis.@Nullable QValue3DAxis axis){
        setValueAxis_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void setValueAxis_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dbars.html#valueAxis-prop">Q3DBars::<wbr>valueAxis()const</a></code></p>
     */
    @QtPropertyReader(name="valueAxis")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis valueAxis(){
        return valueAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxis valueAxis_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected Q3DBars(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DBars(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DBars instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #Q3DBars(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DBars(io.qt.gui.@Nullable QSurfaceFormat format) {
        this(format, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #Q3DBars(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>format = null</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public Q3DBars() {
        this((io.qt.gui.QSurfaceFormat)null, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #barSeriesMargin()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF getBarSeriesMargin() {
        return barSeriesMargin();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #barSpacing()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF getBarSpacing() {
        return barSpacing();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #barThickness()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getBarThickness() {
        return barThickness();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnAxis()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QCategory3DAxis getColumnAxis() {
        return columnAxis();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #floorLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getFloorLevel() {
        return floorLevel();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isBarSpacingRelative()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getBarSpacingRelative() {
        return isBarSpacingRelative();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isMultiSeriesUniform()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMultiSeriesUniform() {
        return isMultiSeriesUniform();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #primarySeries()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBar3DSeries getPrimarySeries() {
        return primarySeries();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowAxis()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QCategory3DAxis getRowAxis() {
        return rowAxis();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedSeries()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBar3DSeries getSelectedSeries() {
        return selectedSeries();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #valueAxis()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis getValueAxis() {
        return valueAxis();
    }
}
