package io.qt.datavis;

import io.qt.*;


/**
 * <p>Proxy class for presenting data in item models with Q3DSurface</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html">QItemModelSurfaceDataProxy</a></code></p>
 * <p>This class was introduced in Qt QtDataVisualization 1.0.</p>
 */
public class QItemModelSurfaceDataProxy extends io.qt.datavis.QSurfaceDataProxy
{
    @QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelSurfaceDataProxy.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::MultiMatchBehavior</a></code></p>
     */
    @QtUnlistedEnum
    public enum MultiMatchBehavior implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::<wbr/>MMBFirst</a></code></p>
         */
        MMBFirst(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::<wbr/>MMBLast</a></code></p>
         */
        MMBLast(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::<wbr/>MMBAverage</a></code></p>
         */
        MMBAverage(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::<wbr/>MMBCumulativeY</a></code></p>
         */
        MMBCumulativeY(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MultiMatchBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MultiMatchBehavior resolve(int value) {
            switch (value) {
            case 0: return MMBFirst;
            case 1: return MMBLast;
            case 2: return MMBAverage;
            case 3: return MMBCumulativeY;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QItemModelSurfaceDataProxy::<wbr/>autoColumnCategoriesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="autoColumnCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoColumnCategoriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QItemModelSurfaceDataProxy::<wbr/>autoRowCategoriesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="autoRowCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoRowCategoriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategories-prop">QItemModelSurfaceDataProxy::<wbr/>columnCategoriesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="columnCategories")
    public final @NonNull Signal0 columnCategoriesChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRole-prop">QItemModelSurfaceDataProxy::<wbr/>columnRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="columnRole")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>columnRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="columnRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> columnRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>columnRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="columnRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#itemModel-prop">QItemModelSurfaceDataProxy::<wbr/>itemModelChanged(const QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyNotify(name="itemModel")
    public final @NonNull Signal1<io.qt.core.@Nullable QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QItemModelSurfaceDataProxy::<wbr/>multiMatchBehaviorChanged(QItemModelSurfaceDataProxy::MultiMatchBehavior)</a></code></p>
     */
    @QtPropertyNotify(name="multiMatchBehavior")
    public final @NonNull Signal1<io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior> multiMatchBehaviorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategories-prop">QItemModelSurfaceDataProxy::<wbr/>rowCategoriesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="rowCategories")
    public final @NonNull Signal0 rowCategoriesChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRole-prop">QItemModelSurfaceDataProxy::<wbr/>rowRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rowRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>rowRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="rowRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> rowRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>rowRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rowRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QItemModelSurfaceDataProxy::<wbr/>useModelCategoriesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="useModelCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> useModelCategoriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>xPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>xPosRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> xPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>xPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>yPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>yPosRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> yPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>yPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>zPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>zPosRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> zPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>zPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-1">QItemModelSurfaceDataProxy::<wbr/>QItemModelSurfaceDataProxy(QAbstractItemModel*,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-2">QItemModelSurfaceDataProxy::<wbr/>QItemModelSurfaceDataProxy(QAbstractItemModel*,<wbr/>QString,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String yPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, yPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String yPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-3">QItemModelSurfaceDataProxy::<wbr/>QItemModelSurfaceDataProxy(QAbstractItemModel*,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, yPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-4">QItemModelSurfaceDataProxy::<wbr/>QItemModelSurfaceDataProxy(QAbstractItemModel*,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-6">QItemModelSurfaceDataProxy::<wbr/>QItemModelSurfaceDataProxy(QAbstractItemModel*,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QStringList,<wbr/>QStringList,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-5">QItemModelSurfaceDataProxy::<wbr/>QItemModelSurfaceDataProxy(QAbstractItemModel*,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QStringList,<wbr/>QStringList,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, yPosRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy">QItemModelSurfaceDataProxy::<wbr/>QItemModelSurfaceDataProxy(QObject*)</a></code></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QItemModelSurfaceDataProxy::<wbr/>autoColumnCategories()const</a></code></p>
     */
    @QtPropertyReader(name="autoColumnCategories")
    @QtUninvokable
    public final boolean autoColumnCategories(){
        return autoColumnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoColumnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QItemModelSurfaceDataProxy::<wbr/>autoRowCategories()const</a></code></p>
     */
    @QtPropertyReader(name="autoRowCategories")
    @QtUninvokable
    public final boolean autoRowCategories(){
        return autoRowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoRowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategories-prop">QItemModelSurfaceDataProxy::<wbr/>columnCategories()const</a></code></p>
     */
    @QtPropertyReader(name="columnCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList columnCategories(){
        return columnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList columnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategoryIndex">QItemModelSurfaceDataProxy::<wbr/>columnCategoryIndex(QString)</a></code></p>
     */
    public final int columnCategoryIndex(java.lang.@NonNull String category){
        return columnCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int columnCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRole-prop">QItemModelSurfaceDataProxy::<wbr/>columnRole()const</a></code></p>
     */
    @QtPropertyReader(name="columnRole")
    @QtUninvokable
    public final java.lang.@NonNull String columnRole(){
        return columnRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>columnRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="columnRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression columnRolePattern(){
        return columnRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression columnRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>columnRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="columnRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String columnRoleReplace(){
        return columnRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#itemModel-prop">QItemModelSurfaceDataProxy::<wbr/>itemModel()const</a></code></p>
     */
    @QtPropertyReader(name="itemModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QItemModelSurfaceDataProxy::<wbr/>multiMatchBehavior()const</a></code></p>
     */
    @QtPropertyReader(name="multiMatchBehavior")
    @QtUninvokable
    public final io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior multiMatchBehavior(){
        return io.qt.datavis.QItemModelSurfaceDataProxy.MultiMatchBehavior.resolve(multiMatchBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int multiMatchBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#remap">QItemModelSurfaceDataProxy::<wbr/>remap(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QStringList,<wbr/>QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void remap(java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories);
    }
    
    @QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(long __this__nativeId, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategories-prop">QItemModelSurfaceDataProxy::<wbr/>rowCategories()const</a></code></p>
     */
    @QtPropertyReader(name="rowCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList rowCategories(){
        return rowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList rowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategoryIndex">QItemModelSurfaceDataProxy::<wbr/>rowCategoryIndex(QString)</a></code></p>
     */
    public final int rowCategoryIndex(java.lang.@NonNull String category){
        return rowCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int rowCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRole-prop">QItemModelSurfaceDataProxy::<wbr/>rowRole()const</a></code></p>
     */
    @QtPropertyReader(name="rowRole")
    @QtUninvokable
    public final java.lang.@NonNull String rowRole(){
        return rowRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>rowRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="rowRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression rowRolePattern(){
        return rowRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression rowRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>rowRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="rowRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rowRoleReplace(){
        return rowRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QItemModelSurfaceDataProxy::<wbr/>setAutoColumnCategories(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoColumnCategories")
    @QtUninvokable
    public final void setAutoColumnCategories(boolean enable){
        setAutoColumnCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoColumnCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QItemModelSurfaceDataProxy::<wbr/>setAutoRowCategories(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoRowCategories")
    @QtUninvokable
    public final void setAutoRowCategories(boolean enable){
        setAutoRowCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoRowCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategories-prop">QItemModelSurfaceDataProxy::<wbr/>setColumnCategories(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="columnCategories")
    @QtUninvokable
    public final void setColumnCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setColumnCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setColumnCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRole-prop">QItemModelSurfaceDataProxy::<wbr/>setColumnRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="columnRole")
    @QtUninvokable
    public final void setColumnRole(java.lang.@NonNull String role){
        setColumnRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setColumnRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>setColumnRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="columnRolePattern")
    @QtUninvokable
    public final void setColumnRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setColumnRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setColumnRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>setColumnRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="columnRoleReplace")
    @QtUninvokable
    public final void setColumnRoleReplace(java.lang.@NonNull String replace){
        setColumnRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setColumnRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#setItemModel">QItemModelSurfaceDataProxy::<wbr/>setItemModel(QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyWriter(name="itemModel")
    @QtUninvokable
    public final void setItemModel(io.qt.core.@Nullable QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QItemModelSurfaceDataProxy::<wbr/>setMultiMatchBehavior(QItemModelSurfaceDataProxy::MultiMatchBehavior)</a></code></p>
     */
    @QtPropertyWriter(name="multiMatchBehavior")
    @QtUninvokable
    public final void setMultiMatchBehavior(io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior behavior){
        setMultiMatchBehavior_native_QItemModelSurfaceDataProxy_MultiMatchBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), behavior.value());
    }
    
    @QtUninvokable
    private native void setMultiMatchBehavior_native_QItemModelSurfaceDataProxy_MultiMatchBehavior(long __this__nativeId, int behavior);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategories-prop">QItemModelSurfaceDataProxy::<wbr/>setRowCategories(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="rowCategories")
    @QtUninvokable
    public final void setRowCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setRowCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setRowCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRole-prop">QItemModelSurfaceDataProxy::<wbr/>setRowRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rowRole")
    @QtUninvokable
    public final void setRowRole(java.lang.@NonNull String role){
        setRowRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRowRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>setRowRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="rowRolePattern")
    @QtUninvokable
    public final void setRowRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setRowRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRowRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>setRowRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rowRoleReplace")
    @QtUninvokable
    public final void setRowRoleReplace(java.lang.@NonNull String replace){
        setRowRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRowRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QItemModelSurfaceDataProxy::<wbr/>setUseModelCategories(bool)</a></code></p>
     */
    @QtPropertyWriter(name="useModelCategories")
    @QtUninvokable
    public final void setUseModelCategories(boolean enable){
        setUseModelCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setUseModelCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>setXPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRole")
    @QtUninvokable
    public final void setXPosRole(java.lang.@NonNull String role){
        setXPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setXPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>setXPosRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRolePattern")
    @QtUninvokable
    public final void setXPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setXPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setXPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>setXPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRoleReplace")
    @QtUninvokable
    public final void setXPosRoleReplace(java.lang.@NonNull String replace){
        setXPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setXPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>setYPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRole")
    @QtUninvokable
    public final void setYPosRole(java.lang.@NonNull String role){
        setYPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setYPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>setYPosRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRolePattern")
    @QtUninvokable
    public final void setYPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setYPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setYPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>setYPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRoleReplace")
    @QtUninvokable
    public final void setYPosRoleReplace(java.lang.@NonNull String replace){
        setYPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setYPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>setZPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRole")
    @QtUninvokable
    public final void setZPosRole(java.lang.@NonNull String role){
        setZPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setZPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>setZPosRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRolePattern")
    @QtUninvokable
    public final void setZPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setZPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setZPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>setZPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRoleReplace")
    @QtUninvokable
    public final void setZPosRoleReplace(java.lang.@NonNull String replace){
        setZPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setZPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QItemModelSurfaceDataProxy::<wbr/>useModelCategories()const</a></code></p>
     */
    @QtPropertyReader(name="useModelCategories")
    @QtUninvokable
    public final boolean useModelCategories(){
        return useModelCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean useModelCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>xPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRole(){
        return xPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>xPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression xPosRolePattern(){
        return xPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression xPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>xPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRoleReplace(){
        return xPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>yPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRole(){
        return yPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>yPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression yPosRolePattern(){
        return yPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression yPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>yPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRoleReplace(){
        return yPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRole-prop">QItemModelSurfaceDataProxy::<wbr/>zPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRole(){
        return zPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QItemModelSurfaceDataProxy::<wbr/>zPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression zPosRolePattern(){
        return zPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression zPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QItemModelSurfaceDataProxy::<wbr/>zPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRoleReplace(){
        return zPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QItemModelSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QItemModelSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QItemModelSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String yPosRole) {
        this(itemModel, yPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole) {
        this(itemModel, rowRole, columnRole, yPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole) {
        this(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, yPosRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #autoColumnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoColumnCategories() {
        return autoColumnCategories();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #autoRowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoRowCategories() {
        return autoRowCategories();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #columnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getColumnCategories() {
        return columnCategories();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #columnRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRole() {
        return columnRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #columnRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getColumnRolePattern() {
        return columnRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #columnRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRoleReplace() {
        return columnRoleReplace();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #itemModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel getItemModel() {
        return itemModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #multiMatchBehavior()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior getMultiMatchBehavior() {
        return multiMatchBehavior();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getRowCategories() {
        return rowCategories();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rowRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRole() {
        return rowRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rowRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getRowRolePattern() {
        return rowRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rowRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRoleReplace() {
        return rowRoleReplace();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #useModelCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUseModelCategories() {
        return useModelCategories();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #xPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRole() {
        return xPosRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #xPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getXPosRolePattern() {
        return xPosRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #xPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRoleReplace() {
        return xPosRoleReplace();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #yPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRole() {
        return yPosRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #yPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getYPosRolePattern() {
        return yPosRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #yPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRoleReplace() {
        return yPosRoleReplace();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRole() {
        return zPosRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getZPosRolePattern() {
        return zPosRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRoleReplace() {
        return zPosRoleReplace();
    }
}
