package io.qt.datavis;

import io.qt.*;


/**
 * <p>Proxy class for presenting data in item models with Q3DScatter</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html">QItemModelScatterDataProxy</a></code></p>
 * <p>This class was introduced in Qt QtDataVisualization 1.0.</p>
 */
public class QItemModelScatterDataProxy extends io.qt.datavis.QScatterDataProxy
{
    @QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelScatterDataProxy.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#itemModel-prop">QItemModelScatterDataProxy::<wbr/>itemModelChanged(const QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyNotify(name="itemModel")
    public final @NonNull Signal1<io.qt.core.@Nullable QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRole-prop">QItemModelScatterDataProxy::<wbr/>rotationRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRolePattern-prop">QItemModelScatterDataProxy::<wbr/>rotationRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> rotationRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>rotationRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRole-prop">QItemModelScatterDataProxy::<wbr/>xPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>xPosRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> xPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>xPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRole-prop">QItemModelScatterDataProxy::<wbr/>yPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>yPosRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> yPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>yPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRole-prop">QItemModelScatterDataProxy::<wbr/>zPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>zPosRolePatternChanged(QRegularExpression)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> zPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>zPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy-1">QItemModelScatterDataProxy::<wbr/>QItemModelScatterDataProxy(QAbstractItemModel*,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy-2">QItemModelScatterDataProxy::<wbr/>QItemModelScatterDataProxy(QAbstractItemModel*,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, xPosRole, yPosRole, zPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy-3">QItemModelScatterDataProxy::<wbr/>QItemModelScatterDataProxy(QAbstractItemModel*,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.lang.@NonNull String rotationRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, xPosRole, yPosRole, zPosRole, rotationRole, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.lang.String rotationRole, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy">QItemModelScatterDataProxy::<wbr/>QItemModelScatterDataProxy(QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#itemModel-prop">QItemModelScatterDataProxy::<wbr/>itemModel()const</a></code></p>
     */
    @QtPropertyReader(name="itemModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#remap">QItemModelScatterDataProxy::<wbr/>remap(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void remap(java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.lang.@NonNull String rotationRole){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), xPosRole, yPosRole, zPosRole, rotationRole);
    }
    
    @QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.lang.String rotationRole);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRole-prop">QItemModelScatterDataProxy::<wbr/>rotationRole()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRole")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRole(){
        return rotationRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRolePattern-prop">QItemModelScatterDataProxy::<wbr/>rotationRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression rotationRolePattern(){
        return rotationRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression rotationRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>rotationRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRoleReplace(){
        return rotationRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#setItemModel">QItemModelScatterDataProxy::<wbr/>setItemModel(QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyWriter(name="itemModel")
    @QtUninvokable
    public final void setItemModel(io.qt.core.@Nullable QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRole-prop">QItemModelScatterDataProxy::<wbr/>setRotationRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRole")
    @QtUninvokable
    public final void setRotationRole(java.lang.@NonNull String role){
        setRotationRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRotationRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRolePattern-prop">QItemModelScatterDataProxy::<wbr/>setRotationRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRolePattern")
    @QtUninvokable
    public final void setRotationRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setRotationRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRotationRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#rotationRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>setRotationRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRoleReplace")
    @QtUninvokable
    public final void setRotationRoleReplace(java.lang.@NonNull String replace){
        setRotationRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRotationRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRole-prop">QItemModelScatterDataProxy::<wbr/>setXPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRole")
    @QtUninvokable
    public final void setXPosRole(java.lang.@NonNull String role){
        setXPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setXPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>setXPosRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRolePattern")
    @QtUninvokable
    public final void setXPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setXPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setXPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>setXPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRoleReplace")
    @QtUninvokable
    public final void setXPosRoleReplace(java.lang.@NonNull String replace){
        setXPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setXPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRole-prop">QItemModelScatterDataProxy::<wbr/>setYPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRole")
    @QtUninvokable
    public final void setYPosRole(java.lang.@NonNull String role){
        setYPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setYPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>setYPosRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRolePattern")
    @QtUninvokable
    public final void setYPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setYPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setYPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>setYPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRoleReplace")
    @QtUninvokable
    public final void setYPosRoleReplace(java.lang.@NonNull String replace){
        setYPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setYPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRole-prop">QItemModelScatterDataProxy::<wbr/>setZPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRole")
    @QtUninvokable
    public final void setZPosRole(java.lang.@NonNull String role){
        setZPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setZPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>setZPosRolePattern(QRegularExpression)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRolePattern")
    @QtUninvokable
    public final void setZPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setZPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setZPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>setZPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRoleReplace")
    @QtUninvokable
    public final void setZPosRoleReplace(java.lang.@NonNull String replace){
        setZPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setZPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRole-prop">QItemModelScatterDataProxy::<wbr/>xPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRole(){
        return xPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>xPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression xPosRolePattern(){
        return xPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression xPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#xPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>xPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRoleReplace(){
        return xPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRole-prop">QItemModelScatterDataProxy::<wbr/>yPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRole(){
        return yPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>yPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression yPosRolePattern(){
        return yPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression yPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#yPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>yPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRoleReplace(){
        return yPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRole-prop">QItemModelScatterDataProxy::<wbr/>zPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRole(){
        return zPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRolePattern-prop">QItemModelScatterDataProxy::<wbr/>zPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression zPosRolePattern(){
        return zPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression zPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qitemmodelscatterdataproxy.html#zPosRoleReplace-prop">QItemModelScatterDataProxy::<wbr/>zPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRoleReplace(){
        return zPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QItemModelScatterDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QItemModelScatterDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QItemModelScatterDataProxy instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole) {
        this(itemModel, xPosRole, yPosRole, zPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.lang.@NonNull String rotationRole) {
        this(itemModel, xPosRole, yPosRole, zPosRole, rotationRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #itemModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel getItemModel() {
        return itemModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRole() {
        return rotationRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getRotationRolePattern() {
        return rotationRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotationRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRoleReplace() {
        return rotationRoleReplace();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #xPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRole() {
        return xPosRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #xPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getXPosRolePattern() {
        return xPosRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #xPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRoleReplace() {
        return xPosRoleReplace();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #yPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRole() {
        return yPosRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #yPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getYPosRolePattern() {
        return yPosRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #yPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRoleReplace() {
        return yPosRoleReplace();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRole() {
        return zPosRole();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getZPosRolePattern() {
        return zPosRolePattern();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRoleReplace() {
        return zPosRoleReplace();
    }
}
