package io.qt.datavis;

import io.qt.*;


/**
 * <p>The data proxy for a 3D bars graph</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qbardataproxy.html">QBarDataProxy</a></code></p>
 * <p>This class was introduced in Qt QtDataVisualization 1.0.</p>
 */
public class QBarDataProxy extends io.qt.datavis.QAbstractDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBarDataProxy.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#arrayReset">QBarDataProxy::<wbr/>arrayReset()</a></code></p>
     */
    public final @NonNull Signal0 arrayReset = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#columnLabels-prop">QBarDataProxy::<wbr/>columnLabelsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="columnLabels")
    public final @NonNull Signal0 columnLabelsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#itemChanged">QBarDataProxy::<wbr/>itemChanged(int,<wbr/>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> itemChanged = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowCount-prop">QBarDataProxy::<wbr/>rowCountChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="rowCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> rowCountChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowLabels-prop">QBarDataProxy::<wbr/>rowLabelsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="rowLabels")
    public final @NonNull Signal0 rowLabelsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowsAdded">QBarDataProxy::<wbr/>rowsAdded(int,<wbr/>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsAdded = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowsChanged">QBarDataProxy::<wbr/>rowsChanged(int,<wbr/>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsChanged = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowsInserted">QBarDataProxy::<wbr/>rowsInserted(int,<wbr/>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsInserted = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowsRemoved">QBarDataProxy::<wbr/>rowsRemoved(int,<wbr/>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsRemoved = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#series-prop">QBarDataProxy::<wbr/>seriesChanged(QBar3DSeries*)</a></code></p>
     */
    @QtPropertyNotify(name="series")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QBar3DSeries> seriesChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#QBarDataProxy">QBarDataProxy::<wbr/>QBarDataProxy(QObject*)</a></code></p>
     */
    public QBarDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBarDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#addRow">QBarDataProxy::<wbr/>addRow(QBarDataRow*)</a></code></p>
     */
    @QtUninvokable
    public final int addRow(io.qt.datavis.@Nullable QBarDataRow row){
        return addRow_native_QBarDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @QtUninvokable
    private native int addRow_native_QBarDataRow_ptr(long __this__nativeId, long row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#addRow-1">QBarDataProxy::<wbr/>addRow(QBarDataRow*,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final int addRow(io.qt.datavis.@Nullable QBarDataRow row, java.lang.@NonNull String label){
        return addRow_native_QBarDataRow_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row), label);
    }
    
    @QtUninvokable
    private native int addRow_native_QBarDataRow_ptr_cref_QString(long __this__nativeId, long row, java.lang.String label);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#addRows">QBarDataProxy::<wbr/>addRows(QBarDataArray)</a></code></p>
     */
    @QtUninvokable
    public final int addRows(io.qt.datavis.@NonNull QBarDataArray rows){
        return addRows_native_cref_QBarDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @QtUninvokable
    private native int addRows_native_cref_QBarDataArray(long __this__nativeId, long rows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#addRows-1">QBarDataProxy::<wbr/>addRows(QBarDataArray,<wbr/>QStringList)</a></code></p>
     */
    @QtUninvokable
    public final int addRows(io.qt.datavis.@NonNull QBarDataArray rows, java.util.@NonNull Collection<java.lang.@NonNull String> labels){
        return addRows_native_cref_QBarDataArray_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rows), labels);
    }
    
    @QtUninvokable
    private native int addRows_native_cref_QBarDataArray_cref_QStringList(long __this__nativeId, long rows, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#array">QBarDataProxy::<wbr/>array()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataArray array(){
        return array_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBarDataArray array_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#columnLabels-prop">QBarDataProxy::<wbr/>columnLabels()const</a></code></p>
     */
    @QtPropertyReader(name="columnLabels")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList columnLabels(){
        return columnLabels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList columnLabels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#insertRow">QBarDataProxy::<wbr/>insertRow(int,<wbr/>QBarDataRow*)</a></code></p>
     */
    @QtUninvokable
    public final void insertRow(int rowIndex, io.qt.datavis.@Nullable QBarDataRow row){
        insertRow_native_int_QBarDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @QtUninvokable
    private native void insertRow_native_int_QBarDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#insertRow-1">QBarDataProxy::<wbr/>insertRow(int,<wbr/>QBarDataRow*,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void insertRow(int rowIndex, io.qt.datavis.@Nullable QBarDataRow row, java.lang.@NonNull String label){
        insertRow_native_int_QBarDataRow_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row), label);
    }
    
    @QtUninvokable
    private native void insertRow_native_int_QBarDataRow_ptr_cref_QString(long __this__nativeId, int rowIndex, long row, java.lang.String label);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#insertRows">QBarDataProxy::<wbr/>insertRows(int,<wbr/>QBarDataArray)</a></code></p>
     */
    @QtUninvokable
    public final void insertRows(int rowIndex, io.qt.datavis.@NonNull QBarDataArray rows){
        insertRows_native_int_cref_QBarDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @QtUninvokable
    private native void insertRows_native_int_cref_QBarDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#insertRows-1">QBarDataProxy::<wbr/>insertRows(int,<wbr/>QBarDataArray,<wbr/>QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void insertRows(int rowIndex, io.qt.datavis.@NonNull QBarDataArray rows, java.util.@NonNull Collection<java.lang.@NonNull String> labels){
        insertRows_native_int_cref_QBarDataArray_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows), labels);
    }
    
    @QtUninvokable
    private native void insertRows_native_int_cref_QBarDataArray_cref_QStringList(long __this__nativeId, int rowIndex, long rows, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#itemAt-1">QBarDataProxy::<wbr/>itemAt(QPoint)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataItem itemAt(io.qt.core.@NonNull QPoint position){
        return itemAt_native_cref_QPoint_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBarDataItem itemAt_native_cref_QPoint_constfct(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#itemAt">QBarDataProxy::<wbr/>itemAt(int,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataItem itemAt(int rowIndex, int columnIndex){
        return itemAt_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex);
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBarDataItem itemAt_native_int_int_constfct(long __this__nativeId, int rowIndex, int columnIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#removeRows">QBarDataProxy::<wbr/>removeRows(int,<wbr/>int,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final void removeRows(int rowIndex, int removeCount, boolean removeLabels){
        removeRows_native_int_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, removeCount, removeLabels);
    }
    
    @QtUninvokable
    private native void removeRows_native_int_int_bool(long __this__nativeId, int rowIndex, int removeCount, boolean removeLabels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#resetArray">QBarDataProxy::<wbr/>resetArray()</a></code></p>
     */
    @QtUninvokable
    public final void resetArray(){
        resetArray_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resetArray_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#resetArray-1">QBarDataProxy::<wbr/>resetArray(QBarDataArray*)</a></code></p>
     */
    @QtUninvokable
    public final void resetArray(io.qt.datavis.@Nullable QBarDataArray newArray){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcArray);
        resetArray_native_QBarDataArray_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newArray));
        QtJambi_LibraryUtilities.internal.setCppOwnership(newArray);
        __rcArray = newArray;
        QtJambi_LibraryUtilities.internal.registerDependentObject(__rcArray, this);
    }
    
    @QtUninvokable
    private native void resetArray_native_QBarDataArray_ptr(long __this__nativeId, long newArray);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#resetArray-2">QBarDataProxy::<wbr/>resetArray(QBarDataArray*,<wbr/>QStringList,<wbr/>QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void resetArray(io.qt.datavis.@Nullable QBarDataArray newArray, java.util.@NonNull Collection<java.lang.@NonNull String> rowLabels, java.util.@NonNull Collection<java.lang.@NonNull String> columnLabels){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcArray);
        resetArray_native_QBarDataArray_ptr_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newArray), rowLabels, columnLabels);
        QtJambi_LibraryUtilities.internal.setCppOwnership(newArray);
        __rcArray = newArray;
        QtJambi_LibraryUtilities.internal.registerDependentObject(__rcArray, this);
    }
    
    @QtUninvokable
    private native void resetArray_native_QBarDataArray_ptr_cref_QStringList_cref_QStringList(long __this__nativeId, long newArray, java.util.Collection<java.lang.String> rowLabels, java.util.Collection<java.lang.String> columnLabels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowAt">QBarDataProxy::<wbr/>rowAt(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataRow rowAt(int rowIndex){
        return rowAt_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex);
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBarDataRow rowAt_native_int_constfct(long __this__nativeId, int rowIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowCount-prop">QBarDataProxy::<wbr/>rowCount()const</a></code></p>
     */
    @QtPropertyReader(name="rowCount")
    @QtUninvokable
    public final int rowCount(){
        return rowCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int rowCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowLabels-prop">QBarDataProxy::<wbr/>rowLabels()const</a></code></p>
     */
    @QtPropertyReader(name="rowLabels")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList rowLabels(){
        return rowLabels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList rowLabels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#series-prop">QBarDataProxy::<wbr/>series()const</a></code></p>
     */
    @QtPropertyReader(name="series")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBar3DSeries series(){
        return series_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBar3DSeries series_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#columnLabels-prop">QBarDataProxy::<wbr/>setColumnLabels(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="columnLabels")
    @QtUninvokable
    public final void setColumnLabels(java.util.@NonNull Collection<java.lang.@NonNull String> labels){
        setColumnLabels_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), labels);
    }
    
    @QtUninvokable
    private native void setColumnLabels_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#setItem-1">QBarDataProxy::<wbr/>setItem(QPoint,<wbr/>QBarDataItem)</a></code></p>
     */
    @QtUninvokable
    public final void setItem(io.qt.core.@NonNull QPoint position, io.qt.datavis.@NonNull QBarDataItem item){
        setItem_native_cref_QPoint_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void setItem_native_cref_QPoint_cref_QBarDataItem(long __this__nativeId, long position, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#setItem">QBarDataProxy::<wbr/>setItem(int,<wbr/>int,<wbr/>QBarDataItem)</a></code></p>
     */
    @QtUninvokable
    public final void setItem(int rowIndex, int columnIndex, io.qt.datavis.@NonNull QBarDataItem item){
        setItem_native_int_int_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void setItem_native_int_int_cref_QBarDataItem(long __this__nativeId, int rowIndex, int columnIndex, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#setRow">QBarDataProxy::<wbr/>setRow(int,<wbr/>QBarDataRow*)</a></code></p>
     */
    @QtUninvokable
    public final void setRow(int rowIndex, io.qt.datavis.@Nullable QBarDataRow row){
        setRow_native_int_QBarDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @QtUninvokable
    private native void setRow_native_int_QBarDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#setRow-1">QBarDataProxy::<wbr/>setRow(int,<wbr/>QBarDataRow*,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void setRow(int rowIndex, io.qt.datavis.@Nullable QBarDataRow row, java.lang.@NonNull String label){
        setRow_native_int_QBarDataRow_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row), label);
    }
    
    @QtUninvokable
    private native void setRow_native_int_QBarDataRow_ptr_cref_QString(long __this__nativeId, int rowIndex, long row, java.lang.String label);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#rowLabels-prop">QBarDataProxy::<wbr/>setRowLabels(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="rowLabels")
    @QtUninvokable
    public final void setRowLabels(java.util.@NonNull Collection<java.lang.@NonNull String> labels){
        setRowLabels_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), labels);
    }
    
    @QtUninvokable
    private native void setRowLabels_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#setRows">QBarDataProxy::<wbr/>setRows(int,<wbr/>QBarDataArray)</a></code></p>
     */
    @QtUninvokable
    public final void setRows(int rowIndex, io.qt.datavis.@NonNull QBarDataArray rows){
        setRows_native_int_cref_QBarDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @QtUninvokable
    private native void setRows_native_int_cref_QBarDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qbardataproxy.html#setRows-1">QBarDataProxy::<wbr/>setRows(int,<wbr/>QBarDataArray,<wbr/>QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void setRows(int rowIndex, io.qt.datavis.@NonNull QBarDataArray rows, java.util.@NonNull Collection<java.lang.@NonNull String> labels){
        setRows_native_int_cref_QBarDataArray_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows), labels);
    }
    
    @QtUninvokable
    private native void setRows_native_int_cref_QBarDataArray_cref_QStringList(long __this__nativeId, int rowIndex, long rows, java.util.Collection<java.lang.String> labels);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QBarDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QBarDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QBarDataProxy instance, QDeclarativeConstructor constructor);
    
    private QBarDataArray __rcArray;
    
    /**
     * <p>Overloaded constructor for {@link #QBarDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBarDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #columnLabels()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getColumnLabels() {
        return columnLabels();
    }
    
    /**
     * <p>Overloaded function for {@link #removeRows(int, int, boolean)}
     *  with <code>removeLabels = true</code>.</p>
     */
    @QtUninvokable
    public final void removeRows(int rowIndex, int removeCount) {
        removeRows(rowIndex, removeCount, (boolean)true);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rowCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getRowCount() {
        return rowCount();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rowLabels()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getRowLabels() {
        return rowLabels();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #series()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBar3DSeries getSeries() {
        return series();
    }
}
