package io.qt.datavis;

import io.qt.*;


/**
 * <p>Visual style for graphs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/q3dtheme.html">Q3DTheme</a></code></p>
 * <p>This class was introduced in Qt QtDataVisualization 1.0.</p>
 */
public class Q3DTheme extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DTheme.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/q3dtheme.html#ColorStyle-enum">Q3DTheme::ColorStyle</a></code></p>
     */
    @QtUnlistedEnum
    public enum ColorStyle implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#ColorStyle-enum">Q3DTheme::<wbr/>ColorStyleUniform</a></code></p>
         */
        ColorStyleUniform(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#ColorStyle-enum">Q3DTheme::<wbr/>ColorStyleObjectGradient</a></code></p>
         */
        ColorStyleObjectGradient(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#ColorStyle-enum">Q3DTheme::<wbr/>ColorStyleRangeGradient</a></code></p>
         */
        ColorStyleRangeGradient(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ColorStyle(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ColorStyle resolve(int value) {
            switch (value) {
            case 0: return ColorStyleUniform;
            case 1: return ColorStyleObjectGradient;
            case 2: return ColorStyleRangeGradient;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::Theme</a></code></p>
     */
    @QtUnlistedEnum
    public enum Theme implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeQt</a></code></p>
         */
        ThemeQt(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemePrimaryColors</a></code></p>
         */
        ThemePrimaryColors(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeDigia</a></code></p>
         */
        ThemeDigia(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeStoneMoss</a></code></p>
         */
        ThemeStoneMoss(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeArmyBlue</a></code></p>
         */
        ThemeArmyBlue(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeRetro</a></code></p>
         */
        ThemeRetro(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeEbony</a></code></p>
         */
        ThemeEbony(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeIsabelle</a></code></p>
         */
        ThemeIsabelle(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::<wbr/>ThemeUserDefined</a></code></p>
         */
        ThemeUserDefined(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Theme(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Theme resolve(int value) {
            switch (value) {
            case 0: return ThemeQt;
            case 1: return ThemePrimaryColors;
            case 2: return ThemeDigia;
            case 3: return ThemeStoneMoss;
            case 4: return ThemeArmyBlue;
            case 5: return ThemeRetro;
            case 6: return ThemeEbony;
            case 7: return ThemeIsabelle;
            case 8: return ThemeUserDefined;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#ambientLightStrength-prop">Q3DTheme::<wbr/>ambientLightStrengthChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="ambientLightStrength")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> ambientLightStrengthChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#backgroundColor-prop">Q3DTheme::<wbr/>backgroundColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="backgroundColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> backgroundColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#backgroundEnabled-prop">Q3DTheme::<wbr/>backgroundEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="backgroundEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> backgroundEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#baseColors-prop">Q3DTheme::<wbr/>baseColorsChanged(QList&lt;QColor&gt;)</a></code></p>
     */
    @QtPropertyNotify(name="baseColors")
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.gui.@NonNull QColor>> baseColorsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#baseGradients-prop">Q3DTheme::<wbr/>baseGradientsChanged(QList&lt;QLinearGradient&gt;)</a></code></p>
     */
    @QtPropertyNotify(name="baseGradients")
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.gui.@NonNull QLinearGradient>> baseGradientsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#colorStyle-prop">Q3DTheme::<wbr/>colorStyleChanged(Q3DTheme::ColorStyle)</a></code></p>
     */
    @QtPropertyNotify(name="colorStyle")
    public final @NonNull Signal1<io.qt.datavis.Q3DTheme.@NonNull ColorStyle> colorStyleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#font-prop">Q3DTheme::<wbr/>fontChanged(QFont)</a></code></p>
     */
    @QtPropertyNotify(name="font")
    public final @NonNull Signal1<io.qt.gui.@NonNull QFont> fontChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#gridEnabled-prop">Q3DTheme::<wbr/>gridEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="gridEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> gridEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#gridLineColor-prop">Q3DTheme::<wbr/>gridLineColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="gridLineColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> gridLineColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#highlightLightStrength-prop">Q3DTheme::<wbr/>highlightLightStrengthChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="highlightLightStrength")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> highlightLightStrengthChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundColor-prop">Q3DTheme::<wbr/>labelBackgroundColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="labelBackgroundColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> labelBackgroundColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundEnabled-prop">Q3DTheme::<wbr/>labelBackgroundEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="labelBackgroundEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> labelBackgroundEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBorderEnabled-prop">Q3DTheme::<wbr/>labelBorderEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="labelBorderEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> labelBorderEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelTextColor-prop">Q3DTheme::<wbr/>labelTextColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="labelTextColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> labelTextColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#lightColor-prop">Q3DTheme::<wbr/>lightColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="lightColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> lightColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#lightStrength-prop">Q3DTheme::<wbr/>lightStrengthChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="lightStrength")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> lightStrengthChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightColor-prop">Q3DTheme::<wbr/>multiHighlightColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="multiHighlightColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> multiHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightGradient-prop">Q3DTheme::<wbr/>multiHighlightGradientChanged(QLinearGradient)</a></code></p>
     */
    @QtPropertyNotify(name="multiHighlightGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> multiHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightColor-prop">Q3DTheme::<wbr/>singleHighlightColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="singleHighlightColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> singleHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightGradient-prop">Q3DTheme::<wbr/>singleHighlightGradientChanged(QLinearGradient)</a></code></p>
     */
    @QtPropertyNotify(name="singleHighlightGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> singleHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#type-prop">Q3DTheme::<wbr/>typeChanged(Q3DTheme::Theme)</a></code></p>
     */
    @QtPropertyNotify(name="type")
    public final @NonNull Signal1<io.qt.datavis.Q3DTheme.@NonNull Theme> typeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#windowColor-prop">Q3DTheme::<wbr/>windowColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="windowColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> windowColorChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#Q3DTheme-1">Q3DTheme::<wbr/>Q3DTheme(Q3DTheme::Theme,<wbr/>QObject*)</a></code></p>
     */
    public Q3DTheme(io.qt.datavis.Q3DTheme.@NonNull Theme themeType, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, themeType, parent);
    }
    
    private native static void initialize_native(Q3DTheme instance, io.qt.datavis.Q3DTheme.Theme themeType, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#Q3DTheme">Q3DTheme::<wbr/>Q3DTheme(QObject*)</a></code></p>
     */
    public Q3DTheme(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DTheme instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#ambientLightStrength-prop">Q3DTheme::<wbr/>ambientLightStrength()const</a></code></p>
     */
    @QtPropertyReader(name="ambientLightStrength")
    @QtUninvokable
    public final float ambientLightStrength(){
        return ambientLightStrength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float ambientLightStrength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#backgroundColor-prop">Q3DTheme::<wbr/>backgroundColor()const</a></code></p>
     */
    @QtPropertyReader(name="backgroundColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor backgroundColor(){
        return backgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor backgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#baseColors-prop">Q3DTheme::<wbr/>baseColors()const</a></code></p>
     */
    @QtPropertyReader(name="baseColors")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.@NonNull QColor> baseColors(){
        return baseColors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QColor> baseColors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#baseGradients-prop">Q3DTheme::<wbr/>baseGradients()const</a></code></p>
     */
    @QtPropertyReader(name="baseGradients")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.@NonNull QLinearGradient> baseGradients(){
        return baseGradients_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QLinearGradient> baseGradients_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#colorStyle-prop">Q3DTheme::<wbr/>colorStyle()const</a></code></p>
     */
    @QtPropertyReader(name="colorStyle")
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull ColorStyle colorStyle(){
        return io.qt.datavis.Q3DTheme.ColorStyle.resolve(colorStyle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int colorStyle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#font-prop">Q3DTheme::<wbr/>font()const</a></code></p>
     */
    @QtPropertyReader(name="font")
    @QtUninvokable
    public final io.qt.gui.@NonNull QFont font(){
        return font_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QFont font_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#gridLineColor-prop">Q3DTheme::<wbr/>gridLineColor()const</a></code></p>
     */
    @QtPropertyReader(name="gridLineColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor gridLineColor(){
        return gridLineColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor gridLineColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#highlightLightStrength-prop">Q3DTheme::<wbr/>highlightLightStrength()const</a></code></p>
     */
    @QtPropertyReader(name="highlightLightStrength")
    @QtUninvokable
    public final float highlightLightStrength(){
        return highlightLightStrength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float highlightLightStrength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#backgroundEnabled-prop">Q3DTheme::<wbr/>isBackgroundEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="backgroundEnabled")
    @QtUninvokable
    public final boolean isBackgroundEnabled(){
        return isBackgroundEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBackgroundEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#gridEnabled-prop">Q3DTheme::<wbr/>isGridEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="gridEnabled")
    @QtUninvokable
    public final boolean isGridEnabled(){
        return isGridEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isGridEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundEnabled-prop">Q3DTheme::<wbr/>isLabelBackgroundEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="labelBackgroundEnabled")
    @QtUninvokable
    public final boolean isLabelBackgroundEnabled(){
        return isLabelBackgroundEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isLabelBackgroundEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBorderEnabled-prop">Q3DTheme::<wbr/>isLabelBorderEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="labelBorderEnabled")
    @QtUninvokable
    public final boolean isLabelBorderEnabled(){
        return isLabelBorderEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isLabelBorderEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundColor-prop">Q3DTheme::<wbr/>labelBackgroundColor()const</a></code></p>
     */
    @QtPropertyReader(name="labelBackgroundColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor labelBackgroundColor(){
        return labelBackgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor labelBackgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelTextColor-prop">Q3DTheme::<wbr/>labelTextColor()const</a></code></p>
     */
    @QtPropertyReader(name="labelTextColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor labelTextColor(){
        return labelTextColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor labelTextColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#lightColor-prop">Q3DTheme::<wbr/>lightColor()const</a></code></p>
     */
    @QtPropertyReader(name="lightColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor lightColor(){
        return lightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor lightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#lightStrength-prop">Q3DTheme::<wbr/>lightStrength()const</a></code></p>
     */
    @QtPropertyReader(name="lightStrength")
    @QtUninvokable
    public final float lightStrength(){
        return lightStrength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float lightStrength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightColor-prop">Q3DTheme::<wbr/>multiHighlightColor()const</a></code></p>
     */
    @QtPropertyReader(name="multiHighlightColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor multiHighlightColor(){
        return multiHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor multiHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightGradient-prop">Q3DTheme::<wbr/>multiHighlightGradient()const</a></code></p>
     */
    @QtPropertyReader(name="multiHighlightGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient multiHighlightGradient(){
        return multiHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient multiHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#ambientLightStrength-prop">Q3DTheme::<wbr/>setAmbientLightStrength(float)</a></code></p>
     */
    @QtPropertyWriter(name="ambientLightStrength")
    @QtUninvokable
    public final void setAmbientLightStrength(float strength){
        setAmbientLightStrength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), strength);
    }
    
    @QtUninvokable
    private native void setAmbientLightStrength_native_float(long __this__nativeId, float strength);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#backgroundColor-prop">Q3DTheme::<wbr/>setBackgroundColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="backgroundColor")
    @QtUninvokable
    public final void setBackgroundColor(io.qt.gui.@NonNull QColor color){
        setBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#backgroundEnabled-prop">Q3DTheme::<wbr/>setBackgroundEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="backgroundEnabled")
    @QtUninvokable
    public final void setBackgroundEnabled(boolean enabled){
        setBackgroundEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setBackgroundEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#baseColors-prop">Q3DTheme::<wbr/>setBaseColors(QList&lt;QColor&gt;)</a></code></p>
     */
    @QtPropertyWriter(name="baseColors")
    @QtUninvokable
    public final void setBaseColors(java.util.@NonNull Collection<? extends io.qt.gui.@NonNull QColor> colors){
        setBaseColors_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), colors);
    }
    
    @QtUninvokable
    private native void setBaseColors_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.gui.QColor> colors);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#baseGradients-prop">Q3DTheme::<wbr/>setBaseGradients(QList&lt;QLinearGradient&gt;)</a></code></p>
     */
    @QtPropertyWriter(name="baseGradients")
    @QtUninvokable
    public final void setBaseGradients(java.util.@NonNull Collection<? extends io.qt.gui.@NonNull QLinearGradient> gradients){
        setBaseGradients_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), gradients);
    }
    
    @QtUninvokable
    private native void setBaseGradients_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.gui.QLinearGradient> gradients);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#colorStyle-prop">Q3DTheme::<wbr/>setColorStyle(Q3DTheme::ColorStyle)</a></code></p>
     */
    @QtPropertyWriter(name="colorStyle")
    @QtUninvokable
    public final void setColorStyle(io.qt.datavis.Q3DTheme.@NonNull ColorStyle style){
        setColorStyle_native_Q3DTheme_ColorStyle(QtJambi_LibraryUtilities.internal.nativeId(this), style.value());
    }
    
    @QtUninvokable
    private native void setColorStyle_native_Q3DTheme_ColorStyle(long __this__nativeId, int style);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#font-prop">Q3DTheme::<wbr/>setFont(QFont)</a></code></p>
     */
    @QtPropertyWriter(name="font")
    @QtUninvokable
    public final void setFont(io.qt.gui.@NonNull QFont font){
        setFont_native_cref_QFont(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(font));
    }
    
    @QtUninvokable
    private native void setFont_native_cref_QFont(long __this__nativeId, long font);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#gridEnabled-prop">Q3DTheme::<wbr/>setGridEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="gridEnabled")
    @QtUninvokable
    public final void setGridEnabled(boolean enabled){
        setGridEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setGridEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#gridLineColor-prop">Q3DTheme::<wbr/>setGridLineColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="gridLineColor")
    @QtUninvokable
    public final void setGridLineColor(io.qt.gui.@NonNull QColor color){
        setGridLineColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setGridLineColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#highlightLightStrength-prop">Q3DTheme::<wbr/>setHighlightLightStrength(float)</a></code></p>
     */
    @QtPropertyWriter(name="highlightLightStrength")
    @QtUninvokable
    public final void setHighlightLightStrength(float strength){
        setHighlightLightStrength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), strength);
    }
    
    @QtUninvokable
    private native void setHighlightLightStrength_native_float(long __this__nativeId, float strength);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundColor-prop">Q3DTheme::<wbr/>setLabelBackgroundColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="labelBackgroundColor")
    @QtUninvokable
    public final void setLabelBackgroundColor(io.qt.gui.@NonNull QColor color){
        setLabelBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setLabelBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundEnabled-prop">Q3DTheme::<wbr/>setLabelBackgroundEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="labelBackgroundEnabled")
    @QtUninvokable
    public final void setLabelBackgroundEnabled(boolean enabled){
        setLabelBackgroundEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setLabelBackgroundEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelBorderEnabled-prop">Q3DTheme::<wbr/>setLabelBorderEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="labelBorderEnabled")
    @QtUninvokable
    public final void setLabelBorderEnabled(boolean enabled){
        setLabelBorderEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setLabelBorderEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#labelTextColor-prop">Q3DTheme::<wbr/>setLabelTextColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="labelTextColor")
    @QtUninvokable
    public final void setLabelTextColor(io.qt.gui.@NonNull QColor color){
        setLabelTextColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setLabelTextColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#lightColor-prop">Q3DTheme::<wbr/>setLightColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="lightColor")
    @QtUninvokable
    public final void setLightColor(io.qt.gui.@NonNull QColor color){
        setLightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setLightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#lightStrength-prop">Q3DTheme::<wbr/>setLightStrength(float)</a></code></p>
     */
    @QtPropertyWriter(name="lightStrength")
    @QtUninvokable
    public final void setLightStrength(float strength){
        setLightStrength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), strength);
    }
    
    @QtUninvokable
    private native void setLightStrength_native_float(long __this__nativeId, float strength);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightColor-prop">Q3DTheme::<wbr/>setMultiHighlightColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="multiHighlightColor")
    @QtUninvokable
    public final void setMultiHighlightColor(io.qt.gui.@NonNull QColor color){
        setMultiHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setMultiHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightGradient-prop">Q3DTheme::<wbr/>setMultiHighlightGradient(QLinearGradient)</a></code></p>
     */
    @QtPropertyWriter(name="multiHighlightGradient")
    @QtUninvokable
    public final void setMultiHighlightGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setMultiHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setMultiHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightColor-prop">Q3DTheme::<wbr/>setSingleHighlightColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="singleHighlightColor")
    @QtUninvokable
    public final void setSingleHighlightColor(io.qt.gui.@NonNull QColor color){
        setSingleHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setSingleHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightGradient-prop">Q3DTheme::<wbr/>setSingleHighlightGradient(QLinearGradient)</a></code></p>
     */
    @QtPropertyWriter(name="singleHighlightGradient")
    @QtUninvokable
    public final void setSingleHighlightGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setSingleHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setSingleHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#type-prop">Q3DTheme::<wbr/>setType(Q3DTheme::Theme)</a></code></p>
     */
    @QtPropertyWriter(name="type")
    @QtUninvokable
    public final void setType(io.qt.datavis.Q3DTheme.@NonNull Theme themeType){
        setType_native_Q3DTheme_Theme(QtJambi_LibraryUtilities.internal.nativeId(this), themeType.value());
    }
    
    @QtUninvokable
    private native void setType_native_Q3DTheme_Theme(long __this__nativeId, int themeType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#windowColor-prop">Q3DTheme::<wbr/>setWindowColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="windowColor")
    @QtUninvokable
    public final void setWindowColor(io.qt.gui.@NonNull QColor color){
        setWindowColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setWindowColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightColor-prop">Q3DTheme::<wbr/>singleHighlightColor()const</a></code></p>
     */
    @QtPropertyReader(name="singleHighlightColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor singleHighlightColor(){
        return singleHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor singleHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightGradient-prop">Q3DTheme::<wbr/>singleHighlightGradient()const</a></code></p>
     */
    @QtPropertyReader(name="singleHighlightGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient singleHighlightGradient(){
        return singleHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient singleHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#type-prop">Q3DTheme::<wbr/>type()const</a></code></p>
     */
    @QtPropertyReader(name="type")
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull Theme type(){
        return io.qt.datavis.Q3DTheme.Theme.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dtheme.html#windowColor-prop">Q3DTheme::<wbr/>windowColor()const</a></code></p>
     */
    @QtPropertyReader(name="windowColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor windowColor(){
        return windowColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor windowColor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected Q3DTheme(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected Q3DTheme(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DTheme instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #Q3DTheme(io.qt.datavis.Q3DTheme.Theme, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DTheme(io.qt.datavis.Q3DTheme.@NonNull Theme themeType) {
        this(themeType, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #Q3DTheme(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DTheme() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #ambientLightStrength()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getAmbientLightStrength() {
        return ambientLightStrength();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #backgroundColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getBackgroundColor() {
        return backgroundColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #baseColors()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.@NonNull QColor> getBaseColors() {
        return baseColors();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #baseGradients()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.@NonNull QLinearGradient> getBaseGradients() {
        return baseGradients();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #colorStyle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull ColorStyle getColorStyle() {
        return colorStyle();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #font()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QFont getFont() {
        return font();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #gridLineColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getGridLineColor() {
        return gridLineColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #highlightLightStrength()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getHighlightLightStrength() {
        return highlightLightStrength();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isBackgroundEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getBackgroundEnabled() {
        return isBackgroundEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isGridEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getGridEnabled() {
        return isGridEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isLabelBackgroundEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getLabelBackgroundEnabled() {
        return isLabelBackgroundEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isLabelBorderEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getLabelBorderEnabled() {
        return isLabelBorderEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #labelBackgroundColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getLabelBackgroundColor() {
        return labelBackgroundColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #labelTextColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getLabelTextColor() {
        return labelTextColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #lightColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getLightColor() {
        return lightColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #lightStrength()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getLightStrength() {
        return lightStrength();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #multiHighlightColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getMultiHighlightColor() {
        return multiHighlightColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #multiHighlightGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getMultiHighlightGradient() {
        return multiHighlightGradient();
    }
    
    /**
     * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setBackgroundColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setBackgroundColor(io.qt.gui.@NonNull QRgba64 color) {
        setBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setBackgroundColor(java.lang.@NonNull String color) {
        setBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setFont(io.qt.gui.QFont)}.</p>
     */
    @QtUninvokable
    public final void setFont(java.lang.@NonNull String font) {
        setFont(new io.qt.gui.QFont(font));
    }
    
    /**
     * <p>Overloaded function for {@link #setGridLineColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setGridLineColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setGridLineColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setGridLineColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setGridLineColor(io.qt.gui.@NonNull QRgba64 color) {
        setGridLineColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setGridLineColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setGridLineColor(java.lang.@NonNull String color) {
        setGridLineColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLabelBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLabelBackgroundColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setLabelBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLabelBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLabelBackgroundColor(io.qt.gui.@NonNull QRgba64 color) {
        setLabelBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLabelBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLabelBackgroundColor(java.lang.@NonNull String color) {
        setLabelBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLabelTextColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLabelTextColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setLabelTextColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLabelTextColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLabelTextColor(io.qt.gui.@NonNull QRgba64 color) {
        setLabelTextColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLabelTextColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLabelTextColor(java.lang.@NonNull String color) {
        setLabelTextColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLightColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setLightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLightColor(io.qt.gui.@NonNull QRgba64 color) {
        setLightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setLightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setLightColor(java.lang.@NonNull String color) {
        setLightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setMultiHighlightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setMultiHighlightColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setMultiHighlightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setMultiHighlightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setMultiHighlightColor(io.qt.gui.@NonNull QRgba64 color) {
        setMultiHighlightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setMultiHighlightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setMultiHighlightColor(java.lang.@NonNull String color) {
        setMultiHighlightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setSingleHighlightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setSingleHighlightColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setSingleHighlightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setSingleHighlightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setSingleHighlightColor(io.qt.gui.@NonNull QRgba64 color) {
        setSingleHighlightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setSingleHighlightColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setSingleHighlightColor(java.lang.@NonNull String color) {
        setSingleHighlightColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setWindowColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setWindowColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setWindowColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setWindowColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setWindowColor(io.qt.gui.@NonNull QRgba64 color) {
        setWindowColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setWindowColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setWindowColor(java.lang.@NonNull String color) {
        setWindowColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #singleHighlightColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getSingleHighlightColor() {
        return singleHighlightColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #singleHighlightGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getSingleHighlightGradient() {
        return singleHighlightGradient();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull Theme getType() {
        return type();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #windowColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getWindowColor() {
        return windowColor();
    }
}
