package io.qt.datavis;

import io.qt.*;


/**
 * <p>Basic wheel mouse based input handler</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/q3dinputhandler.html">Q3DInputHandler</a></code></p>
 * <p>This class was introduced in Qt QtDataVisualization 1.0.</p>
 */
public class Q3DInputHandler extends io.qt.datavis.QAbstract3DInputHandler
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DInputHandler.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#rotationEnabled-prop">Q3DInputHandler::<wbr/>rotationEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="rotationEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> rotationEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#selectionEnabled-prop">Q3DInputHandler::<wbr/>selectionEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="selectionEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> selectionEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomAtTargetEnabled-prop">Q3DInputHandler::<wbr/>zoomAtTargetEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="zoomAtTargetEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> zoomAtTargetEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomEnabled-prop">Q3DInputHandler::<wbr/>zoomEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="zoomEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> zoomEnabledChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#Q3DInputHandler">Q3DInputHandler::<wbr/>Q3DInputHandler(QObject*)</a></code></p>
     */
    public Q3DInputHandler(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DInputHandler instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#rotationEnabled-prop">Q3DInputHandler::<wbr/>isRotationEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="rotationEnabled")
    @QtUninvokable
    public final boolean isRotationEnabled(){
        return isRotationEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRotationEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#selectionEnabled-prop">Q3DInputHandler::<wbr/>isSelectionEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="selectionEnabled")
    @QtUninvokable
    public final boolean isSelectionEnabled(){
        return isSelectionEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSelectionEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomAtTargetEnabled-prop">Q3DInputHandler::<wbr/>isZoomAtTargetEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="zoomAtTargetEnabled")
    @QtUninvokable
    public final boolean isZoomAtTargetEnabled(){
        return isZoomAtTargetEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isZoomAtTargetEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomEnabled-prop">Q3DInputHandler::<wbr/>isZoomEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="zoomEnabled")
    @QtUninvokable
    public final boolean isZoomEnabled(){
        return isZoomEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isZoomEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#rotationEnabled-prop">Q3DInputHandler::<wbr/>setRotationEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="rotationEnabled")
    @QtUninvokable
    public final void setRotationEnabled(boolean enable){
        setRotationEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setRotationEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#selectionEnabled-prop">Q3DInputHandler::<wbr/>setSelectionEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="selectionEnabled")
    @QtUninvokable
    public final void setSelectionEnabled(boolean enable){
        setSelectionEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setSelectionEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomAtTargetEnabled-prop">Q3DInputHandler::<wbr/>setZoomAtTargetEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="zoomAtTargetEnabled")
    @QtUninvokable
    public final void setZoomAtTargetEnabled(boolean enable){
        setZoomAtTargetEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setZoomAtTargetEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomEnabled-prop">Q3DInputHandler::<wbr/>setZoomEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="zoomEnabled")
    @QtUninvokable
    public final void setZoomEnabled(boolean enable){
        setZoomEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setZoomEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mouseMoveEvent">QAbstract3DInputHandler::<wbr/>mouseMoveEvent(QMouseEvent*,<wbr/>QPoint)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void mouseMoveEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mouseMoveEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mousePressEvent">QAbstract3DInputHandler::<wbr/>mousePressEvent(QMouseEvent*,<wbr/>QPoint)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void mousePressEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mousePressEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mouseReleaseEvent">QAbstract3DInputHandler::<wbr/>mouseReleaseEvent(QMouseEvent*,<wbr/>QPoint)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void mouseReleaseEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mouseReleaseEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#wheelEvent">QAbstract3DInputHandler::<wbr/>wheelEvent(QWheelEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void wheelEvent(io.qt.gui.@Nullable QWheelEvent event){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected Q3DInputHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected Q3DInputHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DInputHandler instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #Q3DInputHandler(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DInputHandler() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isRotationEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRotationEnabled() {
        return isRotationEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isSelectionEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSelectionEnabled() {
        return isSelectionEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isZoomAtTargetEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getZoomAtTargetEnabled() {
        return isZoomAtTargetEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isZoomEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getZoomEnabled() {
        return isZoomEnabled();
    }
}
