package io.qt.datavis;

import io.qt.*;


/**
 * <p>The data proxy for a 3D surface graph</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html">QSurfaceDataProxy</a></code></p>
 */
public class QSurfaceDataProxy extends io.qt.datavis.QAbstractDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSurfaceDataProxy.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#arrayReset">QSurfaceDataProxy::<wbr>arrayReset()</a></code></p>
     */
    public final @NonNull Signal0 arrayReset = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#columnCount-prop">QSurfaceDataProxy::<wbr>columnCountChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="columnCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> columnCountChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#itemChanged">QSurfaceDataProxy::<wbr>itemChanged(int,<wbr>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> itemChanged = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#rowCount-prop">QSurfaceDataProxy::<wbr>rowCountChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="rowCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> rowCountChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#rowsAdded">QSurfaceDataProxy::<wbr>rowsAdded(int,<wbr>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsAdded = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#rowsChanged">QSurfaceDataProxy::<wbr>rowsChanged(int,<wbr>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsChanged = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#rowsInserted">QSurfaceDataProxy::<wbr>rowsInserted(int,<wbr>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsInserted = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#rowsRemoved">QSurfaceDataProxy::<wbr>rowsRemoved(int,<wbr>int)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> rowsRemoved = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#series-prop">QSurfaceDataProxy::<wbr>seriesChanged(QSurface3DSeries*)</a></code></p>
     */
    @QtPropertyNotify(name="series")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QSurface3DSeries> seriesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#QSurfaceDataProxy">QSurfaceDataProxy::<wbr>QSurfaceDataProxy(QObject*)</a></code></p>
     */
    public QSurfaceDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#addRow">QSurfaceDataProxy::<wbr>addRow(QSurfaceDataRow*)</a></code></p>
     */
    @QtUninvokable
    public final int addRow(io.qt.datavis.@Nullable QSurfaceDataRow row){
        return addRow_native_QSurfaceDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @QtUninvokable
    private native int addRow_native_QSurfaceDataRow_ptr(long __this__nativeId, long row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#addRows">QSurfaceDataProxy::<wbr>addRows(QSurfaceDataArray)</a></code></p>
     */
    @QtUninvokable
    public final int addRows(io.qt.datavis.@NonNull QSurfaceDataArray rows){
        return addRows_native_cref_QSurfaceDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @QtUninvokable
    private native int addRows_native_cref_QSurfaceDataArray(long __this__nativeId, long rows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#array">QSurfaceDataProxy::<wbr>array()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QSurfaceDataArray array(){
        return array_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QSurfaceDataArray array_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getColumnCount() {
        return columnCount();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#columnCount-prop">QSurfaceDataProxy::<wbr>columnCount()const</a></code></p>
     */
    @QtPropertyReader(name="columnCount")
    @QtUninvokable
    public final int columnCount(){
        return columnCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int columnCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#insertRow">QSurfaceDataProxy::<wbr>insertRow(int,<wbr>QSurfaceDataRow*)</a></code></p>
     */
    @QtUninvokable
    public final void insertRow(int rowIndex, io.qt.datavis.@Nullable QSurfaceDataRow row){
        insertRow_native_int_QSurfaceDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @QtUninvokable
    private native void insertRow_native_int_QSurfaceDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#insertRows">QSurfaceDataProxy::<wbr>insertRows(int,<wbr>QSurfaceDataArray)</a></code></p>
     */
    @QtUninvokable
    public final void insertRows(int rowIndex, io.qt.datavis.@NonNull QSurfaceDataArray rows){
        insertRows_native_int_cref_QSurfaceDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @QtUninvokable
    private native void insertRows_native_int_cref_QSurfaceDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#itemAt-1">QSurfaceDataProxy::<wbr>itemAt(QPoint)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QSurfaceDataItem itemAt(io.qt.core.@NonNull QPoint position){
        return itemAt_native_cref_QPoint_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QSurfaceDataItem itemAt_native_cref_QPoint_constfct(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#itemAt">QSurfaceDataProxy::<wbr>itemAt(int,<wbr>int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QSurfaceDataItem itemAt(int rowIndex, int columnIndex){
        return itemAt_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex);
    }
    
    @QtUninvokable
    private native io.qt.datavis.QSurfaceDataItem itemAt_native_int_int_constfct(long __this__nativeId, int rowIndex, int columnIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#removeRows">QSurfaceDataProxy::<wbr>removeRows(int,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void removeRows(int rowIndex, int removeCount){
        removeRows_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, removeCount);
    }
    
    @QtUninvokable
    private native void removeRows_native_int_int(long __this__nativeId, int rowIndex, int removeCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#resetArray">QSurfaceDataProxy::<wbr>resetArray(QSurfaceDataArray*)</a></code></p>
     */
    @QtUninvokable
    public final void resetArray(io.qt.datavis.@Nullable QSurfaceDataArray newArray){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcArray);
        resetArray_native_QSurfaceDataArray_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newArray));
        QtJambi_LibraryUtilities.internal.setCppOwnership(newArray);
        __rcArray = newArray;
        QtJambi_LibraryUtilities.internal.registerDependentObject(__rcArray, this);
    }
    
    @QtUninvokable
    private native void resetArray_native_QSurfaceDataArray_ptr(long __this__nativeId, long newArray);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getRowCount() {
        return rowCount();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#rowCount-prop">QSurfaceDataProxy::<wbr>rowCount()const</a></code></p>
     */
    @QtPropertyReader(name="rowCount")
    @QtUninvokable
    public final int rowCount(){
        return rowCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int rowCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #series()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QSurface3DSeries getSeries() {
        return series();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#series-prop">QSurfaceDataProxy::<wbr>series()const</a></code></p>
     */
    @QtPropertyReader(name="series")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QSurface3DSeries series(){
        return series_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QSurface3DSeries series_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#setItem-1">QSurfaceDataProxy::<wbr>setItem(QPoint,<wbr>QSurfaceDataItem)</a></code></p>
     */
    @QtUninvokable
    public final void setItem(io.qt.core.@NonNull QPoint position, io.qt.datavis.@NonNull QSurfaceDataItem item){
        setItem_native_cref_QPoint_cref_QSurfaceDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void setItem_native_cref_QPoint_cref_QSurfaceDataItem(long __this__nativeId, long position, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#setItem">QSurfaceDataProxy::<wbr>setItem(int,<wbr>int,<wbr>QSurfaceDataItem)</a></code></p>
     */
    @QtUninvokable
    public final void setItem(int rowIndex, int columnIndex, io.qt.datavis.@NonNull QSurfaceDataItem item){
        setItem_native_int_int_cref_QSurfaceDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void setItem_native_int_int_cref_QSurfaceDataItem(long __this__nativeId, int rowIndex, int columnIndex, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#setRow">QSurfaceDataProxy::<wbr>setRow(int,<wbr>QSurfaceDataRow*)</a></code></p>
     */
    @QtUninvokable
    public final void setRow(int rowIndex, io.qt.datavis.@Nullable QSurfaceDataRow row){
        setRow_native_int_QSurfaceDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @QtUninvokable
    private native void setRow_native_int_QSurfaceDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsurfacedataproxy.html#setRows">QSurfaceDataProxy::<wbr>setRows(int,<wbr>QSurfaceDataArray)</a></code></p>
     */
    @QtUninvokable
    public final void setRows(int rowIndex, io.qt.datavis.@NonNull QSurfaceDataArray rows){
        setRows_native_int_cref_QSurfaceDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @QtUninvokable
    private native void setRows_native_int_cref_QSurfaceDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
    private QSurfaceDataArray __rcArray;
}
