package io.qt.datavis;

import io.qt.*;


/**
 * <p>Proxy class for presenting data in item models with Q3DBars</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html">QItemModelBarDataProxy</a></p>
 */
public class QItemModelBarDataProxy extends io.qt.datavis.QBarDataProxy
{
    @QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelBarDataProxy.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QItemModelBarDataProxy::MultiMatchBehavior</a></p>
     */
    @QtUnlistedEnum
    public enum MultiMatchBehavior implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QItemModelBarDataProxy::MMBFirst</a></p>
         */
        MMBFirst(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QItemModelBarDataProxy::MMBLast</a></p>
         */
        MMBLast(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QItemModelBarDataProxy::MMBAverage</a></p>
         */
        MMBAverage(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QItemModelBarDataProxy::MMBCumulative</a></p>
         */
        MMBCumulative(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MultiMatchBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MultiMatchBehavior resolve(int value) {
            switch (value) {
            case 0: return MMBFirst;
            case 1: return MMBLast;
            case 2: return MMBAverage;
            case 3: return MMBCumulative;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#autoColumnCategories-prop">QItemModelBarDataProxy::autoColumnCategoriesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="autoColumnCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoColumnCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#autoRowCategories-prop">QItemModelBarDataProxy::autoRowCategoriesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="autoRowCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoRowCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnCategories-prop">QItemModelBarDataProxy::columnCategoriesChanged()</a></p>
     */
    @QtPropertyNotify(name="columnCategories")
    public final @NonNull Signal0 columnCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRole-prop">QItemModelBarDataProxy::columnRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="columnRole")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRolePattern-prop">QItemModelBarDataProxy::columnRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="columnRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> columnRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRoleReplace-prop">QItemModelBarDataProxy::columnRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="columnRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#itemModel-prop">QItemModelBarDataProxy::itemModelChanged(const QAbstractItemModel*)</a></p>
     */
    @QtPropertyNotify(name="itemModel")
    public final @NonNull Signal1<io.qt.core.@Nullable QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QItemModelBarDataProxy::multiMatchBehaviorChanged(QItemModelBarDataProxy::MultiMatchBehavior)</a></p>
     */
    @QtPropertyNotify(name="multiMatchBehavior")
    public final @NonNull Signal1<io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior> multiMatchBehaviorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRole-prop">QItemModelBarDataProxy::rotationRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="rotationRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRolePattern-prop">QItemModelBarDataProxy::rotationRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="rotationRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> rotationRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QItemModelBarDataProxy::rotationRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="rotationRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowCategories-prop">QItemModelBarDataProxy::rowCategoriesChanged()</a></p>
     */
    @QtPropertyNotify(name="rowCategories")
    public final @NonNull Signal0 rowCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRole-prop">QItemModelBarDataProxy::rowRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="rowRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRolePattern-prop">QItemModelBarDataProxy::rowRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="rowRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> rowRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRoleReplace-prop">QItemModelBarDataProxy::rowRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="rowRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#useModelCategories-prop">QItemModelBarDataProxy::useModelCategoriesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="useModelCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> useModelCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRole-prop">QItemModelBarDataProxy::valueRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="valueRole")
    public final @NonNull Signal1<java.lang.@NonNull String> valueRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRolePattern-prop">QItemModelBarDataProxy::valueRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="valueRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> valueRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRoleReplace-prop">QItemModelBarDataProxy::valueRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="valueRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> valueRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#QItemModelBarDataProxy-1">QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole) {
        this(itemModel, rowRole, columnRole, valueRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#QItemModelBarDataProxy-3">QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole) {
        this(itemModel, rowRole, columnRole, valueRole, rotationRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#QItemModelBarDataProxy-4">QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rotationRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#QItemModelBarDataProxy-6">QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, valueRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#QItemModelBarDataProxy-5">QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String valueRole) {
        this(itemModel, valueRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#QItemModelBarDataProxy-2">QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String valueRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, valueRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String valueRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#QItemModelBarDataProxy">QItemModelBarDataProxy::QItemModelBarDataProxy(QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoColumnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoColumnCategories() {
        return autoColumnCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#autoColumnCategories-prop">QItemModelBarDataProxy::autoColumnCategories()const</a></p>
     */
    @QtPropertyReader(name="autoColumnCategories")
    @QtUninvokable
    public final boolean autoColumnCategories(){
        return autoColumnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoColumnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoRowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoRowCategories() {
        return autoRowCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#autoRowCategories-prop">QItemModelBarDataProxy::autoRowCategories()const</a></p>
     */
    @QtPropertyReader(name="autoRowCategories")
    @QtUninvokable
    public final boolean autoRowCategories(){
        return autoRowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoRowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getColumnCategories() {
        return columnCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnCategories-prop">QItemModelBarDataProxy::columnCategories()const</a></p>
     */
    @QtPropertyReader(name="columnCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList columnCategories(){
        return columnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList columnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnCategoryIndex">QItemModelBarDataProxy::columnCategoryIndex(QString)</a></p>
     */
    public final int columnCategoryIndex(java.lang.@NonNull String category){
        return columnCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int columnCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRole() {
        return columnRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRole-prop">QItemModelBarDataProxy::columnRole()const</a></p>
     */
    @QtPropertyReader(name="columnRole")
    @QtUninvokable
    public final java.lang.@NonNull String columnRole(){
        return columnRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getColumnRolePattern() {
        return columnRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRolePattern-prop">QItemModelBarDataProxy::columnRolePattern()const</a></p>
     */
    @QtPropertyReader(name="columnRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression columnRolePattern(){
        return columnRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression columnRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRoleReplace() {
        return columnRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRoleReplace-prop">QItemModelBarDataProxy::columnRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="columnRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String columnRoleReplace(){
        return columnRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel getItemModel() {
        return itemModel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#itemModel-prop">QItemModelBarDataProxy::itemModel()const</a></p>
     */
    @QtPropertyReader(name="itemModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #multiMatchBehavior()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior getMultiMatchBehavior() {
        return multiMatchBehavior();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QItemModelBarDataProxy::multiMatchBehavior()const</a></p>
     */
    @QtPropertyReader(name="multiMatchBehavior")
    @QtUninvokable
    public final io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior multiMatchBehavior(){
        return io.qt.datavis.QItemModelBarDataProxy.MultiMatchBehavior.resolve(multiMatchBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int multiMatchBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#remap">QItemModelBarDataProxy::remap(QString,QString,QString,QString,QStringList,QStringList)</a></p>
     */
    @QtUninvokable
    public final void remap(java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories);
    }
    
    @QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(long __this__nativeId, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRole() {
        return rotationRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRole-prop">QItemModelBarDataProxy::rotationRole()const</a></p>
     */
    @QtPropertyReader(name="rotationRole")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRole(){
        return rotationRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getRotationRolePattern() {
        return rotationRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRolePattern-prop">QItemModelBarDataProxy::rotationRolePattern()const</a></p>
     */
    @QtPropertyReader(name="rotationRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression rotationRolePattern(){
        return rotationRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression rotationRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRoleReplace() {
        return rotationRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QItemModelBarDataProxy::rotationRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="rotationRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRoleReplace(){
        return rotationRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getRowCategories() {
        return rowCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowCategories-prop">QItemModelBarDataProxy::rowCategories()const</a></p>
     */
    @QtPropertyReader(name="rowCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList rowCategories(){
        return rowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList rowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowCategoryIndex">QItemModelBarDataProxy::rowCategoryIndex(QString)</a></p>
     */
    public final int rowCategoryIndex(java.lang.@NonNull String category){
        return rowCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int rowCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRole() {
        return rowRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRole-prop">QItemModelBarDataProxy::rowRole()const</a></p>
     */
    @QtPropertyReader(name="rowRole")
    @QtUninvokable
    public final java.lang.@NonNull String rowRole(){
        return rowRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getRowRolePattern() {
        return rowRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRolePattern-prop">QItemModelBarDataProxy::rowRolePattern()const</a></p>
     */
    @QtPropertyReader(name="rowRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression rowRolePattern(){
        return rowRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression rowRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRoleReplace() {
        return rowRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRoleReplace-prop">QItemModelBarDataProxy::rowRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="rowRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rowRoleReplace(){
        return rowRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#autoColumnCategories-prop">QItemModelBarDataProxy::setAutoColumnCategories(bool)</a></p>
     */
    @QtPropertyWriter(name="autoColumnCategories")
    @QtUninvokable
    public final void setAutoColumnCategories(boolean enable){
        setAutoColumnCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoColumnCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#autoRowCategories-prop">QItemModelBarDataProxy::setAutoRowCategories(bool)</a></p>
     */
    @QtPropertyWriter(name="autoRowCategories")
    @QtUninvokable
    public final void setAutoRowCategories(boolean enable){
        setAutoRowCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoRowCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnCategories-prop">QItemModelBarDataProxy::setColumnCategories(QStringList)</a></p>
     */
    @QtPropertyWriter(name="columnCategories")
    @QtUninvokable
    public final void setColumnCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setColumnCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setColumnCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRole-prop">QItemModelBarDataProxy::setColumnRole(QString)</a></p>
     */
    @QtPropertyWriter(name="columnRole")
    @QtUninvokable
    public final void setColumnRole(java.lang.@NonNull String role){
        setColumnRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setColumnRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRolePattern-prop">QItemModelBarDataProxy::setColumnRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="columnRolePattern")
    @QtUninvokable
    public final void setColumnRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setColumnRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setColumnRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#columnRoleReplace-prop">QItemModelBarDataProxy::setColumnRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="columnRoleReplace")
    @QtUninvokable
    public final void setColumnRoleReplace(java.lang.@NonNull String replace){
        setColumnRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setColumnRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#setItemModel">QItemModelBarDataProxy::setItemModel(QAbstractItemModel*)</a></p>
     */
    @QtPropertyWriter(name="itemModel")
    @QtUninvokable
    public final void setItemModel(io.qt.core.@Nullable QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QItemModelBarDataProxy::setMultiMatchBehavior(QItemModelBarDataProxy::MultiMatchBehavior)</a></p>
     */
    @QtPropertyWriter(name="multiMatchBehavior")
    @QtUninvokable
    public final void setMultiMatchBehavior(io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior behavior){
        setMultiMatchBehavior_native_QItemModelBarDataProxy_MultiMatchBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), behavior.value());
    }
    
    @QtUninvokable
    private native void setMultiMatchBehavior_native_QItemModelBarDataProxy_MultiMatchBehavior(long __this__nativeId, int behavior);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRole-prop">QItemModelBarDataProxy::setRotationRole(QString)</a></p>
     */
    @QtPropertyWriter(name="rotationRole")
    @QtUninvokable
    public final void setRotationRole(java.lang.@NonNull String role){
        setRotationRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRotationRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRolePattern-prop">QItemModelBarDataProxy::setRotationRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="rotationRolePattern")
    @QtUninvokable
    public final void setRotationRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setRotationRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRotationRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QItemModelBarDataProxy::setRotationRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="rotationRoleReplace")
    @QtUninvokable
    public final void setRotationRoleReplace(java.lang.@NonNull String replace){
        setRotationRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRotationRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowCategories-prop">QItemModelBarDataProxy::setRowCategories(QStringList)</a></p>
     */
    @QtPropertyWriter(name="rowCategories")
    @QtUninvokable
    public final void setRowCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setRowCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setRowCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRole-prop">QItemModelBarDataProxy::setRowRole(QString)</a></p>
     */
    @QtPropertyWriter(name="rowRole")
    @QtUninvokable
    public final void setRowRole(java.lang.@NonNull String role){
        setRowRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRowRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRolePattern-prop">QItemModelBarDataProxy::setRowRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="rowRolePattern")
    @QtUninvokable
    public final void setRowRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setRowRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRowRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#rowRoleReplace-prop">QItemModelBarDataProxy::setRowRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="rowRoleReplace")
    @QtUninvokable
    public final void setRowRoleReplace(java.lang.@NonNull String replace){
        setRowRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRowRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#useModelCategories-prop">QItemModelBarDataProxy::setUseModelCategories(bool)</a></p>
     */
    @QtPropertyWriter(name="useModelCategories")
    @QtUninvokable
    public final void setUseModelCategories(boolean enable){
        setUseModelCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setUseModelCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRole-prop">QItemModelBarDataProxy::setValueRole(QString)</a></p>
     */
    @QtPropertyWriter(name="valueRole")
    @QtUninvokable
    public final void setValueRole(java.lang.@NonNull String role){
        setValueRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setValueRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRolePattern-prop">QItemModelBarDataProxy::setValueRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="valueRolePattern")
    @QtUninvokable
    public final void setValueRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setValueRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setValueRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRoleReplace-prop">QItemModelBarDataProxy::setValueRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="valueRoleReplace")
    @QtUninvokable
    public final void setValueRoleReplace(java.lang.@NonNull String replace){
        setValueRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setValueRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #useModelCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUseModelCategories() {
        return useModelCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#useModelCategories-prop">QItemModelBarDataProxy::useModelCategories()const</a></p>
     */
    @QtPropertyReader(name="useModelCategories")
    @QtUninvokable
    public final boolean useModelCategories(){
        return useModelCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean useModelCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #valueRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getValueRole() {
        return valueRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRole-prop">QItemModelBarDataProxy::valueRole()const</a></p>
     */
    @QtPropertyReader(name="valueRole")
    @QtUninvokable
    public final java.lang.@NonNull String valueRole(){
        return valueRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String valueRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #valueRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getValueRolePattern() {
        return valueRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRolePattern-prop">QItemModelBarDataProxy::valueRolePattern()const</a></p>
     */
    @QtPropertyReader(name="valueRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression valueRolePattern(){
        return valueRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression valueRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #valueRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getValueRoleReplace() {
        return valueRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelbardataproxy.html#valueRoleReplace-prop">QItemModelBarDataProxy::valueRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="valueRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String valueRoleReplace(){
        return valueRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String valueRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QItemModelBarDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QItemModelBarDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QItemModelBarDataProxy instance, QDeclarativeConstructor constructor);
    
}
