package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base proxy class for Q3DSurface</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html">QHeightMapSurfaceDataProxy</a></p>
 */
public class QHeightMapSurfaceDataProxy extends io.qt.datavis.QSurfaceDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHeightMapSurfaceDataProxy.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#autoScaleY-prop">QHeightMapSurfaceDataProxy::autoScaleYChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="autoScaleY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoScaleYChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMap-prop">QHeightMapSurfaceDataProxy::heightMapChanged(QImage)</a></p>
     */
    @QtPropertyNotify(name="heightMap")
    public final @NonNull Signal1<io.qt.gui.@NonNull QImage> heightMapChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMapFile-prop">QHeightMapSurfaceDataProxy::heightMapFileChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="heightMapFile")
    public final @NonNull Signal1<java.lang.@NonNull String> heightMapFileChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::maxXValueChanged(float)</a></p>
     */
    @QtPropertyNotify(name="maxXValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxXValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxYValue-prop">QHeightMapSurfaceDataProxy::maxYValueChanged(float)</a></p>
     */
    @QtPropertyNotify(name="maxYValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxYValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::maxZValueChanged(float)</a></p>
     */
    @QtPropertyNotify(name="maxZValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxZValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::minXValueChanged(float)</a></p>
     */
    @QtPropertyNotify(name="minXValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minXValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minYValue-prop">QHeightMapSurfaceDataProxy::minYValueChanged(float)</a></p>
     */
    @QtPropertyNotify(name="minYValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minYValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::minZValueChanged(float)</a></p>
     */
    @QtPropertyNotify(name="minZValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minZValueChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy">QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(QObject*)</a></p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(io.qt.gui.QImage, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.gui.@NonNull QImage image) {
        this(image, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy-1">QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(QImage,QObject*)</a></p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.gui.@NonNull QImage image, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, image, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, io.qt.gui.QImage image, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy(java.lang.@NonNull String filename) {
        this(filename, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy-2">QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(QString,QObject*)</a></p>
     */
    public QHeightMapSurfaceDataProxy(java.lang.@NonNull String filename, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, filename, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, java.lang.String filename, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoScaleY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoScaleY() {
        return autoScaleY();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#autoScaleY-prop">QHeightMapSurfaceDataProxy::autoScaleY()const</a></p>
     */
    @QtPropertyReader(name="autoScaleY")
    @QtUninvokable
    public final boolean autoScaleY(){
        return autoScaleY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoScaleY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #heightMap()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage getHeightMap() {
        return heightMap();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMap-prop">QHeightMapSurfaceDataProxy::heightMap()const</a></p>
     */
    @QtPropertyReader(name="heightMap")
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage heightMap(){
        return heightMap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage heightMap_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #heightMapFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getHeightMapFile() {
        return heightMapFile();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMapFile-prop">QHeightMapSurfaceDataProxy::heightMapFile()const</a></p>
     */
    @QtPropertyReader(name="heightMapFile")
    @QtUninvokable
    public final java.lang.@NonNull String heightMapFile(){
        return heightMapFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String heightMapFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxXValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxXValue() {
        return maxXValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::maxXValue()const</a></p>
     */
    @QtPropertyReader(name="maxXValue")
    @QtUninvokable
    public final float maxXValue(){
        return maxXValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxXValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxYValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxYValue() {
        return maxYValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxYValue-prop">QHeightMapSurfaceDataProxy::maxYValue()const</a></p>
     */
    @QtPropertyReader(name="maxYValue")
    @QtUninvokable
    public final float maxYValue(){
        return maxYValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxYValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxZValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxZValue() {
        return maxZValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::maxZValue()const</a></p>
     */
    @QtPropertyReader(name="maxZValue")
    @QtUninvokable
    public final float maxZValue(){
        return maxZValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxZValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minXValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinXValue() {
        return minXValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::minXValue()const</a></p>
     */
    @QtPropertyReader(name="minXValue")
    @QtUninvokable
    public final float minXValue(){
        return minXValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minXValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minYValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinYValue() {
        return minYValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minYValue-prop">QHeightMapSurfaceDataProxy::minYValue()const</a></p>
     */
    @QtPropertyReader(name="minYValue")
    @QtUninvokable
    public final float minYValue(){
        return minYValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minYValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minZValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinZValue() {
        return minZValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::minZValue()const</a></p>
     */
    @QtPropertyReader(name="minZValue")
    @QtUninvokable
    public final float minZValue(){
        return minZValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minZValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#autoScaleY-prop">QHeightMapSurfaceDataProxy::setAutoScaleY(bool)</a></p>
     */
    @QtPropertyWriter(name="autoScaleY")
    @QtUninvokable
    public final void setAutoScaleY(boolean enabled){
        setAutoScaleY_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setAutoScaleY_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setHeightMap">QHeightMapSurfaceDataProxy::setHeightMap(QImage)</a></p>
     */
    @QtPropertyWriter(name="heightMap")
    @QtUninvokable
    public final void setHeightMap(io.qt.gui.@NonNull QImage image){
        setHeightMap_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    @QtUninvokable
    private native void setHeightMap_native_cref_QImage(long __this__nativeId, long image);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setHeightMapFile">QHeightMapSurfaceDataProxy::setHeightMapFile(QString)</a></p>
     */
    @QtPropertyWriter(name="heightMapFile")
    @QtUninvokable
    public final void setHeightMapFile(java.lang.@NonNull String filename){
        setHeightMapFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filename);
    }
    
    @QtUninvokable
    private native void setHeightMapFile_native_cref_QString(long __this__nativeId, java.lang.String filename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::setMaxXValue(float)</a></p>
     */
    @QtPropertyWriter(name="maxXValue")
    @QtUninvokable
    public final void setMaxXValue(float max){
        setMaxXValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @QtUninvokable
    private native void setMaxXValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxYValue-prop">QHeightMapSurfaceDataProxy::setMaxYValue(float)</a></p>
     */
    @QtPropertyWriter(name="maxYValue")
    @QtUninvokable
    public final void setMaxYValue(float max){
        setMaxYValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @QtUninvokable
    private native void setMaxYValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::setMaxZValue(float)</a></p>
     */
    @QtPropertyWriter(name="maxZValue")
    @QtUninvokable
    public final void setMaxZValue(float max){
        setMaxZValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @QtUninvokable
    private native void setMaxZValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::setMinXValue(float)</a></p>
     */
    @QtPropertyWriter(name="minXValue")
    @QtUninvokable
    public final void setMinXValue(float min){
        setMinXValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @QtUninvokable
    private native void setMinXValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minYValue-prop">QHeightMapSurfaceDataProxy::setMinYValue(float)</a></p>
     */
    @QtPropertyWriter(name="minYValue")
    @QtUninvokable
    public final void setMinYValue(float min){
        setMinYValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @QtUninvokable
    private native void setMinYValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::setMinZValue(float)</a></p>
     */
    @QtPropertyWriter(name="minZValue")
    @QtUninvokable
    public final void setMinZValue(float min){
        setMinZValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @QtUninvokable
    private native void setMinZValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setValueRanges">QHeightMapSurfaceDataProxy::setValueRanges(float,float,float,float)</a></p>
     */
    @QtUninvokable
    public final void setValueRanges(float minX, float maxX, float minZ, float maxZ){
        setValueRanges_native_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), minX, maxX, minZ, maxZ);
    }
    
    @QtUninvokable
    private native void setValueRanges_native_float_float_float_float(long __this__nativeId, float minX, float maxX, float minZ, float maxZ);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QHeightMapSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QHeightMapSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QHeightMapSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
}
