package io.qt.datavis;

import io.qt.*;


/**
 * <p>Container for resolved data to be added to bar graphs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qbardataitem.html">QBarDataItem</a></p>
 */
public class QBarDataItem extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem">QBarDataItem::QBarDataItem()</a></p>
     */
    public QBarDataItem(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QBarDataItem instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem-3">QBarDataItem::QBarDataItem(QBarDataItem)</a></p>
     */
    public QBarDataItem(io.qt.datavis.@NonNull QBarDataItem other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QBarDataItem instance, io.qt.datavis.QBarDataItem other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem-1">QBarDataItem::QBarDataItem(float)</a></p>
     */
    public QBarDataItem(float value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QBarDataItem instance, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#QBarDataItem-2">QBarDataItem::QBarDataItem(float,float)</a></p>
     */
    public QBarDataItem(float value, float angle){
        super((QPrivateConstructor)null);
        initialize_native(this, value, angle);
    }
    
    private native static void initialize_native(QBarDataItem instance, float value, float angle);
    
    @QtUninvokable
    protected final void createExtraData(){
        createExtraData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void createExtraData_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#operator-eq">QBarDataItem::operator=(QBarDataItem)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.datavis.@NonNull QBarDataItem other){
        assign_native_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QBarDataItem(long __this__nativeId, long other);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.datavis.@NonNull QBarDataItem b){
        return operator_equal_native_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QBarDataItem(long __this__nativeId, long b);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#rotation">QBarDataItem::rotation()const</a></p>
     */
    @QtUninvokable
    public final float rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#setRotation">QBarDataItem::setRotation(float)</a></p>
     */
    @QtUninvokable
    public final void setRotation(float angle){
        setRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    @QtUninvokable
    private native void setRotation_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#setValue">QBarDataItem::setValue(float)</a></p>
     */
    @QtUninvokable
    public final void setValue(float val){
        setValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), val);
    }
    
    @QtUninvokable
    private native void setValue_native_float(long __this__nativeId, float val);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataitem.html#value">QBarDataItem::value()const</a></p>
     */
    @QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QBarDataItem(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.datavis.QBarDataItem) {
            return operator_equal((io.qt.datavis.QBarDataItem) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QBarDataItem clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QBarDataItem clone_native(long __this_nativeId);
}
