package io.qt.datavis;

import io.qt.*;


/**
 * <p>Manipulates an axis of a graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qvalue3daxis.html">QValue3DAxis</a></p>
 */
public class QValue3DAxis extends io.qt.datavis.QAbstract3DAxis
{
    @QtPropertyMember(enabled=false)
    private Object __rcFormatter = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QValue3DAxis.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#formatter-prop">QValue3DAxis::formatterChanged(QValue3DAxisFormatter*)</a></p>
     */
    @QtPropertyNotify(name="formatter")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QValue3DAxisFormatter> formatterChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#labelFormat-prop">QValue3DAxis::labelFormatChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="labelFormat")
    public final @NonNull Signal1<java.lang.@NonNull String> labelFormatChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#reversed-prop">QValue3DAxis::reversedChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="reversed")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> reversedChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#segmentCount-prop">QValue3DAxis::segmentCountChanged(int)</a></p>
     */
    @QtPropertyNotify(name="segmentCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> segmentCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#subSegmentCount-prop">QValue3DAxis::subSegmentCountChanged(int)</a></p>
     */
    @QtPropertyNotify(name="subSegmentCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> subSegmentCountChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QValue3DAxis(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QValue3DAxis() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#QValue3DAxis">QValue3DAxis::QValue3DAxis(QObject*)</a></p>
     */
    public QValue3DAxis(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QValue3DAxis instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #formatter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxisFormatter getFormatter() {
        return formatter();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#formatter-prop">QValue3DAxis::formatter()const</a></p>
     */
    @QtPropertyReader(name="formatter")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxisFormatter formatter(){
        return formatter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxisFormatter formatter_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #labelFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getLabelFormat() {
        return labelFormat();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#labelFormat-prop">QValue3DAxis::labelFormat()const</a></p>
     */
    @QtPropertyReader(name="labelFormat")
    @QtUninvokable
    public final java.lang.@NonNull String labelFormat(){
        return labelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String labelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reversed()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getReversed() {
        return reversed();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#reversed-prop">QValue3DAxis::reversed()const</a></p>
     */
    @QtPropertyReader(name="reversed")
    @QtUninvokable
    public final boolean reversed(){
        return reversed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean reversed_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #segmentCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSegmentCount() {
        return segmentCount();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#segmentCount-prop">QValue3DAxis::segmentCount()const</a></p>
     */
    @QtPropertyReader(name="segmentCount")
    @QtUninvokable
    public final int segmentCount(){
        return segmentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int segmentCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#formatter-prop">QValue3DAxis::setFormatter(QValue3DAxisFormatter*)</a></p>
     */
    @QtPropertyWriter(name="formatter")
    @QtUninvokable
    public final void setFormatter(io.qt.datavis.@Nullable QValue3DAxisFormatter formatter){
        setFormatter_native_QValue3DAxisFormatter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(formatter));
        __rcFormatter = formatter;
    }
    
    @QtUninvokable
    private native void setFormatter_native_QValue3DAxisFormatter_ptr(long __this__nativeId, long formatter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#labelFormat-prop">QValue3DAxis::setLabelFormat(QString)</a></p>
     */
    @QtPropertyWriter(name="labelFormat")
    @QtUninvokable
    public final void setLabelFormat(java.lang.@NonNull String format){
        setLabelFormat_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), format);
    }
    
    @QtUninvokable
    private native void setLabelFormat_native_cref_QString(long __this__nativeId, java.lang.String format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#reversed-prop">QValue3DAxis::setReversed(bool)</a></p>
     */
    @QtPropertyWriter(name="reversed")
    @QtUninvokable
    public final void setReversed(boolean enable){
        setReversed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setReversed_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#segmentCount-prop">QValue3DAxis::setSegmentCount(int)</a></p>
     */
    @QtPropertyWriter(name="segmentCount")
    @QtUninvokable
    public final void setSegmentCount(int count){
        setSegmentCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @QtUninvokable
    private native void setSegmentCount_native_int(long __this__nativeId, int count);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#subSegmentCount-prop">QValue3DAxis::setSubSegmentCount(int)</a></p>
     */
    @QtPropertyWriter(name="subSegmentCount")
    @QtUninvokable
    public final void setSubSegmentCount(int count){
        setSubSegmentCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @QtUninvokable
    private native void setSubSegmentCount_native_int(long __this__nativeId, int count);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #subSegmentCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSubSegmentCount() {
        return subSegmentCount();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxis.html#subSegmentCount-prop">QValue3DAxis::subSegmentCount()const</a></p>
     */
    @QtPropertyReader(name="subSegmentCount")
    @QtUninvokable
    public final int subSegmentCount(){
        return subSegmentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int subSegmentCount_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QValue3DAxis(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QValue3DAxis(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QValue3DAxis instance, QDeclarativeConstructor constructor);
    
}
