package io.qt.datavis;

import io.qt.*;


/**
 * <p>The data proxy for 3D scatter graphs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscatterdataproxy.html">QScatterDataProxy</a></p>
 */
public class QScatterDataProxy extends io.qt.datavis.QAbstractDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScatterDataProxy.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#arrayReset">QScatterDataProxy::arrayReset()</a></p>
     */
    public final @NonNull Signal0 arrayReset = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#itemCount-prop">QScatterDataProxy::itemCountChanged(int)</a></p>
     */
    @QtPropertyNotify(name="itemCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> itemCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#itemsAdded">QScatterDataProxy::itemsAdded(int,int)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> itemsAdded = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#itemsChanged">QScatterDataProxy::itemsChanged(int,int)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> itemsChanged = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#itemsInserted">QScatterDataProxy::itemsInserted(int,int)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> itemsInserted = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#itemsRemoved">QScatterDataProxy::itemsRemoved(int,int)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> itemsRemoved = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#series-prop">QScatterDataProxy::seriesChanged(QScatter3DSeries*)</a></p>
     */
    @QtPropertyNotify(name="series")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QScatter3DSeries> seriesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QScatterDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScatterDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#QScatterDataProxy">QScatterDataProxy::QScatterDataProxy(QObject*)</a></p>
     */
    public QScatterDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScatterDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#addItem">QScatterDataProxy::addItem(QScatterDataItem)</a></p>
     */
    @QtUninvokable
    public final int addItem(io.qt.datavis.@NonNull QScatterDataItem item){
        return addItem_native_cref_QScatterDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native int addItem_native_cref_QScatterDataItem(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#addItems">QScatterDataProxy::addItems(QScatterDataArray)</a></p>
     */
    @QtUninvokable
    public final int addItems(io.qt.datavis.@NonNull QScatterDataArray items){
        return addItems_native_cref_QScatterDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(items));
    }
    
    @QtUninvokable
    private native int addItems_native_cref_QScatterDataArray(long __this__nativeId, long items);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#array">QScatterDataProxy::array()const</a></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatterDataArray array(){
        return array_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QScatterDataArray array_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#insertItem">QScatterDataProxy::insertItem(int,QScatterDataItem)</a></p>
     */
    @QtUninvokable
    public final void insertItem(int index, io.qt.datavis.@NonNull QScatterDataItem item){
        insertItem_native_int_cref_QScatterDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void insertItem_native_int_cref_QScatterDataItem(long __this__nativeId, int index, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#insertItems">QScatterDataProxy::insertItems(int,QScatterDataArray)</a></p>
     */
    @QtUninvokable
    public final void insertItems(int index, io.qt.datavis.@NonNull QScatterDataArray items){
        insertItems_native_int_cref_QScatterDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(items));
    }
    
    @QtUninvokable
    private native void insertItems_native_int_cref_QScatterDataArray(long __this__nativeId, int index, long items);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#itemAt">QScatterDataProxy::itemAt(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatterDataItem itemAt(int index){
        return itemAt_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native io.qt.datavis.QScatterDataItem itemAt_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getItemCount() {
        return itemCount();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#itemCount-prop">QScatterDataProxy::itemCount()const</a></p>
     */
    @QtPropertyReader(name="itemCount")
    @QtUninvokable
    public final int itemCount(){
        return itemCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int itemCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#removeItems">QScatterDataProxy::removeItems(int,int)</a></p>
     */
    @QtUninvokable
    public final void removeItems(int index, int removeCount){
        removeItems_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), index, removeCount);
    }
    
    @QtUninvokable
    private native void removeItems_native_int_int(long __this__nativeId, int index, int removeCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#resetArray">QScatterDataProxy::resetArray(QScatterDataArray*)</a></p>
     */
    @QtUninvokable
    public final void resetArray(io.qt.datavis.@Nullable QScatterDataArray newArray){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcArray);
        resetArray_native_QScatterDataArray_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newArray));
        QtJambi_LibraryUtilities.internal.setCppOwnership(newArray);
        __rcArray = newArray;
        QtJambi_LibraryUtilities.internal.registerDependentObject(__rcArray, this);
    }
    
    @QtUninvokable
    private native void resetArray_native_QScatterDataArray_ptr(long __this__nativeId, long newArray);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #series()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatter3DSeries getSeries() {
        return series();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#series-prop">QScatterDataProxy::series()const</a></p>
     */
    @QtPropertyReader(name="series")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatter3DSeries series(){
        return series_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QScatter3DSeries series_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#setItem">QScatterDataProxy::setItem(int,QScatterDataItem)</a></p>
     */
    @QtUninvokable
    public final void setItem(int index, io.qt.datavis.@NonNull QScatterDataItem item){
        setItem_native_int_cref_QScatterDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void setItem_native_int_cref_QScatterDataItem(long __this__nativeId, int index, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataproxy.html#setItems">QScatterDataProxy::setItems(int,QScatterDataArray)</a></p>
     */
    @QtUninvokable
    public final void setItems(int index, io.qt.datavis.@NonNull QScatterDataArray items){
        setItems_native_int_cref_QScatterDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(items));
    }
    
    @QtUninvokable
    private native void setItems_native_int_cref_QScatterDataArray(long __this__nativeId, int index, long items);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScatterDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QScatterDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScatterDataProxy instance, QDeclarativeConstructor constructor);
    
    private QScatterDataArray __rcArray;
}
