package io.qt.datavis;

import io.qt.*;


/**
 * <p>Represents a data series in a 3D scatter graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscatter3dseries.html">QScatter3DSeries</a></p>
 */
public class QScatter3DSeries extends io.qt.datavis.QAbstract3DSeries
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScatter3DSeries.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#dataProxy-prop">QScatter3DSeries::dataProxyChanged(QScatterDataProxy*)</a></p>
     */
    @QtPropertyNotify(name="dataProxy")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QScatterDataProxy> dataProxyChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#itemSize-prop">QScatter3DSeries::itemSizeChanged(float)</a></p>
     */
    @QtPropertyNotify(name="itemSize")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> itemSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#selectedItem-prop">QScatter3DSeries::selectedItemChanged(int)</a></p>
     */
    @QtPropertyNotify(name="selectedItem")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> selectedItemChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QScatter3DSeries(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScatter3DSeries() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#QScatter3DSeries">QScatter3DSeries::QScatter3DSeries(QObject*)</a></p>
     */
    public QScatter3DSeries(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScatter3DSeries instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QScatter3DSeries(io.qt.datavis.QScatterDataProxy, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScatter3DSeries(io.qt.datavis.@Nullable QScatterDataProxy dataProxy) {
        this(dataProxy, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#QScatter3DSeries-1">QScatter3DSeries::QScatter3DSeries(QScatterDataProxy*,QObject*)</a></p>
     */
    public QScatter3DSeries(io.qt.datavis.@Nullable QScatterDataProxy dataProxy, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, dataProxy, parent);
    }
    
    private native static void initialize_native(QScatter3DSeries instance, io.qt.datavis.QScatterDataProxy dataProxy, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #dataProxy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatterDataProxy getDataProxy() {
        return dataProxy();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#dataProxy-prop">QScatter3DSeries::dataProxy()const</a></p>
     */
    @QtPropertyReader(name="dataProxy")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatterDataProxy dataProxy(){
        return dataProxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QScatterDataProxy dataProxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getItemSize() {
        return itemSize();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#itemSize-prop">QScatter3DSeries::itemSize()const</a></p>
     */
    @QtPropertyReader(name="itemSize")
    @QtUninvokable
    public final float itemSize(){
        return itemSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float itemSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedItem()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSelectedItem() {
        return selectedItem();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#selectedItem-prop">QScatter3DSeries::selectedItem()const</a></p>
     */
    @QtPropertyReader(name="selectedItem")
    @QtUninvokable
    public final int selectedItem(){
        return selectedItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int selectedItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#setDataProxy">QScatter3DSeries::setDataProxy(QScatterDataProxy*)</a></p>
     */
    @QtPropertyWriter(name="dataProxy")
    @QtUninvokable
    public final void setDataProxy(io.qt.datavis.@StrictNonNull QScatterDataProxy proxy){
        if(proxy!=null){
            if(proxy==dataProxy()){
                throw new IllegalArgumentException("Proxy is already assigned to this series.");
            }else if(proxy.series()!=null){
                throw new IllegalArgumentException("Proxy is already assigned to another series.");
            }
        }
        java.util.Objects.requireNonNull(proxy, "Argument 'proxy': null not expected.");
        setDataProxy_native_QScatterDataProxy_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(proxy));
    }
    
    @QtUninvokable
    private native void setDataProxy_native_QScatterDataProxy_ptr(long __this__nativeId, long proxy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#itemSize-prop">QScatter3DSeries::setItemSize(float)</a></p>
     */
    @QtPropertyWriter(name="itemSize")
    @QtUninvokable
    public final void setItemSize(float size){
        setItemSize_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void setItemSize_native_float(long __this__nativeId, float size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#setSelectedItem">QScatter3DSeries::setSelectedItem(int)</a></p>
     */
    @QtPropertyWriter(name="selectedItem")
    @QtUninvokable
    public final void setSelectedItem(int index){
        setSelectedItem_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void setSelectedItem_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatter3dseries.html#invalidSelectionIndex">QScatter3DSeries::invalidSelectionIndex()</a></p>
     */
    public native static int invalidSelectionIndex();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScatter3DSeries(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QScatter3DSeries(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScatter3DSeries instance, QDeclarativeConstructor constructor);
    
}
