package io.qt.datavis;

import io.qt.*;


/**
 * <p>Proxy class for presenting data in item models with Q3DSurface</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html">QItemModelSurfaceDataProxy</a></p>
 */
public class QItemModelSurfaceDataProxy extends io.qt.datavis.QSurfaceDataProxy
{
    @QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelSurfaceDataProxy.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::MultiMatchBehavior</a></p>
     */
    @QtUnlistedEnum
    public enum MultiMatchBehavior implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::MMBFirst</a></p>
         */
        MMBFirst(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::MMBLast</a></p>
         */
        MMBLast(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::MMBAverage</a></p>
         */
        MMBAverage(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QItemModelSurfaceDataProxy::MMBCumulativeY</a></p>
         */
        MMBCumulativeY(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MultiMatchBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MultiMatchBehavior resolve(int value) {
            switch (value) {
            case 0: return MMBFirst;
            case 1: return MMBLast;
            case 2: return MMBAverage;
            case 3: return MMBCumulativeY;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QItemModelSurfaceDataProxy::autoColumnCategoriesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="autoColumnCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoColumnCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QItemModelSurfaceDataProxy::autoRowCategoriesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="autoRowCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoRowCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategories-prop">QItemModelSurfaceDataProxy::columnCategoriesChanged()</a></p>
     */
    @QtPropertyNotify(name="columnCategories")
    public final @NonNull Signal0 columnCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRole-prop">QItemModelSurfaceDataProxy::columnRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="columnRole")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QItemModelSurfaceDataProxy::columnRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="columnRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> columnRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QItemModelSurfaceDataProxy::columnRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="columnRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#itemModel-prop">QItemModelSurfaceDataProxy::itemModelChanged(const QAbstractItemModel*)</a></p>
     */
    @QtPropertyNotify(name="itemModel")
    public final @NonNull Signal1<io.qt.core.@Nullable QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QItemModelSurfaceDataProxy::multiMatchBehaviorChanged(QItemModelSurfaceDataProxy::MultiMatchBehavior)</a></p>
     */
    @QtPropertyNotify(name="multiMatchBehavior")
    public final @NonNull Signal1<io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior> multiMatchBehaviorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategories-prop">QItemModelSurfaceDataProxy::rowCategoriesChanged()</a></p>
     */
    @QtPropertyNotify(name="rowCategories")
    public final @NonNull Signal0 rowCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRole-prop">QItemModelSurfaceDataProxy::rowRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="rowRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QItemModelSurfaceDataProxy::rowRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="rowRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> rowRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QItemModelSurfaceDataProxy::rowRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="rowRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QItemModelSurfaceDataProxy::useModelCategoriesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="useModelCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> useModelCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRole-prop">QItemModelSurfaceDataProxy::xPosRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="xPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QItemModelSurfaceDataProxy::xPosRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="xPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> xPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QItemModelSurfaceDataProxy::xPosRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="xPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRole-prop">QItemModelSurfaceDataProxy::yPosRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="yPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QItemModelSurfaceDataProxy::yPosRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="yPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> yPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QItemModelSurfaceDataProxy::yPosRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="yPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRole-prop">QItemModelSurfaceDataProxy::zPosRoleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="zPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QItemModelSurfaceDataProxy::zPosRolePatternChanged(QRegularExpression)</a></p>
     */
    @QtPropertyNotify(name="zPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegularExpression> zPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QItemModelSurfaceDataProxy::zPosRoleReplaceChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="zPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-1">QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole) {
        this(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-4">QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-6">QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole) {
        this(itemModel, rowRole, columnRole, yPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-3">QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, yPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, yPosRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-5">QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String yPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, yPosRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String yPosRole) {
        this(itemModel, yPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-2">QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String yPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, yPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String yPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy">QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoColumnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoColumnCategories() {
        return autoColumnCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QItemModelSurfaceDataProxy::autoColumnCategories()const</a></p>
     */
    @QtPropertyReader(name="autoColumnCategories")
    @QtUninvokable
    public final boolean autoColumnCategories(){
        return autoColumnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoColumnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoRowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoRowCategories() {
        return autoRowCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QItemModelSurfaceDataProxy::autoRowCategories()const</a></p>
     */
    @QtPropertyReader(name="autoRowCategories")
    @QtUninvokable
    public final boolean autoRowCategories(){
        return autoRowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoRowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getColumnCategories() {
        return columnCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategories-prop">QItemModelSurfaceDataProxy::columnCategories()const</a></p>
     */
    @QtPropertyReader(name="columnCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList columnCategories(){
        return columnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList columnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategoryIndex">QItemModelSurfaceDataProxy::columnCategoryIndex(QString)</a></p>
     */
    public final int columnCategoryIndex(java.lang.@NonNull String category){
        return columnCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int columnCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRole() {
        return columnRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRole-prop">QItemModelSurfaceDataProxy::columnRole()const</a></p>
     */
    @QtPropertyReader(name="columnRole")
    @QtUninvokable
    public final java.lang.@NonNull String columnRole(){
        return columnRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getColumnRolePattern() {
        return columnRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QItemModelSurfaceDataProxy::columnRolePattern()const</a></p>
     */
    @QtPropertyReader(name="columnRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression columnRolePattern(){
        return columnRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression columnRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRoleReplace() {
        return columnRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QItemModelSurfaceDataProxy::columnRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="columnRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String columnRoleReplace(){
        return columnRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel getItemModel() {
        return itemModel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#itemModel-prop">QItemModelSurfaceDataProxy::itemModel()const</a></p>
     */
    @QtPropertyReader(name="itemModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #multiMatchBehavior()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior getMultiMatchBehavior() {
        return multiMatchBehavior();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QItemModelSurfaceDataProxy::multiMatchBehavior()const</a></p>
     */
    @QtPropertyReader(name="multiMatchBehavior")
    @QtUninvokable
    public final io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior multiMatchBehavior(){
        return io.qt.datavis.QItemModelSurfaceDataProxy.MultiMatchBehavior.resolve(multiMatchBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int multiMatchBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#remap">QItemModelSurfaceDataProxy::remap(QString,QString,QString,QString,QString,QStringList,QStringList)</a></p>
     */
    @QtUninvokable
    public final void remap(java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories);
    }
    
    @QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(long __this__nativeId, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getRowCategories() {
        return rowCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategories-prop">QItemModelSurfaceDataProxy::rowCategories()const</a></p>
     */
    @QtPropertyReader(name="rowCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList rowCategories(){
        return rowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList rowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategoryIndex">QItemModelSurfaceDataProxy::rowCategoryIndex(QString)</a></p>
     */
    public final int rowCategoryIndex(java.lang.@NonNull String category){
        return rowCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int rowCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRole() {
        return rowRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRole-prop">QItemModelSurfaceDataProxy::rowRole()const</a></p>
     */
    @QtPropertyReader(name="rowRole")
    @QtUninvokable
    public final java.lang.@NonNull String rowRole(){
        return rowRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getRowRolePattern() {
        return rowRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QItemModelSurfaceDataProxy::rowRolePattern()const</a></p>
     */
    @QtPropertyReader(name="rowRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression rowRolePattern(){
        return rowRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression rowRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRoleReplace() {
        return rowRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QItemModelSurfaceDataProxy::rowRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="rowRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rowRoleReplace(){
        return rowRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QItemModelSurfaceDataProxy::setAutoColumnCategories(bool)</a></p>
     */
    @QtPropertyWriter(name="autoColumnCategories")
    @QtUninvokable
    public final void setAutoColumnCategories(boolean enable){
        setAutoColumnCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoColumnCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QItemModelSurfaceDataProxy::setAutoRowCategories(bool)</a></p>
     */
    @QtPropertyWriter(name="autoRowCategories")
    @QtUninvokable
    public final void setAutoRowCategories(boolean enable){
        setAutoRowCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoRowCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnCategories-prop">QItemModelSurfaceDataProxy::setColumnCategories(QStringList)</a></p>
     */
    @QtPropertyWriter(name="columnCategories")
    @QtUninvokable
    public final void setColumnCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setColumnCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setColumnCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRole-prop">QItemModelSurfaceDataProxy::setColumnRole(QString)</a></p>
     */
    @QtPropertyWriter(name="columnRole")
    @QtUninvokable
    public final void setColumnRole(java.lang.@NonNull String role){
        setColumnRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setColumnRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QItemModelSurfaceDataProxy::setColumnRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="columnRolePattern")
    @QtUninvokable
    public final void setColumnRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setColumnRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setColumnRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QItemModelSurfaceDataProxy::setColumnRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="columnRoleReplace")
    @QtUninvokable
    public final void setColumnRoleReplace(java.lang.@NonNull String replace){
        setColumnRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setColumnRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#setItemModel">QItemModelSurfaceDataProxy::setItemModel(QAbstractItemModel*)</a></p>
     */
    @QtPropertyWriter(name="itemModel")
    @QtUninvokable
    public final void setItemModel(io.qt.core.@Nullable QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QItemModelSurfaceDataProxy::setMultiMatchBehavior(QItemModelSurfaceDataProxy::MultiMatchBehavior)</a></p>
     */
    @QtPropertyWriter(name="multiMatchBehavior")
    @QtUninvokable
    public final void setMultiMatchBehavior(io.qt.datavis.QItemModelSurfaceDataProxy.@NonNull MultiMatchBehavior behavior){
        setMultiMatchBehavior_native_QItemModelSurfaceDataProxy_MultiMatchBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), behavior.value());
    }
    
    @QtUninvokable
    private native void setMultiMatchBehavior_native_QItemModelSurfaceDataProxy_MultiMatchBehavior(long __this__nativeId, int behavior);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowCategories-prop">QItemModelSurfaceDataProxy::setRowCategories(QStringList)</a></p>
     */
    @QtPropertyWriter(name="rowCategories")
    @QtUninvokable
    public final void setRowCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setRowCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setRowCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRole-prop">QItemModelSurfaceDataProxy::setRowRole(QString)</a></p>
     */
    @QtPropertyWriter(name="rowRole")
    @QtUninvokable
    public final void setRowRole(java.lang.@NonNull String role){
        setRowRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRowRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QItemModelSurfaceDataProxy::setRowRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="rowRolePattern")
    @QtUninvokable
    public final void setRowRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setRowRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRowRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QItemModelSurfaceDataProxy::setRowRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="rowRoleReplace")
    @QtUninvokable
    public final void setRowRoleReplace(java.lang.@NonNull String replace){
        setRowRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRowRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QItemModelSurfaceDataProxy::setUseModelCategories(bool)</a></p>
     */
    @QtPropertyWriter(name="useModelCategories")
    @QtUninvokable
    public final void setUseModelCategories(boolean enable){
        setUseModelCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setUseModelCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRole-prop">QItemModelSurfaceDataProxy::setXPosRole(QString)</a></p>
     */
    @QtPropertyWriter(name="xPosRole")
    @QtUninvokable
    public final void setXPosRole(java.lang.@NonNull String role){
        setXPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setXPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QItemModelSurfaceDataProxy::setXPosRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="xPosRolePattern")
    @QtUninvokable
    public final void setXPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setXPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setXPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QItemModelSurfaceDataProxy::setXPosRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="xPosRoleReplace")
    @QtUninvokable
    public final void setXPosRoleReplace(java.lang.@NonNull String replace){
        setXPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setXPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRole-prop">QItemModelSurfaceDataProxy::setYPosRole(QString)</a></p>
     */
    @QtPropertyWriter(name="yPosRole")
    @QtUninvokable
    public final void setYPosRole(java.lang.@NonNull String role){
        setYPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setYPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QItemModelSurfaceDataProxy::setYPosRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="yPosRolePattern")
    @QtUninvokable
    public final void setYPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setYPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setYPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QItemModelSurfaceDataProxy::setYPosRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="yPosRoleReplace")
    @QtUninvokable
    public final void setYPosRoleReplace(java.lang.@NonNull String replace){
        setYPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setYPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRole-prop">QItemModelSurfaceDataProxy::setZPosRole(QString)</a></p>
     */
    @QtPropertyWriter(name="zPosRole")
    @QtUninvokable
    public final void setZPosRole(java.lang.@NonNull String role){
        setZPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setZPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QItemModelSurfaceDataProxy::setZPosRolePattern(QRegularExpression)</a></p>
     */
    @QtPropertyWriter(name="zPosRolePattern")
    @QtUninvokable
    public final void setZPosRolePattern(io.qt.core.@NonNull QRegularExpression pattern){
        setZPosRolePattern_native_cref_QRegularExpression(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setZPosRolePattern_native_cref_QRegularExpression(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QItemModelSurfaceDataProxy::setZPosRoleReplace(QString)</a></p>
     */
    @QtPropertyWriter(name="zPosRoleReplace")
    @QtUninvokable
    public final void setZPosRoleReplace(java.lang.@NonNull String replace){
        setZPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setZPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #useModelCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUseModelCategories() {
        return useModelCategories();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QItemModelSurfaceDataProxy::useModelCategories()const</a></p>
     */
    @QtPropertyReader(name="useModelCategories")
    @QtUninvokable
    public final boolean useModelCategories(){
        return useModelCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean useModelCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRole() {
        return xPosRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRole-prop">QItemModelSurfaceDataProxy::xPosRole()const</a></p>
     */
    @QtPropertyReader(name="xPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRole(){
        return xPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getXPosRolePattern() {
        return xPosRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QItemModelSurfaceDataProxy::xPosRolePattern()const</a></p>
     */
    @QtPropertyReader(name="xPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression xPosRolePattern(){
        return xPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression xPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRoleReplace() {
        return xPosRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QItemModelSurfaceDataProxy::xPosRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="xPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRoleReplace(){
        return xPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRole() {
        return yPosRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRole-prop">QItemModelSurfaceDataProxy::yPosRole()const</a></p>
     */
    @QtPropertyReader(name="yPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRole(){
        return yPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getYPosRolePattern() {
        return yPosRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QItemModelSurfaceDataProxy::yPosRolePattern()const</a></p>
     */
    @QtPropertyReader(name="yPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression yPosRolePattern(){
        return yPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression yPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRoleReplace() {
        return yPosRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QItemModelSurfaceDataProxy::yPosRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="yPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRoleReplace(){
        return yPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRole() {
        return zPosRole();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRole-prop">QItemModelSurfaceDataProxy::zPosRole()const</a></p>
     */
    @QtPropertyReader(name="zPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRole(){
        return zPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression getZPosRolePattern() {
        return zPosRolePattern();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QItemModelSurfaceDataProxy::zPosRolePattern()const</a></p>
     */
    @QtPropertyReader(name="zPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegularExpression zPosRolePattern(){
        return zPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegularExpression zPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRoleReplace() {
        return zPosRoleReplace();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QItemModelSurfaceDataProxy::zPosRoleReplace()const</a></p>
     */
    @QtPropertyReader(name="zPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRoleReplace(){
        return zPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QItemModelSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QItemModelSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QItemModelSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
}
