package io.qt.datavis;

import io.qt.*;


/**
 * <p>Adds a custom label to a graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qcustom3dlabel.html">QCustom3DLabel</a></p>
 */
public class QCustom3DLabel extends io.qt.datavis.QCustom3DItem
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCustom3DLabel.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#backgroundColor-prop">QCustom3DLabel::backgroundColorChanged(QColor)</a></p>
     */
    @QtPropertyNotify(name="backgroundColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> backgroundColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#backgroundEnabled-prop">QCustom3DLabel::backgroundEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="backgroundEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> backgroundEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#borderEnabled-prop">QCustom3DLabel::borderEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="borderEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> borderEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#facingCamera-prop">QCustom3DLabel::facingCameraChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="facingCamera")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> facingCameraChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#font-prop">QCustom3DLabel::fontChanged(QFont)</a></p>
     */
    @QtPropertyNotify(name="font")
    public final @NonNull Signal1<io.qt.gui.@NonNull QFont> fontChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#text-prop">QCustom3DLabel::textChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="text")
    public final @NonNull Signal1<java.lang.@NonNull String> textChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#textColor-prop">QCustom3DLabel::textColorChanged(QColor)</a></p>
     */
    @QtPropertyNotify(name="textColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> textColorChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DLabel(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DLabel() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#QCustom3DLabel">QCustom3DLabel::QCustom3DLabel(QObject*)</a></p>
     */
    public QCustom3DLabel(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCustom3DLabel instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DLabel(java.lang.String, io.qt.gui.QFont, io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DLabel(java.lang.@NonNull String text, io.qt.gui.@NonNull QFont font, io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation) {
        this(text, font, position, scaling, rotation, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#QCustom3DLabel-1">QCustom3DLabel::QCustom3DLabel(QString,QFont,QVector3D,QVector3D,QQuaternion,QObject*)</a></p>
     */
    public QCustom3DLabel(java.lang.@NonNull String text, io.qt.gui.@NonNull QFont font, io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, text, font, position, scaling, rotation, parent);
    }
    
    private native static void initialize_native(QCustom3DLabel instance, java.lang.String text, io.qt.gui.QFont font, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #backgroundColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getBackgroundColor() {
        return backgroundColor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#backgroundColor-prop">QCustom3DLabel::backgroundColor()const</a></p>
     */
    @QtPropertyReader(name="backgroundColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor backgroundColor(){
        return backgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor backgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #font()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QFont getFont() {
        return font();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#font-prop">QCustom3DLabel::font()const</a></p>
     */
    @QtPropertyReader(name="font")
    @QtUninvokable
    public final io.qt.gui.@NonNull QFont font(){
        return font_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QFont font_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isBackgroundEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getBackgroundEnabled() {
        return isBackgroundEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#backgroundEnabled-prop">QCustom3DLabel::isBackgroundEnabled()const</a></p>
     */
    @QtPropertyReader(name="backgroundEnabled")
    @QtUninvokable
    public final boolean isBackgroundEnabled(){
        return isBackgroundEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBackgroundEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isBorderEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getBorderEnabled() {
        return isBorderEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#borderEnabled-prop">QCustom3DLabel::isBorderEnabled()const</a></p>
     */
    @QtPropertyReader(name="borderEnabled")
    @QtUninvokable
    public final boolean isBorderEnabled(){
        return isBorderEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBorderEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isFacingCamera()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getFacingCamera() {
        return isFacingCamera();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#facingCamera-prop">QCustom3DLabel::isFacingCamera()const</a></p>
     */
    @QtPropertyReader(name="facingCamera")
    @QtUninvokable
    public final boolean isFacingCamera(){
        return isFacingCamera_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFacingCamera_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#backgroundColor-prop">QCustom3DLabel::setBackgroundColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="backgroundColor")
    @QtUninvokable
    public final void setBackgroundColor(io.qt.gui.@NonNull QColor color){
        setBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#backgroundEnabled-prop">QCustom3DLabel::setBackgroundEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="backgroundEnabled")
    @QtUninvokable
    public final void setBackgroundEnabled(boolean enabled){
        setBackgroundEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setBackgroundEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#borderEnabled-prop">QCustom3DLabel::setBorderEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="borderEnabled")
    @QtUninvokable
    public final void setBorderEnabled(boolean enabled){
        setBorderEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setBorderEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#facingCamera-prop">QCustom3DLabel::setFacingCamera(bool)</a></p>
     */
    @QtPropertyWriter(name="facingCamera")
    @QtUninvokable
    public final void setFacingCamera(boolean enabled){
        setFacingCamera_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setFacingCamera_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#font-prop">QCustom3DLabel::setFont(QFont)</a></p>
     */
    @QtPropertyWriter(name="font")
    @QtUninvokable
    public final void setFont(io.qt.gui.@NonNull QFont font){
        setFont_native_cref_QFont(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(font));
    }
    
    @QtUninvokable
    private native void setFont_native_cref_QFont(long __this__nativeId, long font);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#text-prop">QCustom3DLabel::setText(QString)</a></p>
     */
    @QtPropertyWriter(name="text")
    @QtUninvokable
    public final void setText(java.lang.@NonNull String text){
        setText_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @QtUninvokable
    private native void setText_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#textColor-prop">QCustom3DLabel::setTextColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="textColor")
    @QtUninvokable
    public final void setTextColor(io.qt.gui.@NonNull QColor color){
        setTextColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setTextColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #text()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getText() {
        return text();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#text-prop">QCustom3DLabel::text()const</a></p>
     */
    @QtPropertyReader(name="text")
    @QtUninvokable
    public final java.lang.@NonNull String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getTextColor() {
        return textColor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dlabel.html#textColor-prop">QCustom3DLabel::textColor()const</a></p>
     */
    @QtPropertyReader(name="textColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor textColor(){
        return textColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor textColor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QCustom3DLabel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCustom3DLabel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCustom3DLabel instance, QDeclarativeConstructor constructor);
    
}
