package io.qt.datavis;

import io.qt.*;


/**
 * <p>Represents a data series in a 3D bar graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qbar3dseries.html">QBar3DSeries</a></p>
 */
public class QBar3DSeries extends io.qt.datavis.QAbstract3DSeries
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBar3DSeries.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#dataProxy-prop">QBar3DSeries::dataProxyChanged(QBarDataProxy*)</a></p>
     */
    @QtPropertyNotify(name="dataProxy")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QBarDataProxy> dataProxyChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#meshAngle-prop">QBar3DSeries::meshAngleChanged(float)</a></p>
     */
    @QtPropertyNotify(name="meshAngle")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> meshAngleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#rowColors-prop">QBar3DSeries::rowColorsChanged(QList&lt;QColor&gt;)</a></p>
     */
    @QtPropertyNotify(name="rowColors")
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.gui.@NonNull QColor>> rowColorsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#selectedBar-prop">QBar3DSeries::selectedBarChanged(QPoint)</a></p>
     */
    @QtPropertyNotify(name="selectedBar")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> selectedBarChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBar3DSeries(io.qt.datavis.QBarDataProxy, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBar3DSeries(io.qt.datavis.@Nullable QBarDataProxy dataProxy) {
        this(dataProxy, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#QBar3DSeries-1">QBar3DSeries::QBar3DSeries(QBarDataProxy*,QObject*)</a></p>
     */
    public QBar3DSeries(io.qt.datavis.@Nullable QBarDataProxy dataProxy, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, dataProxy, parent);
    }
    
    private native static void initialize_native(QBar3DSeries instance, io.qt.datavis.QBarDataProxy dataProxy, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QBar3DSeries(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBar3DSeries() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#QBar3DSeries">QBar3DSeries::QBar3DSeries(QObject*)</a></p>
     */
    public QBar3DSeries(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBar3DSeries instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #dataProxy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataProxy getDataProxy() {
        return dataProxy();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#dataProxy-prop">QBar3DSeries::dataProxy()const</a></p>
     */
    @QtPropertyReader(name="dataProxy")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataProxy dataProxy(){
        return dataProxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBarDataProxy dataProxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #meshAngle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMeshAngle() {
        return meshAngle();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#meshAngle-prop">QBar3DSeries::meshAngle()const</a></p>
     */
    @QtPropertyReader(name="meshAngle")
    @QtUninvokable
    public final float meshAngle(){
        return meshAngle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float meshAngle_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowColors()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.@NonNull QColor> getRowColors() {
        return rowColors();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#rowColors-prop">QBar3DSeries::rowColors()const</a></p>
     */
    @QtPropertyReader(name="rowColors")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.@NonNull QColor> rowColors(){
        return rowColors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QColor> rowColors_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedBar()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getSelectedBar() {
        return selectedBar();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#selectedBar-prop">QBar3DSeries::selectedBar()const</a></p>
     */
    @QtPropertyReader(name="selectedBar")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint selectedBar(){
        return selectedBar_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint selectedBar_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#dataProxy-prop">QBar3DSeries::setDataProxy(QBarDataProxy*)</a></p>
     */
    @QtPropertyWriter(name="dataProxy")
    @QtUninvokable
    public final void setDataProxy(io.qt.datavis.@StrictNonNull QBarDataProxy proxy){
        if(proxy!=null){
            if(proxy==dataProxy()){
                throw new IllegalArgumentException("Proxy is already assigned to this series.");
            }else if(proxy.series()!=null){
                throw new IllegalArgumentException("Proxy is already assigned to another series.");
            }
        }
        java.util.Objects.requireNonNull(proxy, "Argument 'proxy': null not expected.");
        setDataProxy_native_QBarDataProxy_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(proxy));
    }
    
    @QtUninvokable
    private native void setDataProxy_native_QBarDataProxy_ptr(long __this__nativeId, long proxy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#meshAngle-prop">QBar3DSeries::setMeshAngle(float)</a></p>
     */
    @QtPropertyWriter(name="meshAngle")
    @QtUninvokable
    public final void setMeshAngle(float angle){
        setMeshAngle_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    @QtUninvokable
    private native void setMeshAngle_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#rowColors-prop">QBar3DSeries::setRowColors(QList&lt;QColor&gt;)</a></p>
     */
    @QtPropertyWriter(name="rowColors")
    @QtUninvokable
    public final void setRowColors(java.util.@NonNull Collection<? extends io.qt.gui.@NonNull QColor> colors){
        setRowColors_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), colors);
    }
    
    @QtUninvokable
    private native void setRowColors_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.gui.QColor> colors);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#setSelectedBar">QBar3DSeries::setSelectedBar(QPoint)</a></p>
     */
    @QtPropertyWriter(name="selectedBar")
    @QtUninvokable
    public final void setSelectedBar(io.qt.core.@NonNull QPoint position){
        setSelectedBar_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setSelectedBar_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbar3dseries.html#invalidSelectionPosition">QBar3DSeries::invalidSelectionPosition()</a></p>
     */
    public native static io.qt.core.@NonNull QPoint invalidSelectionPosition();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QBar3DSeries(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QBar3DSeries(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QBar3DSeries instance, QDeclarativeConstructor constructor);
    
}
