package io.qt.datavis;

import io.qt.*;


/**
 * <p>Representation of a camera in 3D space</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/q3dcamera.html">Q3DCamera</a></p>
 */
public class Q3DCamera extends io.qt.datavis.Q3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DCamera.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPreset</a></p>
     */
    @QtUnlistedEnum
    public enum CameraPreset implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetNone</a></p>
         */
        CameraPresetNone(-1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetFrontLow</a></p>
         */
        CameraPresetFrontLow(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetFront</a></p>
         */
        CameraPresetFront(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetFrontHigh</a></p>
         */
        CameraPresetFrontHigh(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetLeftLow</a></p>
         */
        CameraPresetLeftLow(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetLeft</a></p>
         */
        CameraPresetLeft(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetLeftHigh</a></p>
         */
        CameraPresetLeftHigh(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetRightLow</a></p>
         */
        CameraPresetRightLow(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetRight</a></p>
         */
        CameraPresetRight(7),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetRightHigh</a></p>
         */
        CameraPresetRightHigh(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetBehindLow</a></p>
         */
        CameraPresetBehindLow(9),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetBehind</a></p>
         */
        CameraPresetBehind(10),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetBehindHigh</a></p>
         */
        CameraPresetBehindHigh(11),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetIsometricLeft</a></p>
         */
        CameraPresetIsometricLeft(12),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetIsometricLeftHigh</a></p>
         */
        CameraPresetIsometricLeftHigh(13),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetIsometricRight</a></p>
         */
        CameraPresetIsometricRight(14),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetIsometricRightHigh</a></p>
         */
        CameraPresetIsometricRightHigh(15),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetDirectlyAbove</a></p>
         */
        CameraPresetDirectlyAbove(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetDirectlyAboveCW45</a></p>
         */
        CameraPresetDirectlyAboveCW45(17),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetDirectlyAboveCCW45</a></p>
         */
        CameraPresetDirectlyAboveCCW45(18),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetFrontBelow</a></p>
         */
        CameraPresetFrontBelow(19),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetLeftBelow</a></p>
         */
        CameraPresetLeftBelow(20),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetRightBelow</a></p>
         */
        CameraPresetRightBelow(21),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetBehindBelow</a></p>
         */
        CameraPresetBehindBelow(22),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPresetDirectlyBelow</a></p>
         */
        CameraPresetDirectlyBelow(23);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CameraPreset(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CameraPreset resolve(int value) {
            switch (value) {
            case -1: return CameraPresetNone;
            case 0: return CameraPresetFrontLow;
            case 1: return CameraPresetFront;
            case 2: return CameraPresetFrontHigh;
            case 3: return CameraPresetLeftLow;
            case 4: return CameraPresetLeft;
            case 5: return CameraPresetLeftHigh;
            case 6: return CameraPresetRightLow;
            case 7: return CameraPresetRight;
            case 8: return CameraPresetRightHigh;
            case 9: return CameraPresetBehindLow;
            case 10: return CameraPresetBehind;
            case 11: return CameraPresetBehindHigh;
            case 12: return CameraPresetIsometricLeft;
            case 13: return CameraPresetIsometricLeftHigh;
            case 14: return CameraPresetIsometricRight;
            case 15: return CameraPresetIsometricRightHigh;
            case 16: return CameraPresetDirectlyAbove;
            case 17: return CameraPresetDirectlyAboveCW45;
            case 18: return CameraPresetDirectlyAboveCCW45;
            case 19: return CameraPresetFrontBelow;
            case 20: return CameraPresetLeftBelow;
            case 21: return CameraPresetRightBelow;
            case 22: return CameraPresetBehindBelow;
            case 23: return CameraPresetDirectlyBelow;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#cameraPreset-prop">Q3DCamera::cameraPresetChanged(Q3DCamera::CameraPreset)</a></p>
     */
    @QtPropertyNotify(name="cameraPreset")
    public final @NonNull Signal1<io.qt.datavis.Q3DCamera.@NonNull CameraPreset> cameraPresetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#maxZoomLevel-prop">Q3DCamera::maxZoomLevelChanged(float)</a></p>
     */
    @QtPropertyNotify(name="maxZoomLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxZoomLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#minZoomLevel-prop">Q3DCamera::minZoomLevelChanged(float)</a></p>
     */
    @QtPropertyNotify(name="minZoomLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minZoomLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#target-prop">Q3DCamera::targetChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="target")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> targetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapXRotation-prop">Q3DCamera::wrapXRotationChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="wrapXRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> wrapXRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapYRotation-prop">Q3DCamera::wrapYRotationChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="wrapYRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> wrapYRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#xRotation-prop">Q3DCamera::xRotationChanged(float)</a></p>
     */
    @QtPropertyNotify(name="xRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> xRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#yRotation-prop">Q3DCamera::yRotationChanged(float)</a></p>
     */
    @QtPropertyNotify(name="yRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> yRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#zoomLevel-prop">Q3DCamera::zoomLevelChanged(float)</a></p>
     */
    @QtPropertyNotify(name="zoomLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> zoomLevelChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DCamera(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DCamera() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#Q3DCamera">Q3DCamera::Q3DCamera(QObject*)</a></p>
     */
    public Q3DCamera(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DCamera instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #cameraPreset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.Q3DCamera.@NonNull CameraPreset getCameraPreset() {
        return cameraPreset();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#cameraPreset-prop">Q3DCamera::cameraPreset()const</a></p>
     */
    @QtPropertyReader(name="cameraPreset")
    @QtUninvokable
    public final io.qt.datavis.Q3DCamera.@NonNull CameraPreset cameraPreset(){
        return io.qt.datavis.Q3DCamera.CameraPreset.resolve(cameraPreset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int cameraPreset_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxZoomLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxZoomLevel() {
        return maxZoomLevel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#maxZoomLevel-prop">Q3DCamera::maxZoomLevel()const</a></p>
     */
    @QtPropertyReader(name="maxZoomLevel")
    @QtUninvokable
    public final float maxZoomLevel(){
        return maxZoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxZoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minZoomLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinZoomLevel() {
        return minZoomLevel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#minZoomLevel-prop">Q3DCamera::minZoomLevel()const</a></p>
     */
    @QtPropertyReader(name="minZoomLevel")
    @QtUninvokable
    public final float minZoomLevel(){
        return minZoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minZoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setCameraPosition(float, float, float)}
     *  with <code>zoom = 100.0f</code>.</p>
     */
    @QtUninvokable
    public final void setCameraPosition(float horizontal, float vertical) {
        setCameraPosition(horizontal, vertical, (float)100.0f);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#setCameraPosition">Q3DCamera::setCameraPosition(float,float,float)</a></p>
     */
    @QtUninvokable
    public final void setCameraPosition(float horizontal, float vertical, float zoom){
        setCameraPosition_native_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), horizontal, vertical, zoom);
    }
    
    @QtUninvokable
    private native void setCameraPosition_native_float_float_float(long __this__nativeId, float horizontal, float vertical, float zoom);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#cameraPreset-prop">Q3DCamera::setCameraPreset(Q3DCamera::CameraPreset)</a></p>
     */
    @QtPropertyWriter(name="cameraPreset")
    @QtUninvokable
    public final void setCameraPreset(io.qt.datavis.Q3DCamera.@NonNull CameraPreset preset){
        setCameraPreset_native_Q3DCamera_CameraPreset(QtJambi_LibraryUtilities.internal.nativeId(this), preset.value());
    }
    
    @QtUninvokable
    private native void setCameraPreset_native_Q3DCamera_CameraPreset(long __this__nativeId, int preset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#maxZoomLevel-prop">Q3DCamera::setMaxZoomLevel(float)</a></p>
     */
    @QtPropertyWriter(name="maxZoomLevel")
    @QtUninvokable
    public final void setMaxZoomLevel(float zoomLevel){
        setMaxZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @QtUninvokable
    private native void setMaxZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#minZoomLevel-prop">Q3DCamera::setMinZoomLevel(float)</a></p>
     */
    @QtPropertyWriter(name="minZoomLevel")
    @QtUninvokable
    public final void setMinZoomLevel(float zoomLevel){
        setMinZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @QtUninvokable
    private native void setMinZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#target-prop">Q3DCamera::setTarget(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="target")
    @QtUninvokable
    public final void setTarget(io.qt.gui.@NonNull QVector3D target){
        setTarget_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
    }
    
    @QtUninvokable
    private native void setTarget_native_cref_QVector3D(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapXRotation-prop">Q3DCamera::setWrapXRotation(bool)</a></p>
     */
    @QtPropertyWriter(name="wrapXRotation")
    @QtUninvokable
    public final void setWrapXRotation(boolean isEnabled){
        setWrapXRotation_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    @QtUninvokable
    private native void setWrapXRotation_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapYRotation-prop">Q3DCamera::setWrapYRotation(bool)</a></p>
     */
    @QtPropertyWriter(name="wrapYRotation")
    @QtUninvokable
    public final void setWrapYRotation(boolean isEnabled){
        setWrapYRotation_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    @QtUninvokable
    private native void setWrapYRotation_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#xRotation-prop">Q3DCamera::setXRotation(float)</a></p>
     */
    @QtPropertyWriter(name="xRotation")
    @QtUninvokable
    public final void setXRotation(float rotation){
        setXRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotation);
    }
    
    @QtUninvokable
    private native void setXRotation_native_float(long __this__nativeId, float rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#yRotation-prop">Q3DCamera::setYRotation(float)</a></p>
     */
    @QtPropertyWriter(name="yRotation")
    @QtUninvokable
    public final void setYRotation(float rotation){
        setYRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotation);
    }
    
    @QtUninvokable
    private native void setYRotation_native_float(long __this__nativeId, float rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#zoomLevel-prop">Q3DCamera::setZoomLevel(float)</a></p>
     */
    @QtPropertyWriter(name="zoomLevel")
    @QtUninvokable
    public final void setZoomLevel(float zoomLevel){
        setZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @QtUninvokable
    private native void setZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #target()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getTarget() {
        return target();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#target-prop">Q3DCamera::target()const</a></p>
     */
    @QtPropertyReader(name="target")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D target(){
        return target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D target_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #wrapXRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getWrapXRotation() {
        return wrapXRotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapXRotation-prop">Q3DCamera::wrapXRotation()const</a></p>
     */
    @QtPropertyReader(name="wrapXRotation")
    @QtUninvokable
    public final boolean wrapXRotation(){
        return wrapXRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean wrapXRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #wrapYRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getWrapYRotation() {
        return wrapYRotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapYRotation-prop">Q3DCamera::wrapYRotation()const</a></p>
     */
    @QtPropertyReader(name="wrapYRotation")
    @QtUninvokable
    public final boolean wrapYRotation(){
        return wrapYRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean wrapYRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getXRotation() {
        return xRotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#xRotation-prop">Q3DCamera::xRotation()const</a></p>
     */
    @QtPropertyReader(name="xRotation")
    @QtUninvokable
    public final float xRotation(){
        return xRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float xRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getYRotation() {
        return yRotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#yRotation-prop">Q3DCamera::yRotation()const</a></p>
     */
    @QtPropertyReader(name="yRotation")
    @QtUninvokable
    public final float yRotation(){
        return yRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float yRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zoomLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getZoomLevel() {
        return zoomLevel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#zoomLevel-prop">Q3DCamera::zoomLevel()const</a></p>
     */
    @QtPropertyReader(name="zoomLevel")
    @QtUninvokable
    public final float zoomLevel(){
        return zoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float zoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dobject.html#copyValuesFrom">Q3DObject::copyValuesFrom(Q3DObject)</a></p>
     */
    @QtUninvokable
    public void copyValuesFrom(io.qt.datavis.@StrictNonNull Q3DObject source){
        java.util.Objects.requireNonNull(source, "Argument 'source': null not expected.");
        copyValuesFrom_native_cref_Q3DObject(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_cref_Q3DObject(long __this__nativeId, long source);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected Q3DCamera(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DCamera(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DCamera instance, QDeclarativeConstructor constructor);
    
}
