package io.qt.datavis;

import io.qt.*;


/**
 * <p>Container for resolved data to be added to scatter graphs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qscatterdataitem.html">QScatterDataItem</a></p>
 */
public class QScatterDataItem extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#QScatterDataItem">QScatterDataItem::QScatterDataItem()</a></p>
     */
    public QScatterDataItem(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScatterDataItem instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#QScatterDataItem-3">QScatterDataItem::QScatterDataItem(QScatterDataItem)</a></p>
     */
    public QScatterDataItem(io.qt.datavis.@NonNull QScatterDataItem other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScatterDataItem instance, io.qt.datavis.QScatterDataItem other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#QScatterDataItem-1">QScatterDataItem::QScatterDataItem(QVector3D)</a></p>
     */
    public QScatterDataItem(io.qt.gui.@NonNull QVector3D position){
        super((QPrivateConstructor)null);
        initialize_native(this, position);
    }
    
    private native static void initialize_native(QScatterDataItem instance, io.qt.gui.QVector3D position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#QScatterDataItem-2">QScatterDataItem::QScatterDataItem(QVector3D,QQuaternion)</a></p>
     */
    public QScatterDataItem(io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QQuaternion rotation){
        super((QPrivateConstructor)null);
        initialize_native(this, position, rotation);
    }
    
    private native static void initialize_native(QScatterDataItem instance, io.qt.gui.QVector3D position, io.qt.gui.QQuaternion rotation);
    
    @QtUninvokable
    protected final void createExtraData(){
        createExtraData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void createExtraData_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#operator-eq">QScatterDataItem::operator=(QScatterDataItem)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.datavis.@NonNull QScatterDataItem other){
        assign_native_cref_QScatterDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QScatterDataItem(long __this__nativeId, long other);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.datavis.@NonNull QScatterDataItem b){
        return operator_equal_native_cref_QScatterDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QScatterDataItem(long __this__nativeId, long b);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#position">QScatterDataItem::position()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#rotation">QScatterDataItem::rotation()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#setPosition">QScatterDataItem::setPosition(QVector3D)</a></p>
     */
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#setRotation">QScatterDataItem::setRotation(QQuaternion)</a></p>
     */
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion rot){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rot));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rot);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#setX">QScatterDataItem::setX(float)</a></p>
     */
    @QtUninvokable
    public final void setX(float value){
        setX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setX_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#setY">QScatterDataItem::setY(float)</a></p>
     */
    @QtUninvokable
    public final void setY(float value){
        setY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setY_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#setZ">QScatterDataItem::setZ(float)</a></p>
     */
    @QtUninvokable
    public final void setZ(float value){
        setZ_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setZ_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#x">QScatterDataItem::x()const</a></p>
     */
    @QtUninvokable
    public final float x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#y">QScatterDataItem::y()const</a></p>
     */
    @QtUninvokable
    public final float y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qscatterdataitem.html#z">QScatterDataItem::z()const</a></p>
     */
    @QtUninvokable
    public final float z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float z_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScatterDataItem(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.datavis.QScatterDataItem) {
            return operator_equal((io.qt.datavis.QScatterDataItem) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QScatterDataItem clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScatterDataItem clone_native(long __this_nativeId);
}
