package io.qt.datavis;

import io.qt.*;


/**
 * <p>Formatting rules for a logarithmic value axis</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html">QLogValue3DAxisFormatter</a></p>
 */
public class QLogValue3DAxisFormatter extends io.qt.datavis.QValue3DAxisFormatter
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLogValue3DAxisFormatter.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#autoSubGrid-prop">QLogValue3DAxisFormatter::autoSubGridChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="autoSubGrid")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoSubGridChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#base-prop">QLogValue3DAxisFormatter::baseChanged(qreal)</a></p>
     */
    @QtPropertyNotify(name="base")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> baseChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#showEdgeLabels-prop">QLogValue3DAxisFormatter::showEdgeLabelsChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="showEdgeLabels")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> showEdgeLabelsChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QLogValue3DAxisFormatter() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#QLogValue3DAxisFormatter-1">QLogValue3DAxisFormatter::QLogValue3DAxisFormatter(QObject*)</a></p>
     */
    public QLogValue3DAxisFormatter(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLogValue3DAxisFormatter instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoSubGrid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoSubGrid() {
        return autoSubGrid();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#autoSubGrid-prop">QLogValue3DAxisFormatter::autoSubGrid()const</a></p>
     */
    @QtPropertyReader(name="autoSubGrid")
    @QtUninvokable
    public final boolean autoSubGrid(){
        return autoSubGrid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoSubGrid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #base()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getBase() {
        return base();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#base-prop">QLogValue3DAxisFormatter::base()const</a></p>
     */
    @QtPropertyReader(name="base")
    @QtUninvokable
    public final double base(){
        return base_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double base_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#autoSubGrid-prop">QLogValue3DAxisFormatter::setAutoSubGrid(bool)</a></p>
     */
    @QtPropertyWriter(name="autoSubGrid")
    @QtUninvokable
    public final void setAutoSubGrid(boolean enabled){
        setAutoSubGrid_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setAutoSubGrid_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#base-prop">QLogValue3DAxisFormatter::setBase(qreal)</a></p>
     */
    @QtPropertyWriter(name="base")
    @QtUninvokable
    public final void setBase(double base){
        setBase_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), base);
    }
    
    @QtUninvokable
    private native void setBase_native_qreal(long __this__nativeId, double base);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#showEdgeLabels-prop">QLogValue3DAxisFormatter::setShowEdgeLabels(bool)</a></p>
     */
    @QtPropertyWriter(name="showEdgeLabels")
    @QtUninvokable
    public final void setShowEdgeLabels(boolean enabled){
        setShowEdgeLabels_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setShowEdgeLabels_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #showEdgeLabels()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getShowEdgeLabels() {
        return showEdgeLabels();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlogvalue3daxisformatter.html#showEdgeLabels-prop">QLogValue3DAxisFormatter::showEdgeLabels()const</a></p>
     */
    @QtPropertyReader(name="showEdgeLabels")
    @QtUninvokable
    public final boolean showEdgeLabels(){
        return showEdgeLabels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean showEdgeLabels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#createNewInstance">QValue3DAxisFormatter::createNewInstance()const</a></p>
     */
    @QtUninvokable
    protected io.qt.datavis.@Nullable QValue3DAxisFormatter createNewInstance(){
        return createNewInstance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxisFormatter createNewInstance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#populateCopy">QValue3DAxisFormatter::populateCopy(QValue3DAxisFormatter&amp;)const</a></p>
     */
    @QtUninvokable
    protected void populateCopy(io.qt.datavis.@StrictNonNull QValue3DAxisFormatter copy){
        java.util.Objects.requireNonNull(copy, "Argument 'copy': null not expected.");
        populateCopy_native_ref_QValue3DAxisFormatter_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(copy));
    }
    
    @QtUninvokable
    private native void populateCopy_native_ref_QValue3DAxisFormatter_constfct(long __this__nativeId, long copy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#positionAt">QValue3DAxisFormatter::positionAt(float)const</a></p>
     */
    @QtUninvokable
    protected float positionAt(float value){
        return positionAt_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native float positionAt_native_float_constfct(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#recalculate">QValue3DAxisFormatter::recalculate()</a></p>
     */
    @QtUninvokable
    protected void recalculate(){
        recalculate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void recalculate_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvalue3daxisformatter.html#valueAt">QValue3DAxisFormatter::valueAt(float)const</a></p>
     */
    @QtUninvokable
    protected float valueAt(float position){
        return valueAt_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), position);
    }
    
    @QtUninvokable
    private native float valueAt_native_float_constfct(long __this__nativeId, float position);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QLogValue3DAxisFormatter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QLogValue3DAxisFormatter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QLogValue3DAxisFormatter instance, QDeclarativeConstructor constructor);
    
}
