package io.qt.datavis;

import io.qt.*;


/**
 * <p>Adds a volume rendered object to a graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qcustom3dvolume.html">QCustom3DVolume</a></p>
 */
public class QCustom3DVolume extends io.qt.datavis.QCustom3DItem
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCustom3DVolume.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#alphaMultiplier-prop">QCustom3DVolume::alphaMultiplierChanged(float)</a></p>
     */
    @QtPropertyNotify(name="alphaMultiplier")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> alphaMultiplierChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#colorTable-prop">QCustom3DVolume::colorTableChanged()</a></p>
     */
    @QtPropertyNotify(name="colorTable")
    public final @NonNull Signal0 colorTableChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#drawSliceFrames-prop">QCustom3DVolume::drawSliceFramesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="drawSliceFrames")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> drawSliceFramesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#drawSlices-prop">QCustom3DVolume::drawSlicesChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="drawSlices")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> drawSlicesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#preserveOpacity-prop">QCustom3DVolume::preserveOpacityChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="preserveOpacity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> preserveOpacityChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameColor-prop">QCustom3DVolume::sliceFrameColorChanged(QColor)</a></p>
     */
    @QtPropertyNotify(name="sliceFrameColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> sliceFrameColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameGaps-prop">QCustom3DVolume::sliceFrameGapsChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="sliceFrameGaps")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> sliceFrameGapsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameThicknesses-prop">QCustom3DVolume::sliceFrameThicknessesChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="sliceFrameThicknesses")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> sliceFrameThicknessesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameWidths-prop">QCustom3DVolume::sliceFrameWidthsChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="sliceFrameWidths")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> sliceFrameWidthsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexX-prop">QCustom3DVolume::sliceIndexXChanged(int)</a></p>
     */
    @QtPropertyNotify(name="sliceIndexX")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> sliceIndexXChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexY-prop">QCustom3DVolume::sliceIndexYChanged(int)</a></p>
     */
    @QtPropertyNotify(name="sliceIndexY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> sliceIndexYChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexZ-prop">QCustom3DVolume::sliceIndexZChanged(int)</a></p>
     */
    @QtPropertyNotify(name="sliceIndexZ")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> sliceIndexZChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureData-prop">QCustom3DVolume::textureDataChanged(QList&lt;uchar&gt;*)</a></p>
     */
    @QtPropertyNotify(name="textureData")
    public final @NonNull Signal1<java.util.@Nullable List<java.lang.@QtPrimitiveType@NonNull Byte>> textureDataChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureDepth-prop">QCustom3DVolume::textureDepthChanged(int)</a></p>
     */
    @QtPropertyNotify(name="textureDepth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> textureDepthChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureFormatChanged">QCustom3DVolume::textureFormatChanged(QImage::Format)</a></p>
     */
    public final @NonNull Signal1<io.qt.gui.QImage.@NonNull Format> textureFormatChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureHeight-prop">QCustom3DVolume::textureHeightChanged(int)</a></p>
     */
    @QtPropertyNotify(name="textureHeight")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> textureHeightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureWidth-prop">QCustom3DVolume::textureWidthChanged(int)</a></p>
     */
    @QtPropertyNotify(name="textureWidth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> textureWidthChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#useHighDefShader-prop">QCustom3DVolume::useHighDefShaderChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="useHighDefShader")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> useHighDefShaderChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DVolume() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#QCustom3DVolume">QCustom3DVolume::QCustom3DVolume(QObject*)</a></p>
     */
    public QCustom3DVolume(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCustom3DVolume instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, int, int, int, java.util.Collection, io.qt.gui.QImage.Format, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DVolume(io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.@Nullable Collection<java.lang.@QtPrimitiveType@NonNull Byte> textureData, io.qt.gui.QImage.@NonNull Format textureFormat, java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> colorTable) {
        this(position, scaling, rotation, textureWidth, textureHeight, textureDepth, textureData, textureFormat, colorTable, (io.qt.core.QObject)null);
    }
    
    public QCustom3DVolume(io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.@Nullable Collection<java.lang.@QtPrimitiveType@NonNull Byte> textureData, io.qt.gui.QImage.@NonNull Format textureFormat, java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> colorTable, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, position, scaling, rotation, textureWidth, textureHeight, textureDepth, textureData, textureFormat, colorTable, parent);
    }
    
    private native static void initialize_native(QCustom3DVolume instance, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.Collection<java.lang.@QtPrimitiveType Byte> textureData, io.qt.gui.QImage.Format textureFormat, java.util.Collection<java.lang.@QtPrimitiveType Integer> colorTable, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #alphaMultiplier()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getAlphaMultiplier() {
        return alphaMultiplier();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#alphaMultiplier-prop">QCustom3DVolume::alphaMultiplier()const</a></p>
     */
    @QtPropertyReader(name="alphaMultiplier")
    @QtUninvokable
    public final float alphaMultiplier(){
        return alphaMultiplier_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float alphaMultiplier_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #colorTable()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> getColorTable() {
        return colorTable();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#colorTable-prop">QCustom3DVolume::colorTable()const</a></p>
     */
    @QtPropertyReader(name="colorTable")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> colorTable(){
        return colorTable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> colorTable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#createTextureData">QCustom3DVolume::createTextureData(QList&lt;QImage*&gt;)</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QList<java.lang.@QtPrimitiveType@NonNull Byte> createTextureData(java.util.@NonNull Collection<? extends io.qt.gui.@Nullable QImage> images){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcTextureData);
        io.qt.core.@Nullable QList<java.lang.@QtPrimitiveType@NonNull Byte> __qt_return_value = createTextureData_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), images);
        __rcTextureData = __qt_return_value;
        QtJambi_LibraryUtilities.internal.registerDependentObject(__rcTextureData, this);
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Byte> createTextureData_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.gui.QImage> images);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #drawSliceFrames()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getDrawSliceFrames() {
        return drawSliceFrames();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#drawSliceFrames-prop">QCustom3DVolume::drawSliceFrames()const</a></p>
     */
    @QtPropertyReader(name="drawSliceFrames")
    @QtUninvokable
    public final boolean drawSliceFrames(){
        return drawSliceFrames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean drawSliceFrames_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #drawSlices()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getDrawSlices() {
        return drawSlices();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#drawSlices-prop">QCustom3DVolume::drawSlices()const</a></p>
     */
    @QtPropertyReader(name="drawSlices")
    @QtUninvokable
    public final boolean drawSlices(){
        return drawSlices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean drawSlices_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #preserveOpacity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPreserveOpacity() {
        return preserveOpacity();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#preserveOpacity-prop">QCustom3DVolume::preserveOpacity()const</a></p>
     */
    @QtPropertyReader(name="preserveOpacity")
    @QtUninvokable
    public final boolean preserveOpacity(){
        return preserveOpacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean preserveOpacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#renderSlice">QCustom3DVolume::renderSlice(Qt::Axis,int)</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage renderSlice(io.qt.core.Qt.@NonNull Axis axis, int index){
        return renderSlice_native_Qt_Axis_int(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index);
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage renderSlice_native_Qt_Axis_int(long __this__nativeId, int axis, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#alphaMultiplier-prop">QCustom3DVolume::setAlphaMultiplier(float)</a></p>
     */
    @QtPropertyWriter(name="alphaMultiplier")
    @QtUninvokable
    public final void setAlphaMultiplier(float mult){
        setAlphaMultiplier_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), mult);
    }
    
    @QtUninvokable
    private native void setAlphaMultiplier_native_float(long __this__nativeId, float mult);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#colorTable-prop">QCustom3DVolume::setColorTable(QList&lt;QRgb&gt;)</a></p>
     */
    @QtPropertyWriter(name="colorTable")
    @QtUninvokable
    public final void setColorTable(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> colors){
        setColorTable_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), colors);
    }
    
    @QtUninvokable
    private native void setColorTable_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Integer> colors);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#drawSliceFrames-prop">QCustom3DVolume::setDrawSliceFrames(bool)</a></p>
     */
    @QtPropertyWriter(name="drawSliceFrames")
    @QtUninvokable
    public final void setDrawSliceFrames(boolean enable){
        setDrawSliceFrames_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setDrawSliceFrames_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#drawSlices-prop">QCustom3DVolume::setDrawSlices(bool)</a></p>
     */
    @QtPropertyWriter(name="drawSlices")
    @QtUninvokable
    public final void setDrawSlices(boolean enable){
        setDrawSlices_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setDrawSlices_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#preserveOpacity-prop">QCustom3DVolume::setPreserveOpacity(bool)</a></p>
     */
    @QtPropertyWriter(name="preserveOpacity")
    @QtUninvokable
    public final void setPreserveOpacity(boolean enable){
        setPreserveOpacity_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setPreserveOpacity_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameColor-prop">QCustom3DVolume::setSliceFrameColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="sliceFrameColor")
    @QtUninvokable
    public final void setSliceFrameColor(io.qt.gui.@NonNull QColor color){
        setSliceFrameColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setSliceFrameColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameGaps-prop">QCustom3DVolume::setSliceFrameGaps(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="sliceFrameGaps")
    @QtUninvokable
    public final void setSliceFrameGaps(io.qt.gui.@NonNull QVector3D values){
        setSliceFrameGaps_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native void setSliceFrameGaps_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameThicknesses-prop">QCustom3DVolume::setSliceFrameThicknesses(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="sliceFrameThicknesses")
    @QtUninvokable
    public final void setSliceFrameThicknesses(io.qt.gui.@NonNull QVector3D values){
        setSliceFrameThicknesses_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native void setSliceFrameThicknesses_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameWidths-prop">QCustom3DVolume::setSliceFrameWidths(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="sliceFrameWidths")
    @QtUninvokable
    public final void setSliceFrameWidths(io.qt.gui.@NonNull QVector3D values){
        setSliceFrameWidths_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native void setSliceFrameWidths_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexX-prop">QCustom3DVolume::setSliceIndexX(int)</a></p>
     */
    @QtPropertyWriter(name="sliceIndexX")
    @QtUninvokable
    public final void setSliceIndexX(int value){
        setSliceIndexX_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setSliceIndexX_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexY-prop">QCustom3DVolume::setSliceIndexY(int)</a></p>
     */
    @QtPropertyWriter(name="sliceIndexY")
    @QtUninvokable
    public final void setSliceIndexY(int value){
        setSliceIndexY_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setSliceIndexY_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexZ-prop">QCustom3DVolume::setSliceIndexZ(int)</a></p>
     */
    @QtPropertyWriter(name="sliceIndexZ")
    @QtUninvokable
    public final void setSliceIndexZ(int value){
        setSliceIndexZ_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setSliceIndexZ_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#setSliceIndices">QCustom3DVolume::setSliceIndices(int,int,int)</a></p>
     */
    @QtUninvokable
    public final void setSliceIndices(int x, int y, int z){
        setSliceIndices_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void setSliceIndices_native_int_int_int(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#setSubTextureData-1">QCustom3DVolume::setSubTextureData(Qt::Axis,int,QImage)</a></p>
     */
    @QtUninvokable
    public final void setSubTextureData(io.qt.core.Qt.@NonNull Axis axis, int index, io.qt.gui.@NonNull QImage image){
        setSubTextureData_native_Qt_Axis_int_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index, QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    @QtUninvokable
    private native void setSubTextureData_native_Qt_Axis_int_cref_QImage(long __this__nativeId, int axis, int index, long image);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#setSubTextureData">QCustom3DVolume::setSubTextureData(Qt::Axis,int,const uchar*)</a></p>
     */
    @QtUninvokable
    public final void setSubTextureData(io.qt.core.Qt.@NonNull Axis axis, int index, java.nio.ByteBuffer data){
        setSubTextureData_native_Qt_Axis_int_const_uchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index, data);
    }
    
    @QtUninvokable
    private native void setSubTextureData_native_Qt_Axis_int_const_uchar_ptr(long __this__nativeId, int axis, int index, java.nio.ByteBuffer data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureData-prop">QCustom3DVolume::setTextureData(QList&lt;uchar&gt;*)</a></p>
     */
    @QtPropertyWriter(name="textureData")
    @QtUninvokable
    public final void setTextureData(java.util.@Nullable Collection<java.lang.@QtPrimitiveType@NonNull Byte> data){
        setTextureData_native_QList_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native void setTextureData_native_QList_ptr(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Byte> data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureDepth-prop">QCustom3DVolume::setTextureDepth(int)</a></p>
     */
    @QtPropertyWriter(name="textureDepth")
    @QtUninvokable
    public final void setTextureDepth(int value){
        setTextureDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setTextureDepth_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#setTextureDimensions">QCustom3DVolume::setTextureDimensions(int,int,int)</a></p>
     */
    @QtUninvokable
    public final void setTextureDimensions(int width, int height, int depth){
        setTextureDimensions_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, depth);
    }
    
    @QtUninvokable
    private native void setTextureDimensions_native_int_int_int(long __this__nativeId, int width, int height, int depth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#setTextureFormat">QCustom3DVolume::setTextureFormat(QImage::Format)</a></p>
     */
    @QtUninvokable
    public final void setTextureFormat(io.qt.gui.QImage.@NonNull Format format){
        setTextureFormat_native_QImage_Format(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setTextureFormat_native_QImage_Format(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureHeight-prop">QCustom3DVolume::setTextureHeight(int)</a></p>
     */
    @QtPropertyWriter(name="textureHeight")
    @QtUninvokable
    public final void setTextureHeight(int value){
        setTextureHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setTextureHeight_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureWidth-prop">QCustom3DVolume::setTextureWidth(int)</a></p>
     */
    @QtPropertyWriter(name="textureWidth")
    @QtUninvokable
    public final void setTextureWidth(int value){
        setTextureWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setTextureWidth_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#useHighDefShader-prop">QCustom3DVolume::setUseHighDefShader(bool)</a></p>
     */
    @QtPropertyWriter(name="useHighDefShader")
    @QtUninvokable
    public final void setUseHighDefShader(boolean enable){
        setUseHighDefShader_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setUseHighDefShader_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getSliceFrameColor() {
        return sliceFrameColor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameColor-prop">QCustom3DVolume::sliceFrameColor()const</a></p>
     */
    @QtPropertyReader(name="sliceFrameColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor sliceFrameColor(){
        return sliceFrameColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor sliceFrameColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameGaps()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getSliceFrameGaps() {
        return sliceFrameGaps();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameGaps-prop">QCustom3DVolume::sliceFrameGaps()const</a></p>
     */
    @QtPropertyReader(name="sliceFrameGaps")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D sliceFrameGaps(){
        return sliceFrameGaps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameGaps_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameThicknesses()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getSliceFrameThicknesses() {
        return sliceFrameThicknesses();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameThicknesses-prop">QCustom3DVolume::sliceFrameThicknesses()const</a></p>
     */
    @QtPropertyReader(name="sliceFrameThicknesses")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D sliceFrameThicknesses(){
        return sliceFrameThicknesses_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameThicknesses_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameWidths()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getSliceFrameWidths() {
        return sliceFrameWidths();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceFrameWidths-prop">QCustom3DVolume::sliceFrameWidths()const</a></p>
     */
    @QtPropertyReader(name="sliceFrameWidths")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D sliceFrameWidths(){
        return sliceFrameWidths_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameWidths_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceIndexX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSliceIndexX() {
        return sliceIndexX();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexX-prop">QCustom3DVolume::sliceIndexX()const</a></p>
     */
    @QtPropertyReader(name="sliceIndexX")
    @QtUninvokable
    public final int sliceIndexX(){
        return sliceIndexX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sliceIndexX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceIndexY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSliceIndexY() {
        return sliceIndexY();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexY-prop">QCustom3DVolume::sliceIndexY()const</a></p>
     */
    @QtPropertyReader(name="sliceIndexY")
    @QtUninvokable
    public final int sliceIndexY(){
        return sliceIndexY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sliceIndexY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceIndexZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSliceIndexZ() {
        return sliceIndexZ();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#sliceIndexZ-prop">QCustom3DVolume::sliceIndexZ()const</a></p>
     */
    @QtPropertyReader(name="sliceIndexZ")
    @QtUninvokable
    public final int sliceIndexZ(){
        return sliceIndexZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sliceIndexZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureData()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QList<java.lang.@QtPrimitiveType@NonNull Byte> getTextureData() {
        return textureData();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureData-prop">QCustom3DVolume::textureData()const</a></p>
     */
    @QtPropertyReader(name="textureData")
    @QtUninvokable
    public final io.qt.core.@Nullable QList<java.lang.@QtPrimitiveType@NonNull Byte> textureData(){
        return textureData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Byte> textureData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureDataWidth">QCustom3DVolume::textureDataWidth()const</a></p>
     */
    @QtUninvokable
    public final int textureDataWidth(){
        return textureDataWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureDataWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureDepth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTextureDepth() {
        return textureDepth();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureDepth-prop">QCustom3DVolume::textureDepth()const</a></p>
     */
    @QtPropertyReader(name="textureDepth")
    @QtUninvokable
    public final int textureDepth(){
        return textureDepth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureDepth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureFormat">QCustom3DVolume::textureFormat()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.QImage.@NonNull Format textureFormat(){
        return io.qt.gui.QImage.Format.resolve(textureFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int textureFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureHeight()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTextureHeight() {
        return textureHeight();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureHeight-prop">QCustom3DVolume::textureHeight()const</a></p>
     */
    @QtPropertyReader(name="textureHeight")
    @QtUninvokable
    public final int textureHeight(){
        return textureHeight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureHeight_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureWidth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTextureWidth() {
        return textureWidth();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#textureWidth-prop">QCustom3DVolume::textureWidth()const</a></p>
     */
    @QtPropertyReader(name="textureWidth")
    @QtUninvokable
    public final int textureWidth(){
        return textureWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #useHighDefShader()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUseHighDefShader() {
        return useHighDefShader();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3dvolume.html#useHighDefShader-prop">QCustom3DVolume::useHighDefShader()const</a></p>
     */
    @QtPropertyReader(name="useHighDefShader")
    @QtUninvokable
    public final boolean useHighDefShader(){
        return useHighDefShader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean useHighDefShader_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QCustom3DVolume(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCustom3DVolume(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCustom3DVolume instance, QDeclarativeConstructor constructor);
    
    private QtObject __rcTextureData;
}
