package io.qt.datavis;

import io.qt.*;


/**
 * <p>Adds a custom item to a graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qcustom3ditem.html">QCustom3DItem</a></p>
 */
public class QCustom3DItem extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCustom3DItem.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#meshFile-prop">QCustom3DItem::meshFileChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="meshFile")
    public final @NonNull Signal1<java.lang.@NonNull String> meshFileChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#positionAbsolute-prop">QCustom3DItem::positionAbsoluteChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="positionAbsolute")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> positionAbsoluteChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#position-prop">QCustom3DItem::positionChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> positionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#rotation-prop">QCustom3DItem::rotationChanged(QQuaternion)</a></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QQuaternion> rotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scalingAbsolute-prop">QCustom3DItem::scalingAbsoluteChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="scalingAbsolute")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> scalingAbsoluteChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scaling-prop">QCustom3DItem::scalingChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="scaling")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> scalingChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#shadowCasting-prop">QCustom3DItem::shadowCastingChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="shadowCasting")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> shadowCastingChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#textureFile-prop">QCustom3DItem::textureFileChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="textureFile")
    public final @NonNull Signal1<java.lang.@NonNull String> textureFileChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#visible-prop">QCustom3DItem::visibleChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="visible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> visibleChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DItem() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#QCustom3DItem">QCustom3DItem::QCustom3DItem(QObject*)</a></p>
     */
    public QCustom3DItem(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCustom3DItem instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, io.qt.gui.QImage, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DItem(java.lang.@NonNull String meshFile, io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, io.qt.gui.@NonNull QImage texture) {
        this(meshFile, position, scaling, rotation, texture, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#QCustom3DItem-1">QCustom3DItem::QCustom3DItem(QString,QVector3D,QVector3D,QQuaternion,QImage,QObject*)</a></p>
     */
    public QCustom3DItem(java.lang.@NonNull String meshFile, io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, io.qt.gui.@NonNull QImage texture, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, meshFile, position, scaling, rotation, texture, parent);
    }
    
    private native static void initialize_native(QCustom3DItem instance, java.lang.String meshFile, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, io.qt.gui.QImage texture, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isPositionAbsolute()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPositionAbsolute() {
        return isPositionAbsolute();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#positionAbsolute-prop">QCustom3DItem::isPositionAbsolute()const</a></p>
     */
    @QtPropertyReader(name="positionAbsolute")
    @QtUninvokable
    public final boolean isPositionAbsolute(){
        return isPositionAbsolute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPositionAbsolute_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isScalingAbsolute()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getScalingAbsolute() {
        return isScalingAbsolute();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scalingAbsolute-prop">QCustom3DItem::isScalingAbsolute()const</a></p>
     */
    @QtPropertyReader(name="scalingAbsolute")
    @QtUninvokable
    public final boolean isScalingAbsolute(){
        return isScalingAbsolute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isScalingAbsolute_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isShadowCasting()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getShadowCasting() {
        return isShadowCasting();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#shadowCasting-prop">QCustom3DItem::isShadowCasting()const</a></p>
     */
    @QtPropertyReader(name="shadowCasting")
    @QtUninvokable
    public final boolean isShadowCasting(){
        return isShadowCasting_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isShadowCasting_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getVisible() {
        return isVisible();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#visible-prop">QCustom3DItem::isVisible()const</a></p>
     */
    @QtPropertyReader(name="visible")
    @QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #meshFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getMeshFile() {
        return meshFile();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#meshFile-prop">QCustom3DItem::meshFile()const</a></p>
     */
    @QtPropertyReader(name="meshFile")
    @QtUninvokable
    public final java.lang.@NonNull String meshFile(){
        return meshFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String meshFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#position-prop">QCustom3DItem::position()const</a></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#rotation-prop">QCustom3DItem::rotation()</a></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #scaling()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getScaling() {
        return scaling();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scaling-prop">QCustom3DItem::scaling()const</a></p>
     */
    @QtPropertyReader(name="scaling")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D scaling(){
        return scaling_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D scaling_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#meshFile-prop">QCustom3DItem::setMeshFile(QString)</a></p>
     */
    @QtPropertyWriter(name="meshFile")
    @QtUninvokable
    public final void setMeshFile(java.lang.@NonNull String meshFile){
        setMeshFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), meshFile);
    }
    
    @QtUninvokable
    private native void setMeshFile_native_cref_QString(long __this__nativeId, java.lang.String meshFile);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#position-prop">QCustom3DItem::setPosition(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="position")
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D position){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#positionAbsolute-prop">QCustom3DItem::setPositionAbsolute(bool)</a></p>
     */
    @QtPropertyWriter(name="positionAbsolute")
    @QtUninvokable
    public final void setPositionAbsolute(boolean positionAbsolute){
        setPositionAbsolute_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), positionAbsolute);
    }
    
    @QtUninvokable
    private native void setPositionAbsolute_native_bool(long __this__nativeId, boolean positionAbsolute);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#rotation-prop">QCustom3DItem::setRotation(QQuaternion)</a></p>
     */
    @QtPropertyWriter(name="rotation")
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion rotation){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#setRotationAxisAndAngle">QCustom3DItem::setRotationAxisAndAngle(QVector3D,float)</a></p>
     */
    public final void setRotationAxisAndAngle(io.qt.gui.@NonNull QVector3D axis, float angle){
        setRotationAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native void setRotationAxisAndAngle_native_cref_QVector3D_float(long __this__nativeId, long axis, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scaling-prop">QCustom3DItem::setScaling(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="scaling")
    @QtUninvokable
    public final void setScaling(io.qt.gui.@NonNull QVector3D scaling){
        setScaling_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scaling));
    }
    
    @QtUninvokable
    private native void setScaling_native_cref_QVector3D(long __this__nativeId, long scaling);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scalingAbsolute-prop">QCustom3DItem::setScalingAbsolute(bool)</a></p>
     */
    @QtPropertyWriter(name="scalingAbsolute")
    @QtUninvokable
    public final void setScalingAbsolute(boolean scalingAbsolute){
        setScalingAbsolute_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), scalingAbsolute);
    }
    
    @QtUninvokable
    private native void setScalingAbsolute_native_bool(long __this__nativeId, boolean scalingAbsolute);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#shadowCasting-prop">QCustom3DItem::setShadowCasting(bool)</a></p>
     */
    @QtPropertyWriter(name="shadowCasting")
    @QtUninvokable
    public final void setShadowCasting(boolean enabled){
        setShadowCasting_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setShadowCasting_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#textureFile-prop">QCustom3DItem::setTextureFile(QString)</a></p>
     */
    @QtPropertyWriter(name="textureFile")
    @QtUninvokable
    public final void setTextureFile(java.lang.@NonNull String textureFile){
        setTextureFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), textureFile);
    }
    
    @QtUninvokable
    private native void setTextureFile_native_cref_QString(long __this__nativeId, java.lang.String textureFile);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#setTextureImage">QCustom3DItem::setTextureImage(QImage)</a></p>
     */
    @QtUninvokable
    public final void setTextureImage(io.qt.gui.@NonNull QImage textureImage){
        setTextureImage_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @QtUninvokable
    private native void setTextureImage_native_cref_QImage(long __this__nativeId, long textureImage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#visible-prop">QCustom3DItem::setVisible(bool)</a></p>
     */
    @QtPropertyWriter(name="visible")
    @QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTextureFile() {
        return textureFile();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#textureFile-prop">QCustom3DItem::textureFile()const</a></p>
     */
    @QtPropertyReader(name="textureFile")
    @QtUninvokable
    public final java.lang.@NonNull String textureFile(){
        return textureFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String textureFile_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QCustom3DItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCustom3DItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCustom3DItem instance, QDeclarativeConstructor constructor);
    
}
