package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base class for all data series</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qabstract3dseries.html">QAbstract3DSeries</a></p>
 */
public class QAbstract3DSeries extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DSeries.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3dseries.html#Mesh-enum">QAbstract3DSeries::Mesh</a></p>
     */
    @QtUnlistedEnum
    public enum Mesh implements QtEnumerator {
        MeshUserDefined(0),
        MeshBar(1),
        MeshCube(2),
        MeshPyramid(3),
        MeshCone(4),
        MeshCylinder(5),
        MeshBevelBar(6),
        MeshBevelCube(7),
        MeshSphere(8),
        MeshMinimal(9),
        MeshArrow(10),
        MeshPoint(11);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mesh(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Mesh resolve(int value) {
            switch (value) {
            case 0: return MeshUserDefined;
            case 1: return MeshBar;
            case 2: return MeshCube;
            case 3: return MeshPyramid;
            case 4: return MeshCone;
            case 5: return MeshCylinder;
            case 6: return MeshBevelBar;
            case 7: return MeshBevelCube;
            case 8: return MeshSphere;
            case 9: return MeshMinimal;
            case 10: return MeshArrow;
            case 11: return MeshPoint;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3dseries.html#SeriesType-enum">QAbstract3DSeries::SeriesType</a></p>
     */
    @QtUnlistedEnum
    public enum SeriesType implements QtEnumerator {
        SeriesTypeNone(0),
        SeriesTypeBar(1),
        SeriesTypeScatter(2),
        SeriesTypeSurface(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SeriesType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SeriesType resolve(int value) {
            switch (value) {
            case 0: return SeriesTypeNone;
            case 1: return SeriesTypeBar;
            case 2: return SeriesTypeScatter;
            case 4: return SeriesTypeSurface;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#baseColor-prop">QAbstract3DSeries::baseColorChanged(QColor)</a></p>
     */
    @QtPropertyNotify(name="baseColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> baseColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#baseGradient-prop">QAbstract3DSeries::baseGradientChanged(QLinearGradient)</a></p>
     */
    @QtPropertyNotify(name="baseGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> baseGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#colorStyle-prop">QAbstract3DSeries::colorStyleChanged(Q3DTheme::ColorStyle)</a></p>
     */
    @QtPropertyNotify(name="colorStyle")
    public final @NonNull Signal1<io.qt.datavis.Q3DTheme.@NonNull ColorStyle> colorStyleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabel-prop">QAbstract3DSeries::itemLabelChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="itemLabel")
    public final @NonNull Signal1<java.lang.@NonNull String> itemLabelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabelFormat-prop">QAbstract3DSeries::itemLabelFormatChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="itemLabelFormat")
    public final @NonNull Signal1<java.lang.@NonNull String> itemLabelFormatChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabelVisible-prop">QAbstract3DSeries::itemLabelVisibilityChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="itemLabelVisible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> itemLabelVisibilityChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#mesh-prop">QAbstract3DSeries::meshChanged(QAbstract3DSeries::Mesh)</a></p>
     */
    @QtPropertyNotify(name="mesh")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DSeries.@NonNull Mesh> meshChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#meshRotation-prop">QAbstract3DSeries::meshRotationChanged(QQuaternion)</a></p>
     */
    @QtPropertyNotify(name="meshRotation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QQuaternion> meshRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#meshSmooth-prop">QAbstract3DSeries::meshSmoothChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="meshSmooth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> meshSmoothChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#multiHighlightColor-prop">QAbstract3DSeries::multiHighlightColorChanged(QColor)</a></p>
     */
    @QtPropertyNotify(name="multiHighlightColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> multiHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#multiHighlightGradient-prop">QAbstract3DSeries::multiHighlightGradientChanged(QLinearGradient)</a></p>
     */
    @QtPropertyNotify(name="multiHighlightGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> multiHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#name-prop">QAbstract3DSeries::nameChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#singleHighlightColor-prop">QAbstract3DSeries::singleHighlightColorChanged(QColor)</a></p>
     */
    @QtPropertyNotify(name="singleHighlightColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> singleHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#singleHighlightGradient-prop">QAbstract3DSeries::singleHighlightGradientChanged(QLinearGradient)</a></p>
     */
    @QtPropertyNotify(name="singleHighlightGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> singleHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#userDefinedMesh-prop">QAbstract3DSeries::userDefinedMeshChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="userDefinedMesh")
    public final @NonNull Signal1<java.lang.@NonNull String> userDefinedMeshChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#visible-prop">QAbstract3DSeries::visibilityChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="visible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> visibilityChanged = new Signal1<>();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #baseColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getBaseColor() {
        return baseColor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#baseColor-prop">QAbstract3DSeries::baseColor()const</a></p>
     */
    @QtPropertyReader(name="baseColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor baseColor(){
        return baseColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor baseColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #baseGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getBaseGradient() {
        return baseGradient();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#baseGradient-prop">QAbstract3DSeries::baseGradient()const</a></p>
     */
    @QtPropertyReader(name="baseGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient baseGradient(){
        return baseGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient baseGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #colorStyle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull ColorStyle getColorStyle() {
        return colorStyle();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#colorStyle-prop">QAbstract3DSeries::colorStyle()const</a></p>
     */
    @QtPropertyReader(name="colorStyle")
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull ColorStyle colorStyle(){
        return io.qt.datavis.Q3DTheme.ColorStyle.resolve(colorStyle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int colorStyle_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isItemLabelVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getItemLabelVisible() {
        return isItemLabelVisible();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabelVisible-prop">QAbstract3DSeries::isItemLabelVisible()const</a></p>
     */
    @QtPropertyReader(name="itemLabelVisible")
    @QtUninvokable
    public final boolean isItemLabelVisible(){
        return isItemLabelVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isItemLabelVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isMeshSmooth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMeshSmooth() {
        return isMeshSmooth();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#meshSmooth-prop">QAbstract3DSeries::isMeshSmooth()const</a></p>
     */
    @QtPropertyReader(name="meshSmooth")
    @QtUninvokable
    public final boolean isMeshSmooth(){
        return isMeshSmooth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMeshSmooth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getVisible() {
        return isVisible();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#visible-prop">QAbstract3DSeries::isVisible()const</a></p>
     */
    @QtPropertyReader(name="visible")
    @QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemLabel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getItemLabel() {
        return itemLabel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabel-prop">QAbstract3DSeries::itemLabel()const</a></p>
     */
    @QtPropertyReader(name="itemLabel")
    @QtUninvokable
    public final java.lang.@NonNull String itemLabel(){
        return itemLabel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String itemLabel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemLabelFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getItemLabelFormat() {
        return itemLabelFormat();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabelFormat-prop">QAbstract3DSeries::itemLabelFormat()const</a></p>
     */
    @QtPropertyReader(name="itemLabelFormat")
    @QtUninvokable
    public final java.lang.@NonNull String itemLabelFormat(){
        return itemLabelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String itemLabelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mesh()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull Mesh getMesh() {
        return mesh();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#mesh-prop">QAbstract3DSeries::mesh()const</a></p>
     */
    @QtPropertyReader(name="mesh")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull Mesh mesh(){
        return io.qt.datavis.QAbstract3DSeries.Mesh.resolve(mesh_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mesh_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #meshRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getMeshRotation() {
        return meshRotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#meshRotation-prop">QAbstract3DSeries::meshRotation()const</a></p>
     */
    @QtPropertyReader(name="meshRotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion meshRotation(){
        return meshRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion meshRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #multiHighlightColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getMultiHighlightColor() {
        return multiHighlightColor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#multiHighlightColor-prop">QAbstract3DSeries::multiHighlightColor()const</a></p>
     */
    @QtPropertyReader(name="multiHighlightColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor multiHighlightColor(){
        return multiHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor multiHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #multiHighlightGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getMultiHighlightGradient() {
        return multiHighlightGradient();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#multiHighlightGradient-prop">QAbstract3DSeries::multiHighlightGradient()const</a></p>
     */
    @QtPropertyReader(name="multiHighlightGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient multiHighlightGradient(){
        return multiHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient multiHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#name-prop">QAbstract3DSeries::name()const</a></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#baseColor-prop">QAbstract3DSeries::setBaseColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="baseColor")
    @QtUninvokable
    public final void setBaseColor(io.qt.gui.@NonNull QColor color){
        setBaseColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setBaseColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#baseGradient-prop">QAbstract3DSeries::setBaseGradient(QLinearGradient)</a></p>
     */
    @QtPropertyWriter(name="baseGradient")
    @QtUninvokable
    public final void setBaseGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setBaseGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setBaseGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#colorStyle-prop">QAbstract3DSeries::setColorStyle(Q3DTheme::ColorStyle)</a></p>
     */
    @QtPropertyWriter(name="colorStyle")
    @QtUninvokable
    public final void setColorStyle(io.qt.datavis.Q3DTheme.@NonNull ColorStyle style){
        setColorStyle_native_Q3DTheme_ColorStyle(QtJambi_LibraryUtilities.internal.nativeId(this), style.value());
    }
    
    @QtUninvokable
    private native void setColorStyle_native_Q3DTheme_ColorStyle(long __this__nativeId, int style);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabelFormat-prop">QAbstract3DSeries::setItemLabelFormat(QString)</a></p>
     */
    @QtPropertyWriter(name="itemLabelFormat")
    @QtUninvokable
    public final void setItemLabelFormat(java.lang.@NonNull String format){
        setItemLabelFormat_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), format);
    }
    
    @QtUninvokable
    private native void setItemLabelFormat_native_cref_QString(long __this__nativeId, java.lang.String format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#itemLabelVisible-prop">QAbstract3DSeries::setItemLabelVisible(bool)</a></p>
     */
    @QtPropertyWriter(name="itemLabelVisible")
    @QtUninvokable
    public final void setItemLabelVisible(boolean visible){
        setItemLabelVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setItemLabelVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#mesh-prop">QAbstract3DSeries::setMesh(QAbstract3DSeries::Mesh)</a></p>
     */
    @QtPropertyWriter(name="mesh")
    @QtUninvokable
    public final void setMesh(io.qt.datavis.QAbstract3DSeries.@NonNull Mesh mesh){
        setMesh_native_QAbstract3DSeries_Mesh(QtJambi_LibraryUtilities.internal.nativeId(this), mesh.value());
    }
    
    @QtUninvokable
    private native void setMesh_native_QAbstract3DSeries_Mesh(long __this__nativeId, int mesh);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#setMeshAxisAndAngle">QAbstract3DSeries::setMeshAxisAndAngle(QVector3D,float)</a></p>
     */
    public final void setMeshAxisAndAngle(io.qt.gui.@NonNull QVector3D axis, float angle){
        setMeshAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native void setMeshAxisAndAngle_native_cref_QVector3D_float(long __this__nativeId, long axis, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#meshRotation-prop">QAbstract3DSeries::setMeshRotation(QQuaternion)</a></p>
     */
    @QtPropertyWriter(name="meshRotation")
    @QtUninvokable
    public final void setMeshRotation(io.qt.gui.@NonNull QQuaternion rotation){
        setMeshRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    @QtUninvokable
    private native void setMeshRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#meshSmooth-prop">QAbstract3DSeries::setMeshSmooth(bool)</a></p>
     */
    @QtPropertyWriter(name="meshSmooth")
    @QtUninvokable
    public final void setMeshSmooth(boolean enable){
        setMeshSmooth_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setMeshSmooth_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#multiHighlightColor-prop">QAbstract3DSeries::setMultiHighlightColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="multiHighlightColor")
    @QtUninvokable
    public final void setMultiHighlightColor(io.qt.gui.@NonNull QColor color){
        setMultiHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setMultiHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#multiHighlightGradient-prop">QAbstract3DSeries::setMultiHighlightGradient(QLinearGradient)</a></p>
     */
    @QtPropertyWriter(name="multiHighlightGradient")
    @QtUninvokable
    public final void setMultiHighlightGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setMultiHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setMultiHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#name-prop">QAbstract3DSeries::setName(QString)</a></p>
     */
    @QtPropertyWriter(name="name")
    @QtUninvokable
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#singleHighlightColor-prop">QAbstract3DSeries::setSingleHighlightColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="singleHighlightColor")
    @QtUninvokable
    public final void setSingleHighlightColor(io.qt.gui.@NonNull QColor color){
        setSingleHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setSingleHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#singleHighlightGradient-prop">QAbstract3DSeries::setSingleHighlightGradient(QLinearGradient)</a></p>
     */
    @QtPropertyWriter(name="singleHighlightGradient")
    @QtUninvokable
    public final void setSingleHighlightGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setSingleHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setSingleHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#userDefinedMesh-prop">QAbstract3DSeries::setUserDefinedMesh(QString)</a></p>
     */
    @QtPropertyWriter(name="userDefinedMesh")
    @QtUninvokable
    public final void setUserDefinedMesh(java.lang.@NonNull String fileName){
        setUserDefinedMesh_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setUserDefinedMesh_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#visible-prop">QAbstract3DSeries::setVisible(bool)</a></p>
     */
    @QtPropertyWriter(name="visible")
    @QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #singleHighlightColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getSingleHighlightColor() {
        return singleHighlightColor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#singleHighlightColor-prop">QAbstract3DSeries::singleHighlightColor()const</a></p>
     */
    @QtPropertyReader(name="singleHighlightColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor singleHighlightColor(){
        return singleHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor singleHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #singleHighlightGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getSingleHighlightGradient() {
        return singleHighlightGradient();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#singleHighlightGradient-prop">QAbstract3DSeries::singleHighlightGradient()const</a></p>
     */
    @QtPropertyReader(name="singleHighlightGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient singleHighlightGradient(){
        return singleHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient singleHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull SeriesType getType() {
        return type();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#type-prop">QAbstract3DSeries::type()const</a></p>
     */
    @QtPropertyReader(name="type")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull SeriesType type(){
        return io.qt.datavis.QAbstract3DSeries.SeriesType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #userDefinedMesh()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getUserDefinedMesh() {
        return userDefinedMesh();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dseries.html#userDefinedMesh-prop">QAbstract3DSeries::userDefinedMesh()const</a></p>
     */
    @QtPropertyReader(name="userDefinedMesh")
    @QtUninvokable
    public final java.lang.@NonNull String userDefinedMesh(){
        return userDefinedMesh_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String userDefinedMesh_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstract3DSeries(QPrivateConstructor p) { super(p); } 
    
}
