package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base class for implementations of input handlers</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html">QAbstract3DInputHandler</a></p>
 */
public class QAbstract3DInputHandler extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcScene = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DInputHandler.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#InputView-enum">QAbstract3DInputHandler::InputView</a></p>
     */
    @QtUnlistedEnum
    public enum InputView implements QtEnumerator {
        InputViewNone(0),
        InputViewOnPrimary(1),
        InputViewOnSecondary(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private InputView(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static InputView resolve(int value) {
            switch (value) {
            case 0: return InputViewNone;
            case 1: return InputViewOnPrimary;
            case 2: return InputViewOnSecondary;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#inputView-prop">QAbstract3DInputHandler::inputViewChanged(QAbstract3DInputHandler::InputView)</a></p>
     */
    @QtPropertyNotify(name="inputView")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DInputHandler.@NonNull InputView> inputViewChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#inputPosition-prop">QAbstract3DInputHandler::positionChanged(QPoint)</a></p>
     */
    @QtPropertyNotify(name="inputPosition")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> positionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#scene-prop">QAbstract3DInputHandler::sceneChanged(Q3DScene*)</a></p>
     */
    @QtPropertyNotify(name="scene")
    public final @NonNull Signal1<io.qt.datavis.@Nullable Q3DScene> sceneChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstract3DInputHandler() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#QAbstract3DInputHandler">QAbstract3DInputHandler::QAbstract3DInputHandler(QObject*)</a></p>
     */
    protected QAbstract3DInputHandler(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstract3DInputHandler instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #inputPosition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getInputPosition() {
        return inputPosition();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#inputPosition-prop">QAbstract3DInputHandler::inputPosition()const</a></p>
     */
    @QtPropertyReader(name="inputPosition")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint inputPosition(){
        return inputPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint inputPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #inputView()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DInputHandler.@NonNull InputView getInputView() {
        return inputView();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#inputView-prop">QAbstract3DInputHandler::inputView()const</a></p>
     */
    @QtPropertyReader(name="inputView")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DInputHandler.@NonNull InputView inputView(){
        return io.qt.datavis.QAbstract3DInputHandler.InputView.resolve(inputView_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int inputView_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#prevDistance">QAbstract3DInputHandler::prevDistance()const</a></p>
     */
    @QtUninvokable
    protected final int prevDistance(){
        return prevDistance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int prevDistance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#previousInputPos">QAbstract3DInputHandler::previousInputPos()const</a></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QPoint previousInputPos(){
        return previousInputPos_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint previousInputPos_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #scene()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DScene getScene() {
        return scene();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#scene-prop">QAbstract3DInputHandler::scene()const</a></p>
     */
    @QtPropertyReader(name="scene")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DScene scene(){
        return scene_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DScene scene_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#inputPosition-prop">QAbstract3DInputHandler::setInputPosition(QPoint)</a></p>
     */
    @QtPropertyWriter(name="inputPosition")
    @QtUninvokable
    public final void setInputPosition(io.qt.core.@NonNull QPoint position){
        setInputPosition_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setInputPosition_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#inputView-prop">QAbstract3DInputHandler::setInputView(QAbstract3DInputHandler::InputView)</a></p>
     */
    @QtPropertyWriter(name="inputView")
    @QtUninvokable
    public final void setInputView(io.qt.datavis.QAbstract3DInputHandler.@NonNull InputView inputView){
        setInputView_native_QAbstract3DInputHandler_InputView(QtJambi_LibraryUtilities.internal.nativeId(this), inputView.value());
    }
    
    @QtUninvokable
    private native void setInputView_native_QAbstract3DInputHandler_InputView(long __this__nativeId, int inputView);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#setPrevDistance">QAbstract3DInputHandler::setPrevDistance(int)</a></p>
     */
    @QtUninvokable
    protected final void setPrevDistance(int distance){
        setPrevDistance_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), distance);
    }
    
    @QtUninvokable
    private native void setPrevDistance_native_int(long __this__nativeId, int distance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#setPreviousInputPos">QAbstract3DInputHandler::setPreviousInputPos(QPoint)</a></p>
     */
    @QtUninvokable
    protected final void setPreviousInputPos(io.qt.core.@NonNull QPoint position){
        setPreviousInputPos_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setPreviousInputPos_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#scene-prop">QAbstract3DInputHandler::setScene(Q3DScene*)</a></p>
     */
    @QtPropertyWriter(name="scene")
    @QtUninvokable
    public final void setScene(io.qt.datavis.@Nullable Q3DScene scene){
        setScene_native_Q3DScene_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scene));
        __rcScene = scene;
    }
    
    @QtUninvokable
    private native void setScene_native_Q3DScene_ptr(long __this__nativeId, long scene);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mouseDoubleClickEvent">QAbstract3DInputHandler::mouseDoubleClickEvent(QMouseEvent*)</a></p>
     */
    @QtUninvokable
    public void mouseDoubleClickEvent(io.qt.gui.@Nullable QMouseEvent event){
        mouseDoubleClickEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mouseDoubleClickEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mouseMoveEvent">QAbstract3DInputHandler::mouseMoveEvent(QMouseEvent*,QPoint)</a></p>
     */
    @QtUninvokable
    public void mouseMoveEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mouseMoveEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mousePressEvent">QAbstract3DInputHandler::mousePressEvent(QMouseEvent*,QPoint)</a></p>
     */
    @QtUninvokable
    public void mousePressEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mousePressEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mouseReleaseEvent">QAbstract3DInputHandler::mouseReleaseEvent(QMouseEvent*,QPoint)</a></p>
     */
    @QtUninvokable
    public void mouseReleaseEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mouseReleaseEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#touchEvent">QAbstract3DInputHandler::touchEvent(QTouchEvent*)</a></p>
     */
    @QtUninvokable
    public void touchEvent(io.qt.gui.@Nullable QTouchEvent event){
        touchEvent_native_QTouchEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void touchEvent_native_QTouchEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#wheelEvent">QAbstract3DInputHandler::wheelEvent(QWheelEvent*)</a></p>
     */
    @QtUninvokable
    public void wheelEvent(io.qt.gui.@Nullable QWheelEvent event){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstract3DInputHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstract3DInputHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstract3DInputHandler instance, QDeclarativeConstructor constructor);
    
}
