package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base class for the axes of a graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qabstract3daxis.html">QAbstract3DAxis</a></p>
 */
public class QAbstract3DAxis extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DAxis.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3daxis.html#AxisOrientation-enum">QAbstract3DAxis::AxisOrientation</a></p>
     */
    @QtUnlistedEnum
    public enum AxisOrientation implements QtEnumerator {
        AxisOrientationNone(0),
        AxisOrientationX(1),
        AxisOrientationY(2),
        AxisOrientationZ(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AxisOrientation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AxisOrientation resolve(int value) {
            switch (value) {
            case 0: return AxisOrientationNone;
            case 1: return AxisOrientationX;
            case 2: return AxisOrientationY;
            case 4: return AxisOrientationZ;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3daxis.html#AxisType-enum">QAbstract3DAxis::AxisType</a></p>
     */
    @QtUnlistedEnum
    public enum AxisType implements QtEnumerator {
        AxisTypeNone(0),
        AxisTypeCategory(1),
        AxisTypeValue(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AxisType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AxisType resolve(int value) {
            switch (value) {
            case 0: return AxisTypeNone;
            case 1: return AxisTypeCategory;
            case 2: return AxisTypeValue;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#autoAdjustRange-prop">QAbstract3DAxis::autoAdjustRangeChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="autoAdjustRange")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoAdjustRangeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#labelAutoRotation-prop">QAbstract3DAxis::labelAutoRotationChanged(float)</a></p>
     */
    @QtPropertyNotify(name="labelAutoRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> labelAutoRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#labels-prop">QAbstract3DAxis::labelsChanged()</a></p>
     */
    @QtPropertyNotify(name="labels")
    public final @NonNull Signal0 labelsChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#max-prop">QAbstract3DAxis::maxChanged(float)</a></p>
     */
    @QtPropertyNotify(name="max")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#min-prop">QAbstract3DAxis::minChanged(float)</a></p>
     */
    @QtPropertyNotify(name="min")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#orientation-prop">QAbstract3DAxis::orientationChanged(QAbstract3DAxis::AxisOrientation)</a></p>
     */
    @QtPropertyNotify(name="orientation")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DAxis.@NonNull AxisOrientation> orientationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#rangeChanged">QAbstract3DAxis::rangeChanged(float,float)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Float, java.lang.@QtPrimitiveType@NonNull Float> rangeChanged = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#title-prop">QAbstract3DAxis::titleChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="title")
    public final @NonNull Signal1<java.lang.@NonNull String> titleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#titleFixed-prop">QAbstract3DAxis::titleFixedChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="titleFixed")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> titleFixedChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#titleVisible-prop">QAbstract3DAxis::titleVisibilityChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="titleVisible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> titleVisibilityChanged = new Signal1<>();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAutoAdjustRange()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoAdjustRange() {
        return isAutoAdjustRange();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#autoAdjustRange-prop">QAbstract3DAxis::isAutoAdjustRange()const</a></p>
     */
    @QtPropertyReader(name="autoAdjustRange")
    @QtUninvokable
    public final boolean isAutoAdjustRange(){
        return isAutoAdjustRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAutoAdjustRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isTitleFixed()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getTitleFixed() {
        return isTitleFixed();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#titleFixed-prop">QAbstract3DAxis::isTitleFixed()const</a></p>
     */
    @QtPropertyReader(name="titleFixed")
    @QtUninvokable
    public final boolean isTitleFixed(){
        return isTitleFixed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isTitleFixed_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isTitleVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getTitleVisible() {
        return isTitleVisible();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#titleVisible-prop">QAbstract3DAxis::isTitleVisible()const</a></p>
     */
    @QtPropertyReader(name="titleVisible")
    @QtUninvokable
    public final boolean isTitleVisible(){
        return isTitleVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isTitleVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #labelAutoRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getLabelAutoRotation() {
        return labelAutoRotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#labelAutoRotation-prop">QAbstract3DAxis::labelAutoRotation()const</a></p>
     */
    @QtPropertyReader(name="labelAutoRotation")
    @QtUninvokable
    public final float labelAutoRotation(){
        return labelAutoRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float labelAutoRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #labels()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtDeclaredFinal
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getLabels() {
        return labels();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#labels-prop">QAbstract3DAxis::labels()const</a></p>
     */
    @QtPropertyReader(name="labels")
    @QtDeclaredFinal
    @QtUninvokable
    public io.qt.core.@NonNull QStringList labels(){
        return labels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList labels_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #max()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMax() {
        return max();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#max-prop">QAbstract3DAxis::max()const</a></p>
     */
    @QtPropertyReader(name="max")
    @QtUninvokable
    public final float max(){
        return max_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float max_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #min()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMin() {
        return min();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#min-prop">QAbstract3DAxis::min()const</a></p>
     */
    @QtPropertyReader(name="min")
    @QtUninvokable
    public final float min(){
        return min_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float min_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #orientation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DAxis.@NonNull AxisOrientation getOrientation() {
        return orientation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#orientation-prop">QAbstract3DAxis::orientation()const</a></p>
     */
    @QtPropertyReader(name="orientation")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DAxis.@NonNull AxisOrientation orientation(){
        return io.qt.datavis.QAbstract3DAxis.AxisOrientation.resolve(orientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int orientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#autoAdjustRange-prop">QAbstract3DAxis::setAutoAdjustRange(bool)</a></p>
     */
    @QtPropertyWriter(name="autoAdjustRange")
    @QtUninvokable
    public final void setAutoAdjustRange(boolean autoAdjust){
        setAutoAdjustRange_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoAdjust);
    }
    
    @QtUninvokable
    private native void setAutoAdjustRange_native_bool(long __this__nativeId, boolean autoAdjust);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#labelAutoRotation-prop">QAbstract3DAxis::setLabelAutoRotation(float)</a></p>
     */
    @QtPropertyWriter(name="labelAutoRotation")
    @QtUninvokable
    public final void setLabelAutoRotation(float angle){
        setLabelAutoRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    @QtUninvokable
    private native void setLabelAutoRotation_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#labels-prop">QAbstract3DAxis::setLabels(QStringList)</a></p>
     */
    @QtPropertyWriter(name="labels")
    @QtDeclaredFinal
    @QtUninvokable
    public void setLabels(java.util.@NonNull Collection<java.lang.@NonNull String> labels){
        setLabels_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), labels);
    }
    
    @QtUninvokable
    private native void setLabels_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#max-prop">QAbstract3DAxis::setMax(float)</a></p>
     */
    @QtPropertyWriter(name="max")
    @QtUninvokable
    public final void setMax(float max){
        setMax_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @QtUninvokable
    private native void setMax_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#min-prop">QAbstract3DAxis::setMin(float)</a></p>
     */
    @QtPropertyWriter(name="min")
    @QtUninvokable
    public final void setMin(float min){
        setMin_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @QtUninvokable
    private native void setMin_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#setRange">QAbstract3DAxis::setRange(float,float)</a></p>
     */
    @QtUninvokable
    public final void setRange(float min, float max){
        setRange_native_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), min, max);
    }
    
    @QtUninvokable
    private native void setRange_native_float_float(long __this__nativeId, float min, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#title-prop">QAbstract3DAxis::setTitle(QString)</a></p>
     */
    @QtPropertyWriter(name="title")
    @QtUninvokable
    public final void setTitle(java.lang.@NonNull String title){
        setTitle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), title);
    }
    
    @QtUninvokable
    private native void setTitle_native_cref_QString(long __this__nativeId, java.lang.String title);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#titleFixed-prop">QAbstract3DAxis::setTitleFixed(bool)</a></p>
     */
    @QtPropertyWriter(name="titleFixed")
    @QtUninvokable
    public final void setTitleFixed(boolean fixed){
        setTitleFixed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), fixed);
    }
    
    @QtUninvokable
    private native void setTitleFixed_native_bool(long __this__nativeId, boolean fixed);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#titleVisible-prop">QAbstract3DAxis::setTitleVisible(bool)</a></p>
     */
    @QtPropertyWriter(name="titleVisible")
    @QtUninvokable
    public final void setTitleVisible(boolean visible){
        setTitleVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setTitleVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #title()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTitle() {
        return title();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#title-prop">QAbstract3DAxis::title()const</a></p>
     */
    @QtPropertyReader(name="title")
    @QtUninvokable
    public final java.lang.@NonNull String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DAxis.@NonNull AxisType getType() {
        return type();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3daxis.html#type-prop">QAbstract3DAxis::type()const</a></p>
     */
    @QtPropertyReader(name="type")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DAxis.@NonNull AxisType type(){
        return io.qt.datavis.QAbstract3DAxis.AxisType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstract3DAxis(QPrivateConstructor p) { super(p); } 
    
}
