package io.qt.datavis;

import io.qt.*;


/**
 * <p>Description of the 3D scene being visualized</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/q3dscene.html">Q3DScene</a></p>
 */
public class Q3DScene extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DScene.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeCamera-prop">Q3DScene::activeCameraChanged(Q3DCamera*)</a></p>
     */
    @QtPropertyNotify(name="activeCamera")
    public final @NonNull Signal1<io.qt.datavis.@Nullable Q3DCamera> activeCameraChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeLight-prop">Q3DScene::activeLightChanged(Q3DLight*)</a></p>
     */
    @QtPropertyNotify(name="activeLight")
    public final @NonNull Signal1<io.qt.datavis.@Nullable Q3DLight> activeLightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#devicePixelRatio-prop">Q3DScene::devicePixelRatioChanged(float)</a></p>
     */
    @QtPropertyNotify(name="devicePixelRatio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> devicePixelRatioChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#graphPositionQuery-prop">Q3DScene::graphPositionQueryChanged(QPoint)</a></p>
     */
    @QtPropertyNotify(name="graphPositionQuery")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> graphPositionQueryChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#primarySubViewport-prop">Q3DScene::primarySubViewportChanged(QRect)</a></p>
     */
    @QtPropertyNotify(name="primarySubViewport")
    public final @NonNull Signal1<io.qt.core.@NonNull QRect> primarySubViewportChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubViewport-prop">Q3DScene::secondarySubViewportChanged(QRect)</a></p>
     */
    @QtPropertyNotify(name="secondarySubViewport")
    public final @NonNull Signal1<io.qt.core.@NonNull QRect> secondarySubViewportChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubviewOnTop-prop">Q3DScene::secondarySubviewOnTopChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="secondarySubviewOnTop")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> secondarySubviewOnTopChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#selectionQueryPosition-prop">Q3DScene::selectionQueryPositionChanged(QPoint)</a></p>
     */
    @QtPropertyNotify(name="selectionQueryPosition")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> selectionQueryPositionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#slicingActive-prop">Q3DScene::slicingActiveChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="slicingActive")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> slicingActiveChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#viewport-prop">Q3DScene::viewportChanged(QRect)</a></p>
     */
    @QtPropertyNotify(name="viewport")
    public final @NonNull Signal1<io.qt.core.@NonNull QRect> viewportChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DScene() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#Q3DScene">Q3DScene::Q3DScene(QObject*)</a></p>
     */
    public Q3DScene(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DScene instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activeCamera()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DCamera getActiveCamera() {
        return activeCamera();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeCamera-prop">Q3DScene::activeCamera()const</a></p>
     */
    @QtPropertyReader(name="activeCamera")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DCamera activeCamera(){
        return activeCamera_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DCamera activeCamera_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activeLight()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DLight getActiveLight() {
        return activeLight();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeLight-prop">Q3DScene::activeLight()const</a></p>
     */
    @QtPropertyReader(name="activeLight")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DLight activeLight(){
        return activeLight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DLight activeLight_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #devicePixelRatio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDevicePixelRatio() {
        return devicePixelRatio();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#devicePixelRatio-prop">Q3DScene::devicePixelRatio()const</a></p>
     */
    @QtPropertyReader(name="devicePixelRatio")
    @QtUninvokable
    public final float devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #graphPositionQuery()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getGraphPositionQuery() {
        return graphPositionQuery();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#graphPositionQuery-prop">Q3DScene::graphPositionQuery()const</a></p>
     */
    @QtPropertyReader(name="graphPositionQuery")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint graphPositionQuery(){
        return graphPositionQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint graphPositionQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#isPointInPrimarySubView">Q3DScene::isPointInPrimarySubView(QPoint)</a></p>
     */
    @QtUninvokable
    public final boolean isPointInPrimarySubView(io.qt.core.@NonNull QPoint point){
        return isPointInPrimarySubView_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native boolean isPointInPrimarySubView_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#isPointInSecondarySubView">Q3DScene::isPointInSecondarySubView(QPoint)</a></p>
     */
    @QtUninvokable
    public final boolean isPointInSecondarySubView(io.qt.core.@NonNull QPoint point){
        return isPointInSecondarySubView_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native boolean isPointInSecondarySubView_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isSecondarySubviewOnTop()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSecondarySubviewOnTop() {
        return isSecondarySubviewOnTop();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubviewOnTop-prop">Q3DScene::isSecondarySubviewOnTop()const</a></p>
     */
    @QtPropertyReader(name="secondarySubviewOnTop")
    @QtUninvokable
    public final boolean isSecondarySubviewOnTop(){
        return isSecondarySubviewOnTop_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSecondarySubviewOnTop_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isSlicingActive()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSlicingActive() {
        return isSlicingActive();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#slicingActive-prop">Q3DScene::isSlicingActive()const</a></p>
     */
    @QtPropertyReader(name="slicingActive")
    @QtUninvokable
    public final boolean isSlicingActive(){
        return isSlicingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSlicingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #primarySubViewport()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRect getPrimarySubViewport() {
        return primarySubViewport();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#primarySubViewport-prop">Q3DScene::primarySubViewport()const</a></p>
     */
    @QtPropertyReader(name="primarySubViewport")
    @QtUninvokable
    public final io.qt.core.@NonNull QRect primarySubViewport(){
        return primarySubViewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect primarySubViewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #secondarySubViewport()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRect getSecondarySubViewport() {
        return secondarySubViewport();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubViewport-prop">Q3DScene::secondarySubViewport()const</a></p>
     */
    @QtPropertyReader(name="secondarySubViewport")
    @QtUninvokable
    public final io.qt.core.@NonNull QRect secondarySubViewport(){
        return secondarySubViewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect secondarySubViewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectionQueryPosition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getSelectionQueryPosition() {
        return selectionQueryPosition();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#selectionQueryPosition-prop">Q3DScene::selectionQueryPosition()const</a></p>
     */
    @QtPropertyReader(name="selectionQueryPosition")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint selectionQueryPosition(){
        return selectionQueryPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint selectionQueryPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeCamera-prop">Q3DScene::setActiveCamera(Q3DCamera*)</a></p>
     */
    @QtPropertyWriter(name="activeCamera")
    @QtUninvokable
    public final void setActiveCamera(io.qt.datavis.@Nullable Q3DCamera camera){
        setActiveCamera_native_Q3DCamera_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(camera));
    }
    
    @QtUninvokable
    private native void setActiveCamera_native_Q3DCamera_ptr(long __this__nativeId, long camera);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeLight-prop">Q3DScene::setActiveLight(Q3DLight*)</a></p>
     */
    @QtPropertyWriter(name="activeLight")
    @QtUninvokable
    public final void setActiveLight(io.qt.datavis.@Nullable Q3DLight light){
        setActiveLight_native_Q3DLight_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(light));
    }
    
    @QtUninvokable
    private native void setActiveLight_native_Q3DLight_ptr(long __this__nativeId, long light);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#devicePixelRatio-prop">Q3DScene::setDevicePixelRatio(float)</a></p>
     */
    @QtPropertyWriter(name="devicePixelRatio")
    @QtUninvokable
    public final void setDevicePixelRatio(float pixelRatio){
        setDevicePixelRatio_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), pixelRatio);
    }
    
    @QtUninvokable
    private native void setDevicePixelRatio_native_float(long __this__nativeId, float pixelRatio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#graphPositionQuery-prop">Q3DScene::setGraphPositionQuery(QPoint)</a></p>
     */
    @QtPropertyWriter(name="graphPositionQuery")
    @QtUninvokable
    public final void setGraphPositionQuery(io.qt.core.@NonNull QPoint point){
        setGraphPositionQuery_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setGraphPositionQuery_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#primarySubViewport-prop">Q3DScene::setPrimarySubViewport(QRect)</a></p>
     */
    @QtPropertyWriter(name="primarySubViewport")
    @QtUninvokable
    public final void setPrimarySubViewport(io.qt.core.@NonNull QRect primarySubViewport){
        setPrimarySubViewport_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(primarySubViewport));
    }
    
    @QtUninvokable
    private native void setPrimarySubViewport_native_cref_QRect(long __this__nativeId, long primarySubViewport);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubViewport-prop">Q3DScene::setSecondarySubViewport(QRect)</a></p>
     */
    @QtPropertyWriter(name="secondarySubViewport")
    @QtUninvokable
    public final void setSecondarySubViewport(io.qt.core.@NonNull QRect secondarySubViewport){
        setSecondarySubViewport_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(secondarySubViewport));
    }
    
    @QtUninvokable
    private native void setSecondarySubViewport_native_cref_QRect(long __this__nativeId, long secondarySubViewport);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubviewOnTop-prop">Q3DScene::setSecondarySubviewOnTop(bool)</a></p>
     */
    @QtPropertyWriter(name="secondarySubviewOnTop")
    @QtUninvokable
    public final void setSecondarySubviewOnTop(boolean isSecondaryOnTop){
        setSecondarySubviewOnTop_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isSecondaryOnTop);
    }
    
    @QtUninvokable
    private native void setSecondarySubviewOnTop_native_bool(long __this__nativeId, boolean isSecondaryOnTop);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#selectionQueryPosition-prop">Q3DScene::setSelectionQueryPosition(QPoint)</a></p>
     */
    @QtPropertyWriter(name="selectionQueryPosition")
    @QtUninvokable
    public final void setSelectionQueryPosition(io.qt.core.@NonNull QPoint point){
        setSelectionQueryPosition_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setSelectionQueryPosition_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#slicingActive-prop">Q3DScene::setSlicingActive(bool)</a></p>
     */
    @QtPropertyWriter(name="slicingActive")
    @QtUninvokable
    public final void setSlicingActive(boolean isSlicing){
        setSlicingActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isSlicing);
    }
    
    @QtUninvokable
    private native void setSlicingActive_native_bool(long __this__nativeId, boolean isSlicing);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewport()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRect getViewport() {
        return viewport();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#viewport-prop">Q3DScene::viewport()const</a></p>
     */
    @QtPropertyReader(name="viewport")
    @QtUninvokable
    public final io.qt.core.@NonNull QRect viewport(){
        return viewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect viewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#invalidSelectionPoint">Q3DScene::invalidSelectionPoint()</a></p>
     */
    public native static io.qt.core.@NonNull QPoint invalidSelectionPoint();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected Q3DScene(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DScene(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DScene instance, QDeclarativeConstructor constructor);
    
}
