package io.qt.datavis;

import io.qt.*;


/**
 * <p>Methods for rendering 3D scatter graphs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/q3dscatter.html">Q3DScatter</a></p>
 */
public class Q3DScatter extends io.qt.datavis.QAbstract3DGraph
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DScatter.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisX-prop">Q3DScatter::axisXChanged(QValue3DAxis*)</a></p>
     */
    @QtPropertyNotify(name="axisX")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QValue3DAxis> axisXChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisY-prop">Q3DScatter::axisYChanged(QValue3DAxis*)</a></p>
     */
    @QtPropertyNotify(name="axisY")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QValue3DAxis> axisYChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisZ-prop">Q3DScatter::axisZChanged(QValue3DAxis*)</a></p>
     */
    @QtPropertyNotify(name="axisZ")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QValue3DAxis> axisZChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#selectedSeries-prop">Q3DScatter::selectedSeriesChanged(QScatter3DSeries*)</a></p>
     */
    @QtPropertyNotify(name="selectedSeries")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QScatter3DSeries> selectedSeriesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DScatter(io.qt.gui.@Nullable QSurfaceFormat format) {
        this(format, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>format = null</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public Q3DScatter() {
        this((io.qt.gui.QSurfaceFormat)null, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#Q3DScatter">Q3DScatter::Q3DScatter(const QSurfaceFormat*,QWindow*)</a></p>
     */
    public Q3DScatter(io.qt.gui.@Nullable QSurfaceFormat format, io.qt.gui.@Nullable QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, format, parent);
    }
    
    private native static void initialize_native(Q3DScatter instance, io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#addAxis">Q3DScatter::addAxis(QValue3DAxis*)</a></p>
     */
    @QtUninvokable
    public final void addAxis(io.qt.datavis.@Nullable QValue3DAxis axis){
        addAxis_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void addAxis_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#addSeries">Q3DScatter::addSeries(QScatter3DSeries*)</a></p>
     */
    @QtUninvokable
    public final void addSeries(io.qt.datavis.@Nullable QScatter3DSeries series){
        addSeries_native_QScatter3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @QtUninvokable
    private native void addSeries_native_QScatter3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axes">Q3DScatter::axes()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.datavis.@Nullable QValue3DAxis> axes(){
        return axes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QValue3DAxis> axes_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #axisX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis getAxisX() {
        return axisX();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisX-prop">Q3DScatter::axisX()const</a></p>
     */
    @QtPropertyReader(name="axisX")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis axisX(){
        return axisX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #axisY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis getAxisY() {
        return axisY();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisY-prop">Q3DScatter::axisY()const</a></p>
     */
    @QtPropertyReader(name="axisY")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis axisY(){
        return axisY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #axisZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis getAxisZ() {
        return axisZ();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisZ">Q3DScatter::axisZ()const</a></p>
     */
    @QtPropertyReader(name="axisZ")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QValue3DAxis axisZ(){
        return axisZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#releaseAxis">Q3DScatter::releaseAxis(QValue3DAxis*)</a></p>
     */
    @QtUninvokable
    public final void releaseAxis(io.qt.datavis.@Nullable QValue3DAxis axis){
        releaseAxis_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void releaseAxis_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#removeSeries">Q3DScatter::removeSeries(QScatter3DSeries*)</a></p>
     */
    @QtUninvokable
    public final void removeSeries(io.qt.datavis.@Nullable QScatter3DSeries series){
        removeSeries_native_QScatter3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @QtUninvokable
    private native void removeSeries_native_QScatter3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedSeries()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatter3DSeries getSelectedSeries() {
        return selectedSeries();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#selectedSeries-prop">Q3DScatter::selectedSeries()const</a></p>
     */
    @QtPropertyReader(name="selectedSeries")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QScatter3DSeries selectedSeries(){
        return selectedSeries_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QScatter3DSeries selectedSeries_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#seriesList">Q3DScatter::seriesList()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.datavis.@Nullable QScatter3DSeries> seriesList(){
        return seriesList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QScatter3DSeries> seriesList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#setAxisX">Q3DScatter::setAxisX(QValue3DAxis*)</a></p>
     */
    @QtPropertyWriter(name="axisX")
    @QtUninvokable
    public final void setAxisX(io.qt.datavis.@Nullable QValue3DAxis axis){
        setAxisX_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void setAxisX_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#setAxisY">Q3DScatter::setAxisY(QValue3DAxis*)</a></p>
     */
    @QtPropertyWriter(name="axisY")
    @QtUninvokable
    public final void setAxisY(io.qt.datavis.@Nullable QValue3DAxis axis){
        setAxisY_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void setAxisY_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#setAxisZ">Q3DScatter::setAxisZ(QValue3DAxis*)</a></p>
     */
    @QtPropertyWriter(name="axisZ")
    @QtUninvokable
    public final void setAxisZ(io.qt.datavis.@Nullable QValue3DAxis axis){
        setAxisZ_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @QtUninvokable
    private native void setAxisZ_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected Q3DScatter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DScatter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DScatter instance, QDeclarativeConstructor constructor);
    
}
