package io.qt.datavis;

import io.qt.*;


/**
 * <p>Basic wheel mouse based input handler</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/q3dinputhandler.html">Q3DInputHandler</a></p>
 */
public class Q3DInputHandler extends io.qt.datavis.QAbstract3DInputHandler
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DInputHandler.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#rotationEnabled-prop">Q3DInputHandler::rotationEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="rotationEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> rotationEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#selectionEnabled-prop">Q3DInputHandler::selectionEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="selectionEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> selectionEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomAtTargetEnabled-prop">Q3DInputHandler::zoomAtTargetEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="zoomAtTargetEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> zoomAtTargetEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomEnabled-prop">Q3DInputHandler::zoomEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="zoomEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> zoomEnabledChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DInputHandler() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#Q3DInputHandler">Q3DInputHandler::Q3DInputHandler(QObject*)</a></p>
     */
    public Q3DInputHandler(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DInputHandler instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isRotationEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRotationEnabled() {
        return isRotationEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#rotationEnabled-prop">Q3DInputHandler::isRotationEnabled()const</a></p>
     */
    @QtPropertyReader(name="rotationEnabled")
    @QtUninvokable
    public final boolean isRotationEnabled(){
        return isRotationEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRotationEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isSelectionEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSelectionEnabled() {
        return isSelectionEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#selectionEnabled-prop">Q3DInputHandler::isSelectionEnabled()const</a></p>
     */
    @QtPropertyReader(name="selectionEnabled")
    @QtUninvokable
    public final boolean isSelectionEnabled(){
        return isSelectionEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSelectionEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isZoomAtTargetEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getZoomAtTargetEnabled() {
        return isZoomAtTargetEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomAtTargetEnabled-prop">Q3DInputHandler::isZoomAtTargetEnabled()const</a></p>
     */
    @QtPropertyReader(name="zoomAtTargetEnabled")
    @QtUninvokable
    public final boolean isZoomAtTargetEnabled(){
        return isZoomAtTargetEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isZoomAtTargetEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isZoomEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getZoomEnabled() {
        return isZoomEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomEnabled-prop">Q3DInputHandler::isZoomEnabled()const</a></p>
     */
    @QtPropertyReader(name="zoomEnabled")
    @QtUninvokable
    public final boolean isZoomEnabled(){
        return isZoomEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isZoomEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#rotationEnabled-prop">Q3DInputHandler::setRotationEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="rotationEnabled")
    @QtUninvokable
    public final void setRotationEnabled(boolean enable){
        setRotationEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setRotationEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#selectionEnabled-prop">Q3DInputHandler::setSelectionEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="selectionEnabled")
    @QtUninvokable
    public final void setSelectionEnabled(boolean enable){
        setSelectionEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setSelectionEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomAtTargetEnabled-prop">Q3DInputHandler::setZoomAtTargetEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="zoomAtTargetEnabled")
    @QtUninvokable
    public final void setZoomAtTargetEnabled(boolean enable){
        setZoomAtTargetEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setZoomAtTargetEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dinputhandler.html#zoomEnabled-prop">Q3DInputHandler::setZoomEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="zoomEnabled")
    @QtUninvokable
    public final void setZoomEnabled(boolean enable){
        setZoomEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setZoomEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mouseMoveEvent">QAbstract3DInputHandler::mouseMoveEvent(QMouseEvent*,QPoint)</a></p>
     */
    @QtUninvokable
    public void mouseMoveEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mouseMoveEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mousePressEvent">QAbstract3DInputHandler::mousePressEvent(QMouseEvent*,QPoint)</a></p>
     */
    @QtUninvokable
    public void mousePressEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mousePressEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#mouseReleaseEvent">QAbstract3DInputHandler::mouseReleaseEvent(QMouseEvent*,QPoint)</a></p>
     */
    @QtUninvokable
    public void mouseReleaseEvent(io.qt.gui.@Nullable QMouseEvent event, io.qt.core.@NonNull QPoint mousePos){
        mouseReleaseEvent_native_QMouseEvent_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), QtJambi_LibraryUtilities.internal.checkedNativeId(mousePos));
    }
    
    @QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr_cref_QPoint(long __this__nativeId, long event, long mousePos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dinputhandler.html#wheelEvent">QAbstract3DInputHandler::wheelEvent(QWheelEvent*)</a></p>
     */
    @QtUninvokable
    public void wheelEvent(io.qt.gui.@Nullable QWheelEvent event){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected Q3DInputHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DInputHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DInputHandler instance, QDeclarativeConstructor constructor);
    
}
