package io.qt.datavis;


/**
 * <p>Adds a custom item to a graph</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qcustom3ditem.html">QCustom3DItem</a></p>
 */
public class QCustom3DItem extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCustom3DItem.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#meshFile-prop">QCustom3DItem::meshFileChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="meshFile")
    public final Signal1<java.lang.String> meshFileChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#positionAbsolute-prop">QCustom3DItem::positionAbsoluteChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="positionAbsolute")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> positionAbsoluteChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#position-prop">QCustom3DItem::positionChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="position")
    public final Signal1<io.qt.gui.QVector3D> positionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#rotation-prop">QCustom3DItem::rotationChanged(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotation")
    public final Signal1<io.qt.gui.QQuaternion> rotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scalingAbsolute-prop">QCustom3DItem::scalingAbsoluteChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scalingAbsolute")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> scalingAbsoluteChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scaling-prop">QCustom3DItem::scalingChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scaling")
    public final Signal1<io.qt.gui.QVector3D> scalingChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#shadowCasting-prop">QCustom3DItem::shadowCastingChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="shadowCasting")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> shadowCastingChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#textureFile-prop">QCustom3DItem::textureFileChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureFile")
    public final Signal1<java.lang.String> textureFileChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#visible-prop">QCustom3DItem::visibleChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="visible")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> visibleChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DItem(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DItem() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#QCustom3DItem">QCustom3DItem::QCustom3DItem(QObject*)</a></p>
     */
    public QCustom3DItem(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCustom3DItem instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DItem(java.lang.String, io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, io.qt.gui.QImage, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DItem(java.lang.String meshFile, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, io.qt.gui.QImage texture) {
        this(meshFile, position, scaling, rotation, texture, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#QCustom3DItem-1">QCustom3DItem::QCustom3DItem(QString,QVector3D,QVector3D,QQuaternion,QImage,QObject*)</a></p>
     */
    public QCustom3DItem(java.lang.String meshFile, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, io.qt.gui.QImage texture, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, meshFile, position, scaling, rotation, texture, parent);
    }
    
    private native static void initialize_native(QCustom3DItem instance, java.lang.String meshFile, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, io.qt.gui.QImage texture, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#positionAbsolute-prop">QCustom3DItem::isPositionAbsolute()const</a></p>
     */
    @io.qt.QtPropertyReader(name="positionAbsolute")
    @io.qt.QtUninvokable
    public final boolean isPositionAbsolute(){
        return isPositionAbsolute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPositionAbsolute_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scalingAbsolute-prop">QCustom3DItem::isScalingAbsolute()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scalingAbsolute")
    @io.qt.QtUninvokable
    public final boolean isScalingAbsolute(){
        return isScalingAbsolute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isScalingAbsolute_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#shadowCasting-prop">QCustom3DItem::isShadowCasting()const</a></p>
     */
    @io.qt.QtPropertyReader(name="shadowCasting")
    @io.qt.QtUninvokable
    public final boolean isShadowCasting(){
        return isShadowCasting_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isShadowCasting_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#visible-prop">QCustom3DItem::isVisible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="visible")
    @io.qt.QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#meshFile-prop">QCustom3DItem::meshFile()const</a></p>
     */
    @io.qt.QtPropertyReader(name="meshFile")
    @io.qt.QtUninvokable
    public final java.lang.String meshFile(){
        return meshFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String meshFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#position-prop">QCustom3DItem::position()const</a></p>
     */
    @io.qt.QtPropertyReader(name="position")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#rotation-prop">QCustom3DItem::rotation()</a></p>
     */
    @io.qt.QtPropertyReader(name="rotation")
    @io.qt.QtUninvokable
    public final io.qt.gui.QQuaternion rotation(){
        return rotation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scaling-prop">QCustom3DItem::scaling()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scaling")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D scaling(){
        return scaling_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D scaling_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#meshFile-prop">QCustom3DItem::setMeshFile(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="meshFile")
    @io.qt.QtUninvokable
    public final void setMeshFile(java.lang.String meshFile){
        setMeshFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), meshFile);
    }
    
    @io.qt.QtUninvokable
    private native void setMeshFile_native_cref_QString(long __this__nativeId, java.lang.String meshFile);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#position-prop">QCustom3DItem::setPosition(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="position")
    @io.qt.QtUninvokable
    public final void setPosition(io.qt.gui.QVector3D position){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @io.qt.QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#positionAbsolute-prop">QCustom3DItem::setPositionAbsolute(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="positionAbsolute")
    @io.qt.QtUninvokable
    public final void setPositionAbsolute(boolean positionAbsolute){
        setPositionAbsolute_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), positionAbsolute);
    }
    
    @io.qt.QtUninvokable
    private native void setPositionAbsolute_native_bool(long __this__nativeId, boolean positionAbsolute);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#rotation-prop">QCustom3DItem::setRotation(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotation")
    @io.qt.QtUninvokable
    public final void setRotation(io.qt.gui.QQuaternion rotation){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    @io.qt.QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#setRotationAxisAndAngle">QCustom3DItem::setRotationAxisAndAngle(QVector3D,float)</a></p>
     */
    public final void setRotationAxisAndAngle(io.qt.gui.QVector3D axis, float angle){
        setRotationAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native void setRotationAxisAndAngle_native_cref_QVector3D_float(long __this__nativeId, long axis, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scaling-prop">QCustom3DItem::setScaling(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scaling")
    @io.qt.QtUninvokable
    public final void setScaling(io.qt.gui.QVector3D scaling){
        setScaling_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scaling));
    }
    
    @io.qt.QtUninvokable
    private native void setScaling_native_cref_QVector3D(long __this__nativeId, long scaling);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#scalingAbsolute-prop">QCustom3DItem::setScalingAbsolute(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scalingAbsolute")
    @io.qt.QtUninvokable
    public final void setScalingAbsolute(boolean scalingAbsolute){
        setScalingAbsolute_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), scalingAbsolute);
    }
    
    @io.qt.QtUninvokable
    private native void setScalingAbsolute_native_bool(long __this__nativeId, boolean scalingAbsolute);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#shadowCasting-prop">QCustom3DItem::setShadowCasting(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="shadowCasting")
    @io.qt.QtUninvokable
    public final void setShadowCasting(boolean enabled){
        setShadowCasting_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setShadowCasting_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#textureFile-prop">QCustom3DItem::setTextureFile(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureFile")
    @io.qt.QtUninvokable
    public final void setTextureFile(java.lang.String textureFile){
        setTextureFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), textureFile);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureFile_native_cref_QString(long __this__nativeId, java.lang.String textureFile);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#setTextureImage">QCustom3DItem::setTextureImage(QImage)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTextureImage(io.qt.gui.QImage textureImage){
        setTextureImage_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @io.qt.QtUninvokable
    private native void setTextureImage_native_cref_QImage(long __this__nativeId, long textureImage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#visible-prop">QCustom3DItem::setVisible(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="visible")
    @io.qt.QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @io.qt.QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcustom3ditem.html#textureFile-prop">QCustom3DItem::textureFile()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureFile")
    @io.qt.QtUninvokable
    public final java.lang.String textureFile(){
        return textureFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String textureFile_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QCustom3DItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QCustom3DItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QCustom3DItem instance, QDeclarativeConstructor constructor);
    
}
