package io.qt.datavis;


/**
 * <p>Methods for rendering 3D scatter graphs</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/q3dscatter.html">Q3DScatter</a></p>
 */
public class Q3DScatter extends io.qt.datavis.QAbstract3DGraph
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DScatter.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisX-prop">Q3DScatter::axisXChanged(QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisX")
    public final Signal1<io.qt.datavis.QValue3DAxis> axisXChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisY-prop">Q3DScatter::axisYChanged(QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisY")
    public final Signal1<io.qt.datavis.QValue3DAxis> axisYChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisZ-prop">Q3DScatter::axisZChanged(QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisZ")
    public final Signal1<io.qt.datavis.QValue3DAxis> axisZChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#selectedSeries-prop">Q3DScatter::selectedSeriesChanged(QScatter3DSeries*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedSeries")
    public final Signal1<io.qt.datavis.QScatter3DSeries> selectedSeriesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DScatter(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DScatter(io.qt.gui.QSurfaceFormat format) {
        this(format, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #Q3DScatter(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>format = null</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public Q3DScatter() {
        this((io.qt.gui.QSurfaceFormat)null, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#Q3DScatter">Q3DScatter::Q3DScatter(const QSurfaceFormat*,QWindow*)</a></p>
     */
    public Q3DScatter(io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, format, parent);
    }
    
    private native static void initialize_native(Q3DScatter instance, io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#addAxis">Q3DScatter::addAxis(QValue3DAxis*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addAxis(io.qt.datavis.QValue3DAxis axis){
        addAxis_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void addAxis_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#addSeries">Q3DScatter::addSeries(QScatter3DSeries*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addSeries(io.qt.datavis.QScatter3DSeries series){
        addSeries_native_QScatter3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void addSeries_native_QScatter3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axes">Q3DScatter::axes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QValue3DAxis> axes(){
        return axes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QValue3DAxis> axes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisX-prop">Q3DScatter::axisX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisX")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QValue3DAxis axisX(){
        return axisX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisY-prop">Q3DScatter::axisY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisY")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QValue3DAxis axisY(){
        return axisY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#axisZ">Q3DScatter::axisZ()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisZ")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QValue3DAxis axisZ(){
        return axisZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#releaseAxis">Q3DScatter::releaseAxis(QValue3DAxis*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void releaseAxis(io.qt.datavis.QValue3DAxis axis){
        releaseAxis_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void releaseAxis_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#removeSeries">Q3DScatter::removeSeries(QScatter3DSeries*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeSeries(io.qt.datavis.QScatter3DSeries series){
        removeSeries_native_QScatter3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void removeSeries_native_QScatter3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#selectedSeries-prop">Q3DScatter::selectedSeries()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedSeries")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QScatter3DSeries selectedSeries(){
        return selectedSeries_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QScatter3DSeries selectedSeries_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#seriesList">Q3DScatter::seriesList()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QScatter3DSeries> seriesList(){
        return seriesList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QScatter3DSeries> seriesList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#setAxisX">Q3DScatter::setAxisX(QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axisX")
    @io.qt.QtUninvokable
    public final void setAxisX(io.qt.datavis.QValue3DAxis axis){
        setAxisX_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setAxisX_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#setAxisY">Q3DScatter::setAxisY(QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axisY")
    @io.qt.QtUninvokable
    public final void setAxisY(io.qt.datavis.QValue3DAxis axis){
        setAxisY_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setAxisY_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscatter.html#setAxisZ">Q3DScatter::setAxisZ(QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axisZ")
    @io.qt.QtUninvokable
    public final void setAxisZ(io.qt.datavis.QValue3DAxis axis){
        setAxisZ_native_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setAxisZ_native_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DScatter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DScatter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DScatter instance, QDeclarativeConstructor constructor);
    
}
