package io.qt.datavis;


/**
 * <p>Description of the 3D scene being visualized</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/q3dscene.html">Q3DScene</a></p>
 */
public class Q3DScene extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DScene.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeCamera-prop">Q3DScene::activeCameraChanged(Q3DCamera*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeCamera")
    public final Signal1<io.qt.datavis.Q3DCamera> activeCameraChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeLight-prop">Q3DScene::activeLightChanged(Q3DLight*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeLight")
    public final Signal1<io.qt.datavis.Q3DLight> activeLightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#devicePixelRatio-prop">Q3DScene::devicePixelRatioChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="devicePixelRatio")
    public final Signal1<@io.qt.QtPrimitiveType Float> devicePixelRatioChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#graphPositionQuery-prop">Q3DScene::graphPositionQueryChanged(QPoint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="graphPositionQuery")
    public final Signal1<io.qt.core.QPoint> graphPositionQueryChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#primarySubViewport-prop">Q3DScene::primarySubViewportChanged(QRect)</a></p>
     */
    @io.qt.QtPropertyNotify(name="primarySubViewport")
    public final Signal1<io.qt.core.QRect> primarySubViewportChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubViewport-prop">Q3DScene::secondarySubViewportChanged(QRect)</a></p>
     */
    @io.qt.QtPropertyNotify(name="secondarySubViewport")
    public final Signal1<io.qt.core.QRect> secondarySubViewportChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubviewOnTop-prop">Q3DScene::secondarySubviewOnTopChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="secondarySubviewOnTop")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> secondarySubviewOnTopChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#selectionQueryPosition-prop">Q3DScene::selectionQueryPositionChanged(QPoint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectionQueryPosition")
    public final Signal1<io.qt.core.QPoint> selectionQueryPositionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#slicingActive-prop">Q3DScene::slicingActiveChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="slicingActive")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> slicingActiveChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#viewport-prop">Q3DScene::viewportChanged(QRect)</a></p>
     */
    @io.qt.QtPropertyNotify(name="viewport")
    public final Signal1<io.qt.core.QRect> viewportChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DScene(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DScene() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#Q3DScene">Q3DScene::Q3DScene(QObject*)</a></p>
     */
    public Q3DScene(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DScene instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeCamera-prop">Q3DScene::activeCamera()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeCamera")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DCamera activeCamera(){
        return activeCamera_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.Q3DCamera activeCamera_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeLight-prop">Q3DScene::activeLight()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeLight")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DLight activeLight(){
        return activeLight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.Q3DLight activeLight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#devicePixelRatio-prop">Q3DScene::devicePixelRatio()const</a></p>
     */
    @io.qt.QtPropertyReader(name="devicePixelRatio")
    @io.qt.QtUninvokable
    public final float devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#graphPositionQuery-prop">Q3DScene::graphPositionQuery()const</a></p>
     */
    @io.qt.QtPropertyReader(name="graphPositionQuery")
    @io.qt.QtUninvokable
    public final io.qt.core.QPoint graphPositionQuery(){
        return graphPositionQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPoint graphPositionQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#isPointInPrimarySubView">Q3DScene::isPointInPrimarySubView(QPoint)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isPointInPrimarySubView(io.qt.core.QPoint point){
        return isPointInPrimarySubView_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPointInPrimarySubView_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#isPointInSecondarySubView">Q3DScene::isPointInSecondarySubView(QPoint)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isPointInSecondarySubView(io.qt.core.QPoint point){
        return isPointInSecondarySubView_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPointInSecondarySubView_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubviewOnTop-prop">Q3DScene::isSecondarySubviewOnTop()const</a></p>
     */
    @io.qt.QtPropertyReader(name="secondarySubviewOnTop")
    @io.qt.QtUninvokable
    public final boolean isSecondarySubviewOnTop(){
        return isSecondarySubviewOnTop_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSecondarySubviewOnTop_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#slicingActive-prop">Q3DScene::isSlicingActive()const</a></p>
     */
    @io.qt.QtPropertyReader(name="slicingActive")
    @io.qt.QtUninvokable
    public final boolean isSlicingActive(){
        return isSlicingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSlicingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#primarySubViewport-prop">Q3DScene::primarySubViewport()const</a></p>
     */
    @io.qt.QtPropertyReader(name="primarySubViewport")
    @io.qt.QtUninvokable
    public final io.qt.core.QRect primarySubViewport(){
        return primarySubViewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRect primarySubViewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubViewport-prop">Q3DScene::secondarySubViewport()const</a></p>
     */
    @io.qt.QtPropertyReader(name="secondarySubViewport")
    @io.qt.QtUninvokable
    public final io.qt.core.QRect secondarySubViewport(){
        return secondarySubViewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRect secondarySubViewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#selectionQueryPosition-prop">Q3DScene::selectionQueryPosition()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectionQueryPosition")
    @io.qt.QtUninvokable
    public final io.qt.core.QPoint selectionQueryPosition(){
        return selectionQueryPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPoint selectionQueryPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeCamera-prop">Q3DScene::setActiveCamera(Q3DCamera*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="activeCamera")
    @io.qt.QtUninvokable
    public final void setActiveCamera(io.qt.datavis.Q3DCamera camera){
        setActiveCamera_native_Q3DCamera_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(camera));
    }
    
    @io.qt.QtUninvokable
    private native void setActiveCamera_native_Q3DCamera_ptr(long __this__nativeId, long camera);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#activeLight-prop">Q3DScene::setActiveLight(Q3DLight*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="activeLight")
    @io.qt.QtUninvokable
    public final void setActiveLight(io.qt.datavis.Q3DLight light){
        setActiveLight_native_Q3DLight_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(light));
    }
    
    @io.qt.QtUninvokable
    private native void setActiveLight_native_Q3DLight_ptr(long __this__nativeId, long light);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#devicePixelRatio-prop">Q3DScene::setDevicePixelRatio(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="devicePixelRatio")
    @io.qt.QtUninvokable
    public final void setDevicePixelRatio(float pixelRatio){
        setDevicePixelRatio_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), pixelRatio);
    }
    
    @io.qt.QtUninvokable
    private native void setDevicePixelRatio_native_float(long __this__nativeId, float pixelRatio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#graphPositionQuery-prop">Q3DScene::setGraphPositionQuery(QPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="graphPositionQuery")
    @io.qt.QtUninvokable
    public final void setGraphPositionQuery(io.qt.core.QPoint point){
        setGraphPositionQuery_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native void setGraphPositionQuery_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#primarySubViewport-prop">Q3DScene::setPrimarySubViewport(QRect)</a></p>
     */
    @io.qt.QtPropertyWriter(name="primarySubViewport")
    @io.qt.QtUninvokable
    public final void setPrimarySubViewport(io.qt.core.QRect primarySubViewport){
        setPrimarySubViewport_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(primarySubViewport));
    }
    
    @io.qt.QtUninvokable
    private native void setPrimarySubViewport_native_cref_QRect(long __this__nativeId, long primarySubViewport);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubViewport-prop">Q3DScene::setSecondarySubViewport(QRect)</a></p>
     */
    @io.qt.QtPropertyWriter(name="secondarySubViewport")
    @io.qt.QtUninvokable
    public final void setSecondarySubViewport(io.qt.core.QRect secondarySubViewport){
        setSecondarySubViewport_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(secondarySubViewport));
    }
    
    @io.qt.QtUninvokable
    private native void setSecondarySubViewport_native_cref_QRect(long __this__nativeId, long secondarySubViewport);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#secondarySubviewOnTop-prop">Q3DScene::setSecondarySubviewOnTop(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="secondarySubviewOnTop")
    @io.qt.QtUninvokable
    public final void setSecondarySubviewOnTop(boolean isSecondaryOnTop){
        setSecondarySubviewOnTop_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isSecondaryOnTop);
    }
    
    @io.qt.QtUninvokable
    private native void setSecondarySubviewOnTop_native_bool(long __this__nativeId, boolean isSecondaryOnTop);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#selectionQueryPosition-prop">Q3DScene::setSelectionQueryPosition(QPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="selectionQueryPosition")
    @io.qt.QtUninvokable
    public final void setSelectionQueryPosition(io.qt.core.QPoint point){
        setSelectionQueryPosition_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native void setSelectionQueryPosition_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#slicingActive-prop">Q3DScene::setSlicingActive(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="slicingActive")
    @io.qt.QtUninvokable
    public final void setSlicingActive(boolean isSlicing){
        setSlicingActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isSlicing);
    }
    
    @io.qt.QtUninvokable
    private native void setSlicingActive_native_bool(long __this__nativeId, boolean isSlicing);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#viewport-prop">Q3DScene::viewport()const</a></p>
     */
    @io.qt.QtPropertyReader(name="viewport")
    @io.qt.QtUninvokable
    public final io.qt.core.QRect viewport(){
        return viewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRect viewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dscene.html#invalidSelectionPoint">Q3DScene::invalidSelectionPoint()</a></p>
     */
    public native static io.qt.core.QPoint invalidSelectionPoint();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DScene(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DScene(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DScene instance, QDeclarativeConstructor constructor);
    
}
