package io.qt.datavis;


/**
 * <p>Base proxy class for Q3DSurface</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html">QHeightMapSurfaceDataProxy</a></p>
 */
public class QHeightMapSurfaceDataProxy extends io.qt.datavis.QSurfaceDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHeightMapSurfaceDataProxy.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMap-prop">QHeightMapSurfaceDataProxy::heightMapChanged(QImage)</a></p>
     */
    @io.qt.QtPropertyNotify(name="heightMap")
    public final Signal1<io.qt.gui.QImage> heightMapChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMapFile-prop">QHeightMapSurfaceDataProxy::heightMapFileChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="heightMapFile")
    public final Signal1<java.lang.String> heightMapFileChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::maxXValueChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="maxXValue")
    public final Signal1<@io.qt.QtPrimitiveType Float> maxXValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::maxZValueChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="maxZValue")
    public final Signal1<@io.qt.QtPrimitiveType Float> maxZValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::minXValueChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="minXValue")
    public final Signal1<@io.qt.QtPrimitiveType Float> minXValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::minZValueChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="minZValue")
    public final Signal1<@io.qt.QtPrimitiveType Float> minZValueChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy">QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(QObject*)</a></p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(io.qt.gui.QImage, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.gui.QImage image) {
        this(image, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy-1">QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(QImage,QObject*)</a></p>
     */
    public QHeightMapSurfaceDataProxy(io.qt.gui.QImage image, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, image, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, io.qt.gui.QImage image, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QHeightMapSurfaceDataProxy(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHeightMapSurfaceDataProxy(java.lang.String filename) {
        this(filename, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#QHeightMapSurfaceDataProxy-2">QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(QString,QObject*)</a></p>
     */
    public QHeightMapSurfaceDataProxy(java.lang.String filename, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, filename, parent);
    }
    
    private native static void initialize_native(QHeightMapSurfaceDataProxy instance, java.lang.String filename, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMap-prop">QHeightMapSurfaceDataProxy::heightMap()const</a></p>
     */
    @io.qt.QtPropertyReader(name="heightMap")
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage heightMap(){
        return heightMap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage heightMap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#heightMapFile-prop">QHeightMapSurfaceDataProxy::heightMapFile()const</a></p>
     */
    @io.qt.QtPropertyReader(name="heightMapFile")
    @io.qt.QtUninvokable
    public final java.lang.String heightMapFile(){
        return heightMapFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String heightMapFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::maxXValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxXValue")
    @io.qt.QtUninvokable
    public final float maxXValue(){
        return maxXValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float maxXValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::maxZValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxZValue")
    @io.qt.QtUninvokable
    public final float maxZValue(){
        return maxZValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float maxZValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::minXValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="minXValue")
    @io.qt.QtUninvokable
    public final float minXValue(){
        return minXValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float minXValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::minZValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="minZValue")
    @io.qt.QtUninvokable
    public final float minZValue(){
        return minZValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float minZValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setHeightMap">QHeightMapSurfaceDataProxy::setHeightMap(QImage)</a></p>
     */
    @io.qt.QtPropertyWriter(name="heightMap")
    @io.qt.QtUninvokable
    public final void setHeightMap(io.qt.gui.QImage image){
        setHeightMap_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    @io.qt.QtUninvokable
    private native void setHeightMap_native_cref_QImage(long __this__nativeId, long image);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setHeightMapFile">QHeightMapSurfaceDataProxy::setHeightMapFile(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="heightMapFile")
    @io.qt.QtUninvokable
    public final void setHeightMapFile(java.lang.String filename){
        setHeightMapFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filename);
    }
    
    @io.qt.QtUninvokable
    private native void setHeightMapFile_native_cref_QString(long __this__nativeId, java.lang.String filename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxXValue-prop">QHeightMapSurfaceDataProxy::setMaxXValue(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="maxXValue")
    @io.qt.QtUninvokable
    public final void setMaxXValue(float max){
        setMaxXValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @io.qt.QtUninvokable
    private native void setMaxXValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#maxZValue-prop">QHeightMapSurfaceDataProxy::setMaxZValue(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="maxZValue")
    @io.qt.QtUninvokable
    public final void setMaxZValue(float max){
        setMaxZValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @io.qt.QtUninvokable
    private native void setMaxZValue_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minXValue-prop">QHeightMapSurfaceDataProxy::setMinXValue(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="minXValue")
    @io.qt.QtUninvokable
    public final void setMinXValue(float min){
        setMinXValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @io.qt.QtUninvokable
    private native void setMinXValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#minZValue-prop">QHeightMapSurfaceDataProxy::setMinZValue(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="minZValue")
    @io.qt.QtUninvokable
    public final void setMinZValue(float min){
        setMinZValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @io.qt.QtUninvokable
    private native void setMinZValue_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qheightmapsurfacedataproxy.html#setValueRanges">QHeightMapSurfaceDataProxy::setValueRanges(float,float,float,float)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setValueRanges(float minX, float maxX, float minZ, float maxZ){
        setValueRanges_native_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), minX, maxX, minZ, maxZ);
    }
    
    @io.qt.QtUninvokable
    private native void setValueRanges_native_float_float_float_float(long __this__nativeId, float minX, float maxX, float minZ, float maxZ);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QHeightMapSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QHeightMapSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QHeightMapSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
}
