package io.qt.datavis;


/**
 * <p>Window and render loop for graphs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qabstract3dgraph.html">QAbstract3DGraph</a></p>
 */
public class QAbstract3DGraph extends io.qt.gui.QWindow
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DGraph.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3dgraph.html#ElementType-enum">QAbstract3DGraph::ElementType</a></p>
     */
    public enum ElementType implements io.qt.QtEnumerator {
        ElementNone(0),
        ElementSeries(1),
        ElementAxisXLabel(2),
        ElementAxisYLabel(3),
        ElementAxisZLabel(4),
        ElementCustomItem(5);

        private ElementType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ElementType resolve(int value) {
            switch (value) {
            case 0: return ElementNone;
            case 1: return ElementSeries;
            case 2: return ElementAxisXLabel;
            case 3: return ElementAxisYLabel;
            case 4: return ElementAxisZLabel;
            case 5: return ElementCustomItem;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3dgraph.html#OptimizationHint-enum">QAbstract3DGraph::OptimizationHint</a></p>
     * 
     * @see OptimizationHints
     */
    public enum OptimizationHint implements io.qt.QtFlagEnumerator {
        OptimizationDefault(0),
        OptimizationStatic(1);

        private OptimizationHint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public OptimizationHints asFlags() {
            return new OptimizationHints(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public OptimizationHints combined(OptimizationHint e) {
            return new OptimizationHints(this, e);
        }

        /**
         * Creates a new {@link OptimizationHints} from the entries.
         * @param values entries
         * @return new flag
         */
        public static OptimizationHints flags(OptimizationHint ... values) {
            return new OptimizationHints(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static OptimizationHint resolve(int value) {
            switch (value) {
            case 0: return OptimizationDefault;
            case 1: return OptimizationStatic;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link OptimizationHint}
     */
    public static final class OptimizationHints extends io.qt.QFlags<OptimizationHint> implements Comparable<OptimizationHints> {
        private static final long serialVersionUID = 0xc1f9e34912806440L;

        /**
         * Creates a new OptimizationHints where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public OptimizationHints(OptimizationHint ... args){
            super(args);
        }

        /**
         * Creates a new OptimizationHints with given <code>value</code>.
         * @param value
         */
        public OptimizationHints(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new OptimizationHints
         */
        @Override
        public final OptimizationHints combined(OptimizationHint e){
            return new OptimizationHints(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final OptimizationHints setFlag(OptimizationHint e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final OptimizationHints setFlag(OptimizationHint e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this OptimizationHints.
         * @return array of enum entries
         */
        @Override
        public final OptimizationHint[] flags(){
            return super.flags(OptimizationHint.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final OptimizationHints clone(){
            return new OptimizationHints(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(OptimizationHints other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3dgraph.html#SelectionFlag-enum">QAbstract3DGraph::SelectionFlag</a></p>
     * 
     * @see SelectionFlags
     */
    public enum SelectionFlag implements io.qt.QtFlagEnumerator {
        SelectionNone(0),
        SelectionItem(1),
        SelectionRow(2),
        SelectionItemAndRow(3),
        SelectionColumn(4),
        SelectionItemAndColumn(5),
        SelectionRowAndColumn(6),
        SelectionItemRowAndColumn(7),
        SelectionSlice(8),
        SelectionMultiSeries(16);

        private SelectionFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public SelectionFlags asFlags() {
            return new SelectionFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public SelectionFlags combined(SelectionFlag e) {
            return new SelectionFlags(this, e);
        }

        /**
         * Creates a new {@link SelectionFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static SelectionFlags flags(SelectionFlag ... values) {
            return new SelectionFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SelectionFlag resolve(int value) {
            switch (value) {
            case 0: return SelectionNone;
            case 1: return SelectionItem;
            case 2: return SelectionRow;
            case 3: return SelectionItemAndRow;
            case 4: return SelectionColumn;
            case 5: return SelectionItemAndColumn;
            case 6: return SelectionRowAndColumn;
            case 7: return SelectionItemRowAndColumn;
            case 8: return SelectionSlice;
            case 16: return SelectionMultiSeries;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link SelectionFlag}
     */
    public static final class SelectionFlags extends io.qt.QFlags<SelectionFlag> implements Comparable<SelectionFlags> {
        private static final long serialVersionUID = 0x94dda626326e2012L;

        /**
         * Creates a new SelectionFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public SelectionFlags(SelectionFlag ... args){
            super(args);
        }

        /**
         * Creates a new SelectionFlags with given <code>value</code>.
         * @param value
         */
        public SelectionFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new SelectionFlags
         */
        @Override
        public final SelectionFlags combined(SelectionFlag e){
            return new SelectionFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final SelectionFlags setFlag(SelectionFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final SelectionFlags setFlag(SelectionFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this SelectionFlags.
         * @return array of enum entries
         */
        @Override
        public final SelectionFlag[] flags(){
            return super.flags(SelectionFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final SelectionFlags clone(){
            return new SelectionFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(SelectionFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstract3dgraph.html#ShadowQuality-enum">QAbstract3DGraph::ShadowQuality</a></p>
     */
    public enum ShadowQuality implements io.qt.QtEnumerator {
        ShadowQualityNone(0),
        ShadowQualityLow(1),
        ShadowQualityMedium(2),
        ShadowQualityHigh(3),
        ShadowQualitySoftLow(4),
        ShadowQualitySoftMedium(5),
        ShadowQualitySoftHigh(6);

        private ShadowQuality(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShadowQuality resolve(int value) {
            switch (value) {
            case 0: return ShadowQualityNone;
            case 1: return ShadowQualityLow;
            case 2: return ShadowQualityMedium;
            case 3: return ShadowQualityHigh;
            case 4: return ShadowQualitySoftLow;
            case 5: return ShadowQualitySoftMedium;
            case 6: return ShadowQualitySoftHigh;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeInputHandler-prop">QAbstract3DGraph::activeInputHandlerChanged(QAbstract3DInputHandler*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeInputHandler")
    public final Signal1<io.qt.datavis.QAbstract3DInputHandler> activeInputHandlerChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeTheme-prop">QAbstract3DGraph::activeThemeChanged(Q3DTheme*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeTheme")
    public final Signal1<io.qt.datavis.Q3DTheme> activeThemeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#aspectRatio-prop">QAbstract3DGraph::aspectRatioChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="aspectRatio")
    public final Signal1<@io.qt.QtPrimitiveType Double> aspectRatioChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#currentFps-prop">QAbstract3DGraph::currentFpsChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="currentFps")
    public final Signal1<@io.qt.QtPrimitiveType Double> currentFpsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#horizontalAspectRatio-prop">QAbstract3DGraph::horizontalAspectRatioChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="horizontalAspectRatio")
    public final Signal1<@io.qt.QtPrimitiveType Double> horizontalAspectRatioChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#locale-prop">QAbstract3DGraph::localeChanged(QLocale)</a></p>
     */
    @io.qt.QtPropertyNotify(name="locale")
    public final Signal1<io.qt.core.QLocale> localeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#margin-prop">QAbstract3DGraph::marginChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="margin")
    public final Signal1<@io.qt.QtPrimitiveType Double> marginChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#measureFps-prop">QAbstract3DGraph::measureFpsChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="measureFps")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> measureFpsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#optimizationHints-prop">QAbstract3DGraph::optimizationHintsChanged(QAbstract3DGraph::OptimizationHints)</a></p>
     */
    @io.qt.QtPropertyNotify(name="optimizationHints")
    public final Signal1<io.qt.datavis.QAbstract3DGraph.OptimizationHints> optimizationHintsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#orthoProjection-prop">QAbstract3DGraph::orthoProjectionChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="orthoProjection")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> orthoProjectionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#polar-prop">QAbstract3DGraph::polarChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="polar")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> polarChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#queriedGraphPosition-prop">QAbstract3DGraph::queriedGraphPositionChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="queriedGraphPosition")
    public final Signal1<io.qt.gui.QVector3D> queriedGraphPositionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#radialLabelOffset-prop">QAbstract3DGraph::radialLabelOffsetChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="radialLabelOffset")
    public final Signal1<@io.qt.QtPrimitiveType Float> radialLabelOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflection-prop">QAbstract3DGraph::reflectionChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="reflection")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> reflectionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflectivity-prop">QAbstract3DGraph::reflectivityChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="reflectivity")
    public final Signal1<@io.qt.QtPrimitiveType Double> reflectivityChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedElement-prop">QAbstract3DGraph::selectedElementChanged(QAbstract3DGraph::ElementType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedElement")
    public final Signal1<io.qt.datavis.QAbstract3DGraph.ElementType> selectedElementChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectionMode-prop">QAbstract3DGraph::selectionModeChanged(QAbstract3DGraph::SelectionFlags)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectionMode")
    public final Signal1<io.qt.datavis.QAbstract3DGraph.SelectionFlags> selectionModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#shadowQuality-prop">QAbstract3DGraph::shadowQualityChanged(QAbstract3DGraph::ShadowQuality)</a></p>
     */
    @io.qt.QtPropertyNotify(name="shadowQuality")
    public final Signal1<io.qt.datavis.QAbstract3DGraph.ShadowQuality> shadowQualityChanged = new Signal1<>();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeInputHandler-prop">QAbstract3DGraph::activeInputHandler()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeInputHandler")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DInputHandler activeInputHandler(){
        return activeInputHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QAbstract3DInputHandler activeInputHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#activeTheme-prop">QAbstract3DGraph::activeTheme()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeTheme")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DTheme activeTheme(){
        return activeTheme_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.Q3DTheme activeTheme_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#addCustomItem">QAbstract3DGraph::addCustomItem(QCustom3DItem*)</a></p>
     */
    @io.qt.QtUninvokable
    public final int addCustomItem(io.qt.datavis.QCustom3DItem item){
        return addCustomItem_native_QCustom3DItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native int addCustomItem_native_QCustom3DItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#addInputHandler">QAbstract3DGraph::addInputHandler(QAbstract3DInputHandler*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addInputHandler(io.qt.datavis.QAbstract3DInputHandler inputHandler){
        addInputHandler_native_QAbstract3DInputHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inputHandler));
    }
    
    @io.qt.QtUninvokable
    private native void addInputHandler_native_QAbstract3DInputHandler_ptr(long __this__nativeId, long inputHandler);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#addTheme">QAbstract3DGraph::addTheme(Q3DTheme*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addTheme(io.qt.datavis.Q3DTheme theme){
        addTheme_native_Q3DTheme_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(theme));
    }
    
    @io.qt.QtUninvokable
    private native void addTheme_native_Q3DTheme_ptr(long __this__nativeId, long theme);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#aspectRatio-prop">QAbstract3DGraph::aspectRatio()const</a></p>
     */
    @io.qt.QtPropertyReader(name="aspectRatio")
    @io.qt.QtUninvokable
    public final double aspectRatio(){
        return aspectRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double aspectRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#clearSelection">QAbstract3DGraph::clearSelection()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clearSelection(){
        clearSelection_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearSelection_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#currentFps-prop">QAbstract3DGraph::currentFps()const</a></p>
     */
    @io.qt.QtPropertyReader(name="currentFps")
    @io.qt.QtUninvokable
    public final double currentFps(){
        return currentFps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double currentFps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#customItems">QAbstract3DGraph::customItems()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QCustom3DItem> customItems(){
        return customItems_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QCustom3DItem> customItems_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final io.qt.gui.QOpenGLFunctions functions(){
        return functions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLFunctions functions_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#hasContext">QAbstract3DGraph::hasContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasContext(){
        return hasContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#horizontalAspectRatio-prop">QAbstract3DGraph::horizontalAspectRatio()const</a></p>
     */
    @io.qt.QtPropertyReader(name="horizontalAspectRatio")
    @io.qt.QtUninvokable
    public final double horizontalAspectRatio(){
        return horizontalAspectRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double horizontalAspectRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#inputHandlers">QAbstract3DGraph::inputHandlers()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QAbstract3DInputHandler> inputHandlers(){
        return inputHandlers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QAbstract3DInputHandler> inputHandlers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#orthoProjection-prop">QAbstract3DGraph::isOrthoProjection()const</a></p>
     */
    @io.qt.QtPropertyReader(name="orthoProjection")
    @io.qt.QtUninvokable
    public final boolean isOrthoProjection(){
        return isOrthoProjection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isOrthoProjection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#polar-prop">QAbstract3DGraph::isPolar()const</a></p>
     */
    @io.qt.QtPropertyReader(name="polar")
    @io.qt.QtUninvokable
    public final boolean isPolar(){
        return isPolar_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPolar_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflection-prop">QAbstract3DGraph::isReflection()const</a></p>
     */
    @io.qt.QtPropertyReader(name="reflection")
    @io.qt.QtUninvokable
    public final boolean isReflection(){
        return isReflection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isReflection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#locale-prop">QAbstract3DGraph::locale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="locale")
    @io.qt.QtUninvokable
    public final io.qt.core.QLocale locale(){
        return locale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QLocale locale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#margin-prop">QAbstract3DGraph::margin()const</a></p>
     */
    @io.qt.QtPropertyReader(name="margin")
    @io.qt.QtUninvokable
    public final double margin(){
        return margin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double margin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#measureFps-prop">QAbstract3DGraph::measureFps()const</a></p>
     */
    @io.qt.QtPropertyReader(name="measureFps")
    @io.qt.QtUninvokable
    public final boolean measureFps(){
        return measureFps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean measureFps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#optimizationHints-prop">QAbstract3DGraph::optimizationHints()const</a></p>
     */
    @io.qt.QtPropertyReader(name="optimizationHints")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.OptimizationHints optimizationHints(){
        return new io.qt.datavis.QAbstract3DGraph.OptimizationHints(optimizationHints_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int optimizationHints_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#queriedGraphPosition-prop">QAbstract3DGraph::queriedGraphPosition()const</a></p>
     */
    @io.qt.QtPropertyReader(name="queriedGraphPosition")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D queriedGraphPosition(){
        return queriedGraphPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D queriedGraphPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#radialLabelOffset-prop">QAbstract3DGraph::radialLabelOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="radialLabelOffset")
    @io.qt.QtUninvokable
    public final float radialLabelOffset(){
        return radialLabelOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float radialLabelOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflectivity-prop">QAbstract3DGraph::reflectivity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="reflectivity")
    @io.qt.QtUninvokable
    public final double reflectivity(){
        return reflectivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double reflectivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#releaseCustomItem">QAbstract3DGraph::releaseCustomItem(QCustom3DItem*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void releaseCustomItem(io.qt.datavis.QCustom3DItem item){
        releaseCustomItem_native_QCustom3DItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native void releaseCustomItem_native_QCustom3DItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#releaseInputHandler">QAbstract3DGraph::releaseInputHandler(QAbstract3DInputHandler*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void releaseInputHandler(io.qt.datavis.QAbstract3DInputHandler inputHandler){
        releaseInputHandler_native_QAbstract3DInputHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inputHandler));
    }
    
    @io.qt.QtUninvokable
    private native void releaseInputHandler_native_QAbstract3DInputHandler_ptr(long __this__nativeId, long inputHandler);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#releaseTheme">QAbstract3DGraph::releaseTheme(Q3DTheme*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void releaseTheme(io.qt.datavis.Q3DTheme theme){
        releaseTheme_native_Q3DTheme_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(theme));
    }
    
    @io.qt.QtUninvokable
    private native void releaseTheme_native_Q3DTheme_ptr(long __this__nativeId, long theme);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#removeCustomItem">QAbstract3DGraph::removeCustomItem(QCustom3DItem*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeCustomItem(io.qt.datavis.QCustom3DItem item){
        removeCustomItem_native_QCustom3DItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native void removeCustomItem_native_QCustom3DItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#removeCustomItemAt">QAbstract3DGraph::removeCustomItemAt(QVector3D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeCustomItemAt(io.qt.gui.QVector3D position){
        removeCustomItemAt_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @io.qt.QtUninvokable
    private native void removeCustomItemAt_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#removeCustomItems">QAbstract3DGraph::removeCustomItems()</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeCustomItems(){
        removeCustomItems_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void removeCustomItems_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #renderToImage(int, io.qt.core.QSize)}
     *  with <code>imageSize = new io.qt.core.QSize()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage renderToImage(int msaaSamples) {
        return renderToImage(msaaSamples, new io.qt.core.QSize());
    }
    
    /**
     * <p>Overloaded function for {@link #renderToImage(int, io.qt.core.QSize)}</p>
     * <p>with: </p><ul>
     * <li><code>msaaSamples = 0</code></li>
     * <li><code>imageSize = new io.qt.core.QSize()</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage renderToImage() {
        return renderToImage((int)0, new io.qt.core.QSize());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#renderToImage">QAbstract3DGraph::renderToImage(int,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage renderToImage(int msaaSamples, io.qt.core.QSize imageSize){
        return renderToImage_native_int_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), msaaSamples, QtJambi_LibraryUtilities.internal.checkedNativeId(imageSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage renderToImage_native_int_cref_QSize(long __this__nativeId, int msaaSamples, long imageSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#scene-prop">QAbstract3DGraph::scene()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scene")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DScene scene(){
        return scene_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.Q3DScene scene_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedAxis">QAbstract3DGraph::selectedAxis()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DAxis selectedAxis(){
        return selectedAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QAbstract3DAxis selectedAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedCustomItem">QAbstract3DGraph::selectedCustomItem()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QCustom3DItem selectedCustomItem(){
        return selectedCustomItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QCustom3DItem selectedCustomItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedCustomItemIndex">QAbstract3DGraph::selectedCustomItemIndex()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int selectedCustomItemIndex(){
        return selectedCustomItemIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int selectedCustomItemIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedElement-prop">QAbstract3DGraph::selectedElement()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedElement")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.ElementType selectedElement(){
        return io.qt.datavis.QAbstract3DGraph.ElementType.resolve(selectedElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int selectedElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectedLabelIndex">QAbstract3DGraph::selectedLabelIndex()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int selectedLabelIndex(){
        return selectedLabelIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int selectedLabelIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectionMode-prop">QAbstract3DGraph::selectionMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectionMode")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.SelectionFlags selectionMode(){
        return new io.qt.datavis.QAbstract3DGraph.SelectionFlags(selectionMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int selectionMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#setActiveInputHandler">QAbstract3DGraph::setActiveInputHandler(QAbstract3DInputHandler*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="activeInputHandler")
    @io.qt.QtUninvokable
    public final void setActiveInputHandler(io.qt.datavis.QAbstract3DInputHandler inputHandler){
        setActiveInputHandler_native_QAbstract3DInputHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inputHandler));
    }
    
    @io.qt.QtUninvokable
    private native void setActiveInputHandler_native_QAbstract3DInputHandler_ptr(long __this__nativeId, long inputHandler);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#setActiveTheme">QAbstract3DGraph::setActiveTheme(Q3DTheme*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="activeTheme")
    @io.qt.QtUninvokable
    public final void setActiveTheme(io.qt.datavis.Q3DTheme theme){
        setActiveTheme_native_Q3DTheme_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(theme));
    }
    
    @io.qt.QtUninvokable
    private native void setActiveTheme_native_Q3DTheme_ptr(long __this__nativeId, long theme);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#aspectRatio-prop">QAbstract3DGraph::setAspectRatio(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="aspectRatio")
    @io.qt.QtUninvokable
    public final void setAspectRatio(double ratio){
        setAspectRatio_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), ratio);
    }
    
    @io.qt.QtUninvokable
    private native void setAspectRatio_native_qreal(long __this__nativeId, double ratio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#horizontalAspectRatio-prop">QAbstract3DGraph::setHorizontalAspectRatio(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="horizontalAspectRatio")
    @io.qt.QtUninvokable
    public final void setHorizontalAspectRatio(double ratio){
        setHorizontalAspectRatio_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), ratio);
    }
    
    @io.qt.QtUninvokable
    private native void setHorizontalAspectRatio_native_qreal(long __this__nativeId, double ratio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#locale-prop">QAbstract3DGraph::setLocale(QLocale)</a></p>
     */
    @io.qt.QtPropertyWriter(name="locale")
    @io.qt.QtUninvokable
    public final void setLocale(io.qt.core.QLocale locale){
        setLocale_native_cref_QLocale(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(locale));
    }
    
    @io.qt.QtUninvokable
    private native void setLocale_native_cref_QLocale(long __this__nativeId, long locale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#margin-prop">QAbstract3DGraph::setMargin(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="margin")
    @io.qt.QtUninvokable
    public final void setMargin(double margin){
        setMargin_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), margin);
    }
    
    @io.qt.QtUninvokable
    private native void setMargin_native_qreal(long __this__nativeId, double margin);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#measureFps-prop">QAbstract3DGraph::setMeasureFps(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="measureFps")
    @io.qt.QtUninvokable
    public final void setMeasureFps(boolean enable){
        setMeasureFps_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setMeasureFps_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>Overloaded function for {@link #setOptimizationHints(io.qt.datavis.QAbstract3DGraph.OptimizationHints)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setOptimizationHints(io.qt.datavis.QAbstract3DGraph.OptimizationHint ... hints){
        setOptimizationHints(new io.qt.datavis.QAbstract3DGraph.OptimizationHints(hints));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#optimizationHints-prop">QAbstract3DGraph::setOptimizationHints(OptimizationHints)</a></p>
     */
    @io.qt.QtPropertyWriter(name="optimizationHints")
    @io.qt.QtUninvokable
    public final void setOptimizationHints(io.qt.datavis.QAbstract3DGraph.OptimizationHints hints){
        setOptimizationHints_native_QFlags_QAbstract3DGraph_OptimizationHint_(QtJambi_LibraryUtilities.internal.nativeId(this), hints.value());
    }
    
    @io.qt.QtUninvokable
    private native void setOptimizationHints_native_QFlags_QAbstract3DGraph_OptimizationHint_(long __this__nativeId, int hints);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#orthoProjection-prop">QAbstract3DGraph::setOrthoProjection(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="orthoProjection")
    @io.qt.QtUninvokable
    public final void setOrthoProjection(boolean enable){
        setOrthoProjection_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setOrthoProjection_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#polar-prop">QAbstract3DGraph::setPolar(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="polar")
    @io.qt.QtUninvokable
    public final void setPolar(boolean enable){
        setPolar_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setPolar_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#radialLabelOffset-prop">QAbstract3DGraph::setRadialLabelOffset(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="radialLabelOffset")
    @io.qt.QtUninvokable
    public final void setRadialLabelOffset(float offset){
        setRadialLabelOffset_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    @io.qt.QtUninvokable
    private native void setRadialLabelOffset_native_float(long __this__nativeId, float offset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflection-prop">QAbstract3DGraph::setReflection(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="reflection")
    @io.qt.QtUninvokable
    public final void setReflection(boolean enable){
        setReflection_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setReflection_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#reflectivity-prop">QAbstract3DGraph::setReflectivity(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="reflectivity")
    @io.qt.QtUninvokable
    public final void setReflectivity(double reflectivity){
        setReflectivity_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), reflectivity);
    }
    
    @io.qt.QtUninvokable
    private native void setReflectivity_native_qreal(long __this__nativeId, double reflectivity);
    
    /**
     * <p>Overloaded function for {@link #setSelectionMode(io.qt.datavis.QAbstract3DGraph.SelectionFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setSelectionMode(io.qt.datavis.QAbstract3DGraph.SelectionFlag ... mode){
        setSelectionMode(new io.qt.datavis.QAbstract3DGraph.SelectionFlags(mode));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#selectionMode-prop">QAbstract3DGraph::setSelectionMode(SelectionFlags)</a></p>
     */
    @io.qt.QtPropertyWriter(name="selectionMode")
    @io.qt.QtUninvokable
    public final void setSelectionMode(io.qt.datavis.QAbstract3DGraph.SelectionFlags mode){
        setSelectionMode_native_QFlags_QAbstract3DGraph_SelectionFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setSelectionMode_native_QFlags_QAbstract3DGraph_SelectionFlag_(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#shadowQuality-prop">QAbstract3DGraph::setShadowQuality(QAbstract3DGraph::ShadowQuality)</a></p>
     */
    @io.qt.QtPropertyWriter(name="shadowQuality")
    @io.qt.QtUninvokable
    public final void setShadowQuality(io.qt.datavis.QAbstract3DGraph.ShadowQuality quality){
        setShadowQuality_native_QAbstract3DGraph_ShadowQuality(QtJambi_LibraryUtilities.internal.nativeId(this), quality.value());
    }
    
    @io.qt.QtUninvokable
    private native void setShadowQuality_native_QAbstract3DGraph_ShadowQuality(long __this__nativeId, int quality);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#shadowQuality-prop">QAbstract3DGraph::shadowQuality()const</a></p>
     */
    @io.qt.QtPropertyReader(name="shadowQuality")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DGraph.ShadowQuality shadowQuality(){
        return io.qt.datavis.QAbstract3DGraph.ShadowQuality.resolve(shadowQuality_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int shadowQuality_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#themes">QAbstract3DGraph::themes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.Q3DTheme> themes(){
        return themes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.Q3DTheme> themes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent event){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#exposeEvent">QWindow::exposeEvent(QExposeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void exposeEvent(io.qt.gui.QExposeEvent event){
        exposeEvent_native_QExposeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void exposeEvent_native_QExposeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#mouseDoubleClickEvent">QWindow::mouseDoubleClickEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseDoubleClickEvent(io.qt.gui.QMouseEvent event){
        mouseDoubleClickEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mouseDoubleClickEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#mouseMoveEvent">QWindow::mouseMoveEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseMoveEvent(io.qt.gui.QMouseEvent event){
        mouseMoveEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#mousePressEvent">QWindow::mousePressEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mousePressEvent(io.qt.gui.QMouseEvent event){
        mousePressEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#mouseReleaseEvent">QWindow::mouseReleaseEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseReleaseEvent(io.qt.gui.QMouseEvent event){
        mouseReleaseEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#resizeEvent">QWindow::resizeEvent(QResizeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeEvent(io.qt.gui.QResizeEvent event){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstract3dgraph.html#shadowsSupported">QAbstract3DGraph::shadowsSupported()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean shadowsSupported(){
        return shadowsSupported_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean shadowsSupported_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#touchEvent">QWindow::touchEvent(QTouchEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void touchEvent(io.qt.gui.QTouchEvent event){
        touchEvent_native_QTouchEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void touchEvent_native_QTouchEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#wheelEvent">QWindow::wheelEvent(QWheelEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void wheelEvent(io.qt.gui.QWheelEvent event){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstract3DGraph(QPrivateConstructor p) { super(p); } 
    
}
