package io.qt.datavis;


/**
 * <p>Representation of a light source in 3D space</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/q3dlight.html">Q3DLight</a></p>
 */
public class Q3DLight extends io.qt.datavis.Q3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DLight.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dlight.html#autoPosition-prop">Q3DLight::autoPositionChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="autoPosition")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> autoPositionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DLight(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DLight() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dlight.html#Q3DLight">Q3DLight::Q3DLight(QObject*)</a></p>
     */
    public Q3DLight(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DLight instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dlight.html#autoPosition-prop">Q3DLight::isAutoPosition()</a></p>
     */
    @io.qt.QtPropertyReader(name="autoPosition")
    @io.qt.QtUninvokable
    public final boolean isAutoPosition(){
        return isAutoPosition_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAutoPosition_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dlight.html#autoPosition-prop">Q3DLight::setAutoPosition(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="autoPosition")
    @io.qt.QtUninvokable
    public final void setAutoPosition(boolean enabled){
        setAutoPosition_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoPosition_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DLight(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DLight(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DLight instance, QDeclarativeConstructor constructor);
    
}
