package io.qt.datavis;


/**
 * <p>Represents a data series in a 3D surface graph</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qsurface3dseries.html">QSurface3DSeries</a></p>
 */
public class QSurface3DSeries extends io.qt.datavis.QAbstract3DSeries
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSurface3DSeries.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsurface3dseries.html#DrawFlag-enum">QSurface3DSeries::DrawFlag</a></p>
     * 
     * @see DrawFlags
     */
    public enum DrawFlag implements io.qt.QtFlagEnumerator {
        DrawWireframe(1),
        DrawSurface(2),
        DrawSurfaceAndWireframe(3);

        private DrawFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public DrawFlags asFlags() {
            return new DrawFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public DrawFlags combined(DrawFlag e) {
            return new DrawFlags(this, e);
        }

        /**
         * Creates a new {@link DrawFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static DrawFlags flags(DrawFlag ... values) {
            return new DrawFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DrawFlag resolve(int value) {
            switch (value) {
            case 1: return DrawWireframe;
            case 2: return DrawSurface;
            case 3: return DrawSurfaceAndWireframe;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link DrawFlag}
     */
    public static final class DrawFlags extends io.qt.QFlags<DrawFlag> implements Comparable<DrawFlags> {
        private static final long serialVersionUID = 0xcc74b066c0184b89L;

        /**
         * Creates a new DrawFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public DrawFlags(DrawFlag ... args){
            super(args);
        }

        /**
         * Creates a new DrawFlags with given <code>value</code>.
         * @param value
         */
        public DrawFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new DrawFlags
         */
        @Override
        public final DrawFlags combined(DrawFlag e){
            return new DrawFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final DrawFlags setFlag(DrawFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final DrawFlags setFlag(DrawFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this DrawFlags.
         * @return array of enum entries
         */
        @Override
        public final DrawFlag[] flags(){
            return super.flags(DrawFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final DrawFlags clone(){
            return new DrawFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(DrawFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#dataProxy-prop">QSurface3DSeries::dataProxyChanged(QSurfaceDataProxy*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="dataProxy")
    public final Signal1<io.qt.datavis.QSurfaceDataProxy> dataProxyChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#drawMode-prop">QSurface3DSeries::drawModeChanged(QSurface3DSeries::DrawFlags)</a></p>
     */
    @io.qt.QtPropertyNotify(name="drawMode")
    public final Signal1<io.qt.datavis.QSurface3DSeries.DrawFlags> drawModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#flatShadingEnabled-prop">QSurface3DSeries::flatShadingEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="flatShadingEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> flatShadingEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#flatShadingSupported-prop">QSurface3DSeries::flatShadingSupportedChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="flatShadingSupported")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> flatShadingSupportedChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#selectedPoint-prop">QSurface3DSeries::selectedPointChanged(QPoint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedPoint")
    public final Signal1<io.qt.core.QPoint> selectedPointChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#texture-prop">QSurface3DSeries::textureChanged(QImage)</a></p>
     */
    @io.qt.QtPropertyNotify(name="texture")
    public final Signal1<io.qt.gui.QImage> textureChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#textureFile-prop">QSurface3DSeries::textureFileChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureFile")
    public final Signal1<java.lang.String> textureFileChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSurface3DSeries(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSurface3DSeries() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#QSurface3DSeries">QSurface3DSeries::QSurface3DSeries(QObject*)</a></p>
     */
    public QSurface3DSeries(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSurface3DSeries instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QSurface3DSeries(io.qt.datavis.QSurfaceDataProxy, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSurface3DSeries(io.qt.datavis.QSurfaceDataProxy dataProxy) {
        this(dataProxy, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#QSurface3DSeries-1">QSurface3DSeries::QSurface3DSeries(QSurfaceDataProxy*,QObject*)</a></p>
     */
    public QSurface3DSeries(io.qt.datavis.QSurfaceDataProxy dataProxy, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, dataProxy, parent);
    }
    
    private native static void initialize_native(QSurface3DSeries instance, io.qt.datavis.QSurfaceDataProxy dataProxy, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#dataProxy-prop">QSurface3DSeries::dataProxy()const</a></p>
     */
    @io.qt.QtPropertyReader(name="dataProxy")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QSurfaceDataProxy dataProxy(){
        return dataProxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QSurfaceDataProxy dataProxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#drawMode-prop">QSurface3DSeries::drawMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="drawMode")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QSurface3DSeries.DrawFlags drawMode(){
        return new io.qt.datavis.QSurface3DSeries.DrawFlags(drawMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int drawMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#flatShadingEnabled-prop">QSurface3DSeries::isFlatShadingEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="flatShadingEnabled")
    @io.qt.QtUninvokable
    public final boolean isFlatShadingEnabled(){
        return isFlatShadingEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFlatShadingEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#flatShadingSupported-prop">QSurface3DSeries::isFlatShadingSupported()const</a></p>
     */
    @io.qt.QtPropertyReader(name="flatShadingSupported")
    @io.qt.QtUninvokable
    public final boolean isFlatShadingSupported(){
        return isFlatShadingSupported_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFlatShadingSupported_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#selectedPoint-prop">QSurface3DSeries::selectedPoint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedPoint")
    @io.qt.QtUninvokable
    public final io.qt.core.QPoint selectedPoint(){
        return selectedPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPoint selectedPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#dataProxy-prop">QSurface3DSeries::setDataProxy(QSurfaceDataProxy*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="dataProxy")
    @io.qt.QtUninvokable
    public final void setDataProxy(io.qt.datavis.QSurfaceDataProxy proxy){
        if(proxy!=null){
                        if(proxy==dataProxy()){
                            throw new IllegalArgumentException("Proxy is already assigned to this series.");
                        }else if(proxy.series()!=null){
                            throw new IllegalArgumentException("Proxy is already assigned to another series.");
                        }
                    }
        java.util.Objects.requireNonNull(proxy, "Argument 'proxy': null not expected.");
        setDataProxy_native_QSurfaceDataProxy_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(proxy));
    }
    
    @io.qt.QtUninvokable
    private native void setDataProxy_native_QSurfaceDataProxy_ptr(long __this__nativeId, long proxy);
    
    /**
     * <p>Overloaded function for {@link #setDrawMode(io.qt.datavis.QSurface3DSeries.DrawFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setDrawMode(io.qt.datavis.QSurface3DSeries.DrawFlag ... mode){
        setDrawMode(new io.qt.datavis.QSurface3DSeries.DrawFlags(mode));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#drawMode-prop">QSurface3DSeries::setDrawMode(DrawFlags)</a></p>
     */
    @io.qt.QtPropertyWriter(name="drawMode")
    @io.qt.QtUninvokable
    public final void setDrawMode(io.qt.datavis.QSurface3DSeries.DrawFlags mode){
        setDrawMode_native_QFlags_QSurface3DSeries_DrawFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setDrawMode_native_QFlags_QSurface3DSeries_DrawFlag_(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#flatShadingEnabled-prop">QSurface3DSeries::setFlatShadingEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="flatShadingEnabled")
    @io.qt.QtUninvokable
    public final void setFlatShadingEnabled(boolean enabled){
        setFlatShadingEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setFlatShadingEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#setSelectedPoint">QSurface3DSeries::setSelectedPoint(QPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="selectedPoint")
    @io.qt.QtUninvokable
    public final void setSelectedPoint(io.qt.core.QPoint position){
        setSelectedPoint_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @io.qt.QtUninvokable
    private native void setSelectedPoint_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#texture-prop">QSurface3DSeries::setTexture(QImage)</a></p>
     */
    @io.qt.QtPropertyWriter(name="texture")
    @io.qt.QtUninvokable
    public final void setTexture(io.qt.gui.QImage texture){
        setTexture_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    @io.qt.QtUninvokable
    private native void setTexture_native_cref_QImage(long __this__nativeId, long texture);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#textureFile-prop">QSurface3DSeries::setTextureFile(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureFile")
    @io.qt.QtUninvokable
    public final void setTextureFile(java.lang.String filename){
        setTextureFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filename);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureFile_native_cref_QString(long __this__nativeId, java.lang.String filename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#texture-prop">QSurface3DSeries::texture()const</a></p>
     */
    @io.qt.QtPropertyReader(name="texture")
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage texture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#textureFile-prop">QSurface3DSeries::textureFile()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureFile")
    @io.qt.QtUninvokable
    public final java.lang.String textureFile(){
        return textureFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String textureFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsurface3dseries.html#invalidSelectionPosition">QSurface3DSeries::invalidSelectionPosition()</a></p>
     */
    public native static io.qt.core.QPoint invalidSelectionPosition();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSurface3DSeries(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSurface3DSeries(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSurface3DSeries instance, QDeclarativeConstructor constructor);
    
}
