package io.qt.datavis;


/**
 * <p>The data proxy for a 3D bars graph</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qbardataproxy.html">QBarDataProxy</a></p>
 */
public class QBarDataProxy extends io.qt.datavis.QAbstractDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBarDataProxy.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#arrayReset">QBarDataProxy::arrayReset()</a></p>
     */
    public final Signal0 arrayReset = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#columnLabels-prop">QBarDataProxy::columnLabelsChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnLabels")
    public final Signal0 columnLabelsChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#itemChanged">QBarDataProxy::itemChanged(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> itemChanged = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowCount-prop">QBarDataProxy::rowCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowCount")
    public final Signal1<@io.qt.QtPrimitiveType Integer> rowCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowLabels-prop">QBarDataProxy::rowLabelsChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowLabels")
    public final Signal0 rowLabelsChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowsAdded">QBarDataProxy::rowsAdded(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsAdded = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowsChanged">QBarDataProxy::rowsChanged(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsChanged = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowsInserted">QBarDataProxy::rowsInserted(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsInserted = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowsRemoved">QBarDataProxy::rowsRemoved(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsRemoved = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#series-prop">QBarDataProxy::seriesChanged(QBar3DSeries*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="series")
    public final Signal1<io.qt.datavis.QBar3DSeries> seriesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBarDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBarDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#QBarDataProxy">QBarDataProxy::QBarDataProxy(QObject*)</a></p>
     */
    public QBarDataProxy(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBarDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#addRow">QBarDataProxy::addRow(QBarDataRow*)</a></p>
     */
    @io.qt.QtUninvokable
    public final int addRow(io.qt.datavis.QBarDataRow row){
        return addRow_native_QBarDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @io.qt.QtUninvokable
    private native int addRow_native_QBarDataRow_ptr(long __this__nativeId, long row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#addRow-1">QBarDataProxy::addRow(QBarDataRow*,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final int addRow(io.qt.datavis.QBarDataRow row, java.lang.String label){
        return addRow_native_QBarDataRow_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row), label);
    }
    
    @io.qt.QtUninvokable
    private native int addRow_native_QBarDataRow_ptr_cref_QString(long __this__nativeId, long row, java.lang.String label);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#addRows">QBarDataProxy::addRows(QBarDataArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final int addRows(io.qt.datavis.QBarDataArray rows){
        return addRows_native_cref_QBarDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @io.qt.QtUninvokable
    private native int addRows_native_cref_QBarDataArray(long __this__nativeId, long rows);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#addRows-1">QBarDataProxy::addRows(QBarDataArray,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final int addRows(io.qt.datavis.QBarDataArray rows, java.util.Collection<java.lang.String> labels){
        return addRows_native_cref_QBarDataArray_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rows), labels);
    }
    
    @io.qt.QtUninvokable
    private native int addRows_native_cref_QBarDataArray_cref_QStringList(long __this__nativeId, long rows, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#array">QBarDataProxy::array()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBarDataArray array(){
        return array_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBarDataArray array_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#columnLabels-prop">QBarDataProxy::columnLabels()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnLabels")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList columnLabels(){
        return columnLabels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList columnLabels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#insertRow">QBarDataProxy::insertRow(int,QBarDataRow*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertRow(int rowIndex, io.qt.datavis.QBarDataRow row){
        insertRow_native_int_QBarDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @io.qt.QtUninvokable
    private native void insertRow_native_int_QBarDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#insertRow-1">QBarDataProxy::insertRow(int,QBarDataRow*,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertRow(int rowIndex, io.qt.datavis.QBarDataRow row, java.lang.String label){
        insertRow_native_int_QBarDataRow_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row), label);
    }
    
    @io.qt.QtUninvokable
    private native void insertRow_native_int_QBarDataRow_ptr_cref_QString(long __this__nativeId, int rowIndex, long row, java.lang.String label);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#insertRows">QBarDataProxy::insertRows(int,QBarDataArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertRows(int rowIndex, io.qt.datavis.QBarDataArray rows){
        insertRows_native_int_cref_QBarDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @io.qt.QtUninvokable
    private native void insertRows_native_int_cref_QBarDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#insertRows-1">QBarDataProxy::insertRows(int,QBarDataArray,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertRows(int rowIndex, io.qt.datavis.QBarDataArray rows, java.util.Collection<java.lang.String> labels){
        insertRows_native_int_cref_QBarDataArray_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows), labels);
    }
    
    @io.qt.QtUninvokable
    private native void insertRows_native_int_cref_QBarDataArray_cref_QStringList(long __this__nativeId, int rowIndex, long rows, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#itemAt-1">QBarDataProxy::itemAt(QPoint)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBarDataItem itemAt(io.qt.core.QPoint position){
        return itemAt_native_cref_QPoint_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBarDataItem itemAt_native_cref_QPoint_constfct(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#itemAt">QBarDataProxy::itemAt(int,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBarDataItem itemAt(int rowIndex, int columnIndex){
        return itemAt_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBarDataItem itemAt_native_int_int_constfct(long __this__nativeId, int rowIndex, int columnIndex);
    
    /**
     * <p>Overloaded function for {@link #removeRows(int, int, boolean)}
     *  with <code>removeLabels = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void removeRows(int rowIndex, int removeCount) {
        removeRows(rowIndex, removeCount, (boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#removeRows">QBarDataProxy::removeRows(int,int,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeRows(int rowIndex, int removeCount, boolean removeLabels){
        removeRows_native_int_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, removeCount, removeLabels);
    }
    
    @io.qt.QtUninvokable
    private native void removeRows_native_int_int_bool(long __this__nativeId, int rowIndex, int removeCount, boolean removeLabels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#resetArray">QBarDataProxy::resetArray()</a></p>
     */
    @io.qt.QtUninvokable
    public final void resetArray(){
        resetArray_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void resetArray_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#resetArray-1">QBarDataProxy::resetArray(QBarDataArray*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void resetArray(io.qt.datavis.QBarDataArray newArray){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcArray);
        resetArray_native_QBarDataArray_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), newArray);
        QtJambi_LibraryUtilities.internal.setCppOwnership(newArray);
        __rcArray = newArray;
                    QtJambi_LibraryUtilities.internal.registerDependentObject(__rcArray, this);
    }
    
    @io.qt.QtUninvokable
    private native void resetArray_native_QBarDataArray_ptr(long __this__nativeId, io.qt.datavis.QBarDataArray newArray);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#resetArray-2">QBarDataProxy::resetArray(QBarDataArray*,QStringList,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void resetArray(io.qt.datavis.QBarDataArray newArray, java.util.Collection<java.lang.String> rowLabels, java.util.Collection<java.lang.String> columnLabels){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcArray);
        resetArray_native_QBarDataArray_ptr_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), newArray, rowLabels, columnLabels);
        QtJambi_LibraryUtilities.internal.setCppOwnership(newArray);
        __rcArray = newArray;
                    QtJambi_LibraryUtilities.internal.registerDependentObject(__rcArray, this);
    }
    
    @io.qt.QtUninvokable
    private native void resetArray_native_QBarDataArray_ptr_cref_QStringList_cref_QStringList(long __this__nativeId, io.qt.datavis.QBarDataArray newArray, java.util.Collection<java.lang.String> rowLabels, java.util.Collection<java.lang.String> columnLabels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowAt">QBarDataProxy::rowAt(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBarDataRow rowAt(int rowIndex){
        return rowAt_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBarDataRow rowAt_native_int_constfct(long __this__nativeId, int rowIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowCount-prop">QBarDataProxy::rowCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowCount")
    @io.qt.QtUninvokable
    public final int rowCount(){
        return rowCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int rowCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowLabels-prop">QBarDataProxy::rowLabels()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowLabels")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList rowLabels(){
        return rowLabels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList rowLabels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#series-prop">QBarDataProxy::series()const</a></p>
     */
    @io.qt.QtPropertyReader(name="series")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBar3DSeries series(){
        return series_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBar3DSeries series_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#columnLabels-prop">QBarDataProxy::setColumnLabels(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnLabels")
    @io.qt.QtUninvokable
    public final void setColumnLabels(java.util.Collection<java.lang.String> labels){
        setColumnLabels_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), labels);
    }
    
    @io.qt.QtUninvokable
    private native void setColumnLabels_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#setItem-1">QBarDataProxy::setItem(QPoint,QBarDataItem)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setItem(io.qt.core.QPoint position, io.qt.datavis.QBarDataItem item){
        setItem_native_cref_QPoint_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native void setItem_native_cref_QPoint_cref_QBarDataItem(long __this__nativeId, long position, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#setItem">QBarDataProxy::setItem(int,int,QBarDataItem)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setItem(int rowIndex, int columnIndex, io.qt.datavis.QBarDataItem item){
        setItem_native_int_int_cref_QBarDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native void setItem_native_int_int_cref_QBarDataItem(long __this__nativeId, int rowIndex, int columnIndex, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#setRow">QBarDataProxy::setRow(int,QBarDataRow*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRow(int rowIndex, io.qt.datavis.QBarDataRow row){
        setRow_native_int_QBarDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @io.qt.QtUninvokable
    private native void setRow_native_int_QBarDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#setRow-1">QBarDataProxy::setRow(int,QBarDataRow*,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRow(int rowIndex, io.qt.datavis.QBarDataRow row, java.lang.String label){
        setRow_native_int_QBarDataRow_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row), label);
    }
    
    @io.qt.QtUninvokable
    private native void setRow_native_int_QBarDataRow_ptr_cref_QString(long __this__nativeId, int rowIndex, long row, java.lang.String label);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#rowLabels-prop">QBarDataProxy::setRowLabels(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowLabels")
    @io.qt.QtUninvokable
    public final void setRowLabels(java.util.Collection<java.lang.String> labels){
        setRowLabels_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), labels);
    }
    
    @io.qt.QtUninvokable
    private native void setRowLabels_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#setRows">QBarDataProxy::setRows(int,QBarDataArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRows(int rowIndex, io.qt.datavis.QBarDataArray rows){
        setRows_native_int_cref_QBarDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @io.qt.QtUninvokable
    private native void setRows_native_int_cref_QBarDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qbardataproxy.html#setRows-1">QBarDataProxy::setRows(int,QBarDataArray,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRows(int rowIndex, io.qt.datavis.QBarDataArray rows, java.util.Collection<java.lang.String> labels){
        setRows_native_int_cref_QBarDataArray_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows), labels);
    }
    
    @io.qt.QtUninvokable
    private native void setRows_native_int_cref_QBarDataArray_cref_QStringList(long __this__nativeId, int rowIndex, long rows, java.util.Collection<java.lang.String> labels);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBarDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QBarDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QBarDataProxy instance, QDeclarativeConstructor constructor);
    
    private QBarDataArray __rcArray;
}
