package io.qt.datavis;


/**
 * <p>Representation of a camera in 3D space</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/q3dcamera.html">Q3DCamera</a></p>
 */
public class Q3DCamera extends io.qt.datavis.Q3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DCamera.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/q3dcamera.html#CameraPreset-enum">Q3DCamera::CameraPreset</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum CameraPreset implements io.qt.QtEnumerator {
        CameraPresetNone(-1),
        CameraPresetFrontLow(0),
        CameraPresetFront(1),
        CameraPresetFrontHigh(2),
        CameraPresetLeftLow(3),
        CameraPresetLeft(4),
        CameraPresetLeftHigh(5),
        CameraPresetRightLow(6),
        CameraPresetRight(7),
        CameraPresetRightHigh(8),
        CameraPresetBehindLow(9),
        CameraPresetBehind(10),
        CameraPresetBehindHigh(11),
        CameraPresetIsometricLeft(12),
        CameraPresetIsometricLeftHigh(13),
        CameraPresetIsometricRight(14),
        CameraPresetIsometricRightHigh(15),
        CameraPresetDirectlyAbove(16),
        CameraPresetDirectlyAboveCW45(17),
        CameraPresetDirectlyAboveCCW45(18),
        CameraPresetFrontBelow(19),
        CameraPresetLeftBelow(20),
        CameraPresetRightBelow(21),
        CameraPresetBehindBelow(22),
        CameraPresetDirectlyBelow(23);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CameraPreset(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static CameraPreset resolve(int value) {
            switch (value) {
            case -1: return CameraPresetNone;
            case 0: return CameraPresetFrontLow;
            case 1: return CameraPresetFront;
            case 2: return CameraPresetFrontHigh;
            case 3: return CameraPresetLeftLow;
            case 4: return CameraPresetLeft;
            case 5: return CameraPresetLeftHigh;
            case 6: return CameraPresetRightLow;
            case 7: return CameraPresetRight;
            case 8: return CameraPresetRightHigh;
            case 9: return CameraPresetBehindLow;
            case 10: return CameraPresetBehind;
            case 11: return CameraPresetBehindHigh;
            case 12: return CameraPresetIsometricLeft;
            case 13: return CameraPresetIsometricLeftHigh;
            case 14: return CameraPresetIsometricRight;
            case 15: return CameraPresetIsometricRightHigh;
            case 16: return CameraPresetDirectlyAbove;
            case 17: return CameraPresetDirectlyAboveCW45;
            case 18: return CameraPresetDirectlyAboveCCW45;
            case 19: return CameraPresetFrontBelow;
            case 20: return CameraPresetLeftBelow;
            case 21: return CameraPresetRightBelow;
            case 22: return CameraPresetBehindBelow;
            case 23: return CameraPresetDirectlyBelow;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#cameraPreset-prop">Q3DCamera::cameraPresetChanged(Q3DCamera::CameraPreset)</a></p>
     */
    @io.qt.QtPropertyNotify(name="cameraPreset")
    public final Signal1<io.qt.datavis.Q3DCamera.CameraPreset> cameraPresetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#maxZoomLevel-prop">Q3DCamera::maxZoomLevelChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="maxZoomLevel")
    public final Signal1<@io.qt.QtPrimitiveType Float> maxZoomLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#minZoomLevel-prop">Q3DCamera::minZoomLevelChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="minZoomLevel")
    public final Signal1<@io.qt.QtPrimitiveType Float> minZoomLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#target-prop">Q3DCamera::targetChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="target")
    public final Signal1<io.qt.gui.QVector3D> targetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapXRotation-prop">Q3DCamera::wrapXRotationChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="wrapXRotation")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> wrapXRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapYRotation-prop">Q3DCamera::wrapYRotationChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="wrapYRotation")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> wrapYRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#xRotation-prop">Q3DCamera::xRotationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="xRotation")
    public final Signal1<@io.qt.QtPrimitiveType Float> xRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#yRotation-prop">Q3DCamera::yRotationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="yRotation")
    public final Signal1<@io.qt.QtPrimitiveType Float> yRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#zoomLevel-prop">Q3DCamera::zoomLevelChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="zoomLevel")
    public final Signal1<@io.qt.QtPrimitiveType Float> zoomLevelChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DCamera(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DCamera() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#Q3DCamera">Q3DCamera::Q3DCamera(QObject*)</a></p>
     */
    public Q3DCamera(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DCamera instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#cameraPreset-prop">Q3DCamera::cameraPreset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="cameraPreset")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DCamera.CameraPreset cameraPreset(){
        return io.qt.datavis.Q3DCamera.CameraPreset.resolve(cameraPreset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int cameraPreset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#maxZoomLevel-prop">Q3DCamera::maxZoomLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxZoomLevel")
    @io.qt.QtUninvokable
    public final float maxZoomLevel(){
        return maxZoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float maxZoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#minZoomLevel-prop">Q3DCamera::minZoomLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="minZoomLevel")
    @io.qt.QtUninvokable
    public final float minZoomLevel(){
        return minZoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float minZoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setCameraPosition(float, float, float)}
     *  with <code>zoom = 100.0f</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setCameraPosition(float horizontal, float vertical) {
        setCameraPosition(horizontal, vertical, (float)100.0f);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#setCameraPosition">Q3DCamera::setCameraPosition(float,float,float)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCameraPosition(float horizontal, float vertical, float zoom){
        setCameraPosition_native_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), horizontal, vertical, zoom);
    }
    
    @io.qt.QtUninvokable
    private native void setCameraPosition_native_float_float_float(long __this__nativeId, float horizontal, float vertical, float zoom);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#cameraPreset-prop">Q3DCamera::setCameraPreset(Q3DCamera::CameraPreset)</a></p>
     */
    @io.qt.QtPropertyWriter(name="cameraPreset")
    @io.qt.QtUninvokable
    public final void setCameraPreset(io.qt.datavis.Q3DCamera.CameraPreset preset){
        setCameraPreset_native_Q3DCamera_CameraPreset(QtJambi_LibraryUtilities.internal.nativeId(this), preset.value());
    }
    
    @io.qt.QtUninvokable
    private native void setCameraPreset_native_Q3DCamera_CameraPreset(long __this__nativeId, int preset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#maxZoomLevel-prop">Q3DCamera::setMaxZoomLevel(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="maxZoomLevel")
    @io.qt.QtUninvokable
    public final void setMaxZoomLevel(float zoomLevel){
        setMaxZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @io.qt.QtUninvokable
    private native void setMaxZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#minZoomLevel-prop">Q3DCamera::setMinZoomLevel(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="minZoomLevel")
    @io.qt.QtUninvokable
    public final void setMinZoomLevel(float zoomLevel){
        setMinZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @io.qt.QtUninvokable
    private native void setMinZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#target-prop">Q3DCamera::setTarget(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="target")
    @io.qt.QtUninvokable
    public final void setTarget(io.qt.gui.QVector3D target){
        setTarget_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
    }
    
    @io.qt.QtUninvokable
    private native void setTarget_native_cref_QVector3D(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapXRotation-prop">Q3DCamera::setWrapXRotation(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="wrapXRotation")
    @io.qt.QtUninvokable
    public final void setWrapXRotation(boolean isEnabled){
        setWrapXRotation_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    @io.qt.QtUninvokable
    private native void setWrapXRotation_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapYRotation-prop">Q3DCamera::setWrapYRotation(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="wrapYRotation")
    @io.qt.QtUninvokable
    public final void setWrapYRotation(boolean isEnabled){
        setWrapYRotation_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    @io.qt.QtUninvokable
    private native void setWrapYRotation_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#xRotation-prop">Q3DCamera::setXRotation(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="xRotation")
    @io.qt.QtUninvokable
    public final void setXRotation(float rotation){
        setXRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotation);
    }
    
    @io.qt.QtUninvokable
    private native void setXRotation_native_float(long __this__nativeId, float rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#yRotation-prop">Q3DCamera::setYRotation(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="yRotation")
    @io.qt.QtUninvokable
    public final void setYRotation(float rotation){
        setYRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotation);
    }
    
    @io.qt.QtUninvokable
    private native void setYRotation_native_float(long __this__nativeId, float rotation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#zoomLevel-prop">Q3DCamera::setZoomLevel(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zoomLevel")
    @io.qt.QtUninvokable
    public final void setZoomLevel(float zoomLevel){
        setZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @io.qt.QtUninvokable
    private native void setZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#target-prop">Q3DCamera::target()const</a></p>
     */
    @io.qt.QtPropertyReader(name="target")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D target(){
        return target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapXRotation-prop">Q3DCamera::wrapXRotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="wrapXRotation")
    @io.qt.QtUninvokable
    public final boolean wrapXRotation(){
        return wrapXRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean wrapXRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#wrapYRotation-prop">Q3DCamera::wrapYRotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="wrapYRotation")
    @io.qt.QtUninvokable
    public final boolean wrapYRotation(){
        return wrapYRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean wrapYRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#xRotation-prop">Q3DCamera::xRotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="xRotation")
    @io.qt.QtUninvokable
    public final float xRotation(){
        return xRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float xRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#yRotation-prop">Q3DCamera::yRotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="yRotation")
    @io.qt.QtUninvokable
    public final float yRotation(){
        return yRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float yRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dcamera.html#zoomLevel-prop">Q3DCamera::zoomLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zoomLevel")
    @io.qt.QtUninvokable
    public final float zoomLevel(){
        return zoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float zoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dobject.html#copyValuesFrom">Q3DObject::copyValuesFrom(Q3DObject)</a></p>
     */
    @io.qt.QtUninvokable
    public void copyValuesFrom(io.qt.datavis.Q3DObject source){
        copyValuesFrom_native_cref_Q3DObject(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_cref_Q3DObject(long __this__nativeId, long source);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DCamera(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DCamera(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DCamera instance, QDeclarativeConstructor constructor);
    
}
