package io.qt.datavis;


/**
 * <p>Visual style for graphs</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/q3dtheme.html">Q3DTheme</a></p>
 */
public class Q3DTheme extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DTheme.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/q3dtheme.html#ColorStyle-enum">Q3DTheme::ColorStyle</a></p>
     */
    public enum ColorStyle implements io.qt.QtEnumerator {
        ColorStyleUniform(0),
        ColorStyleObjectGradient(1),
        ColorStyleRangeGradient(2);

        private ColorStyle(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ColorStyle resolve(int value) {
            switch (value) {
            case 0: return ColorStyleUniform;
            case 1: return ColorStyleObjectGradient;
            case 2: return ColorStyleRangeGradient;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/q3dtheme.html#Theme-enum">Q3DTheme::Theme</a></p>
     */
    public enum Theme implements io.qt.QtEnumerator {
        ThemeQt(0),
        ThemePrimaryColors(1),
        ThemeDigia(2),
        ThemeStoneMoss(3),
        ThemeArmyBlue(4),
        ThemeRetro(5),
        ThemeEbony(6),
        ThemeIsabelle(7),
        ThemeUserDefined(8);

        private Theme(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Theme resolve(int value) {
            switch (value) {
            case 0: return ThemeQt;
            case 1: return ThemePrimaryColors;
            case 2: return ThemeDigia;
            case 3: return ThemeStoneMoss;
            case 4: return ThemeArmyBlue;
            case 5: return ThemeRetro;
            case 6: return ThemeEbony;
            case 7: return ThemeIsabelle;
            case 8: return ThemeUserDefined;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#ambientLightStrength-prop">Q3DTheme::ambientLightStrengthChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="ambientLightStrength")
    public final Signal1<@io.qt.QtPrimitiveType Float> ambientLightStrengthChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#backgroundColor-prop">Q3DTheme::backgroundColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="backgroundColor")
    public final Signal1<io.qt.gui.QColor> backgroundColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#backgroundEnabled-prop">Q3DTheme::backgroundEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="backgroundEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> backgroundEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#baseColors-prop">Q3DTheme::baseColorsChanged(QList&lt;QColor&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="baseColors")
    public final Signal1<java.util.List<io.qt.gui.QColor>> baseColorsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#baseGradients-prop">Q3DTheme::baseGradientsChanged(QList&lt;QLinearGradient&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="baseGradients")
    public final Signal1<java.util.List<io.qt.gui.QLinearGradient>> baseGradientsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#colorStyle-prop">Q3DTheme::colorStyleChanged(Q3DTheme::ColorStyle)</a></p>
     */
    @io.qt.QtPropertyNotify(name="colorStyle")
    public final Signal1<io.qt.datavis.Q3DTheme.ColorStyle> colorStyleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#font-prop">Q3DTheme::fontChanged(QFont)</a></p>
     */
    @io.qt.QtPropertyNotify(name="font")
    public final Signal1<io.qt.gui.QFont> fontChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#gridEnabled-prop">Q3DTheme::gridEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="gridEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> gridEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#gridLineColor-prop">Q3DTheme::gridLineColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="gridLineColor")
    public final Signal1<io.qt.gui.QColor> gridLineColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#highlightLightStrength-prop">Q3DTheme::highlightLightStrengthChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="highlightLightStrength")
    public final Signal1<@io.qt.QtPrimitiveType Float> highlightLightStrengthChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundColor-prop">Q3DTheme::labelBackgroundColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="labelBackgroundColor")
    public final Signal1<io.qt.gui.QColor> labelBackgroundColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundEnabled-prop">Q3DTheme::labelBackgroundEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="labelBackgroundEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> labelBackgroundEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBorderEnabled-prop">Q3DTheme::labelBorderEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="labelBorderEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> labelBorderEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelTextColor-prop">Q3DTheme::labelTextColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="labelTextColor")
    public final Signal1<io.qt.gui.QColor> labelTextColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#lightColor-prop">Q3DTheme::lightColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="lightColor")
    public final Signal1<io.qt.gui.QColor> lightColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#lightStrength-prop">Q3DTheme::lightStrengthChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="lightStrength")
    public final Signal1<@io.qt.QtPrimitiveType Float> lightStrengthChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightColor-prop">Q3DTheme::multiHighlightColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="multiHighlightColor")
    public final Signal1<io.qt.gui.QColor> multiHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightGradient-prop">Q3DTheme::multiHighlightGradientChanged(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyNotify(name="multiHighlightGradient")
    public final Signal1<io.qt.gui.QLinearGradient> multiHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightColor-prop">Q3DTheme::singleHighlightColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="singleHighlightColor")
    public final Signal1<io.qt.gui.QColor> singleHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightGradient-prop">Q3DTheme::singleHighlightGradientChanged(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyNotify(name="singleHighlightGradient")
    public final Signal1<io.qt.gui.QLinearGradient> singleHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#type-prop">Q3DTheme::typeChanged(Q3DTheme::Theme)</a></p>
     */
    @io.qt.QtPropertyNotify(name="type")
    public final Signal1<io.qt.datavis.Q3DTheme.Theme> typeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#windowColor-prop">Q3DTheme::windowColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="windowColor")
    public final Signal1<io.qt.gui.QColor> windowColorChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DTheme(io.qt.datavis.Q3DTheme.Theme, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DTheme(io.qt.datavis.Q3DTheme.Theme themeType) {
        this(themeType, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#Q3DTheme-1">Q3DTheme::Q3DTheme(Q3DTheme::Theme,QObject*)</a></p>
     */
    public Q3DTheme(io.qt.datavis.Q3DTheme.Theme themeType, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, themeType, parent);
    }
    
    private native static void initialize_native(Q3DTheme instance, io.qt.datavis.Q3DTheme.Theme themeType, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #Q3DTheme(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DTheme() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#Q3DTheme">Q3DTheme::Q3DTheme(QObject*)</a></p>
     */
    public Q3DTheme(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DTheme instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#ambientLightStrength-prop">Q3DTheme::ambientLightStrength()const</a></p>
     */
    @io.qt.QtPropertyReader(name="ambientLightStrength")
    @io.qt.QtUninvokable
    public final float ambientLightStrength(){
        return ambientLightStrength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float ambientLightStrength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#backgroundColor-prop">Q3DTheme::backgroundColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="backgroundColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor backgroundColor(){
        return backgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor backgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#baseColors-prop">Q3DTheme::baseColors()const</a></p>
     */
    @io.qt.QtPropertyReader(name="baseColors")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.gui.QColor> baseColors(){
        return baseColors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QColor> baseColors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#baseGradients-prop">Q3DTheme::baseGradients()const</a></p>
     */
    @io.qt.QtPropertyReader(name="baseGradients")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.gui.QLinearGradient> baseGradients(){
        return baseGradients_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QLinearGradient> baseGradients_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#colorStyle-prop">Q3DTheme::colorStyle()const</a></p>
     */
    @io.qt.QtPropertyReader(name="colorStyle")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DTheme.ColorStyle colorStyle(){
        return io.qt.datavis.Q3DTheme.ColorStyle.resolve(colorStyle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int colorStyle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#font-prop">Q3DTheme::font()const</a></p>
     */
    @io.qt.QtPropertyReader(name="font")
    @io.qt.QtUninvokable
    public final io.qt.gui.QFont font(){
        return font_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QFont font_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#gridLineColor-prop">Q3DTheme::gridLineColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="gridLineColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor gridLineColor(){
        return gridLineColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor gridLineColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#highlightLightStrength-prop">Q3DTheme::highlightLightStrength()const</a></p>
     */
    @io.qt.QtPropertyReader(name="highlightLightStrength")
    @io.qt.QtUninvokable
    public final float highlightLightStrength(){
        return highlightLightStrength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float highlightLightStrength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#backgroundEnabled-prop">Q3DTheme::isBackgroundEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="backgroundEnabled")
    @io.qt.QtUninvokable
    public final boolean isBackgroundEnabled(){
        return isBackgroundEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isBackgroundEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#gridEnabled-prop">Q3DTheme::isGridEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="gridEnabled")
    @io.qt.QtUninvokable
    public final boolean isGridEnabled(){
        return isGridEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isGridEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundEnabled-prop">Q3DTheme::isLabelBackgroundEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="labelBackgroundEnabled")
    @io.qt.QtUninvokable
    public final boolean isLabelBackgroundEnabled(){
        return isLabelBackgroundEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLabelBackgroundEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBorderEnabled-prop">Q3DTheme::isLabelBorderEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="labelBorderEnabled")
    @io.qt.QtUninvokable
    public final boolean isLabelBorderEnabled(){
        return isLabelBorderEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLabelBorderEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundColor-prop">Q3DTheme::labelBackgroundColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="labelBackgroundColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor labelBackgroundColor(){
        return labelBackgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor labelBackgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelTextColor-prop">Q3DTheme::labelTextColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="labelTextColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor labelTextColor(){
        return labelTextColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor labelTextColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#lightColor-prop">Q3DTheme::lightColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="lightColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor lightColor(){
        return lightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor lightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#lightStrength-prop">Q3DTheme::lightStrength()const</a></p>
     */
    @io.qt.QtPropertyReader(name="lightStrength")
    @io.qt.QtUninvokable
    public final float lightStrength(){
        return lightStrength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float lightStrength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightColor-prop">Q3DTheme::multiHighlightColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="multiHighlightColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor multiHighlightColor(){
        return multiHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor multiHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightGradient-prop">Q3DTheme::multiHighlightGradient()const</a></p>
     */
    @io.qt.QtPropertyReader(name="multiHighlightGradient")
    @io.qt.QtUninvokable
    public final io.qt.gui.QLinearGradient multiHighlightGradient(){
        return multiHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QLinearGradient multiHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#ambientLightStrength-prop">Q3DTheme::setAmbientLightStrength(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="ambientLightStrength")
    @io.qt.QtUninvokable
    public final void setAmbientLightStrength(float strength){
        setAmbientLightStrength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), strength);
    }
    
    @io.qt.QtUninvokable
    private native void setAmbientLightStrength_native_float(long __this__nativeId, float strength);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#backgroundColor-prop">Q3DTheme::setBackgroundColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="backgroundColor")
    @io.qt.QtUninvokable
    public final void setBackgroundColor(io.qt.gui.QColor color){
        setBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#backgroundEnabled-prop">Q3DTheme::setBackgroundEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="backgroundEnabled")
    @io.qt.QtUninvokable
    public final void setBackgroundEnabled(boolean enabled){
        setBackgroundEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setBackgroundEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#baseColors-prop">Q3DTheme::setBaseColors(QList&lt;QColor&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="baseColors")
    @io.qt.QtUninvokable
    public final void setBaseColors(java.util.Collection<io.qt.gui.QColor> colors){
        setBaseColors_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), colors);
    }
    
    @io.qt.QtUninvokable
    private native void setBaseColors_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.gui.QColor> colors);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#baseGradients-prop">Q3DTheme::setBaseGradients(QList&lt;QLinearGradient&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="baseGradients")
    @io.qt.QtUninvokable
    public final void setBaseGradients(java.util.Collection<io.qt.gui.QLinearGradient> gradients){
        setBaseGradients_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), gradients);
    }
    
    @io.qt.QtUninvokable
    private native void setBaseGradients_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.gui.QLinearGradient> gradients);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#colorStyle-prop">Q3DTheme::setColorStyle(Q3DTheme::ColorStyle)</a></p>
     */
    @io.qt.QtPropertyWriter(name="colorStyle")
    @io.qt.QtUninvokable
    public final void setColorStyle(io.qt.datavis.Q3DTheme.ColorStyle style){
        setColorStyle_native_Q3DTheme_ColorStyle(QtJambi_LibraryUtilities.internal.nativeId(this), style.value());
    }
    
    @io.qt.QtUninvokable
    private native void setColorStyle_native_Q3DTheme_ColorStyle(long __this__nativeId, int style);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#font-prop">Q3DTheme::setFont(QFont)</a></p>
     */
    @io.qt.QtPropertyWriter(name="font")
    @io.qt.QtUninvokable
    public final void setFont(io.qt.gui.QFont font){
        setFont_native_cref_QFont(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(font));
    }
    
    @io.qt.QtUninvokable
    private native void setFont_native_cref_QFont(long __this__nativeId, long font);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#gridEnabled-prop">Q3DTheme::setGridEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="gridEnabled")
    @io.qt.QtUninvokable
    public final void setGridEnabled(boolean enabled){
        setGridEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setGridEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#gridLineColor-prop">Q3DTheme::setGridLineColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="gridLineColor")
    @io.qt.QtUninvokable
    public final void setGridLineColor(io.qt.gui.QColor color){
        setGridLineColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setGridLineColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#highlightLightStrength-prop">Q3DTheme::setHighlightLightStrength(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="highlightLightStrength")
    @io.qt.QtUninvokable
    public final void setHighlightLightStrength(float strength){
        setHighlightLightStrength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), strength);
    }
    
    @io.qt.QtUninvokable
    private native void setHighlightLightStrength_native_float(long __this__nativeId, float strength);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundColor-prop">Q3DTheme::setLabelBackgroundColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="labelBackgroundColor")
    @io.qt.QtUninvokable
    public final void setLabelBackgroundColor(io.qt.gui.QColor color){
        setLabelBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setLabelBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBackgroundEnabled-prop">Q3DTheme::setLabelBackgroundEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="labelBackgroundEnabled")
    @io.qt.QtUninvokable
    public final void setLabelBackgroundEnabled(boolean enabled){
        setLabelBackgroundEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setLabelBackgroundEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelBorderEnabled-prop">Q3DTheme::setLabelBorderEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="labelBorderEnabled")
    @io.qt.QtUninvokable
    public final void setLabelBorderEnabled(boolean enabled){
        setLabelBorderEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setLabelBorderEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#labelTextColor-prop">Q3DTheme::setLabelTextColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="labelTextColor")
    @io.qt.QtUninvokable
    public final void setLabelTextColor(io.qt.gui.QColor color){
        setLabelTextColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setLabelTextColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#lightColor-prop">Q3DTheme::setLightColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="lightColor")
    @io.qt.QtUninvokable
    public final void setLightColor(io.qt.gui.QColor color){
        setLightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setLightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#lightStrength-prop">Q3DTheme::setLightStrength(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="lightStrength")
    @io.qt.QtUninvokable
    public final void setLightStrength(float strength){
        setLightStrength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), strength);
    }
    
    @io.qt.QtUninvokable
    private native void setLightStrength_native_float(long __this__nativeId, float strength);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightColor-prop">Q3DTheme::setMultiHighlightColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="multiHighlightColor")
    @io.qt.QtUninvokable
    public final void setMultiHighlightColor(io.qt.gui.QColor color){
        setMultiHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setMultiHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#multiHighlightGradient-prop">Q3DTheme::setMultiHighlightGradient(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyWriter(name="multiHighlightGradient")
    @io.qt.QtUninvokable
    public final void setMultiHighlightGradient(io.qt.gui.QLinearGradient gradient){
        setMultiHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @io.qt.QtUninvokable
    private native void setMultiHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightColor-prop">Q3DTheme::setSingleHighlightColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="singleHighlightColor")
    @io.qt.QtUninvokable
    public final void setSingleHighlightColor(io.qt.gui.QColor color){
        setSingleHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setSingleHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightGradient-prop">Q3DTheme::setSingleHighlightGradient(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyWriter(name="singleHighlightGradient")
    @io.qt.QtUninvokable
    public final void setSingleHighlightGradient(io.qt.gui.QLinearGradient gradient){
        setSingleHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @io.qt.QtUninvokable
    private native void setSingleHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#type-prop">Q3DTheme::setType(Q3DTheme::Theme)</a></p>
     */
    @io.qt.QtPropertyWriter(name="type")
    @io.qt.QtUninvokable
    public final void setType(io.qt.datavis.Q3DTheme.Theme themeType){
        setType_native_Q3DTheme_Theme(QtJambi_LibraryUtilities.internal.nativeId(this), themeType.value());
    }
    
    @io.qt.QtUninvokable
    private native void setType_native_Q3DTheme_Theme(long __this__nativeId, int themeType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#windowColor-prop">Q3DTheme::setWindowColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="windowColor")
    @io.qt.QtUninvokable
    public final void setWindowColor(io.qt.gui.QColor color){
        setWindowColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setWindowColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightColor-prop">Q3DTheme::singleHighlightColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="singleHighlightColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor singleHighlightColor(){
        return singleHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor singleHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#singleHighlightGradient-prop">Q3DTheme::singleHighlightGradient()const</a></p>
     */
    @io.qt.QtPropertyReader(name="singleHighlightGradient")
    @io.qt.QtUninvokable
    public final io.qt.gui.QLinearGradient singleHighlightGradient(){
        return singleHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QLinearGradient singleHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#type-prop">Q3DTheme::type()const</a></p>
     */
    @io.qt.QtPropertyReader(name="type")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DTheme.Theme type(){
        return io.qt.datavis.Q3DTheme.Theme.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/q3dtheme.html#windowColor-prop">Q3DTheme::windowColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="windowColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor windowColor(){
        return windowColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor windowColor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DTheme(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DTheme(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DTheme instance, QDeclarativeConstructor constructor);
    
}
