package io.qt.datavis;


/**
 * <p>Proxy class for presenting data in item models with Q3DSurface</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html">QtDataVisualization::QItemModelSurfaceDataProxy</a></p>
 */
public class QItemModelSurfaceDataProxy extends io.qt.datavis.QSurfaceDataProxy
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelSurfaceDataProxy.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#MultiMatchBehavior-enum">QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior</a></p>
     */
    public enum MultiMatchBehavior implements io.qt.QtEnumerator {
        MMBFirst(0),
        MMBLast(1),
        MMBAverage(2),
        MMBCumulativeY(3);

        private MultiMatchBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MultiMatchBehavior resolve(int value) {
            switch (value) {
            case 0: return MMBFirst;
            case 1: return MMBLast;
            case 2: return MMBAverage;
            case 3: return MMBCumulativeY;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::autoColumnCategoriesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="autoColumnCategories")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> autoColumnCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::autoRowCategoriesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="autoRowCategories")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> autoRowCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnCategoriesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnCategories")
    public final Signal0 columnCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnRole")
    public final Signal1<java.lang.String> columnRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnRolePattern")
    public final Signal1<io.qt.core.QRegExp> columnRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnRoleReplace")
    public final Signal1<java.lang.String> columnRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#itemModel-prop">QtDataVisualization::QItemModelSurfaceDataProxy::itemModelChanged(const QAbstractItemModel*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="itemModel")
    public final Signal1<io.qt.core.QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelSurfaceDataProxy::multiMatchBehaviorChanged(QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior)</a></p>
     */
    @io.qt.QtPropertyNotify(name="multiMatchBehavior")
    public final Signal1<io.qt.datavis.QItemModelSurfaceDataProxy.MultiMatchBehavior> multiMatchBehaviorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowCategoriesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowCategories")
    public final Signal0 rowCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowRole")
    public final Signal1<java.lang.String> rowRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowRolePattern")
    public final Signal1<io.qt.core.QRegExp> rowRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowRoleReplace")
    public final Signal1<java.lang.String> rowRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::useModelCategoriesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="useModelCategories")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> useModelCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::xPosRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="xPosRole")
    public final Signal1<java.lang.String> xPosRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::xPosRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="xPosRolePattern")
    public final Signal1<io.qt.core.QRegExp> xPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::xPosRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="xPosRoleReplace")
    public final Signal1<java.lang.String> xPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::yPosRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="yPosRole")
    public final Signal1<java.lang.String> yPosRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::yPosRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="yPosRolePattern")
    public final Signal1<io.qt.core.QRegExp> yPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::yPosRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="yPosRoleReplace")
    public final Signal1<java.lang.String> yPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::zPosRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="zPosRole")
    public final Signal1<java.lang.String> zPosRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::zPosRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="zPosRolePattern")
    public final Signal1<io.qt.core.QRegExp> zPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::zPosRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="zPosRoleReplace")
    public final Signal1<java.lang.String> zPosRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-1">QtDataVisualization::QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole) {
        this(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-4">QtDataVisualization::QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories) {
        this(itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-6">QtDataVisualization::QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole) {
        this(itemModel, rowRole, columnRole, yPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-3">QtDataVisualization::QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, yPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories) {
        this(itemModel, rowRole, columnRole, yPosRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-5">QtDataVisualization::QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, yPosRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String yPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String yPosRole) {
        this(itemModel, yPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy-2">QtDataVisualization::QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemModel*,QString,QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String yPosRole, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, yPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String yPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#QItemModelSurfaceDataProxy">QtDataVisualization::QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QObject*)</a></p>
     */
    public QItemModelSurfaceDataProxy(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::autoColumnCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="autoColumnCategories")
    @io.qt.QtUninvokable
    public final boolean autoColumnCategories(){
        return autoColumnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean autoColumnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::autoRowCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="autoRowCategories")
    @io.qt.QtUninvokable
    public final boolean autoRowCategories(){
        return autoRowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean autoRowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnCategories")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList columnCategories(){
        return columnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList columnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnCategoryIndex">QtDataVisualization::QItemModelSurfaceDataProxy::columnCategoryIndex(QString)</a></p>
     */
    public final int columnCategoryIndex(java.lang.String category){
        return columnCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int columnCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnRole")
    @io.qt.QtUninvokable
    public final java.lang.String columnRole(){
        return columnRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String columnRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp columnRolePattern(){
        return columnRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp columnRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::columnRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String columnRoleReplace(){
        return columnRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String columnRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#itemModel-prop">QtDataVisualization::QItemModelSurfaceDataProxy::itemModel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="itemModel")
    @io.qt.QtUninvokable
    public final io.qt.core.QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelSurfaceDataProxy::multiMatchBehavior()const</a></p>
     */
    @io.qt.QtPropertyReader(name="multiMatchBehavior")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QItemModelSurfaceDataProxy.MultiMatchBehavior multiMatchBehavior(){
        return io.qt.datavis.QItemModelSurfaceDataProxy.MultiMatchBehavior.resolve(multiMatchBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int multiMatchBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#remap">QtDataVisualization::QItemModelSurfaceDataProxy::remap(QString,QString,QString,QString,QString,QStringList,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void remap(java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowRole, columnRole, xPosRole, yPosRole, zPosRole, rowCategories, columnCategories);
    }
    
    @io.qt.QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(long __this__nativeId, java.lang.String rowRole, java.lang.String columnRole, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowCategories")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList rowCategories(){
        return rowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList rowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowCategoryIndex">QtDataVisualization::QItemModelSurfaceDataProxy::rowCategoryIndex(QString)</a></p>
     */
    public final int rowCategoryIndex(java.lang.String category){
        return rowCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int rowCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowRole")
    @io.qt.QtUninvokable
    public final java.lang.String rowRole(){
        return rowRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String rowRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp rowRolePattern(){
        return rowRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp rowRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::rowRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String rowRoleReplace(){
        return rowRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String rowRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setAutoColumnCategories(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="autoColumnCategories")
    @io.qt.QtUninvokable
    public final void setAutoColumnCategories(boolean enable){
        setAutoColumnCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoColumnCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setAutoRowCategories(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="autoRowCategories")
    @io.qt.QtUninvokable
    public final void setAutoRowCategories(boolean enable){
        setAutoRowCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoRowCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setColumnCategories(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnCategories")
    @io.qt.QtUninvokable
    public final void setColumnCategories(java.util.Collection<java.lang.String> categories){
        setColumnCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @io.qt.QtUninvokable
    private native void setColumnCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setColumnRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnRole")
    @io.qt.QtUninvokable
    public final void setColumnRole(java.lang.String role){
        setColumnRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setColumnRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setColumnRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnRolePattern")
    @io.qt.QtUninvokable
    public final void setColumnRolePattern(io.qt.core.QRegExp pattern){
        setColumnRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setColumnRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setColumnRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnRoleReplace")
    @io.qt.QtUninvokable
    public final void setColumnRoleReplace(java.lang.String replace){
        setColumnRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setColumnRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#setItemModel">QtDataVisualization::QItemModelSurfaceDataProxy::setItemModel(QAbstractItemModel*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="itemModel")
    @io.qt.QtUninvokable
    public final void setItemModel(io.qt.core.QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @io.qt.QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setMultiMatchBehavior(QtDataVisualization::QItemModelSurfaceDataProxy::MultiMatchBehavior)</a></p>
     */
    @io.qt.QtPropertyWriter(name="multiMatchBehavior")
    @io.qt.QtUninvokable
    public final void setMultiMatchBehavior(io.qt.datavis.QItemModelSurfaceDataProxy.MultiMatchBehavior behavior){
        setMultiMatchBehavior_native_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), behavior.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMultiMatchBehavior_native_QtDataVisualization_QItemModelSurfaceDataProxy_MultiMatchBehavior(long __this__nativeId, int behavior);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setRowCategories(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowCategories")
    @io.qt.QtUninvokable
    public final void setRowCategories(java.util.Collection<java.lang.String> categories){
        setRowCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @io.qt.QtUninvokable
    private native void setRowCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setRowRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowRole")
    @io.qt.QtUninvokable
    public final void setRowRole(java.lang.String role){
        setRowRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setRowRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setRowRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowRolePattern")
    @io.qt.QtUninvokable
    public final void setRowRolePattern(io.qt.core.QRegExp pattern){
        setRowRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setRowRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setRowRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowRoleReplace")
    @io.qt.QtUninvokable
    public final void setRowRoleReplace(java.lang.String replace){
        setRowRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setRowRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setUseModelCategories(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="useModelCategories")
    @io.qt.QtUninvokable
    public final void setUseModelCategories(boolean enable){
        setUseModelCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setUseModelCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setXPosRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="xPosRole")
    @io.qt.QtUninvokable
    public final void setXPosRole(java.lang.String role){
        setXPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setXPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setXPosRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="xPosRolePattern")
    @io.qt.QtUninvokable
    public final void setXPosRolePattern(io.qt.core.QRegExp pattern){
        setXPosRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setXPosRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setXPosRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="xPosRoleReplace")
    @io.qt.QtUninvokable
    public final void setXPosRoleReplace(java.lang.String replace){
        setXPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setXPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setYPosRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="yPosRole")
    @io.qt.QtUninvokable
    public final void setYPosRole(java.lang.String role){
        setYPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setYPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setYPosRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="yPosRolePattern")
    @io.qt.QtUninvokable
    public final void setYPosRolePattern(io.qt.core.QRegExp pattern){
        setYPosRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setYPosRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setYPosRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="yPosRoleReplace")
    @io.qt.QtUninvokable
    public final void setYPosRoleReplace(java.lang.String replace){
        setYPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setYPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setZPosRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zPosRole")
    @io.qt.QtUninvokable
    public final void setZPosRole(java.lang.String role){
        setZPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setZPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setZPosRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zPosRolePattern")
    @io.qt.QtUninvokable
    public final void setZPosRolePattern(io.qt.core.QRegExp pattern){
        setZPosRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setZPosRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::setZPosRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zPosRoleReplace")
    @io.qt.QtUninvokable
    public final void setZPosRoleReplace(java.lang.String replace){
        setZPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setZPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelSurfaceDataProxy::useModelCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="useModelCategories")
    @io.qt.QtUninvokable
    public final boolean useModelCategories(){
        return useModelCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean useModelCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::xPosRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="xPosRole")
    @io.qt.QtUninvokable
    public final java.lang.String xPosRole(){
        return xPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String xPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::xPosRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="xPosRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp xPosRolePattern(){
        return xPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp xPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#xPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::xPosRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="xPosRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String xPosRoleReplace(){
        return xPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String xPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::yPosRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="yPosRole")
    @io.qt.QtUninvokable
    public final java.lang.String yPosRole(){
        return yPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String yPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::yPosRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="yPosRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp yPosRolePattern(){
        return yPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp yPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#yPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::yPosRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="yPosRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String yPosRoleReplace(){
        return yPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String yPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRole-prop">QtDataVisualization::QItemModelSurfaceDataProxy::zPosRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zPosRole")
    @io.qt.QtUninvokable
    public final java.lang.String zPosRole(){
        return zPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String zPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRolePattern-prop">QtDataVisualization::QItemModelSurfaceDataProxy::zPosRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zPosRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp zPosRolePattern(){
        return zPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp zPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelsurfacedataproxy.html#zPosRoleReplace-prop">QtDataVisualization::QItemModelSurfaceDataProxy::zPosRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zPosRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String zPosRoleReplace(){
        return zPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String zPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QItemModelSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QItemModelSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QItemModelSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
}
