package io.qt.datavis;


/**
 * <p>Proxy class for presenting data in item models with Q3DBars</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html">QtDataVisualization::QItemModelBarDataProxy</a></p>
 */
public class QItemModelBarDataProxy extends io.qt.datavis.QBarDataProxy
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelBarDataProxy.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior</a></p>
     */
    public enum MultiMatchBehavior implements io.qt.QtEnumerator {
        MMBFirst(0),
        MMBLast(1),
        MMBAverage(2),
        MMBCumulative(3);

        private MultiMatchBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MultiMatchBehavior resolve(int value) {
            switch (value) {
            case 0: return MMBFirst;
            case 1: return MMBLast;
            case 2: return MMBAverage;
            case 3: return MMBCumulative;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::autoColumnCategoriesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="autoColumnCategories")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> autoColumnCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::autoRowCategoriesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="autoRowCategories")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> autoRowCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::columnCategoriesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnCategories")
    public final Signal0 columnCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRole-prop">QtDataVisualization::QItemModelBarDataProxy::columnRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnRole")
    public final Signal1<java.lang.String> columnRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::columnRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnRolePattern")
    public final Signal1<io.qt.core.QRegExp> columnRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::columnRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnRoleReplace")
    public final Signal1<java.lang.String> columnRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#itemModel-prop">QtDataVisualization::QItemModelBarDataProxy::itemModelChanged(const QAbstractItemModel*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="itemModel")
    public final Signal1<io.qt.core.QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelBarDataProxy::multiMatchBehaviorChanged(QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior)</a></p>
     */
    @io.qt.QtPropertyNotify(name="multiMatchBehavior")
    public final Signal1<io.qt.datavis.QItemModelBarDataProxy.MultiMatchBehavior> multiMatchBehaviorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelBarDataProxy::rotationRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationRole")
    public final Signal1<java.lang.String> rotationRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::rotationRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationRolePattern")
    public final Signal1<io.qt.core.QRegExp> rotationRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::rotationRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotationRoleReplace")
    public final Signal1<java.lang.String> rotationRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::rowCategoriesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowCategories")
    public final Signal0 rowCategoriesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRole-prop">QtDataVisualization::QItemModelBarDataProxy::rowRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowRole")
    public final Signal1<java.lang.String> rowRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::rowRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowRolePattern")
    public final Signal1<io.qt.core.QRegExp> rowRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::rowRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowRoleReplace")
    public final Signal1<java.lang.String> rowRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelBarDataProxy::useModelCategoriesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="useModelCategories")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> useModelCategoriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRole-prop">QtDataVisualization::QItemModelBarDataProxy::valueRoleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="valueRole")
    public final Signal1<java.lang.String> valueRoleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::valueRolePatternChanged(QRegExp)</a></p>
     */
    @io.qt.QtPropertyNotify(name="valueRolePattern")
    public final Signal1<io.qt.core.QRegExp> valueRolePatternChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::valueRoleReplaceChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="valueRoleReplace")
    public final Signal1<java.lang.String> valueRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-1">QtDataVisualization::QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole) {
        this(itemModel, rowRole, columnRole, valueRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-3">QtDataVisualization::QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole) {
        this(itemModel, rowRole, columnRole, valueRole, rotationRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-4">QtDataVisualization::QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rotationRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories) {
        this(itemModel, rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-6">QtDataVisualization::QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories) {
        this(itemModel, rowRole, columnRole, valueRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-5">QtDataVisualization::QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QString,QString,QStringList,QStringList,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String valueRole) {
        this(itemModel, valueRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-2">QtDataVisualization::QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel*,QString,QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.QAbstractItemModel itemModel, java.lang.String valueRole, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, valueRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String valueRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy">QtDataVisualization::QItemModelBarDataProxy::QItemModelBarDataProxy(QObject*)</a></p>
     */
    public QItemModelBarDataProxy(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::autoColumnCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="autoColumnCategories")
    @io.qt.QtUninvokable
    public final boolean autoColumnCategories(){
        return autoColumnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean autoColumnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::autoRowCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="autoRowCategories")
    @io.qt.QtUninvokable
    public final boolean autoRowCategories(){
        return autoRowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean autoRowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::columnCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnCategories")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList columnCategories(){
        return columnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList columnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategoryIndex">QtDataVisualization::QItemModelBarDataProxy::columnCategoryIndex(QString)</a></p>
     */
    public final int columnCategoryIndex(java.lang.String category){
        return columnCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int columnCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRole-prop">QtDataVisualization::QItemModelBarDataProxy::columnRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnRole")
    @io.qt.QtUninvokable
    public final java.lang.String columnRole(){
        return columnRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String columnRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::columnRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp columnRolePattern(){
        return columnRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp columnRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::columnRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String columnRoleReplace(){
        return columnRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String columnRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#itemModel-prop">QtDataVisualization::QItemModelBarDataProxy::itemModel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="itemModel")
    @io.qt.QtUninvokable
    public final io.qt.core.QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelBarDataProxy::multiMatchBehavior()const</a></p>
     */
    @io.qt.QtPropertyReader(name="multiMatchBehavior")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QItemModelBarDataProxy.MultiMatchBehavior multiMatchBehavior(){
        return io.qt.datavis.QItemModelBarDataProxy.MultiMatchBehavior.resolve(multiMatchBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int multiMatchBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#remap">QtDataVisualization::QItemModelBarDataProxy::remap(QString,QString,QString,QString,QStringList,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void remap(java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories);
    }
    
    @io.qt.QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(long __this__nativeId, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelBarDataProxy::rotationRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationRole")
    @io.qt.QtUninvokable
    public final java.lang.String rotationRole(){
        return rotationRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String rotationRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::rotationRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp rotationRolePattern(){
        return rotationRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp rotationRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::rotationRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotationRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String rotationRoleReplace(){
        return rotationRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String rotationRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::rowCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowCategories")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList rowCategories(){
        return rowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList rowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategoryIndex">QtDataVisualization::QItemModelBarDataProxy::rowCategoryIndex(QString)</a></p>
     */
    public final int rowCategoryIndex(java.lang.String category){
        return rowCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int rowCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRole-prop">QtDataVisualization::QItemModelBarDataProxy::rowRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowRole")
    @io.qt.QtUninvokable
    public final java.lang.String rowRole(){
        return rowRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String rowRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::rowRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp rowRolePattern(){
        return rowRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp rowRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::rowRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String rowRoleReplace(){
        return rowRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String rowRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::setAutoColumnCategories(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="autoColumnCategories")
    @io.qt.QtUninvokable
    public final void setAutoColumnCategories(boolean enable){
        setAutoColumnCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoColumnCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::setAutoRowCategories(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="autoRowCategories")
    @io.qt.QtUninvokable
    public final void setAutoRowCategories(boolean enable){
        setAutoRowCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoRowCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::setColumnCategories(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnCategories")
    @io.qt.QtUninvokable
    public final void setColumnCategories(java.util.Collection<java.lang.String> categories){
        setColumnCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @io.qt.QtUninvokable
    private native void setColumnCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRole-prop">QtDataVisualization::QItemModelBarDataProxy::setColumnRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnRole")
    @io.qt.QtUninvokable
    public final void setColumnRole(java.lang.String role){
        setColumnRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setColumnRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::setColumnRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnRolePattern")
    @io.qt.QtUninvokable
    public final void setColumnRolePattern(io.qt.core.QRegExp pattern){
        setColumnRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setColumnRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::setColumnRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnRoleReplace")
    @io.qt.QtUninvokable
    public final void setColumnRoleReplace(java.lang.String replace){
        setColumnRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setColumnRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#setItemModel">QtDataVisualization::QItemModelBarDataProxy::setItemModel(QAbstractItemModel*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="itemModel")
    @io.qt.QtUninvokable
    public final void setItemModel(io.qt.core.QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @io.qt.QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelBarDataProxy::setMultiMatchBehavior(QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior)</a></p>
     */
    @io.qt.QtPropertyWriter(name="multiMatchBehavior")
    @io.qt.QtUninvokable
    public final void setMultiMatchBehavior(io.qt.datavis.QItemModelBarDataProxy.MultiMatchBehavior behavior){
        setMultiMatchBehavior_native_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), behavior.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMultiMatchBehavior_native_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior(long __this__nativeId, int behavior);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelBarDataProxy::setRotationRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationRole")
    @io.qt.QtUninvokable
    public final void setRotationRole(java.lang.String role){
        setRotationRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setRotationRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::setRotationRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationRolePattern")
    @io.qt.QtUninvokable
    public final void setRotationRolePattern(io.qt.core.QRegExp pattern){
        setRotationRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setRotationRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::setRotationRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotationRoleReplace")
    @io.qt.QtUninvokable
    public final void setRotationRoleReplace(java.lang.String replace){
        setRotationRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setRotationRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::setRowCategories(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowCategories")
    @io.qt.QtUninvokable
    public final void setRowCategories(java.util.Collection<java.lang.String> categories){
        setRowCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @io.qt.QtUninvokable
    private native void setRowCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRole-prop">QtDataVisualization::QItemModelBarDataProxy::setRowRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowRole")
    @io.qt.QtUninvokable
    public final void setRowRole(java.lang.String role){
        setRowRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setRowRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::setRowRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowRolePattern")
    @io.qt.QtUninvokable
    public final void setRowRolePattern(io.qt.core.QRegExp pattern){
        setRowRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setRowRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::setRowRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowRoleReplace")
    @io.qt.QtUninvokable
    public final void setRowRoleReplace(java.lang.String replace){
        setRowRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setRowRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelBarDataProxy::setUseModelCategories(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="useModelCategories")
    @io.qt.QtUninvokable
    public final void setUseModelCategories(boolean enable){
        setUseModelCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setUseModelCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRole-prop">QtDataVisualization::QItemModelBarDataProxy::setValueRole(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="valueRole")
    @io.qt.QtUninvokable
    public final void setValueRole(java.lang.String role){
        setValueRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @io.qt.QtUninvokable
    private native void setValueRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::setValueRolePattern(QRegExp)</a></p>
     */
    @io.qt.QtPropertyWriter(name="valueRolePattern")
    @io.qt.QtUninvokable
    public final void setValueRolePattern(io.qt.core.QRegExp pattern){
        setValueRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @io.qt.QtUninvokable
    private native void setValueRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::setValueRoleReplace(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="valueRoleReplace")
    @io.qt.QtUninvokable
    public final void setValueRoleReplace(java.lang.String replace){
        setValueRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @io.qt.QtUninvokable
    private native void setValueRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelBarDataProxy::useModelCategories()const</a></p>
     */
    @io.qt.QtPropertyReader(name="useModelCategories")
    @io.qt.QtUninvokable
    public final boolean useModelCategories(){
        return useModelCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean useModelCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRole-prop">QtDataVisualization::QItemModelBarDataProxy::valueRole()const</a></p>
     */
    @io.qt.QtPropertyReader(name="valueRole")
    @io.qt.QtUninvokable
    public final java.lang.String valueRole(){
        return valueRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String valueRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::valueRolePattern()const</a></p>
     */
    @io.qt.QtPropertyReader(name="valueRolePattern")
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp valueRolePattern(){
        return valueRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp valueRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::valueRoleReplace()const</a></p>
     */
    @io.qt.QtPropertyReader(name="valueRoleReplace")
    @io.qt.QtUninvokable
    public final java.lang.String valueRoleReplace(){
        return valueRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String valueRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QItemModelBarDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QItemModelBarDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QItemModelBarDataProxy instance, QDeclarativeConstructor constructor);
    
}
