package io.qt.datavis;

import io.qt.*;


/**
 * <p>Represents a data series in a 3D surface graph</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html">QtDataVisualization::QSurface3DSeries</a></code></p>
 */
public class QSurface3DSeries extends io.qt.datavis.QAbstract3DSeries
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSurface3DSeries.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#DrawFlag-enum">QtDataVisualization::QSurface3DSeries::DrawFlag</a></code></p>
     * 
     * @see DrawFlags
     */
    public enum DrawFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#DrawFlag-enum">QtDataVisualization::<wbr>QSurface3DSeries::<wbr>DrawWireframe</a></code></p>
         */
        DrawWireframe(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#DrawFlag-enum">QtDataVisualization::<wbr>QSurface3DSeries::<wbr>DrawSurface</a></code></p>
         */
        DrawSurface(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#DrawFlag-enum">QtDataVisualization::<wbr>QSurface3DSeries::<wbr>DrawSurfaceAndWireframe</a></code></p>
         */
        DrawSurfaceAndWireframe(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DrawFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull DrawFlags asFlags() {
            return new DrawFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull DrawFlags combined(@NonNull DrawFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull DrawFlags cleared(@NonNull DrawFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link DrawFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull DrawFlags flags(@Nullable DrawFlag @NonNull... values) {
            return new DrawFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DrawFlag resolve(int value) {
            switch (value) {
            case 1: return DrawWireframe;
            case 2: return DrawSurface;
            case 3: return DrawSurfaceAndWireframe;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link DrawFlag}
     */
    public static final class DrawFlags extends QFlags<DrawFlag> implements Comparable<DrawFlags> {
        private static final long serialVersionUID = 0xcc74b066c0184b89L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new DrawFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public DrawFlags(@Nullable DrawFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new DrawFlags with given <code>value</code>.
         * @param value
         */
        public DrawFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new DrawFlags
         */
        @Override
        public final @NonNull DrawFlags combined(@StrictNonNull DrawFlag e){
            return new DrawFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull DrawFlags setFlag(@Nullable DrawFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull DrawFlags setFlag(@Nullable DrawFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this DrawFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull DrawFlag @NonNull[] flags(){
            return super.flags(DrawFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull DrawFlags clone(){
            return new DrawFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull DrawFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#dataProxy-prop">QtDataVisualization::QSurface3DSeries::<wbr>dataProxyChanged(QtDataVisualization::QSurfaceDataProxy*)</a></code></p>
     */
    @QtPropertyNotify(name="dataProxy")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QSurfaceDataProxy> dataProxyChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#drawMode-prop">QtDataVisualization::QSurface3DSeries::<wbr>drawModeChanged(QtDataVisualization::QSurface3DSeries::DrawFlags)</a></code></p>
     */
    @QtPropertyNotify(name="drawMode")
    public final @NonNull Signal1<io.qt.datavis.QSurface3DSeries.@NonNull DrawFlags> drawModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#flatShadingEnabled-prop">QtDataVisualization::QSurface3DSeries::<wbr>flatShadingEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="flatShadingEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> flatShadingEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#flatShadingSupported-prop">QtDataVisualization::QSurface3DSeries::<wbr>flatShadingSupportedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="flatShadingSupported")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> flatShadingSupportedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#selectedPoint-prop">QtDataVisualization::QSurface3DSeries::<wbr>selectedPointChanged(QPoint)</a></code></p>
     */
    @QtPropertyNotify(name="selectedPoint")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> selectedPointChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#texture-prop">QtDataVisualization::QSurface3DSeries::<wbr>textureChanged(QImage)</a></code></p>
     */
    @QtPropertyNotify(name="texture")
    public final @NonNull Signal1<io.qt.gui.@NonNull QImage> textureChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#textureFile-prop">QtDataVisualization::QSurface3DSeries::<wbr>textureFileChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="textureFile")
    public final @NonNull Signal1<java.lang.@NonNull String> textureFileChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#QSurface3DSeries">QtDataVisualization::QSurface3DSeries::<wbr>QSurface3DSeries(QObject*)</a></code></p>
     */
    public QSurface3DSeries(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSurface3DSeries instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QtDataVisualization::QSurface3DSeries::<wbr>QSurface3DSeries(QtDataVisualization::QSurfaceDataProxy*,<wbr>QObject*)</code></p>
     */
    public QSurface3DSeries(io.qt.datavis.@Nullable QSurfaceDataProxy dataProxy, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, dataProxy, parent);
    }
    
    private native static void initialize_native(QSurface3DSeries instance, io.qt.datavis.QSurfaceDataProxy dataProxy, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#dataProxy-prop">QtDataVisualization::QSurface3DSeries::<wbr>dataProxy()const</a></code></p>
     */
    @QtPropertyReader(name="dataProxy")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QSurfaceDataProxy dataProxy(){
        return dataProxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QSurfaceDataProxy dataProxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#drawMode-prop">QtDataVisualization::QSurface3DSeries::<wbr>drawMode()const</a></code></p>
     */
    @QtPropertyReader(name="drawMode")
    @QtUninvokable
    public final io.qt.datavis.QSurface3DSeries.@NonNull DrawFlags drawMode(){
        return new io.qt.datavis.QSurface3DSeries.DrawFlags(drawMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int drawMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#flatShadingEnabled-prop">QtDataVisualization::QSurface3DSeries::<wbr>isFlatShadingEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="flatShadingEnabled")
    @QtUninvokable
    public final boolean isFlatShadingEnabled(){
        return isFlatShadingEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFlatShadingEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#flatShadingSupported-prop">QtDataVisualization::QSurface3DSeries::<wbr>isFlatShadingSupported()const</a></code></p>
     */
    @QtPropertyReader(name="flatShadingSupported")
    @QtUninvokable
    public final boolean isFlatShadingSupported(){
        return isFlatShadingSupported_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFlatShadingSupported_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#selectedPoint-prop">QtDataVisualization::QSurface3DSeries::<wbr>selectedPoint()const</a></code></p>
     */
    @QtPropertyReader(name="selectedPoint")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint selectedPoint(){
        return selectedPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint selectedPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#dataProxy-prop">QtDataVisualization::QSurface3DSeries::<wbr>setDataProxy(QtDataVisualization::QSurfaceDataProxy*)</a></code></p>
     */
    @QtPropertyWriter(name="dataProxy")
    @QtUninvokable
    public final void setDataProxy(io.qt.datavis.@StrictNonNull QSurfaceDataProxy proxy){
        if(proxy!=null){
            if(proxy==dataProxy()){
                throw new IllegalArgumentException("Proxy is already assigned to this series.");
            }else if(proxy.series()!=null){
                throw new IllegalArgumentException("Proxy is already assigned to another series.");
            }
        }
        java.util.Objects.requireNonNull(proxy, "Argument 'proxy': null not expected.");
        setDataProxy_native_QtDataVisualization_QSurfaceDataProxy_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(proxy));
    }
    
    @QtUninvokable
    private native void setDataProxy_native_QtDataVisualization_QSurfaceDataProxy_ptr(long __this__nativeId, long proxy);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#drawMode-prop">QtDataVisualization::QSurface3DSeries::<wbr>setDrawMode(QtDataVisualization::QSurface3DSeries::DrawFlags)</a></code></p>
     */
    @QtPropertyWriter(name="drawMode")
    @QtUninvokable
    public final void setDrawMode(io.qt.datavis.QSurface3DSeries.@NonNull DrawFlags mode){
        setDrawMode_native_QtDataVisualization_QSurface3DSeries_DrawFlags(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setDrawMode_native_QtDataVisualization_QSurface3DSeries_DrawFlags(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#flatShadingEnabled-prop">QtDataVisualization::QSurface3DSeries::<wbr>setFlatShadingEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="flatShadingEnabled")
    @QtUninvokable
    public final void setFlatShadingEnabled(boolean enabled){
        setFlatShadingEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setFlatShadingEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#setSelectedPoint">QtDataVisualization::QSurface3DSeries::<wbr>setSelectedPoint(QPoint)</a></code></p>
     */
    @QtPropertyWriter(name="selectedPoint")
    @QtUninvokable
    public final void setSelectedPoint(io.qt.core.@NonNull QPoint position){
        setSelectedPoint_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setSelectedPoint_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#texture-prop">QtDataVisualization::QSurface3DSeries::<wbr>setTexture(QImage)</a></code></p>
     */
    @QtPropertyWriter(name="texture")
    @QtUninvokable
    public final void setTexture(io.qt.gui.@NonNull QImage texture){
        setTexture_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    @QtUninvokable
    private native void setTexture_native_cref_QImage(long __this__nativeId, long texture);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#textureFile-prop">QtDataVisualization::QSurface3DSeries::<wbr>setTextureFile(QString)</a></code></p>
     */
    @QtPropertyWriter(name="textureFile")
    @QtUninvokable
    public final void setTextureFile(java.lang.@NonNull String filename){
        setTextureFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filename);
    }
    
    @QtUninvokable
    private native void setTextureFile_native_cref_QString(long __this__nativeId, java.lang.String filename);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#texture-prop">QtDataVisualization::QSurface3DSeries::<wbr>texture()const</a></code></p>
     */
    @QtPropertyReader(name="texture")
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage texture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#textureFile-prop">QtDataVisualization::QSurface3DSeries::<wbr>textureFile()const</a></code></p>
     */
    @QtPropertyReader(name="textureFile")
    @QtUninvokable
    public final java.lang.@NonNull String textureFile(){
        return textureFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String textureFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsurface3dseries.html#invalidSelectionPosition">QtDataVisualization::QSurface3DSeries::<wbr>invalidSelectionPosition()</a></code></p>
     */
    public native static io.qt.core.@NonNull QPoint invalidSelectionPosition();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSurface3DSeries(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSurface3DSeries(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSurface3DSeries instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QSurface3DSeries(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSurface3DSeries() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSurface3DSeries(io.qt.datavis.QSurfaceDataProxy, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSurface3DSeries(io.qt.datavis.@Nullable QSurfaceDataProxy dataProxy) {
        this(dataProxy, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #dataProxy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QSurfaceDataProxy getDataProxy() {
        return dataProxy();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #drawMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QSurface3DSeries.@NonNull DrawFlags getDrawMode() {
        return drawMode();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isFlatShadingEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getFlatShadingEnabled() {
        return isFlatShadingEnabled();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isFlatShadingSupported()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getFlatShadingSupported() {
        return isFlatShadingSupported();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getSelectedPoint() {
        return selectedPoint();
    }
    
    /**
     * <p>Overloaded function for {@link #setDrawMode(io.qt.datavis.QSurface3DSeries.DrawFlags)}.</p>
     */
    @QtUninvokable
    public final void setDrawMode(io.qt.datavis.QSurface3DSeries.@NonNull DrawFlag @NonNull... mode) {
        setDrawMode(new io.qt.datavis.QSurface3DSeries.DrawFlags(mode));
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #texture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage getTexture() {
        return texture();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTextureFile() {
        return textureFile();
    }
}
