package io.qt.datavis;

import io.qt.*;


/**
 * <p>Represents a data series in a 3D bar graph</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html">QtDataVisualization::QBar3DSeries</a></code></p>
 */
public class QBar3DSeries extends io.qt.datavis.QAbstract3DSeries
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBar3DSeries.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#dataProxy-prop">QtDataVisualization::QBar3DSeries::<wbr>dataProxyChanged(QtDataVisualization::QBarDataProxy*)</a></code></p>
     */
    @QtPropertyNotify(name="dataProxy")
    public final @NonNull Signal1<io.qt.datavis.@Nullable QBarDataProxy> dataProxyChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#meshAngle-prop">QtDataVisualization::QBar3DSeries::<wbr>meshAngleChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="meshAngle")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> meshAngleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#selectedBar-prop">QtDataVisualization::QBar3DSeries::<wbr>selectedBarChanged(QPoint)</a></code></p>
     */
    @QtPropertyNotify(name="selectedBar")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> selectedBarChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#QBar3DSeries">QtDataVisualization::QBar3DSeries::<wbr>QBar3DSeries(QObject*)</a></code></p>
     */
    public QBar3DSeries(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBar3DSeries instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QtDataVisualization::QBar3DSeries::<wbr>QBar3DSeries(QtDataVisualization::QBarDataProxy*,<wbr>QObject*)</code></p>
     */
    public QBar3DSeries(io.qt.datavis.@Nullable QBarDataProxy dataProxy, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, dataProxy, parent);
    }
    
    private native static void initialize_native(QBar3DSeries instance, io.qt.datavis.QBarDataProxy dataProxy, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#dataProxy-prop">QtDataVisualization::QBar3DSeries::<wbr>dataProxy()const</a></code></p>
     */
    @QtPropertyReader(name="dataProxy")
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataProxy dataProxy(){
        return dataProxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.QBarDataProxy dataProxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#meshAngle-prop">QtDataVisualization::QBar3DSeries::<wbr>meshAngle()const</a></code></p>
     */
    @QtPropertyReader(name="meshAngle")
    @QtUninvokable
    public final float meshAngle(){
        return meshAngle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float meshAngle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#selectedBar-prop">QtDataVisualization::QBar3DSeries::<wbr>selectedBar()const</a></code></p>
     */
    @QtPropertyReader(name="selectedBar")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint selectedBar(){
        return selectedBar_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint selectedBar_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#dataProxy-prop">QtDataVisualization::QBar3DSeries::<wbr>setDataProxy(QtDataVisualization::QBarDataProxy*)</a></code></p>
     */
    @QtPropertyWriter(name="dataProxy")
    @QtUninvokable
    public final void setDataProxy(io.qt.datavis.@StrictNonNull QBarDataProxy proxy){
        if(proxy!=null){
            if(proxy==dataProxy()){
                throw new IllegalArgumentException("Proxy is already assigned to this series.");
            }else if(proxy.series()!=null){
                throw new IllegalArgumentException("Proxy is already assigned to another series.");
            }
        }
        java.util.Objects.requireNonNull(proxy, "Argument 'proxy': null not expected.");
        setDataProxy_native_QtDataVisualization_QBarDataProxy_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(proxy));
    }
    
    @QtUninvokable
    private native void setDataProxy_native_QtDataVisualization_QBarDataProxy_ptr(long __this__nativeId, long proxy);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#meshAngle-prop">QtDataVisualization::QBar3DSeries::<wbr>setMeshAngle(float)</a></code></p>
     */
    @QtPropertyWriter(name="meshAngle")
    @QtUninvokable
    public final void setMeshAngle(float angle){
        setMeshAngle_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    @QtUninvokable
    private native void setMeshAngle_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#setSelectedBar">QtDataVisualization::QBar3DSeries::<wbr>setSelectedBar(QPoint)</a></code></p>
     */
    @QtPropertyWriter(name="selectedBar")
    @QtUninvokable
    public final void setSelectedBar(io.qt.core.@NonNull QPoint position){
        setSelectedBar_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setSelectedBar_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qbar3dseries.html#invalidSelectionPosition">QtDataVisualization::QBar3DSeries::<wbr>invalidSelectionPosition()</a></code></p>
     */
    public native static io.qt.core.@NonNull QPoint invalidSelectionPosition();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QBar3DSeries(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QBar3DSeries(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QBar3DSeries instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QBar3DSeries(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBar3DSeries() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QBar3DSeries(io.qt.datavis.QBarDataProxy, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBar3DSeries(io.qt.datavis.@Nullable QBarDataProxy dataProxy) {
        this(dataProxy, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #dataProxy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable QBarDataProxy getDataProxy() {
        return dataProxy();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #meshAngle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMeshAngle() {
        return meshAngle();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedBar()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getSelectedBar() {
        return selectedBar();
    }
}
