package io.qt.datavis;

import io.qt.*;


/**
 * <p>Base class for all data series</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html">QtDataVisualization::QAbstract3DSeries</a></code></p>
 */
public class QAbstract3DSeries extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DSeries.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::QAbstract3DSeries::Mesh</a></code></p>
     */
    @QtUnlistedEnum
    public enum Mesh implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshUserDefined</a></code></p>
         */
        MeshUserDefined(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshBar</a></code></p>
         */
        MeshBar(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshCube</a></code></p>
         */
        MeshCube(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshPyramid</a></code></p>
         */
        MeshPyramid(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshCone</a></code></p>
         */
        MeshCone(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshCylinder</a></code></p>
         */
        MeshCylinder(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshBevelBar</a></code></p>
         */
        MeshBevelBar(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshBevelCube</a></code></p>
         */
        MeshBevelCube(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshSphere</a></code></p>
         */
        MeshSphere(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshMinimal</a></code></p>
         */
        MeshMinimal(9),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshArrow</a></code></p>
         */
        MeshArrow(10),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>MeshPoint</a></code></p>
         */
        MeshPoint(11);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mesh(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Mesh resolve(int value) {
            switch (value) {
            case 0: return MeshUserDefined;
            case 1: return MeshBar;
            case 2: return MeshCube;
            case 3: return MeshPyramid;
            case 4: return MeshCone;
            case 5: return MeshCylinder;
            case 6: return MeshBevelBar;
            case 7: return MeshBevelCube;
            case 8: return MeshSphere;
            case 9: return MeshMinimal;
            case 10: return MeshArrow;
            case 11: return MeshPoint;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#SeriesType-enum">QtDataVisualization::QAbstract3DSeries::SeriesType</a></code></p>
     */
    @QtUnlistedEnum
    public enum SeriesType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#SeriesType-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>SeriesTypeNone</a></code></p>
         */
        SeriesTypeNone(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#SeriesType-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>SeriesTypeBar</a></code></p>
         */
        SeriesTypeBar(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#SeriesType-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>SeriesTypeScatter</a></code></p>
         */
        SeriesTypeScatter(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#SeriesType-enum">QtDataVisualization::<wbr>QAbstract3DSeries::<wbr>SeriesTypeSurface</a></code></p>
         */
        SeriesTypeSurface(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SeriesType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SeriesType resolve(int value) {
            switch (value) {
            case 0: return SeriesTypeNone;
            case 1: return SeriesTypeBar;
            case 2: return SeriesTypeScatter;
            case 4: return SeriesTypeSurface;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>baseColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="baseColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> baseColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>baseGradientChanged(QLinearGradient)</a></code></p>
     */
    @QtPropertyNotify(name="baseGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> baseGradientChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#colorStyle-prop">QtDataVisualization::QAbstract3DSeries::<wbr>colorStyleChanged(QtDataVisualization::Q3DTheme::ColorStyle)</a></code></p>
     */
    @QtPropertyNotify(name="colorStyle")
    public final @NonNull Signal1<io.qt.datavis.Q3DTheme.@NonNull ColorStyle> colorStyleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabel-prop">QtDataVisualization::QAbstract3DSeries::<wbr>itemLabelChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="itemLabel")
    public final @NonNull Signal1<java.lang.@NonNull String> itemLabelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelFormat-prop">QtDataVisualization::QAbstract3DSeries::<wbr>itemLabelFormatChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="itemLabelFormat")
    public final @NonNull Signal1<java.lang.@NonNull String> itemLabelFormatChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelVisible-prop">QtDataVisualization::QAbstract3DSeries::<wbr>itemLabelVisibilityChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="itemLabelVisible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> itemLabelVisibilityChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#mesh-prop">QtDataVisualization::QAbstract3DSeries::<wbr>meshChanged(QtDataVisualization::QAbstract3DSeries::Mesh)</a></code></p>
     */
    @QtPropertyNotify(name="mesh")
    public final @NonNull Signal1<io.qt.datavis.QAbstract3DSeries.@NonNull Mesh> meshChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshRotation-prop">QtDataVisualization::QAbstract3DSeries::<wbr>meshRotationChanged(QQuaternion)</a></code></p>
     */
    @QtPropertyNotify(name="meshRotation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QQuaternion> meshRotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshSmooth-prop">QtDataVisualization::QAbstract3DSeries::<wbr>meshSmoothChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="meshSmooth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> meshSmoothChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>multiHighlightColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="multiHighlightColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> multiHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>multiHighlightGradientChanged(QLinearGradient)</a></code></p>
     */
    @QtPropertyNotify(name="multiHighlightGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> multiHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#name-prop">QtDataVisualization::QAbstract3DSeries::<wbr>nameChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>singleHighlightColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="singleHighlightColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> singleHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>singleHighlightGradientChanged(QLinearGradient)</a></code></p>
     */
    @QtPropertyNotify(name="singleHighlightGradient")
    public final @NonNull Signal1<io.qt.gui.@NonNull QLinearGradient> singleHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#userDefinedMesh-prop">QtDataVisualization::QAbstract3DSeries::<wbr>userDefinedMeshChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="userDefinedMesh")
    public final @NonNull Signal1<java.lang.@NonNull String> userDefinedMeshChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#visible-prop">QtDataVisualization::QAbstract3DSeries::<wbr>visibilityChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="visible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> visibilityChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>baseColor()const</a></code></p>
     */
    @QtPropertyReader(name="baseColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor baseColor(){
        return baseColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor baseColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>baseGradient()const</a></code></p>
     */
    @QtPropertyReader(name="baseGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient baseGradient(){
        return baseGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient baseGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#colorStyle-prop">QtDataVisualization::QAbstract3DSeries::<wbr>colorStyle()const</a></code></p>
     */
    @QtPropertyReader(name="colorStyle")
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull ColorStyle colorStyle(){
        return io.qt.datavis.Q3DTheme.ColorStyle.resolve(colorStyle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int colorStyle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelVisible-prop">QtDataVisualization::QAbstract3DSeries::<wbr>isItemLabelVisible()const</a></code></p>
     */
    @QtPropertyReader(name="itemLabelVisible")
    @QtUninvokable
    public final boolean isItemLabelVisible(){
        return isItemLabelVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isItemLabelVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshSmooth-prop">QtDataVisualization::QAbstract3DSeries::<wbr>isMeshSmooth()const</a></code></p>
     */
    @QtPropertyReader(name="meshSmooth")
    @QtUninvokable
    public final boolean isMeshSmooth(){
        return isMeshSmooth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMeshSmooth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#visible-prop">QtDataVisualization::QAbstract3DSeries::<wbr>isVisible()const</a></code></p>
     */
    @QtPropertyReader(name="visible")
    @QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabel-prop">QtDataVisualization::QAbstract3DSeries::<wbr>itemLabel()const</a></code></p>
     */
    @QtPropertyReader(name="itemLabel")
    @QtUninvokable
    public final java.lang.@NonNull String itemLabel(){
        return itemLabel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String itemLabel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelFormat-prop">QtDataVisualization::QAbstract3DSeries::<wbr>itemLabelFormat()const</a></code></p>
     */
    @QtPropertyReader(name="itemLabelFormat")
    @QtUninvokable
    public final java.lang.@NonNull String itemLabelFormat(){
        return itemLabelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String itemLabelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#mesh-prop">QtDataVisualization::QAbstract3DSeries::<wbr>mesh()const</a></code></p>
     */
    @QtPropertyReader(name="mesh")
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull Mesh mesh(){
        return io.qt.datavis.QAbstract3DSeries.Mesh.resolve(mesh_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mesh_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshRotation-prop">QtDataVisualization::QAbstract3DSeries::<wbr>meshRotation()const</a></code></p>
     */
    @QtPropertyReader(name="meshRotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion meshRotation(){
        return meshRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion meshRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>multiHighlightColor()const</a></code></p>
     */
    @QtPropertyReader(name="multiHighlightColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor multiHighlightColor(){
        return multiHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor multiHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>multiHighlightGradient()const</a></code></p>
     */
    @QtPropertyReader(name="multiHighlightGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient multiHighlightGradient(){
        return multiHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient multiHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#name-prop">QtDataVisualization::QAbstract3DSeries::<wbr>name()const</a></code></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setBaseColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="baseColor")
    @QtUninvokable
    public final void setBaseColor(io.qt.gui.@NonNull QColor color){
        setBaseColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setBaseColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setBaseGradient(QLinearGradient)</a></code></p>
     */
    @QtPropertyWriter(name="baseGradient")
    @QtUninvokable
    public final void setBaseGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setBaseGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setBaseGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#colorStyle-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)</a></code></p>
     */
    @QtPropertyWriter(name="colorStyle")
    @QtUninvokable
    public final void setColorStyle(io.qt.datavis.Q3DTheme.@NonNull ColorStyle style){
        setColorStyle_native_QtDataVisualization_Q3DTheme_ColorStyle(QtJambi_LibraryUtilities.internal.nativeId(this), style.value());
    }
    
    @QtUninvokable
    private native void setColorStyle_native_QtDataVisualization_Q3DTheme_ColorStyle(long __this__nativeId, int style);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelFormat-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setItemLabelFormat(QString)</a></code></p>
     */
    @QtPropertyWriter(name="itemLabelFormat")
    @QtUninvokable
    public final void setItemLabelFormat(java.lang.@NonNull String format){
        setItemLabelFormat_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), format);
    }
    
    @QtUninvokable
    private native void setItemLabelFormat_native_cref_QString(long __this__nativeId, java.lang.String format);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelVisible-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setItemLabelVisible(bool)</a></code></p>
     */
    @QtPropertyWriter(name="itemLabelVisible")
    @QtUninvokable
    public final void setItemLabelVisible(boolean visible){
        setItemLabelVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setItemLabelVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#mesh-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setMesh(QtDataVisualization::QAbstract3DSeries::Mesh)</a></code></p>
     */
    @QtPropertyWriter(name="mesh")
    @QtUninvokable
    public final void setMesh(io.qt.datavis.QAbstract3DSeries.@NonNull Mesh mesh){
        setMesh_native_QtDataVisualization_QAbstract3DSeries_Mesh(QtJambi_LibraryUtilities.internal.nativeId(this), mesh.value());
    }
    
    @QtUninvokable
    private native void setMesh_native_QtDataVisualization_QAbstract3DSeries_Mesh(long __this__nativeId, int mesh);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#setMeshAxisAndAngle">QtDataVisualization::QAbstract3DSeries::<wbr>setMeshAxisAndAngle(QVector3D,<wbr>float)</a></code></p>
     */
    public final void setMeshAxisAndAngle(io.qt.gui.@NonNull QVector3D axis, float angle){
        setMeshAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native void setMeshAxisAndAngle_native_cref_QVector3D_float(long __this__nativeId, long axis, float angle);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshRotation-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setMeshRotation(QQuaternion)</a></code></p>
     */
    @QtPropertyWriter(name="meshRotation")
    @QtUninvokable
    public final void setMeshRotation(io.qt.gui.@NonNull QQuaternion rotation){
        setMeshRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    @QtUninvokable
    private native void setMeshRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshSmooth-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setMeshSmooth(bool)</a></code></p>
     */
    @QtPropertyWriter(name="meshSmooth")
    @QtUninvokable
    public final void setMeshSmooth(boolean enable){
        setMeshSmooth_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setMeshSmooth_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setMultiHighlightColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="multiHighlightColor")
    @QtUninvokable
    public final void setMultiHighlightColor(io.qt.gui.@NonNull QColor color){
        setMultiHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setMultiHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setMultiHighlightGradient(QLinearGradient)</a></code></p>
     */
    @QtPropertyWriter(name="multiHighlightGradient")
    @QtUninvokable
    public final void setMultiHighlightGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setMultiHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setMultiHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#name-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="name")
    @QtUninvokable
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setSingleHighlightColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="singleHighlightColor")
    @QtUninvokable
    public final void setSingleHighlightColor(io.qt.gui.@NonNull QColor color){
        setSingleHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setSingleHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setSingleHighlightGradient(QLinearGradient)</a></code></p>
     */
    @QtPropertyWriter(name="singleHighlightGradient")
    @QtUninvokable
    public final void setSingleHighlightGradient(io.qt.gui.@NonNull QLinearGradient gradient){
        setSingleHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @QtUninvokable
    private native void setSingleHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#userDefinedMesh-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setUserDefinedMesh(QString)</a></code></p>
     */
    @QtPropertyWriter(name="userDefinedMesh")
    @QtUninvokable
    public final void setUserDefinedMesh(java.lang.@NonNull String fileName){
        setUserDefinedMesh_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setUserDefinedMesh_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#visible-prop">QtDataVisualization::QAbstract3DSeries::<wbr>setVisible(bool)</a></code></p>
     */
    @QtPropertyWriter(name="visible")
    @QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::<wbr>singleHighlightColor()const</a></code></p>
     */
    @QtPropertyReader(name="singleHighlightColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor singleHighlightColor(){
        return singleHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor singleHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::<wbr>singleHighlightGradient()const</a></code></p>
     */
    @QtPropertyReader(name="singleHighlightGradient")
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient singleHighlightGradient(){
        return singleHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QLinearGradient singleHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#type-prop">QtDataVisualization::QAbstract3DSeries::<wbr>type()const</a></code></p>
     */
    @QtPropertyReader(name="type")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull SeriesType type(){
        return io.qt.datavis.QAbstract3DSeries.SeriesType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstract3dseries.html#userDefinedMesh-prop">QtDataVisualization::QAbstract3DSeries::<wbr>userDefinedMesh()const</a></code></p>
     */
    @QtPropertyReader(name="userDefinedMesh")
    @QtUninvokable
    public final java.lang.@NonNull String userDefinedMesh(){
        return userDefinedMesh_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String userDefinedMesh_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstract3DSeries(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #baseColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getBaseColor() {
        return baseColor();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #baseGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getBaseGradient() {
        return baseGradient();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #colorStyle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.Q3DTheme.@NonNull ColorStyle getColorStyle() {
        return colorStyle();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isItemLabelVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getItemLabelVisible() {
        return isItemLabelVisible();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isMeshSmooth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMeshSmooth() {
        return isMeshSmooth();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getVisible() {
        return isVisible();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemLabel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getItemLabel() {
        return itemLabel();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemLabelFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getItemLabelFormat() {
        return itemLabelFormat();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mesh()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull Mesh getMesh() {
        return mesh();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #meshRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getMeshRotation() {
        return meshRotation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #multiHighlightColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getMultiHighlightColor() {
        return multiHighlightColor();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #multiHighlightGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getMultiHighlightGradient() {
        return multiHighlightGradient();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #singleHighlightColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getSingleHighlightColor() {
        return singleHighlightColor();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #singleHighlightGradient()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QLinearGradient getSingleHighlightGradient() {
        return singleHighlightGradient();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.@NonNull SeriesType getType() {
        return type();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #userDefinedMesh()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getUserDefinedMesh() {
        return userDefinedMesh();
    }
}
